/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation.helper.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentationHack;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;

public class VisibleDelegate {
    private static final String FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE = "fragmentation_invisible_when_leave";
    private static final String FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE = "fragmentation_compat_replace";
    private boolean mIsSupportVisible;
    private boolean mNeedDispatch = true;
    private boolean mInvisibleWhenLeave;
    private boolean mIsFirstVisible = true;
    private boolean mFixStatePagerAdapter;
    private boolean mFirstCreateViewCompatReplace = true;
    private Handler mHandler;
    private Bundle mSaveInstanceState;
    private ISupportFragment mSupportF;
    private Fragment mFragment;

    public VisibleDelegate(ISupportFragment fragment) {
        this.mSupportF = fragment;
        this.mFragment = (Fragment)fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mSaveInstanceState = savedInstanceState;
            if (!this.mFixStatePagerAdapter) {
                this.mInvisibleWhenLeave = savedInstanceState.getBoolean(FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE);
                this.mFirstCreateViewCompatReplace = savedInstanceState.getBoolean(FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBoolean(FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE, this.mInvisibleWhenLeave);
        outState.putBoolean(FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE, this.mFirstCreateViewCompatReplace);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        if (!this.mFirstCreateViewCompatReplace && this.mFragment.getTag() != null && this.mFragment.getTag().startsWith("android:switcher:")) {
            return;
        }
        if (this.mFirstCreateViewCompatReplace) {
            this.mFirstCreateViewCompatReplace = false;
        }
        if (!this.mInvisibleWhenLeave && !this.mFragment.isHidden() && (this.mFragment.getUserVisibleHint() || this.mFixStatePagerAdapter) && (this.mFragment.getParentFragment() != null && this.isFragmentVisible(this.mFragment.getParentFragment()) || this.mFragment.getParentFragment() == null)) {
            this.mNeedDispatch = false;
            this.dispatchSupportVisible(true);
        }
    }

    public void onResume() {
        if (!this.mIsFirstVisible && !this.mIsSupportVisible && !this.mInvisibleWhenLeave && this.isFragmentVisible(this.mFragment)) {
            this.mNeedDispatch = false;
            this.dispatchSupportVisible(true);
        }
    }

    public void onPause() {
        if (this.mIsSupportVisible && this.isFragmentVisible(this.mFragment)) {
            this.mNeedDispatch = false;
            this.mInvisibleWhenLeave = false;
            this.dispatchSupportVisible(false);
        } else {
            this.mInvisibleWhenLeave = true;
        }
    }

    public void onHiddenChanged(boolean hidden) {
        if (hidden || this.mFragment.getView() == null) {
            this.safeDispatchUserVisibleHint(false);
        } else {
            this.dispatchSupportVisible(true);
        }
    }

    public void onDestroyView() {
        this.mIsFirstVisible = true;
        this.mFixStatePagerAdapter = false;
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (this.mFragment.isResumed() || this.mFragment.isDetached() && isVisibleToUser) {
            if (!this.mIsSupportVisible && isVisibleToUser) {
                this.safeDispatchUserVisibleHint(true);
            } else if (this.mIsSupportVisible && !isVisibleToUser) {
                this.dispatchSupportVisible(false);
            }
        } else if (isVisibleToUser) {
            this.mInvisibleWhenLeave = false;
            this.mFixStatePagerAdapter = true;
        }
    }

    private void safeDispatchUserVisibleHint(final boolean visible) {
        if (this.mIsFirstVisible) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    VisibleDelegate.this.dispatchSupportVisible(visible);
                }
            });
        } else {
            this.dispatchSupportVisible(visible);
        }
    }

    private void dispatchSupportVisible(boolean visible) {
        this.mIsSupportVisible = visible;
        if (!this.mNeedDispatch) {
            this.mNeedDispatch = true;
        } else {
            List<Fragment> childFragments;
            FragmentManager fragmentManager = this.mFragment.getChildFragmentManager();
            if (fragmentManager != null && (childFragments = FragmentationHack.getActiveFragments(fragmentManager)) != null) {
                for (Fragment child : childFragments) {
                    if (!(child instanceof ISupportFragment) || child.isHidden() || !child.getUserVisibleHint()) continue;
                    ((ISupportFragment)child).getSupportDelegate().getVisibleDelegate().dispatchSupportVisible(visible);
                }
            }
        }
        if (visible) {
            this.mSupportF.onSupportVisible();
            if (this.mIsFirstVisible) {
                this.mIsFirstVisible = false;
                this.mSupportF.onLazyInitView(this.mSaveInstanceState);
            }
        } else {
            this.mSupportF.onSupportInvisible();
        }
    }

    private boolean isFragmentVisible(Fragment fragment) {
        return !fragment.isHidden() && fragment.getUserVisibleHint();
    }

    public boolean isSupportVisible() {
        return this.mIsSupportVisible;
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }
}

