/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation.helper.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import me.yokeyword.fragmentation.R;
import me.yokeyword.fragmentation.anim.FragmentAnimator;

public final class AnimatorHelper {
    private Animation noneAnim;
    private Animation noneAnimFixed;
    public Animation enterAnim;
    public Animation exitAnim;
    public Animation popEnterAnim;
    public Animation popExitAnim;
    private Context context;
    private FragmentAnimator fragmentAnimator;

    public AnimatorHelper(Context context, FragmentAnimator fragmentAnimator) {
        this.context = context;
        this.notifyChanged(fragmentAnimator);
    }

    public void notifyChanged(FragmentAnimator fragmentAnimator) {
        this.fragmentAnimator = fragmentAnimator;
        this.initEnterAnim();
        this.initExitAnim();
        this.initPopEnterAnim();
        this.initPopExitAnim();
    }

    public Animation getNoneAnim() {
        if (this.noneAnim == null) {
            this.noneAnim = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.no_anim);
        }
        return this.noneAnim;
    }

    public Animation getNoneAnimFixed() {
        if (this.noneAnimFixed == null) {
            this.noneAnimFixed = new Animation(){};
        }
        return this.noneAnimFixed;
    }

    @Nullable
    public Animation getViewPagerChildFragmentAnimFixed(Fragment fragment, boolean enter) {
        if (!enter && fragment.getTag() != null && fragment.getTag().startsWith("android:switcher:") && fragment.getUserVisibleHint()) {
            Animation animation = new Animation(){};
            animation.setDuration(this.exitAnim.getDuration());
            return animation;
        }
        return null;
    }

    private Animation initEnterAnim() {
        this.enterAnim = this.fragmentAnimator.getEnter() == 0 ? AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.no_anim) : AnimationUtils.loadAnimation((Context)this.context, (int)this.fragmentAnimator.getEnter());
        return this.enterAnim;
    }

    private Animation initExitAnim() {
        this.exitAnim = this.fragmentAnimator.getExit() == 0 ? AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.no_anim) : AnimationUtils.loadAnimation((Context)this.context, (int)this.fragmentAnimator.getExit());
        return this.exitAnim;
    }

    private Animation initPopEnterAnim() {
        this.popEnterAnim = this.fragmentAnimator.getPopEnter() == 0 ? AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.no_anim) : AnimationUtils.loadAnimation((Context)this.context, (int)this.fragmentAnimator.getPopEnter());
        return this.popEnterAnim;
    }

    private Animation initPopExitAnim() {
        this.popExitAnim = this.fragmentAnimator.getPopExit() == 0 ? AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.no_anim) : AnimationUtils.loadAnimation((Context)this.context, (int)this.fragmentAnimator.getPopExit());
        return this.popExitAnim;
    }
}

