/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation.debug;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentationHack;
import android.support.v7.app.AlertDialog;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.Fragmentation;
import me.yokeyword.fragmentation.R;
import me.yokeyword.fragmentation.debug.DebugFragmentRecord;
import me.yokeyword.fragmentation.debug.DebugHierarchyViewContainer;

public class DebugStackDelegate
implements SensorEventListener {
    private FragmentActivity mActivity;
    private SensorManager mSensorManager;
    private AlertDialog mStackDialog;

    public DebugStackDelegate(FragmentActivity activity) {
        this.mActivity = activity;
    }

    public void onCreate(int mode) {
        if (mode != 1) {
            return;
        }
        this.mSensorManager = (SensorManager)this.mActivity.getSystemService("sensor");
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(1), 3);
    }

    public void onPostCreate(int mode) {
        if (mode != 2) {
            return;
        }
        View root = this.mActivity.findViewById(0x1020002);
        if (root instanceof FrameLayout) {
            FrameLayout content = (FrameLayout)root;
            ImageView stackView = new ImageView((Context)this.mActivity);
            stackView.setImageResource(R.drawable.fragmentation_ic_stack);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 0x800005;
            int dp18 = (int)TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)this.mActivity.getResources().getDisplayMetrics());
            params.topMargin = dp18 * 7;
            params.rightMargin = dp18;
            stackView.setLayoutParams((ViewGroup.LayoutParams)params);
            content.addView((View)stackView);
            stackView.setOnTouchListener((View.OnTouchListener)new StackViewTouchListener((View)stackView, dp18 / 4));
            stackView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DebugStackDelegate.this.showFragmentStackHierarchyView();
                }
            });
        }
    }

    public void onDestroy() {
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void onSensorChanged(SensorEvent event) {
        int sensorType = event.sensor.getType();
        float[] values = event.values;
        if (sensorType == 1) {
            int value = 12;
            if (Math.abs(values[0]) >= (float)value || Math.abs(values[1]) >= (float)value || Math.abs(values[2]) >= (float)value) {
                this.showFragmentStackHierarchyView();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void showFragmentStackHierarchyView() {
        if (!Fragmentation.getDefault().isDebug()) {
            return;
        }
        if (this.mStackDialog != null && this.mStackDialog.isShowing()) {
            return;
        }
        DebugHierarchyViewContainer container = new DebugHierarchyViewContainer((Context)this.mActivity);
        container.bindFragmentRecords(this.getFragmentRecords());
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mStackDialog = new AlertDialog.Builder((Context)this.mActivity).setView((View)container).setPositiveButton((CharSequence)"\u5173\u95ed", null).setCancelable(true).create();
        this.mStackDialog.show();
    }

    public void logFragmentRecords(String tag) {
        List<DebugFragmentRecord> fragmentRecordList = this.getFragmentRecords();
        if (fragmentRecordList == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = fragmentRecordList.size() - 1; i >= 0; --i) {
            DebugFragmentRecord fragmentRecord = fragmentRecordList.get(i);
            if (i == fragmentRecordList.size() - 1) {
                sb.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
                if (i == 0) {
                    sb.append("\t\u6808\u9876\t\t\t").append(fragmentRecord.fragmentName).append("\n");
                    sb.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                } else {
                    sb.append("\t\u6808\u9876\t\t\t").append(fragmentRecord.fragmentName).append("\n\n");
                }
            } else {
                if (i == 0) {
                    sb.append("\t\u6808\u5e95\t\t\t").append(fragmentRecord.fragmentName).append("\n\n");
                    this.processChildLog(fragmentRecord.childFragmentRecord, sb, 1);
                    sb.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    Log.i((String)tag, (String)sb.toString());
                    return;
                }
                sb.append("\t\u2193\t\t\t").append(fragmentRecord.fragmentName).append("\n\n");
            }
            this.processChildLog(fragmentRecord.childFragmentRecord, sb, 1);
        }
    }

    private List<DebugFragmentRecord> getFragmentRecords() {
        ArrayList<DebugFragmentRecord> fragmentRecordList = new ArrayList<DebugFragmentRecord>();
        List<Fragment> fragmentList = FragmentationHack.getActiveFragments(this.mActivity.getSupportFragmentManager());
        if (fragmentList == null || fragmentList.size() < 1) {
            return null;
        }
        for (Fragment fragment : fragmentList) {
            this.addDebugFragmentRecord(fragmentRecordList, fragment);
        }
        return fragmentRecordList;
    }

    private void processChildLog(List<DebugFragmentRecord> fragmentRecordList, StringBuilder sb, int childHierarchy) {
        if (fragmentRecordList == null || fragmentRecordList.size() == 0) {
            return;
        }
        for (int j = 0; j < fragmentRecordList.size(); ++j) {
            DebugFragmentRecord childFragmentRecord = fragmentRecordList.get(j);
            for (int k = 0; k < childHierarchy; ++k) {
                sb.append("\t\t\t");
            }
            if (j == 0) {
                sb.append("\t\u5b50\u6808\u9876\t\t").append(childFragmentRecord.fragmentName).append("\n\n");
            } else {
                if (j == fragmentRecordList.size() - 1) {
                    sb.append("\t\u5b50\u6808\u5e95\t\t").append(childFragmentRecord.fragmentName).append("\n\n");
                    this.processChildLog(childFragmentRecord.childFragmentRecord, sb, ++childHierarchy);
                    return;
                }
                sb.append("\t\u2193\t\t\t").append(childFragmentRecord.fragmentName).append("\n\n");
            }
            this.processChildLog(childFragmentRecord.childFragmentRecord, sb, childHierarchy);
        }
    }

    private List<DebugFragmentRecord> getChildFragmentRecords(Fragment parentFragment) {
        ArrayList<DebugFragmentRecord> fragmentRecords = new ArrayList<DebugFragmentRecord>();
        List<Fragment> fragmentList = FragmentationHack.getActiveFragments(parentFragment.getChildFragmentManager());
        if (fragmentList == null || fragmentList.size() < 1) {
            return null;
        }
        for (int i = fragmentList.size() - 1; i >= 0; --i) {
            Fragment fragment = fragmentList.get(i);
            this.addDebugFragmentRecord(fragmentRecords, fragment);
        }
        return fragmentRecords;
    }

    private void addDebugFragmentRecord(List<DebugFragmentRecord> fragmentRecords, Fragment fragment) {
        if (fragment != null) {
            int backStackCount = fragment.getFragmentManager().getBackStackEntryCount();
            CharSequence name = fragment.getClass().getSimpleName();
            if (backStackCount == 0) {
                name = this.span(name);
            } else {
                FragmentManager.BackStackEntry entry;
                for (int j = 0; j < backStackCount && !(entry = fragment.getFragmentManager().getBackStackEntryAt(j)).getName().equals(fragment.getClass().getName()); ++j) {
                    if (j != backStackCount - 1) continue;
                    name = this.span(name);
                }
            }
            fragmentRecords.add(new DebugFragmentRecord(name, this.getChildFragmentRecords(fragment)));
        }
    }

    @NonNull
    private CharSequence span(CharSequence name) {
        name = name + " *";
        return name;
    }

    private class StackViewTouchListener
    implements View.OnTouchListener {
        private View stackView;
        private float dX;
        private float dY = 0.0f;
        private float downX;
        private float downY = 0.0f;
        private boolean isClickState;
        private int clickLimitValue;

        StackViewTouchListener(View stackView, int clickLimitValue) {
            this.stackView = stackView;
            this.clickLimitValue = clickLimitValue;
        }

        public boolean onTouch(View v, MotionEvent event) {
            float X = event.getRawX();
            float Y = event.getRawY();
            switch (event.getAction()) {
                case 0: {
                    this.isClickState = true;
                    this.downX = X;
                    this.downY = Y;
                    this.dX = this.stackView.getX() - event.getRawX();
                    this.dY = this.stackView.getY() - event.getRawY();
                    break;
                }
                case 2: {
                    if (Math.abs(X - this.downX) < (float)this.clickLimitValue && Math.abs(Y - this.downY) < (float)this.clickLimitValue && this.isClickState) {
                        this.isClickState = true;
                        break;
                    }
                    this.isClickState = false;
                    this.stackView.setX(event.getRawX() + this.dX);
                    this.stackView.setY(event.getRawY() + this.dY);
                    break;
                }
                case 1: 
                case 3: {
                    if (!(X - this.downX < (float)this.clickLimitValue) || !this.isClickState) break;
                    this.stackView.performClick();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }
}

