/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation.debug;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.List;
import me.yokeyword.fragmentation.R;
import me.yokeyword.fragmentation.debug.DebugFragmentRecord;

public class DebugHierarchyViewContainer
extends ScrollView {
    private Context mContext;
    private LinearLayout mLinearLayout;
    private LinearLayout mTitleLayout;
    private int mItemHeight;
    private int mPadding;

    public DebugHierarchyViewContainer(Context context) {
        super(context);
        this.initView(context);
    }

    public DebugHierarchyViewContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public DebugHierarchyViewContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        HorizontalScrollView hScrollView = new HorizontalScrollView(context);
        this.mLinearLayout = new LinearLayout(context);
        this.mLinearLayout.setOrientation(1);
        hScrollView.addView((View)this.mLinearLayout);
        hScrollView.setBackgroundColor(-16777216);
        this.addView((View)hScrollView);
        this.mItemHeight = this.dip2px(50.0f);
        this.mPadding = this.dip2px(16.0f);
    }

    private int dip2px(float dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public void bindFragmentRecords(List<DebugFragmentRecord> fragmentRecords) {
        this.mLinearLayout.removeAllViews();
        LinearLayout ll = this.getTitleLayout();
        this.mLinearLayout.addView((View)ll);
        if (fragmentRecords == null) {
            return;
        }
        this.setView(fragmentRecords, 0, null);
    }

    @NonNull
    private LinearLayout getTitleLayout() {
        if (this.mTitleLayout != null) {
            return this.mTitleLayout;
        }
        this.mTitleLayout = new LinearLayout(this.mContext);
        this.mTitleLayout.setPadding(this.dip2px(24.0f), this.dip2px(24.0f), 0, this.dip2px(8.0f));
        this.mTitleLayout.setOrientation(0);
        ViewGroup.LayoutParams flParams = new ViewGroup.LayoutParams(-1, -2);
        this.mTitleLayout.setLayoutParams(flParams);
        TextView title = new TextView(this.mContext);
        title.setText((CharSequence)"\u6808\u89c6\u56fe(Stack)");
        title.setTextSize(20.0f);
        title.setTextColor(-1);
        LinearLayout.LayoutParams p = new LinearLayout.LayoutParams(-2, -2);
        p.gravity = 16;
        title.setLayoutParams((ViewGroup.LayoutParams)p);
        this.mTitleLayout.addView((View)title);
        ImageView img = new ImageView(this.mContext);
        img.setImageResource(R.drawable.fragmentation_help);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.leftMargin = this.dip2px(16.0f);
        params.gravity = 16;
        img.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTitleLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Toast.makeText((Context)DebugHierarchyViewContainer.this.mContext, (CharSequence)"* means not in backBack.", (int)0).show();
            }
        });
        this.mTitleLayout.addView((View)img);
        return this.mTitleLayout;
    }

    private void setView(List<DebugFragmentRecord> fragmentRecordList, int hierarchy, TextView tvItem) {
        for (int i = fragmentRecordList.size() - 1; i >= 0; --i) {
            DebugFragmentRecord child = fragmentRecordList.get(i);
            int tempHierarchy = hierarchy;
            final TextView childTvItem = this.getTextView(child, tempHierarchy);
            childTvItem.setTag(R.id.hierarchy, (Object)tempHierarchy);
            childTvItem.setTextColor(-1);
            final List<DebugFragmentRecord> childFragmentRecord = child.childFragmentRecord;
            if (childFragmentRecord != null && childFragmentRecord.size() > 0) {
                childTvItem.setCompoundDrawablesWithIntrinsicBounds(R.drawable.fragmentation_ic_right, 0, 0, 0);
                final int finalChilHierarchy = ++tempHierarchy;
                childTvItem.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (v.getTag(R.id.isexpand) != null) {
                            boolean isExpand = (Boolean)v.getTag(R.id.isexpand);
                            if (isExpand) {
                                childTvItem.setCompoundDrawablesWithIntrinsicBounds(R.drawable.fragmentation_ic_right, 0, 0, 0);
                                DebugHierarchyViewContainer.this.removeView(finalChilHierarchy);
                            } else {
                                DebugHierarchyViewContainer.this.handleExpandView(childFragmentRecord, finalChilHierarchy, childTvItem);
                            }
                            v.setTag(R.id.isexpand, (Object)(!isExpand ? 1 : 0));
                        } else {
                            childTvItem.setTag(R.id.isexpand, (Object)true);
                            DebugHierarchyViewContainer.this.handleExpandView(childFragmentRecord, finalChilHierarchy, childTvItem);
                        }
                    }
                });
            } else {
                childTvItem.setPadding(childTvItem.getPaddingLeft() + this.mPadding, 0, this.mPadding, 0);
            }
            if (tvItem == null) {
                this.mLinearLayout.addView((View)childTvItem);
                continue;
            }
            this.mLinearLayout.addView((View)childTvItem, this.mLinearLayout.indexOfChild((View)tvItem) + 1);
        }
    }

    private void handleExpandView(List<DebugFragmentRecord> childFragmentRecord, int finalChilHierarchy, TextView childTvItem) {
        this.setView(childFragmentRecord, finalChilHierarchy, childTvItem);
        childTvItem.setCompoundDrawablesWithIntrinsicBounds(R.drawable.fragmentation_ic_expandable, 0, 0, 0);
    }

    private void removeView(int hierarchy) {
        int size = this.mLinearLayout.getChildCount();
        for (int i = size - 1; i >= 0; --i) {
            View view = this.mLinearLayout.getChildAt(i);
            if (view.getTag(R.id.hierarchy) == null || (Integer)view.getTag(R.id.hierarchy) < hierarchy) continue;
            this.mLinearLayout.removeView(view);
        }
    }

    private TextView getTextView(DebugFragmentRecord fragmentRecord, int hierarchy) {
        TextView tvItem = new TextView(this.mContext);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, this.mItemHeight);
        tvItem.setLayoutParams(params);
        if (hierarchy == 0) {
            tvItem.setTextColor(-256);
            tvItem.setTextSize(16.0f);
        }
        tvItem.setGravity(16);
        tvItem.setPadding((int)((double)this.mPadding + (double)(hierarchy * this.mPadding) * 1.5), 0, this.mPadding, 0);
        tvItem.setCompoundDrawablePadding(this.mPadding / 2);
        TypedArray a = this.mContext.obtainStyledAttributes(new int[]{16843534});
        tvItem.setBackgroundDrawable(a.getDrawable(0));
        a.recycle();
        tvItem.setText(fragmentRecord.fragmentName);
        return tvItem;
    }
}

