/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.FragmentationHack;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.Fragmentation;
import me.yokeyword.fragmentation.ISupportActivity;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragmentDelegate;
import me.yokeyword.fragmentation.SupportHelper;
import me.yokeyword.fragmentation.helper.internal.ResultRecord;
import me.yokeyword.fragmentation.helper.internal.TransactionRecord;

class TransactionDelegate {
    private static final String TAG = "Fragmentation";
    static final String FRAGMENTATION_ARG_RESULT_RECORD = "fragment_arg_result_record";
    static final String FRAGMENTATION_ARG_ANIM_DISABLE = "fragmentation_arg_anim_disable";
    static final String FRAGMENTATION_ARG_IS_SHARED_ELEMENT = "fragmentation_arg_is_shared_element";
    static final String FRAGMENTATION_ARG_CONTAINER = "fragmentation_arg_container";
    static final String FRAGMENTATION_ARG_REPLACE = "fragmentation_arg_replace";
    static final String FRAGMENTATION_STATE_SAVE_ANIMATOR = "fragmentation_state_save_animator";
    static final String FRAGMENTATION_STATE_SAVE_IS_HIDDEN = "fragmentation_state_save_status";
    static final int TYPE_ADD = 0;
    static final int TYPE_ADD_WITH_POP = 1;
    static final int TYPE_ADD_RESULT = 2;
    static final int TYPE_ADD_WITHOUT_HIDE = 3;
    static final int TYPE_REPLACE = 10;
    static final int TYPE_REPLACE_DONT_BACK = 14;
    private static final long BUFFER_TIME = 50L;
    private ISupportActivity mSupport;
    private FragmentActivity mActivity;
    private long mShareElementDebounceTime;
    private Handler mHandler;
    private FragmentManager mPopToTempFragmentManager;

    TransactionDelegate(ISupportActivity support) {
        this.mSupport = support;
        this.mActivity = (FragmentActivity)support;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    void loadRootTransaction(FragmentManager fragmentManager, int containerId, ISupportFragment to, boolean addToBackStack, boolean allowAnimation) {
        if ((fragmentManager = this.checkFragmentManager(fragmentManager, null)) == null) {
            return;
        }
        this.bindContainerId(containerId, to);
        this.start(fragmentManager, null, to, to.getClass().getName(), !addToBackStack, null, allowAnimation, 10);
    }

    void loadMultipleRootTransaction(FragmentManager fragmentManager, int containerId, int showPosition, ISupportFragment ... tos) {
        if ((fragmentManager = this.checkFragmentManager(fragmentManager, null)) == null) {
            return;
        }
        FragmentTransaction ft = fragmentManager.beginTransaction();
        for (int i = 0; i < tos.length; ++i) {
            Fragment to = (Fragment)tos[i];
            Bundle args = to.getArguments();
            if (args == null) {
                args = new Bundle();
                to.setArguments(args);
            }
            args.putBoolean(FRAGMENTATION_ARG_ANIM_DISABLE, true);
            this.bindContainerId(containerId, tos[i]);
            String toName = to.getClass().getName();
            ft.add(containerId, to, toName);
            if (i == showPosition) continue;
            ft.hide(to);
        }
        this.supportCommit(fragmentManager, ft);
    }

    void dispatchStartTransaction(FragmentManager fragmentManager, ISupportFragment from, ISupportFragment to, int requestCode, int launchMode, int type) {
        if ((fragmentManager = this.checkFragmentManager(fragmentManager, from)) == null) {
            return;
        }
        TransactionDelegate.checkNotNull(to, "toFragment == null");
        if (from != null) {
            Fragment fromF = (Fragment)from;
            if (from.getSupportDelegate().mContainerId == 0 && fromF.getTag() != null && !fromF.getTag().startsWith("android:switcher:")) {
                throw new RuntimeException("Can't find container, please call loadRootFragment() first!");
            }
            this.bindContainerId(from.getSupportDelegate().mContainerId, to);
        }
        String toFragmentTag = to.getClass().getName();
        boolean dontAddToBackStack = false;
        ArrayList<TransactionRecord.SharedElement> sharedElementList = null;
        TransactionRecord transactionRecord = to.getSupportDelegate().mTransactionRecord;
        if (transactionRecord != null) {
            if (transactionRecord.tag != null) {
                toFragmentTag = transactionRecord.tag;
            }
            dontAddToBackStack = transactionRecord.dontAddToBackStack;
            if (transactionRecord.sharedElementList != null) {
                sharedElementList = transactionRecord.sharedElementList;
                FragmentationHack.reorderIndices(fragmentManager);
            }
        }
        if (type == 2) {
            this.saveRequestCode((Fragment)to, requestCode);
        }
        if (this.handleLaunchMode(fragmentManager, to, toFragmentTag, launchMode)) {
            return;
        }
        if (type == 1) {
            this.startWithPop(fragmentManager, from, to);
        } else {
            this.start(fragmentManager, from, to, toFragmentTag, dontAddToBackStack, sharedElementList, false, type);
        }
    }

    private void bindContainerId(int containerId, ISupportFragment to) {
        Fragment toF = (Fragment)to;
        Bundle args = toF.getArguments();
        if (args == null) {
            args = new Bundle();
            toF.setArguments(args);
        }
        args.putInt(FRAGMENTATION_ARG_CONTAINER, containerId);
    }

    void showHideFragment(FragmentManager fragmentManager, ISupportFragment showFragment, ISupportFragment hideFragment) {
        if ((fragmentManager = this.checkFragmentManager(fragmentManager, null)) == null) {
            return;
        }
        if (showFragment == hideFragment) {
            return;
        }
        FragmentTransaction ft = fragmentManager.beginTransaction().show((Fragment)showFragment);
        if (hideFragment == null) {
            List<Fragment> fragmentList = FragmentationHack.getActiveFragments(fragmentManager);
            if (fragmentList != null) {
                for (Fragment fragment : fragmentList) {
                    if (fragment == null || fragment == showFragment) continue;
                    ft.hide(fragment);
                }
            }
        } else {
            ft.hide((Fragment)hideFragment);
        }
        this.supportCommit(fragmentManager, ft);
    }

    private void start(FragmentManager fragmentManager, ISupportFragment from, ISupportFragment to, String toFragmentTag, boolean dontAddToBackStack, ArrayList<TransactionRecord.SharedElement> sharedElementList, boolean allowRootFragmentAnim, int type) {
        FragmentTransaction ft = fragmentManager.beginTransaction();
        boolean addMode = type == 0 || type == 2 || type == 3;
        Fragment fromF = (Fragment)from;
        Fragment toF = (Fragment)to;
        Bundle bundle = toF.getArguments();
        bundle.putBoolean(FRAGMENTATION_ARG_REPLACE, !addMode);
        if (sharedElementList == null) {
            if (addMode) {
                ft.setTransition(4097);
            } else {
                bundle.putBoolean(FRAGMENTATION_ARG_ANIM_DISABLE, true);
            }
        } else {
            bundle.putBoolean(FRAGMENTATION_ARG_IS_SHARED_ELEMENT, true);
            for (TransactionRecord.SharedElement item : sharedElementList) {
                ft.addSharedElement(item.sharedElement, item.sharedName);
            }
        }
        if (from == null) {
            ft.replace(bundle.getInt(FRAGMENTATION_ARG_CONTAINER), toF, toFragmentTag);
            bundle.putBoolean(FRAGMENTATION_ARG_ANIM_DISABLE, !allowRootFragmentAnim);
        } else if (addMode) {
            ft.add(from.getSupportDelegate().mContainerId, toF, toFragmentTag);
            if (type != 3) {
                ft.hide(fromF);
            }
        } else {
            ft.replace(from.getSupportDelegate().mContainerId, toF, toFragmentTag);
        }
        if (!dontAddToBackStack && type != 14) {
            ft.addToBackStack(toFragmentTag);
        }
        this.supportCommit(fragmentManager, ft);
    }

    private void startWithPop(final FragmentManager fragmentManager, final ISupportFragment from, final ISupportFragment to) {
        fragmentManager.executePendingTransactions();
        final ISupportFragment preFragment = this.getPreFragment((Fragment)from);
        final int fromContainerId = from.getSupportDelegate().mContainerId;
        this.mockStartWithPopAnim(from, to, from.getSupportDelegate().mAnimHelper.popExitAnim);
        fragmentManager.popBackStackImmediate();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                FragmentationHack.reorderIndices(fragmentManager);
                if (preFragment != null && preFragment.getSupportDelegate().mContainerId == fromContainerId) {
                    preFragment.getSupportDelegate().start(to);
                } else {
                    TransactionDelegate.this.dispatchStartTransaction(fragmentManager, from, to, 0, 0, 0);
                }
            }
        });
    }

    private void supportCommit(FragmentManager fragmentManager, FragmentTransaction transaction) {
        if (Fragmentation.getDefault().isDebug()) {
            transaction.commit();
        } else {
            boolean stateSaved = FragmentationHack.isStateSaved(fragmentManager);
            if (stateSaved) {
                Log.e((String)TAG, (String)"Please beginTransaction in onPostResume() after the Activity returns!");
                IllegalStateException e = new IllegalStateException("Can not perform this action after onSaveInstanceState!");
                e.printStackTrace();
                if (Fragmentation.getDefault().getHandler() != null) {
                    Fragmentation.getDefault().getHandler().onException(e);
                }
            }
            transaction.commitAllowingStateLoss();
        }
        fragmentManager.executePendingTransactions();
    }

    private ISupportFragment getTopFragment(FragmentManager fragmentManager) {
        return SupportHelper.getTopFragment(fragmentManager);
    }

    private ISupportFragment getPreFragment(Fragment fragment) {
        return SupportHelper.getPreFragment(fragment);
    }

    boolean dispatchBackPressedEvent(ISupportFragment activeFragment) {
        if (activeFragment != null) {
            boolean result = activeFragment.onBackPressedSupport();
            if (result) {
                return true;
            }
            Fragment parentFragment = ((Fragment)activeFragment).getParentFragment();
            if (this.dispatchBackPressedEvent((ISupportFragment)parentFragment)) {
                return true;
            }
        }
        return false;
    }

    private boolean handleLaunchMode(FragmentManager fragmentManager, final ISupportFragment to, String toFragmentTag, int launchMode) {
        ISupportFragment topFragment = this.getTopFragment(fragmentManager);
        if (topFragment == null) {
            return false;
        }
        Object stackToFragment = SupportHelper.findStackFragment(to.getClass(), toFragmentTag, fragmentManager);
        if (stackToFragment == null) {
            return false;
        }
        if (launchMode == 1) {
            if (to == topFragment || to.getClass().getName().equals(topFragment.getClass().getName())) {
                this.handleNewBundle(to, (ISupportFragment)stackToFragment);
                return true;
            }
        } else if (launchMode == 2) {
            this.popTo(toFragmentTag, false, null, fragmentManager, 0);
            this.mHandler.post(new Runnable((ISupportFragment)stackToFragment){
                final /* synthetic */ ISupportFragment val$stackToFragment;
                {
                    this.val$stackToFragment = iSupportFragment2;
                }

                @Override
                public void run() {
                    TransactionDelegate.this.handleNewBundle(to, this.val$stackToFragment);
                }
            });
            return true;
        }
        return false;
    }

    private void handleNewBundle(ISupportFragment toFragment, ISupportFragment stackToFragment) {
        Bundle argsNewBundle = toFragment.getSupportDelegate().mNewBundle;
        Bundle args = ((Fragment)toFragment).getArguments();
        if (args.containsKey(FRAGMENTATION_ARG_CONTAINER)) {
            args.remove(FRAGMENTATION_ARG_CONTAINER);
        }
        if (argsNewBundle != null) {
            args.putAll(argsNewBundle);
        }
        stackToFragment.onNewBundle(args);
    }

    private void saveRequestCode(Fragment to, int requestCode) {
        Bundle bundle = to.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
            to.setArguments(bundle);
        }
        ResultRecord resultRecord = new ResultRecord();
        resultRecord.requestCode = requestCode;
        bundle.putParcelable(FRAGMENTATION_ARG_RESULT_RECORD, (Parcelable)resultRecord);
    }

    void handleResultRecord(Fragment from) {
        final ISupportFragment preFragment = this.getPreFragment(from);
        if (preFragment == null) {
            return;
        }
        Bundle args = from.getArguments();
        if (args == null || !args.containsKey(FRAGMENTATION_ARG_RESULT_RECORD)) {
            return;
        }
        final ResultRecord resultRecord = (ResultRecord)args.getParcelable(FRAGMENTATION_ARG_RESULT_RECORD);
        if (resultRecord == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                preFragment.onFragmentResult(resultRecord.requestCode, resultRecord.resultCode, resultRecord.resultBundle);
            }
        });
    }

    void remove(FragmentManager fm, Fragment fragment, boolean showPreFragment) {
        ISupportFragment preFragment;
        FragmentTransaction ft = fm.beginTransaction().setTransition(8194).remove(fragment);
        if (showPreFragment && (preFragment = SupportHelper.getPreFragment(fragment)) instanceof Fragment) {
            ft.show((Fragment)preFragment);
        }
        this.supportCommit(fm, ft);
    }

    void back(FragmentManager fm) {
        if ((fm = this.checkFragmentManager(fm, null)) == null) {
            return;
        }
        int count = fm.getBackStackEntryCount();
        if (count > 0) {
            this.debouncePop(fm);
        }
    }

    private void debouncePop(FragmentManager fm) {
        Fragment popF = fm.findFragmentByTag(fm.getBackStackEntryAt(fm.getBackStackEntryCount() - 1).getName());
        if (popF instanceof ISupportFragment) {
            long now;
            ISupportFragment supportF = (ISupportFragment)popF;
            if (supportF.getSupportDelegate().mIsSharedElement && (now = System.currentTimeMillis()) < this.mShareElementDebounceTime) {
                this.mShareElementDebounceTime = System.currentTimeMillis() + supportF.getSupportDelegate().mAnimHelper.exitAnim.getDuration();
                return;
            }
            this.mShareElementDebounceTime = System.currentTimeMillis() + supportF.getSupportDelegate().mAnimHelper.exitAnim.getDuration();
        }
        fm.popBackStackImmediate();
        fm.executePendingTransactions();
    }

    void popTo(final String targetFragmentTag, boolean includeTargetFragment, final Runnable afterPopTransactionRunnable, FragmentManager fragmentManager, int popAnim) {
        Animation popAnimation;
        if ((fragmentManager = this.checkFragmentManager(fragmentManager, null)) == null) {
            return;
        }
        fragmentManager.executePendingTransactions();
        Fragment targetFragment = fragmentManager.findFragmentByTag(targetFragmentTag);
        if (targetFragment == null) {
            Log.e((String)TAG, (String)("Pop failure! Can't find FragmentTag:" + targetFragmentTag + " in the FragmentManager's Stack."));
            return;
        }
        int flag = 0;
        if (includeTargetFragment) {
            flag = 1;
            targetFragment = (Fragment)this.getPreFragment(targetFragment);
        }
        ISupportFragment fromFragment = this.getTopFragment(fragmentManager);
        if (afterPopTransactionRunnable == null && popAnim == 0) {
            popAnimation = fromFragment.getSupportDelegate().mAnimHelper.exitAnim;
        } else if (popAnim == 0) {
            popAnimation = new Animation(){};
            popAnimation.setDuration(fromFragment.getSupportDelegate().mAnimHelper.exitAnim.getDuration());
        } else {
            popAnimation = AnimationUtils.loadAnimation((Context)this.mActivity, (int)popAnim);
        }
        final int finalFlag = flag;
        final FragmentManager finalFragmentManager = fragmentManager;
        this.mockPopAnim(fromFragment, (ISupportFragment)targetFragment, popAnimation, afterPopTransactionRunnable != null, new Callback(){

            @Override
            public void call() {
                TransactionDelegate.this.popToFix(targetFragmentTag, finalFlag, finalFragmentManager);
                if (afterPopTransactionRunnable != null) {
                    TransactionDelegate.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            TransactionDelegate.this.mPopToTempFragmentManager = finalFragmentManager;
                            afterPopTransactionRunnable.run();
                            TransactionDelegate.this.mPopToTempFragmentManager = null;
                        }
                    });
                }
            }
        });
    }

    private void popToFix(String fragmentTag, int flag, final FragmentManager fragmentManager) {
        if (FragmentationHack.getActiveFragments(fragmentManager) == null) {
            return;
        }
        this.mSupport.getSupportDelegate().mPopMultipleNoAnim = true;
        fragmentManager.popBackStackImmediate(fragmentTag, flag);
        fragmentManager.executePendingTransactions();
        this.mSupport.getSupportDelegate().mPopMultipleNoAnim = false;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                FragmentationHack.reorderIndices(fragmentManager);
            }
        });
    }

    private void mockStartWithPopAnim(ISupportFragment from, ISupportFragment to, final Animation exitAnim) {
        Fragment fromF = (Fragment)from;
        final ViewGroup container = this.findContainerById(fromF, from.getSupportDelegate().mContainerId);
        if (container == null) {
            return;
        }
        from.getSupportDelegate().mLockAnim = true;
        View fromView = fromF.getView();
        container.removeViewInLayout(fromView);
        final ViewGroup mock = this.addMockView(fromView, container);
        to.getSupportDelegate().mEnterAnimListener = new SupportFragmentDelegate.EnterAnimListener(){

            @Override
            public void onEnterAnimStart() {
                mock.startAnimation(exitAnim);
                TransactionDelegate.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        container.removeView((View)mock);
                    }
                }, exitAnim.getDuration() + 50L);
            }
        };
    }

    private void mockPopAnim(ISupportFragment from, ISupportFragment targetF, Animation exitAnim, boolean afterRunnable, Callback cb) {
        if (from == targetF) {
            if (cb != null) {
                cb.call();
            }
            return;
        }
        Fragment fromF = (Fragment)from;
        ViewGroup container = this.findContainerById(fromF, from.getSupportDelegate().mContainerId);
        if (container == null) {
            return;
        }
        View fromView = fromF.getView();
        Fragment preF = (Fragment)this.getPreFragment(fromF);
        ViewGroup preViewGroup = null;
        from.getSupportDelegate().mLockAnim = true;
        if (BuildUtils.INSTANCE.getSDK_INT() < 21 && preF != targetF && preF != null && preF.getView() instanceof ViewGroup) {
            preViewGroup = (ViewGroup)preF.getView();
        }
        if (preViewGroup != null) {
            this.hideChildView(preViewGroup);
            container.removeViewInLayout(fromView);
            preViewGroup.addView(fromView);
            if (cb != null) {
                cb.call();
            }
            preViewGroup.removeViewInLayout(fromView);
            this.handleMock(exitAnim, afterRunnable, null, fromView, container);
        } else {
            container.removeViewInLayout(fromView);
            this.handleMock(exitAnim, afterRunnable, cb, fromView, container);
        }
    }

    private void handleMock(Animation exitAnim, boolean afterRunnable, Callback cb, final View fromView, final ViewGroup container) {
        final ViewGroup mock = this.addMockView(fromView, container);
        if (cb != null) {
            cb.call();
        }
        long delay = exitAnim.getDuration();
        if (afterRunnable) {
            long duration = exitAnim.getDuration();
            if (BuildUtils.INSTANCE.getSDK_INT() < 21) {
                delay = (duration += 100L) + 50L;
            } else {
                duration += 50L;
            }
            exitAnim.setDuration(duration);
        }
        exitAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                mock.setVisibility(4);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        mock.startAnimation(exitAnim);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                mock.removeViewInLayout(fromView);
                container.removeViewInLayout((View)mock);
            }
        }, delay);
    }

    @NonNull
    private ViewGroup addMockView(View fromView, ViewGroup container) {
        ViewGroup mock = new ViewGroup((Context)this.mActivity){

            protected void onLayout(boolean changed, int l, int t, int r, int b) {
            }
        };
        mock.addView(fromView);
        container.addView((View)mock);
        return mock;
    }

    private ViewGroup findContainerById(Fragment fragment, int containerId) {
        if (fragment.getView() == null) {
            return null;
        }
        Fragment parentFragment = fragment.getParentFragment();
        Object container = parentFragment != null ? (parentFragment.getView() != null ? parentFragment.getView().findViewById(containerId) : this.findContainerById(parentFragment, containerId)) : this.mActivity.findViewById(containerId);
        if (container instanceof ViewGroup) {
            return (ViewGroup)container;
        }
        return null;
    }

    private void hideChildView(ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            child.setVisibility(8);
        }
    }

    private static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    private FragmentManager checkFragmentManager(FragmentManager fragmentManager, ISupportFragment from) {
        if (fragmentManager == null) {
            if (this.mPopToTempFragmentManager == null) {
                String fromName = from == null ? "Fragment" : from.getClass().getSimpleName();
                Log.e((String)TAG, (String)(fromName + "'s FragmentManager is null,  Please check if " + fromName + " is destroyed!"));
                return null;
            }
            return this.mPopToTempFragmentManager;
        }
        return fragmentManager;
    }

    private static interface Callback {
        public void call();
    }
}

