/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation;

import android.app.Activity;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.animation.Animation;
import me.yokeyword.fragmentation.ExtraTransaction;
import me.yokeyword.fragmentation.ISupportActivity;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportHelper;
import me.yokeyword.fragmentation.TransactionDelegate;
import me.yokeyword.fragmentation.anim.FragmentAnimator;
import me.yokeyword.fragmentation.helper.internal.AnimatorHelper;
import me.yokeyword.fragmentation.helper.internal.ResultRecord;
import me.yokeyword.fragmentation.helper.internal.TransactionRecord;
import me.yokeyword.fragmentation.helper.internal.VisibleDelegate;

public class SupportFragmentDelegate {
    private boolean mEnterAnimDisable;
    boolean mIsSharedElement;
    FragmentAnimator mFragmentAnimator;
    AnimatorHelper mAnimHelper;
    boolean mLockAnim;
    private Handler mHandler;
    private boolean mFirstCreateView = true;
    private boolean mReplaceMode;
    private boolean mIsHidden = true;
    int mContainerId;
    private TransactionDelegate mTransactionDelegate;
    TransactionRecord mTransactionRecord;
    private VisibleDelegate mVisibleDelegate;
    Bundle mNewBundle;
    private Bundle mSaveInstanceState;
    private ISupportFragment mSupportF;
    private Fragment mFragment;
    protected FragmentActivity _mActivity;
    private ISupportActivity mSupport;
    boolean mAnimByActivity = true;
    EnterAnimListener mEnterAnimListener;

    public SupportFragmentDelegate(ISupportFragment support) {
        if (!(support instanceof Fragment)) {
            throw new RuntimeException("Must extends Fragment");
        }
        this.mSupportF = support;
        this.mFragment = (Fragment)support;
    }

    public ExtraTransaction extraTransaction() {
        if (this.mTransactionDelegate == null) {
            throw new RuntimeException(this.mFragment.getClass().getSimpleName() + " not attach!");
        }
        return new ExtraTransaction.ExtraTransactionImpl<ISupportFragment>(this.mSupportF, this.mTransactionDelegate, false);
    }

    public void onAttach(Activity activity) {
        if (!(activity instanceof ISupportActivity)) {
            throw new RuntimeException(activity.getClass().getSimpleName() + " must impl ISupportActivity!");
        }
        this.mSupport = (ISupportActivity)activity;
        this._mActivity = (FragmentActivity)activity;
        this.mTransactionDelegate = this.mSupport.getSupportDelegate().getTransactionDelegate();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.getVisibleDelegate().onCreate(savedInstanceState);
        Bundle bundle = this.mFragment.getArguments();
        if (bundle != null) {
            this.mEnterAnimDisable = bundle.getBoolean("fragmentation_arg_anim_disable", false);
            this.mIsSharedElement = bundle.getBoolean("fragmentation_arg_is_shared_element", false);
            this.mContainerId = bundle.getInt("fragmentation_arg_container");
            this.mReplaceMode = bundle.getBoolean("fragmentation_arg_replace", false);
        }
        if (savedInstanceState == null) {
            this.getFragmentAnimator();
        } else {
            this.mSaveInstanceState = savedInstanceState;
            this.mFragmentAnimator = (FragmentAnimator)savedInstanceState.getParcelable("fragmentation_state_save_animator");
            this.mIsHidden = savedInstanceState.getBoolean("fragmentation_state_save_status");
            this.mContainerId = savedInstanceState.getInt("fragmentation_arg_container");
        }
        this.processRestoreInstanceState(savedInstanceState);
        this.mAnimHelper = new AnimatorHelper(this._mActivity.getApplicationContext(), this.mFragmentAnimator);
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation fixedAnim;
        if (this.mSupport.getSupportDelegate().mPopMultipleNoAnim || this.mLockAnim) {
            if (transit == 8194 && enter) {
                return this.mAnimHelper.getNoneAnimFixed();
            }
            return this.mAnimHelper.getNoneAnim();
        }
        if (transit == 4097) {
            if (enter) {
                Animation enterAnim = this.mEnterAnimDisable ? this.mAnimHelper.getNoneAnim() : this.mAnimHelper.enterAnim;
                this.fixAnimationListener(enterAnim);
                return enterAnim;
            }
            return this.mAnimHelper.popExitAnim;
        }
        if (transit == 8194) {
            return enter ? this.mAnimHelper.popEnterAnim : this.mAnimHelper.exitAnim;
        }
        if (this.mIsSharedElement && enter) {
            this.compatSharedElements();
        }
        if ((fixedAnim = this.mAnimHelper.getViewPagerChildFragmentAnimFixed(this.mFragment, enter)) != null) {
            return fixedAnim;
        }
        return null;
    }

    public void onSaveInstanceState(Bundle outState) {
        this.getVisibleDelegate().onSaveInstanceState(outState);
        outState.putParcelable("fragmentation_state_save_animator", (Parcelable)this.mFragmentAnimator);
        outState.putBoolean("fragmentation_state_save_status", this.mFragment.isHidden());
        outState.putInt("fragmentation_arg_container", this.mContainerId);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        this.getVisibleDelegate().onActivityCreated(savedInstanceState);
        View view = this.mFragment.getView();
        if (view != null) {
            view.setClickable(true);
            this.setBackground(view);
        }
        if (savedInstanceState != null || this.mEnterAnimDisable || this.mFragment.getTag() != null && this.mFragment.getTag().startsWith("android:switcher:") || this.mReplaceMode && !this.mFirstCreateView) {
            this.notifyEnterAnimEnd();
        }
        if (this.mFirstCreateView) {
            this.mFirstCreateView = false;
        }
    }

    public void onResume() {
        this.getVisibleDelegate().onResume();
    }

    public void onPause() {
        this.getVisibleDelegate().onPause();
    }

    public void onDestroyView() {
        this.mSupport.getSupportDelegate().mFragmentClickable = true;
        this.getVisibleDelegate().onDestroyView();
    }

    public void onDestroy() {
        this.mTransactionDelegate.handleResultRecord(this.mFragment);
    }

    public void onHiddenChanged(boolean hidden) {
        this.getVisibleDelegate().onHiddenChanged(hidden);
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        this.getVisibleDelegate().setUserVisibleHint(isVisibleToUser);
    }

    public void enqueueAction(Runnable runnable) {
        this.getHandler().postDelayed(runnable, this.mAnimHelper == null ? 0L : this.mAnimHelper.enterAnim.getDuration());
    }

    public void onEnterAnimationEnd(Bundle savedInstanceState) {
    }

    public void onLazyInitView(@Nullable Bundle savedInstanceState) {
    }

    public void onSupportVisible() {
    }

    public void onSupportInvisible() {
    }

    public final boolean isSupportVisible() {
        return this.getVisibleDelegate().isSupportVisible();
    }

    public FragmentAnimator onCreateFragmentAnimator() {
        return this.mSupport.getFragmentAnimator();
    }

    public FragmentAnimator getFragmentAnimator() {
        if (this.mSupport == null) {
            throw new RuntimeException("Fragment has not been attached to Activity!");
        }
        if (this.mFragmentAnimator == null) {
            this.mFragmentAnimator = this.mSupportF.onCreateFragmentAnimator();
            if (this.mFragmentAnimator == null) {
                this.mFragmentAnimator = this.mSupport.getFragmentAnimator();
            }
        }
        return this.mFragmentAnimator;
    }

    public void setFragmentAnimator(FragmentAnimator fragmentAnimator) {
        this.mFragmentAnimator = fragmentAnimator;
        if (this.mAnimHelper != null) {
            this.mAnimHelper.notifyChanged(fragmentAnimator);
        }
        this.mAnimByActivity = false;
    }

    public void setFragmentResult(int resultCode, Bundle bundle) {
        Bundle args = this.mFragment.getArguments();
        if (args == null || !args.containsKey("fragment_arg_result_record")) {
            return;
        }
        ResultRecord resultRecord = (ResultRecord)args.getParcelable("fragment_arg_result_record");
        if (resultRecord != null) {
            resultRecord.resultCode = resultCode;
            resultRecord.resultBundle = bundle;
        }
    }

    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
    }

    public void onNewBundle(Bundle args) {
    }

    public void putNewBundle(Bundle newBundle) {
        this.mNewBundle = newBundle;
    }

    public boolean onBackPressedSupport() {
        return false;
    }

    public void hideSoftInput() {
        SupportHelper.hideSoftInput(this.mFragment.getView());
    }

    public void showSoftInput(View view) {
        SupportHelper.showSoftInput(view);
    }

    public void loadRootFragment(int containerId, ISupportFragment toFragment) {
        this.loadRootFragment(containerId, toFragment, true, false);
    }

    public void loadRootFragment(int containerId, ISupportFragment toFragment, boolean addToBackStack, boolean allowAnim) {
        this.mTransactionDelegate.loadRootTransaction(this.getChildFragmentManager(), containerId, toFragment, addToBackStack, allowAnim);
    }

    public void loadMultipleRootFragment(int containerId, int showPosition, ISupportFragment ... toFragments) {
        this.mTransactionDelegate.loadMultipleRootTransaction(this.getChildFragmentManager(), containerId, showPosition, toFragments);
    }

    public void showHideFragment(ISupportFragment showFragment) {
        this.showHideFragment(showFragment, null);
    }

    public void showHideFragment(ISupportFragment showFragment, ISupportFragment hideFragment) {
        this.mTransactionDelegate.showHideFragment(this.getChildFragmentManager(), showFragment, hideFragment);
    }

    public void start(ISupportFragment toFragment) {
        this.start(toFragment, 0);
    }

    public void start(ISupportFragment toFragment, int launchMode) {
        this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), this.mSupportF, toFragment, 0, launchMode, 0);
    }

    public void startForResult(ISupportFragment toFragment, int requestCode) {
        this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), this.mSupportF, toFragment, requestCode, 0, 2);
    }

    public void startWithPop(ISupportFragment toFragment) {
        this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), this.mSupportF, toFragment, 0, 0, 1);
    }

    public void replaceFragment(ISupportFragment toFragment, boolean addToBackStack) {
        this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), this.mSupportF, toFragment, 0, 0, addToBackStack ? 10 : 14);
    }

    public void startChild(ISupportFragment toFragment) {
        this.startChild(toFragment, 0);
    }

    public void startChild(ISupportFragment toFragment, int launchMode) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getChildFragmentManager(), this.getTopFragment(), toFragment, 0, launchMode, 0);
    }

    public void startChildForResult(ISupportFragment toFragment, int requestCode) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getChildFragmentManager(), this.getTopFragment(), toFragment, requestCode, 0, 2);
    }

    public void startChildWithPop(ISupportFragment toFragment) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getChildFragmentManager(), this.getTopFragment(), toFragment, 0, 0, 1);
    }

    public void replaceChildFragment(ISupportFragment toFragment, boolean addToBackStack) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getChildFragmentManager(), this.getTopFragment(), toFragment, 0, 0, addToBackStack ? 10 : 14);
    }

    public void pop() {
        this.mTransactionDelegate.back(this.mFragment.getFragmentManager());
    }

    public void popChild() {
        this.mTransactionDelegate.back(this.getChildFragmentManager());
    }

    public void popTo(Class<?> targetFragmentClass, boolean includeTargetFragment) {
        this.getChildFragmentManager().popBackStack();
        this.popTo(targetFragmentClass, includeTargetFragment, null);
    }

    public void popTo(Class<?> targetFragmentClass, boolean includeTargetFragment, Runnable afterPopTransactionRunnable) {
        this.popTo(targetFragmentClass, includeTargetFragment, afterPopTransactionRunnable, 0);
    }

    public void popTo(Class<?> targetFragmentClass, boolean includeTargetFragment, Runnable afterPopTransactionRunnable, int popAnim) {
        this.mTransactionDelegate.popTo(targetFragmentClass.getName(), includeTargetFragment, afterPopTransactionRunnable, this.mFragment.getFragmentManager(), popAnim);
    }

    public void popToChild(Class<?> targetFragmentClass, boolean includeTargetFragment) {
        this.popToChild(targetFragmentClass, includeTargetFragment, null);
    }

    public void popToChild(Class<?> targetFragmentClass, boolean includeTargetFragment, Runnable afterPopTransactionRunnable) {
        this.popToChild(targetFragmentClass, includeTargetFragment, afterPopTransactionRunnable, 0);
    }

    public void popToChild(Class<?> targetFragmentClass, boolean includeTargetFragment, Runnable afterPopTransactionRunnable, int popAnim) {
        this.mTransactionDelegate.popTo(targetFragmentClass.getName(), includeTargetFragment, afterPopTransactionRunnable, this.getChildFragmentManager(), popAnim);
    }

    private FragmentManager getChildFragmentManager() {
        return this.mFragment.getChildFragmentManager();
    }

    private ISupportFragment getTopFragment() {
        return SupportHelper.getTopFragment(this.getChildFragmentManager());
    }

    private void processRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            FragmentTransaction ft = this.mFragment.getFragmentManager().beginTransaction();
            if (this.mIsHidden) {
                ft.hide(this.mFragment);
            } else {
                ft.show(this.mFragment);
            }
            ft.commitAllowingStateLoss();
        }
    }

    private void fixAnimationListener(Animation enterAnim) {
        this.mSupport.getSupportDelegate().mFragmentClickable = false;
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SupportFragmentDelegate.this.notifyEnterAnimEnd();
            }
        }, enterAnim.getDuration());
        if (this.mEnterAnimListener != null) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    SupportFragmentDelegate.this.mEnterAnimListener.onEnterAnimStart();
                    SupportFragmentDelegate.this.mEnterAnimListener = null;
                }
            });
        }
    }

    private void compatSharedElements() {
        this.notifyEnterAnimEnd();
    }

    public void setBackground(View view) {
        if (this.mFragment.getTag() != null && this.mFragment.getTag().startsWith("android:switcher:") || this.mEnterAnimDisable || view.getBackground() != null) {
            return;
        }
        int defaultBg = this.mSupport.getSupportDelegate().getDefaultFragmentBackground();
        if (defaultBg == 0) {
            int background = this.getWindowBackground();
            view.setBackgroundResource(background);
        } else {
            view.setBackgroundResource(defaultBg);
        }
    }

    private int getWindowBackground() {
        TypedArray a = this._mActivity.getTheme().obtainStyledAttributes(new int[]{16842836});
        int background = a.getResourceId(0, 0);
        a.recycle();
        return background;
    }

    private void notifyEnterAnimEnd() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (SupportFragmentDelegate.this.mFragment == null) {
                    return;
                }
                SupportFragmentDelegate.this.mSupportF.onEnterAnimationEnd(SupportFragmentDelegate.this.mSaveInstanceState);
            }
        });
        this.mSupport.getSupportDelegate().mFragmentClickable = true;
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    public VisibleDelegate getVisibleDelegate() {
        if (this.mVisibleDelegate == null) {
            this.mVisibleDelegate = new VisibleDelegate(this.mSupportF);
        }
        return this.mVisibleDelegate;
    }

    public FragmentActivity getActivity() {
        return this._mActivity;
    }

    static interface EnterAnimListener {
        public void onEnterAnimStart();
    }
}

