/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentationHack;
import android.view.MotionEvent;
import me.yokeyword.fragmentation.ExtraTransaction;
import me.yokeyword.fragmentation.Fragmentation;
import me.yokeyword.fragmentation.ISupportActivity;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragmentDelegate;
import me.yokeyword.fragmentation.SupportHelper;
import me.yokeyword.fragmentation.TransactionDelegate;
import me.yokeyword.fragmentation.anim.DefaultVerticalAnimator;
import me.yokeyword.fragmentation.anim.FragmentAnimator;
import me.yokeyword.fragmentation.debug.DebugStackDelegate;

public class SupportActivityDelegate {
    private ISupportActivity mSupport;
    private FragmentActivity mActivity;
    boolean mPopMultipleNoAnim = false;
    boolean mFragmentClickable = true;
    private TransactionDelegate mTransactionDelegate;
    private FragmentAnimator mFragmentAnimator;
    private int mDefaultFragmentBackground = 0;
    private DebugStackDelegate mDebugStackDelegate;

    public SupportActivityDelegate(ISupportActivity support) {
        if (!(support instanceof Activity)) {
            throw new RuntimeException("Must extends FragmentActivity/AppCompatActivity");
        }
        this.mSupport = support;
        this.mActivity = (FragmentActivity)support;
    }

    public ExtraTransaction extraTransaction() {
        return new ExtraTransaction.ExtraTransactionImpl<ISupportFragment>(this.getTopFragment(), this.getTransactionDelegate(), true);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.mTransactionDelegate = this.getTransactionDelegate();
        this.mDebugStackDelegate = new DebugStackDelegate(this.mActivity);
        this.mFragmentAnimator = this.mSupport.onCreateFragmentAnimator();
        this.mDebugStackDelegate.onCreate(Fragmentation.getDefault().getMode());
    }

    public TransactionDelegate getTransactionDelegate() {
        if (this.mTransactionDelegate == null) {
            this.mTransactionDelegate = new TransactionDelegate(this.mSupport);
        }
        return this.mTransactionDelegate;
    }

    public void onPostCreate(@Nullable Bundle savedInstanceState) {
        this.mDebugStackDelegate.onPostCreate(Fragmentation.getDefault().getMode());
    }

    public FragmentAnimator getFragmentAnimator() {
        return this.mFragmentAnimator.copy();
    }

    public void setFragmentAnimator(FragmentAnimator fragmentAnimator) {
        this.mFragmentAnimator = fragmentAnimator;
        for (Fragment fragment : FragmentationHack.getActiveFragments(this.getSupportFragmentManager())) {
            if (!(fragment instanceof ISupportFragment)) continue;
            ISupportFragment iF = (ISupportFragment)fragment;
            SupportFragmentDelegate delegate = iF.getSupportDelegate();
            if (!delegate.mAnimByActivity) continue;
            delegate.mFragmentAnimator = fragmentAnimator.copy();
            if (delegate.mAnimHelper == null) continue;
            delegate.mAnimHelper.notifyChanged(delegate.mFragmentAnimator);
        }
    }

    public FragmentAnimator onCreateFragmentAnimator() {
        return new DefaultVerticalAnimator();
    }

    public void setDefaultFragmentBackground(@DrawableRes int backgroundRes) {
        this.mDefaultFragmentBackground = backgroundRes;
    }

    public int getDefaultFragmentBackground() {
        return this.mDefaultFragmentBackground;
    }

    public void showFragmentStackHierarchyView() {
        this.mDebugStackDelegate.showFragmentStackHierarchyView();
    }

    public void logFragmentStackHierarchy(String TAG) {
        this.mDebugStackDelegate.logFragmentRecords(TAG);
    }

    public void onBackPressed() {
        ISupportFragment activeFragment;
        if (!this.mFragmentClickable) {
            this.mFragmentClickable = true;
        }
        if (this.mTransactionDelegate.dispatchBackPressedEvent(activeFragment = SupportHelper.getActiveFragment(this.getSupportFragmentManager()))) {
            return;
        }
        this.mSupport.onBackPressedSupport();
    }

    public void onBackPressedSupport() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 1) {
            this.pop();
        } else {
            ActivityCompat.finishAfterTransition((Activity)this.mActivity);
        }
    }

    public void onDestroy() {
        this.mDebugStackDelegate.onDestroy();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return !this.mFragmentClickable;
    }

    public void loadRootFragment(int containerId, ISupportFragment toFragment) {
        this.loadRootFragment(containerId, toFragment, true, false);
    }

    public void loadRootFragment(int containerId, ISupportFragment toFragment, boolean addToBackStack, boolean allowAnimation) {
        this.mTransactionDelegate.loadRootTransaction(this.getSupportFragmentManager(), containerId, toFragment, addToBackStack, allowAnimation);
    }

    public void loadMultipleRootFragment(int containerId, int showPosition, ISupportFragment ... toFragments) {
        this.mTransactionDelegate.loadMultipleRootTransaction(this.getSupportFragmentManager(), containerId, showPosition, toFragments);
    }

    public void showHideFragment(ISupportFragment showFragment) {
        this.showHideFragment(showFragment, null);
    }

    public void showHideFragment(ISupportFragment showFragment, ISupportFragment hideFragment) {
        this.mTransactionDelegate.showHideFragment(this.getSupportFragmentManager(), showFragment, hideFragment);
    }

    public void start(ISupportFragment toFragment) {
        this.start(toFragment, 0);
    }

    public void start(ISupportFragment toFragment, int launchMode) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getSupportFragmentManager(), this.getTopFragment(), toFragment, 0, launchMode, 0);
    }

    public void startForResult(ISupportFragment toFragment, int requestCode) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getSupportFragmentManager(), this.getTopFragment(), toFragment, requestCode, 0, 2);
    }

    public void startWithPop(ISupportFragment toFragment) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getSupportFragmentManager(), this.getTopFragment(), toFragment, 0, 0, 1);
    }

    public void replaceFragment(ISupportFragment toFragment, boolean addToBackStack) {
        this.mTransactionDelegate.dispatchStartTransaction(this.getSupportFragmentManager(), this.getTopFragment(), toFragment, 0, 0, addToBackStack ? 10 : 14);
    }

    public void pop() {
        this.mTransactionDelegate.back(this.getSupportFragmentManager());
    }

    public void popTo(Class<?> targetFragmentClass, boolean includeTargetFragment) {
        this.popTo(targetFragmentClass, includeTargetFragment, null);
    }

    public void popTo(Class<?> targetFragmentClass, boolean includeTargetFragment, Runnable afterPopTransactionRunnable) {
        this.popTo(targetFragmentClass, includeTargetFragment, afterPopTransactionRunnable, 0);
    }

    public void popTo(Class<?> targetFragmentClass, boolean includeTargetFragment, Runnable afterPopTransactionRunnable, int popAnim) {
        this.mTransactionDelegate.popTo(targetFragmentClass.getName(), includeTargetFragment, afterPopTransactionRunnable, this.getSupportFragmentManager(), popAnim);
    }

    private FragmentManager getSupportFragmentManager() {
        return this.mActivity.getSupportFragmentManager();
    }

    private ISupportFragment getTopFragment() {
        return SupportHelper.getTopFragment(this.getSupportFragmentManager());
    }
}

