/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation;

import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.view.View;
import java.util.ArrayList;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.TransactionDelegate;
import me.yokeyword.fragmentation.helper.internal.TransactionRecord;

public abstract class ExtraTransaction {
    public abstract ExtraSupportTransaction setTag(String var1);

    @RequiresApi(value=22)
    public abstract ExtraSupportTransaction addSharedElement(View var1, String var2);

    public abstract DontAddToBackStackTransaction dontAddToBackStack();

    public abstract void remove(ISupportFragment var1, boolean var2);

    public abstract void popTo(String var1, boolean var2);

    public abstract void popTo(String var1, boolean var2, Runnable var3, int var4);

    public abstract void popToChild(String var1, boolean var2);

    public abstract void popToChild(String var1, boolean var2, Runnable var3, int var4);

    static final class ExtraTransactionImpl<T extends ISupportFragment>
    extends ExtraTransaction
    implements DontAddToBackStackTransaction,
    ExtraSupportTransaction {
        private T mSupportF;
        private Fragment mFragment;
        private TransactionDelegate mTransactionDelegate;
        private boolean mFromActivity;
        private TransactionRecord mRecord;

        ExtraTransactionImpl(T supportF, TransactionDelegate transactionDelegate, boolean fromActivity) {
            this.mSupportF = supportF;
            this.mFragment = (Fragment)supportF;
            this.mTransactionDelegate = transactionDelegate;
            this.mFromActivity = fromActivity;
            this.mRecord = new TransactionRecord();
        }

        @Override
        public ExtraSupportTransaction setTag(String tag) {
            this.mRecord.tag = tag;
            return this;
        }

        @Override
        public ExtraSupportTransaction addSharedElement(View sharedElement, String sharedName) {
            if (this.mRecord.sharedElementList == null) {
                this.mRecord.sharedElementList = new ArrayList();
            }
            this.mRecord.sharedElementList.add(new TransactionRecord.SharedElement(sharedElement, sharedName));
            return this;
        }

        @Override
        public DontAddToBackStackTransaction dontAddToBackStack() {
            this.mRecord.dontAddToBackStack = true;
            return this;
        }

        @Override
        public void remove(ISupportFragment fragment, boolean showPreFragment) {
            this.mTransactionDelegate.remove(this.mFragment.getFragmentManager(), (Fragment)fragment, showPreFragment);
        }

        @Override
        public void popTo(String targetFragmentTag, boolean includeTargetFragment) {
            this.popTo(targetFragmentTag, includeTargetFragment, null, 0);
        }

        @Override
        public void popTo(String targetFragmentTag, boolean includeTargetFragment, Runnable afterPopTransactionRunnable, int popAnim) {
            this.mTransactionDelegate.popTo(targetFragmentTag, includeTargetFragment, afterPopTransactionRunnable, this.mFragment.getFragmentManager(), popAnim);
        }

        @Override
        public void popToChild(String targetFragmentTag, boolean includeTargetFragment) {
            this.popToChild(targetFragmentTag, includeTargetFragment, null, 0);
        }

        @Override
        public void popToChild(String targetFragmentTag, boolean includeTargetFragment, Runnable afterPopTransactionRunnable, int popAnim) {
            if (this.mFromActivity) {
                this.popTo(targetFragmentTag, includeTargetFragment, afterPopTransactionRunnable, popAnim);
            } else {
                this.mTransactionDelegate.popTo(targetFragmentTag, includeTargetFragment, afterPopTransactionRunnable, this.mFragment.getChildFragmentManager(), popAnim);
            }
        }

        @Override
        public void add(ISupportFragment toFragment) {
            toFragment.getSupportDelegate().mTransactionRecord = this.mRecord;
            this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), (ISupportFragment)this.mSupportF, toFragment, 0, 0, 3);
        }

        @Override
        public void start(ISupportFragment toFragment) {
            this.start(toFragment, 0);
        }

        @Override
        public void replace(ISupportFragment toFragment) {
            toFragment.getSupportDelegate().mTransactionRecord = this.mRecord;
            this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), (ISupportFragment)this.mSupportF, toFragment, 0, 0, 10);
        }

        @Override
        public void start(ISupportFragment toFragment, int launchMode) {
            toFragment.getSupportDelegate().mTransactionRecord = this.mRecord;
            this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), (ISupportFragment)this.mSupportF, toFragment, 0, launchMode, 0);
        }

        @Override
        public void startForResult(ISupportFragment toFragment, int requestCode) {
            toFragment.getSupportDelegate().mTransactionRecord = this.mRecord;
            this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), (ISupportFragment)this.mSupportF, toFragment, requestCode, 0, 2);
        }

        @Override
        public void startWithPop(ISupportFragment toFragment) {
            toFragment.getSupportDelegate().mTransactionRecord = this.mRecord;
            this.mTransactionDelegate.dispatchStartTransaction(this.mFragment.getFragmentManager(), (ISupportFragment)this.mSupportF, toFragment, 0, 0, 1);
        }
    }

    public static interface ExtraSupportTransaction {
        public ExtraSupportTransaction setTag(String var1);

        @RequiresApi(value=22)
        public ExtraSupportTransaction addSharedElement(View var1, String var2);

        public void start(ISupportFragment var1);

        public void start(ISupportFragment var1, int var2);

        public void startForResult(ISupportFragment var1, int var2);

        public void startWithPop(ISupportFragment var1);

        public void replace(ISupportFragment var1);
    }

    public static interface DontAddToBackStackTransaction {
        public void start(ISupportFragment var1);

        public void add(ISupportFragment var1);

        public void replace(ISupportFragment var1);
    }
}

