/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.floatview;

import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

public abstract class BaseIconView
extends ConstraintLayout {
    private static final String TAG = "ICON_VIEW";
    public static int sViewWidth;
    public static int sViewHeight;
    private static int sStatusBarHeight;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mParams;
    private float xInScreen;
    private float yInScreen;
    private float xDownInScreen;
    private float yDownInScreen;
    private float xInView;
    private float yInView;
    public ImageView mView;
    private View layout;

    public BaseIconView(Context context) {
        super(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this);
        this.layout = this.findViewById(this.getRootId());
        sViewWidth = this.layout.getLayoutParams().width;
        sViewHeight = this.layout.getLayoutParams().height;
    }

    public abstract int getLayoutId();

    public abstract int getRootId();

    public abstract int getDefaultX();

    public abstract int getDefaultY();

    public boolean onTouchEvent(MotionEvent event) {
        this.xInScreen = event.getRawX();
        this.yInScreen = this.ignoreStatusBar() ? event.getRawY() : event.getRawY() - (float)this.getStatusBarHeight();
        switch (event.getAction()) {
            case 0: {
                this.xInView = event.getX();
                this.yInView = event.getY();
                this.xDownInScreen = event.getRawX();
                if (this.ignoreStatusBar()) {
                    this.yDownInScreen = event.getRawY();
                    break;
                }
                this.yDownInScreen = event.getRawY() - (float)this.getStatusBarHeight();
                break;
            }
            case 2: {
                if (!this.needUpdateViewPosition()) break;
                this.updateViewPosition();
                break;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    private boolean needUpdateViewPosition() {
        return Math.abs(this.xInScreen - this.xDownInScreen) > 12.0f || Math.abs(this.yInScreen - this.yDownInScreen) > 12.0f;
    }

    public void setParams(WindowManager.LayoutParams params) {
        this.mParams = params;
    }

    private void updateViewPosition() {
        this.mParams.x = (int)(this.xInScreen - this.xInView);
        this.mParams.y = (int)(this.yInScreen - this.yInView) - 60;
        int minUnit = 0;
        minUnit = this.ignoreStatusBar() ? 0 : this.getStatusBarHeight();
        if (this.mParams.y < minUnit) {
            this.mParams.y = minUnit;
        } else if (this.mParams.y > DisplayUtil.getScreenHeight((Context)this.getContext()) - minUnit) {
            this.mParams.y = DisplayUtil.getScreenHeight((Context)this.getContext()) - minUnit;
        }
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    public int getLocationX() {
        if (null == this.mParams) {
            return this.getDefaultX();
        }
        return this.mParams.x;
    }

    public int getLocationY() {
        if (null == this.mParams) {
            return this.getDefaultY();
        }
        return this.mParams.y;
    }

    protected boolean ignoreStatusBar() {
        return false;
    }

    protected int getStatusBarHeight() {
        if (sStatusBarHeight == 0) {
            sStatusBarHeight = DisplayUtil.getStatusBarHeight((Context)this.getContext());
        }
        return sStatusBarHeight;
    }
}

