/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file.mimetype;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.bihe0832.android.lib.file.FileUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/bihe0832/android/lib/file/mimetype/FileMimeTypes;", "", "()V", "mMimeTypes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getMimeType", "filename", "getTypeByExtension", "extension", "isApkFile", "", "isArchive", "file", "isAudioFile", "Ljava/io/File;", "path", "isImageFile", "isTextFile", "isVideoFile", "putTypeByExtension", "", "type", "LibFile_release"})
public final class FileMimeTypes {
    private static final ConcurrentHashMap<String, String> mMimeTypes;
    public static final FileMimeTypes INSTANCE;

    private final void putTypeByExtension(String extension, String type) {
        String string2 = extension;
        Map map = mMimeTypes;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        map.put(string5, type);
    }

    private final String getTypeByExtension(String extension) {
        String string2;
        String string3 = extension;
        ConcurrentHashMap<String, String> concurrentHashMap = mMimeTypes;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String string6 = string5;
        if (concurrentHashMap.contains(string6)) {
            string3 = extension;
            concurrentHashMap = mMimeTypes;
            bl = false;
            String string7 = string3;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
            string6 = string8;
            string2 = concurrentHashMap.get(string6);
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final String getMimeType(@Nullable String filename) {
        String extension = FileUtils.INSTANCE.getExtensionName(filename);
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return "*/*";
        }
        String string2 = this.getTypeByExtension(extension);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        if (TextUtils.isEmpty((CharSequence)it)) {
            String string3;
            String string4 = extension;
            int n = 1;
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            boolean bl4 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            string4 = mimeTypeMap.getMimeTypeFromExtension(string7);
            n = 0;
            bl4 = false;
            String webkitMimeType = string4;
            boolean bl5 = false;
            String string8 = webkitMimeType;
            if (string8 != null) {
                String string9 = string8;
                boolean bl6 = false;
                boolean bl7 = false;
                String it2 = string9;
                boolean bl8 = false;
                INSTANCE.putTypeByExtension(extension, webkitMimeType);
            }
            if ((string3 = webkitMimeType) == null) {
                string3 = "*/*";
            }
            return string3;
        }
        return it;
    }

    public final boolean isTextFile(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return StringsKt.startsWith$default((String)this.getMimeType(file), (String)"text", (boolean)false, (int)2, null);
    }

    public final boolean isImageFile(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String ext = FileUtils.INSTANCE.getExtensionName(file);
        return StringsKt.startsWith$default((String)this.getMimeType(file), (String)"image/", (boolean)false, (int)2, null) ? true : StringsKt.equals((String)ext, (String)"png", (boolean)true) || StringsKt.equals((String)ext, (String)"jpg", (boolean)true) || StringsKt.equals((String)ext, (String)"jpeg", (boolean)true) || StringsKt.equals((String)ext, (String)"gif", (boolean)true) || StringsKt.equals((String)ext, (String)"tiff", (boolean)true) || StringsKt.equals((String)ext, (String)"tif", (boolean)true);
    }

    public final boolean isApkFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return StringsKt.endsWith$default((String)filename, (String)".apk", (boolean)false, (int)2, null);
    }

    public final boolean isArchive(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return StringsKt.endsWith((String)file, (String)".zip", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isVideoFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) return false;
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        if (!this.isVideoFile(string2)) return false;
        return true;
    }

    public final boolean isVideoFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)this.getMimeType(path), (String)"video/", (boolean)false, (int)2, null)) {
            return true;
        }
        String ext = FileUtils.INSTANCE.getExtensionName(path);
        return StringsKt.equals((String)ext, (String)"mp4", (boolean)true) || StringsKt.equals((String)ext, (String)"3gp", (boolean)true) || StringsKt.equals((String)ext, (String)"avi", (boolean)true) || StringsKt.equals((String)ext, (String)"webm", (boolean)true) || StringsKt.equals((String)ext, (String)"m4v", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAudioFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) return false;
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        if (!this.isAudioFile(string2)) return false;
        return true;
    }

    public final boolean isAudioFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)this.getMimeType(path), (String)"audio/", (boolean)false, (int)2, null)) {
            return true;
        }
        String ext = FileUtils.INSTANCE.getExtensionName(path);
        return StringsKt.equals((String)ext, (String)"mp3", (boolean)true) || StringsKt.equals((String)ext, (String)"wma", (boolean)true) || StringsKt.equals((String)ext, (String)"flac", (boolean)true) || StringsKt.equals((String)ext, (String)"wav", (boolean)true) || StringsKt.equals((String)ext, (String)"aac", (boolean)true) || StringsKt.equals((String)ext, (String)"ogg", (boolean)true) || StringsKt.equals((String)ext, (String)"m4a", (boolean)true);
    }

    private FileMimeTypes() {
    }

    static {
        FileMimeTypes fileMimeTypes;
        INSTANCE = fileMimeTypes = new FileMimeTypes();
        mMimeTypes = new ConcurrentHashMap();
    }
}

