/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.wrapper;

import android.content.Context;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.core.DownloadManager;
import com.bihe0832.android.lib.download.core.list.DownloadTaskList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DownloadUtils {
    public static final void init(Context context, int maxDownloadNum, DownloadListener listener, Boolean isDebug) {
        DownloadManager.INSTANCE.init(context, maxDownloadNum, listener, isDebug);
    }

    public static void onDestroy() {
        DownloadManager.INSTANCE.onDestroy();
    }

    public static final void startDownload(Context context, @NotNull DownloadItem info, boolean forceDownload) {
        DownloadManager.INSTANCE.init(context);
        DownloadManager.INSTANCE.addTask(info, forceDownload);
    }

    public static final void startDownload(Context context, @NotNull DownloadItem info) {
        info.setForceDownloadNew(true);
        DownloadUtils.startDownload(context, info, info.isForceDownloadNew());
    }

    public static final void addDownloadListener(DownloadListener listener) {
        DownloadManager.INSTANCE.addGlobalDownloadListener(listener);
    }

    public static final void removeDownloadListener(DownloadListener listener) {
        DownloadManager.INSTANCE.removeGlobalDownloadListener(listener);
    }

    public static final DownloadItem getTaskByDownloadURL(@NotNull String downloadURL) {
        return DownloadTaskList.INSTANCE.getTaskByDownloadURL(downloadURL);
    }

    public static long getDownloadIDByURL(String url) {
        return DownloadItem.getDownloadIDByURL(url);
    }

    public static final void pauseDownload(@NotNull long downloadID) {
        DownloadManager.INSTANCE.pauseTask(downloadID, true, false);
    }

    public static final void resumeDownload(long downloadID, boolean pauseOnMobile) {
        DownloadManager.INSTANCE.resumeTask(downloadID, null, true, pauseOnMobile, false);
    }

    public static final void deleteTask(long downloadID, boolean deleteFile2) {
        DownloadManager.INSTANCE.deleteTask(downloadID, true, deleteFile2);
    }

    public static final void pauseAll() {
        DownloadManager.INSTANCE.pauseAllTask(true);
    }

    public static final void pauseDownloading() {
        DownloadManager.INSTANCE.pauseDownloadingTask(true);
    }

    public static final void pauseWaiting() {
        DownloadManager.INSTANCE.pauseWaitingTask(true);
    }

    public static final void resumeAll(boolean pauseOnMobile) {
        DownloadManager.INSTANCE.resumeAllTask(pauseOnMobile);
    }

    public static final void resumeFailed(boolean pauseOnMobile) {
        DownloadManager.INSTANCE.resumeFailedTask(pauseOnMobile);
    }

    public static final void resumePause(boolean pauseOnMobile) {
        DownloadManager.INSTANCE.resumePauseTask(pauseOnMobile);
    }

    @NotNull
    public static final List getAll() {
        return DownloadManager.INSTANCE.getAllTask();
    }

    @NotNull
    public static final List getFinished() {
        return DownloadManager.INSTANCE.getFinishedTask();
    }

    @NotNull
    public static final List getDownloading() {
        return DownloadManager.INSTANCE.getDownloadingTask();
    }

    @NotNull
    public static final List getWaiting() {
        return DownloadManager.INSTANCE.getWaitingTask();
    }
}

