/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.part;

import android.text.TextUtils;
import com.bihe0832.android.lib.download.DownloadPartInfo;
import com.bihe0832.android.lib.download.core.ConnectionUpdateKt;
import com.bihe0832.android.lib.download.dabase.DownloadInfoDBManager;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.request.HTTPRequestUtils;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/bihe0832/android/lib/download/part/DownloadThread;", "Ljava/lang/Thread;", "mDownloadPartInfo", "Lcom/bihe0832/android/lib/download/DownloadPartInfo;", "(Lcom/bihe0832/android/lib/download/DownloadPartInfo;)V", "DOWNLOAD_SVAE_SIZE", "", "DOWNLOAD_SVAE_TIMER", "retryTimes", "getDownloadPartInfo", "run", "", "startDownload", "", "randomAccessFile", "Ljava/io/RandomAccessFile;", "finalStart", "", "LibDownload_release"})
public final class DownloadThread
extends Thread {
    private final int DOWNLOAD_SVAE_TIMER = 10000;
    private final int DOWNLOAD_SVAE_SIZE = 20480000;
    private int retryTimes;
    private final DownloadPartInfo mDownloadPartInfo;

    @NotNull
    public final DownloadPartInfo getDownloadPartInfo() {
        return this.mDownloadPartInfo;
    }

    @Override
    public void run() {
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u51c6\u5907 \u5206\u7247\u4fe1\u606f:" + this.mDownloadPartInfo));
        if (TextUtils.isEmpty((CharSequence)this.mDownloadPartInfo.getFinalFileName())) {
            ZLog.e((String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb  \u5206\u7247\u4fe1\u606f\u9519\u8bef\uff0c\u9519\u8bef\u7684\u672c\u5730\u8def\u5f84\uff1a" + this.mDownloadPartInfo));
            this.mDownloadPartInfo.setPartStatus(7);
            return;
        }
        if (this.mDownloadPartInfo.getPartFinished() > 0L && this.mDownloadPartInfo.getPartStart() + this.mDownloadPartInfo.getPartFinished() == this.mDownloadPartInfo.getPartEnd()) {
            ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: \u5206\u7247\u6b64\u524d\u5df2\u7ecf\u4e0b\u8f7d\u7ed3\u675f"));
            this.mDownloadPartInfo.setPartStatus(5);
            return;
        }
        File file = new File(this.mDownloadPartInfo.getFinalFileName());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        while (true) {
            long newStart;
            long l;
            if (this.mDownloadPartInfo.getPartEnd() > 0L) {
                if (this.mDownloadPartInfo.getPartFinished() > (long)16384) {
                    ZLog.w((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u56de\u9000\u8fdb\u5ea6\u7b80\u8981\u4fe1\u606f \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247:  \u53ef\u4ee5\u56de\u9000"));
                    l = this.mDownloadPartInfo.getPartStart() + this.mDownloadPartInfo.getPartFinished() - (long)16384;
                } else {
                    l = this.mDownloadPartInfo.getPartStart();
                }
            } else {
                l = newStart = 0L;
            }
            if (newStart < 0L) {
                newStart = 0L;
            }
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.parentFile");
            String string = file2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.parentFile.absolutePath");
            long availableSpace = FileUtils.INSTANCE.getDirectoryAvailableSpace(string);
            long needSpace = this.mDownloadPartInfo.getPartEnd() - newStart;
            if (needSpace > 0L && needSpace > availableSpace) {
                this.mDownloadPartInfo.setPartStatus(7);
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u5931\u8d25 \u4e0b\u8f7d\u5f02\u5e38 " + this.retryTimes + "\uff01\uff01\uff01\uff01\u5b58\u50a8\u7a7a\u95f4\u4e0d\u8db3, availableSpace: " + availableSpace + ", need: " + (this.mDownloadPartInfo.getPartEnd() - newStart) + ' '));
                break;
            }
            ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u56de\u9000\u8fdb\u5ea6\u7b80\u8981\u4fe1\u606f \u5206\u7247\u4e0b\u8f7d\u524d:  \u5206\u7247\u5f00\u5934\uff1a" + this.mDownloadPartInfo.getPartStart() + ", \u672c\u6b21\u5f00\u5934\uff1a" + (this.mDownloadPartInfo.getPartStart() + this.mDownloadPartInfo.getPartFinished()) + " \u56de\u9000\u540e\u5f00\u5934\uff1a" + newStart + ", \u5206\u7247\u7ed3\u675f " + this.mDownloadPartInfo.getPartEnd() + ", \u5df2\u5b8c\u6210\uff1a" + this.mDownloadPartInfo.getPartFinished()));
            this.mDownloadPartInfo.setPartFinished(newStart - this.mDownloadPartInfo.getPartStart());
            this.mDownloadPartInfo.setPartFinishedBefore(this.mDownloadPartInfo.getPartFinished());
            DownloadInfoDBManager.INSTANCE.saveDownloadPartInfo(this.mDownloadPartInfo);
            if (this.mDownloadPartInfo.getPartEnd() > 0L) {
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247 \u5f00\u59cb: start: " + this.mDownloadPartInfo.getPartStart() + ", finalStart : " + newStart + " end: " + this.mDownloadPartInfo.getPartEnd()));
            } else {
                ZLog.d((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\uff1a\u5206\u7247\u957f\u5ea6\u5f02\u5e38\uff0c\u4ece\u5934\u4e0b\u8f7d"));
            }
            try {
                randomAccessFile.seek(newStart);
            }
            catch (Exception e) {
                e.printStackTrace();
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u5f00\u59cb \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247 \u6587\u4ef6\u79fb\u52a8\u5f02\u5e38 :" + e.getClass().getName()));
                this.mDownloadPartInfo.setPartStatus(7);
                break;
            }
            try {
                if (this.startDownload(randomAccessFile, newStart)) continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u5f02\u5e38 " + this.retryTimes + "\uff01\uff01\uff01\uff01:" + e.getClass().getName()));
                String string2 = this.mDownloadPartInfo.getDownloadPartID();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mDownloadPartInfo.downloadPartID");
                DownloadInfoDBManager.INSTANCE.updateDownloadFinished(string2, this.mDownloadPartInfo.getPartFinished());
                Thread.sleep(3L);
                if (this.retryTimes < 3) {
                    int n = this.retryTimes;
                    this.retryTimes = n + 1;
                    continue;
                }
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u5931\u8d25 " + this.retryTimes + "\uff01\uff01\uff01\uff01:" + e.getClass().getName()));
                this.mDownloadPartInfo.setPartStatus(7);
            }
            break;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final boolean startDownload(RandomAccessFile randomAccessFile, long finalStart) {
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: \u5f00\u59cbstart: " + this.mDownloadPartInfo.getPartStart() + ", finalStart : " + finalStart + " end: " + this.mDownloadPartInfo.getPartEnd()));
        URL url = new URL(this.mDownloadPartInfo.getRealDownloadURL());
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection $this$apply = httpURLConnection;
        boolean bl3 = false;
        ConnectionUpdateKt.upateRequestInfo($this$apply);
        if (this.mDownloadPartInfo.getPartEnd() > 0L) {
            ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: \u4e0b\u8f7dparams bytes=" + finalStart + '-' + this.mDownloadPartInfo.getPartEnd()));
            $this$apply.setRequestProperty("Range", "bytes=" + finalStart + '-' + this.mDownloadPartInfo.getPartEnd());
        }
        HttpURLConnection connection = httpURLConnection;
        long time = System.currentTimeMillis();
        connection.connect();
        ZLog.w((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: \u8bf7\u6c42\u7528\u65f6: " + (System.currentTimeMillis() - time) + " ~~~~~~~~~~~~~"));
        ConnectionUpdateKt.logHeaderFields(connection, "\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247");
        long serverContentLength = HTTPRequestUtils.getContentLength((URLConnection)connection);
        long localContentLength = this.mDownloadPartInfo.getPartEnd() - finalStart;
        ZLog.e((String)"DownloadInfoDBManager", (String)("~~~~~~~~~~~~~ \u5206\u7247\u4fe1\u606f \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247 ~~~~~~~~~~~~~"));
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: getContentType:" + connection.getContentType()));
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: responseCode:" + connection.getResponseCode()));
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: contentLength: origin start " + this.mDownloadPartInfo.getPartStart() + ", final start " + finalStart + ", end " + this.mDownloadPartInfo.getPartEnd() + ", bytes=" + finalStart + '-' + this.mDownloadPartInfo.getPartEnd()));
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: contentLength: from server " + serverContentLength + ", local " + localContentLength + ' '));
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247: finished " + this.mDownloadPartInfo.getPartFinished() + ", finished before: " + this.mDownloadPartInfo.getPartFinishedBefore() + " \n"));
        if (connection.getResponseCode() == 200 || connection.getResponseCode() == 206 || connection.getResponseCode() == 416) {
            if (this.mDownloadPartInfo.getPartEnd() > 0L) {
                long l = serverContentLength - localContentLength;
                boolean bl4 = false;
                if (Math.abs(l) > 1L) {
                    ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u957f\u5ea6 \u9519\u8bef \uff01\uff01\uff01"));
                    if (this.mDownloadPartInfo.getPartFinished() >= this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart()) {
                        this.mDownloadPartInfo.setPartStatus(5);
                    } else {
                        DownloadInfoDBManager.INSTANCE.clearDownloadPartByID(this.mDownloadPartInfo.getDownloadID());
                        this.mDownloadPartInfo.setPartStatus(7);
                    }
                    return false;
                }
                if (serverContentLength < 1L) {
                    ZLog.e((String)"DownloadInfoDBManager", (String)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                    ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u957f\u5ea6\u4e3a0 \uff01\uff01\uff01 " + this.retryTimes));
                    ZLog.e((String)"DownloadInfoDBManager", (String)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                    this.mDownloadPartInfo.setPartStatus(7);
                    return false;
                }
            } else if (this.mDownloadPartInfo.getPartID() > 0) {
                ZLog.e((String)"DownloadInfoDBManager", (String)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u957f\u5ea6\u4e3a0 \uff01\uff01\uff01 " + this.retryTimes));
                ZLog.e((String)"DownloadInfoDBManager", (String)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                this.mDownloadPartInfo.setPartStatus(7);
                return false;
            }
            InputStream inputStream = connection.getInputStream();
            byte[] data = new byte[16384];
            int len = -1;
            long hasDownloadLength = 0L;
            long lastUpdateTime = 0L;
            long lastUpdateLength = 0L;
            while (true) {
                int n = inputStream.read(data);
                boolean bl5 = false;
                boolean bl6 = false;
                int it = n;
                boolean bl7 = false;
                len = it;
                if (n == -1) break;
                if (this.mDownloadPartInfo.getPartStatus() > 3) {
                    String string = this.mDownloadPartInfo.getDownloadPartID();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mDownloadPartInfo.downloadPartID");
                    DownloadInfoDBManager.INSTANCE.updateDownloadFinished(string, hasDownloadLength + this.mDownloadPartInfo.getPartFinishedBefore());
                    return false;
                }
                if (this.mDownloadPartInfo.getPartStatus() != 3) {
                    this.mDownloadPartInfo.setPartStatus(3);
                }
                randomAccessFile.write(data, 0, len);
                hasDownloadLength += (long)len;
                if (this.mDownloadPartInfo.getPartEnd() > 0L && this.mDownloadPartInfo.getPartFinished() + (long)len - 1L > this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart()) {
                    ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u7d2f\u79ef\u4e0b\u8f7d\u8d85\u957f\uff01\uff01\uff01\u5206\u7247\u957f\u5ea6\uff1a" + (this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart()) + ", \u7d2f\u79ef\u4e0b\u8f7d\u957f\u5ea6\uff1a" + (this.mDownloadPartInfo.getPartFinished() + (long)len)));
                    ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u7d2f\u79ef\u4e0b\u8f7d\u8d85\u957f\uff01\uff01\uff01" + this.mDownloadPartInfo));
                } else {
                    if (System.currentTimeMillis() - lastUpdateTime > (long)this.DOWNLOAD_SVAE_TIMER || hasDownloadLength - lastUpdateLength > (long)this.DOWNLOAD_SVAE_SIZE) {
                        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + this.mDownloadPartInfo.getDownloadPartID() + " \u5206\u7247\u5b58\u50a8\uff1a \u8ddd\u79bb\u4e0a\u6b21\u5b58\u50a8\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - lastUpdateTime) + " \u5df2\u4e0b\u8f7d\u957f\u5ea6\uff1a" + hasDownloadLength + " \u4e0a\u6b21\u5b58\u50a8\u4e0b\u8f7d\u957f\u5ea6\uff1a" + lastUpdateLength));
                        String string = this.mDownloadPartInfo.getDownloadPartID();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mDownloadPartInfo.downloadPartID");
                        DownloadInfoDBManager.INSTANCE.updateDownloadFinished(string, hasDownloadLength + this.mDownloadPartInfo.getPartFinishedBefore());
                        lastUpdateTime = System.currentTimeMillis();
                        lastUpdateLength = hasDownloadLength;
                    }
                    this.mDownloadPartInfo.setPartFinished(this.mDownloadPartInfo.getPartFinished() + (long)len);
                }
                if (this.retryTimes <= 0) continue;
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u91cd\u8bd5\u6b21\u6570\u5c06\u88ab\u91cd\u7f6e"));
                this.retryTimes = 0;
            }
            ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u7ed3\u675f \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\uff1a\u5206\u7247\u957f\u5ea6\uff1a" + (this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart()) + ", \u672c\u6b21\u672c\u5730\u8ba1\u7b97\u8981\u957f\u5ea6:" + (this.mDownloadPartInfo.getPartEnd() - finalStart) + " ;\u672c\u6b21\u670d\u52a1\u5668\u4e0b\u53d1\u957f\u5ea6: " + serverContentLength));
            ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u7ed3\u675f \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\uff1a\u5206\u7247\u957f\u5ea6\uff1a" + (this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart()) + ", \u672c\u6b21\u4e0b\u8f7d\u957f\u5ea6:" + hasDownloadLength + " ;\u7d2f\u79ef\u4e0b\u8f7d\u957f\u5ea6: " + this.mDownloadPartInfo.getPartFinished()));
            String string = this.mDownloadPartInfo.getDownloadPartID();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mDownloadPartInfo.downloadPartID");
            DownloadInfoDBManager.INSTANCE.updateDownloadFinished(string, hasDownloadLength + this.mDownloadPartInfo.getPartFinishedBefore());
            if (hasDownloadLength == serverContentLength) {
                if (hasDownloadLength >= localContentLength) {
                    ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u6570\u636e\u4fee\u6b63: \u672c\u6b21\u5b9e\u9645\u4e0b\u8f7d\uff1a" + hasDownloadLength + " \u672c\u6b21\u8ba1\u5212\u4e0b\u8f7d\u5927\u5c0f\uff1a" + localContentLength));
                    this.mDownloadPartInfo.setPartFinished(this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart());
                    this.mDownloadPartInfo.setPartStatus(5);
                } else {
                    ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u5f02\u5e38: \u672c\u6b21\u8ba1\u5212\u4e0b\u8f7d\uff1a" + localContentLength + " \u670d\u52a1\u5668\u4e0b\u53d1\u957f\u5ea6: " + serverContentLength + " \u670d\u52a1\u5668\u5b9e\u9645\u8fd4\u56de\uff1a" + hasDownloadLength + ' '));
                    this.mDownloadPartInfo.setPartStatus(7);
                }
            } else if (serverContentLength < 1L && hasDownloadLength > 0L) {
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u6570\u636e\u4fee\u6b63: \u672c\u6b21\u5b9e\u9645\u4e0b\u8f7d\uff1a" + hasDownloadLength + " \u670d\u52a1\u5668\u4e0b\u53d1\u957f\u5ea6: " + serverContentLength + "  \u672c\u6b21\u8ba1\u5212\u4e0b\u8f7d\u5927\u5c0f\uff1a" + localContentLength));
                this.mDownloadPartInfo.setPartFinished(this.mDownloadPartInfo.getPartEnd() - this.mDownloadPartInfo.getPartStart());
                this.mDownloadPartInfo.setPartStatus(5);
            } else {
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u5f02\u5e38: \u672c\u6b21\u8ba1\u5212\u4e0b\u8f7d\uff1a" + localContentLength + " \u670d\u52a1\u5668\u4e0b\u53d1\u957f\u5ea6: " + serverContentLength + " \u670d\u52a1\u5668\u5b9e\u9645\u8fd4\u56de\uff1a" + hasDownloadLength + ' '));
                this.mDownloadPartInfo.setPartStatus(7);
            }
            String string2 = this.mDownloadPartInfo.getDownloadPartID();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mDownloadPartInfo.downloadPartID");
            DownloadInfoDBManager.INSTANCE.updateDownloadFinished(string2, this.mDownloadPartInfo.getPartFinished());
            ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + this.mDownloadPartInfo.getDownloadPartID() + "\u5206\u7247\u4e0b\u8f7d\u7ed3\u675f: " + this.mDownloadPartInfo));
            try {
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return true;
        }
        return false;
    }

    public DownloadThread(@NotNull DownloadPartInfo mDownloadPartInfo) {
        Intrinsics.checkParameterIsNotNull((Object)mDownloadPartInfo, (String)"mDownloadPartInfo");
        this.mDownloadPartInfo = mDownloadPartInfo;
        this.DOWNLOAD_SVAE_TIMER = 10000;
        this.DOWNLOAD_SVAE_SIZE = 20480000;
    }
}

