/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.dabase;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Base64;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.core.DownloadManager;
import com.bihe0832.android.lib.download.core.list.DownloadTaskList;
import com.bihe0832.android.lib.download.dabase.DownloadInfoDBManager;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.sqlite.BaseDBHelper;
import com.bihe0832.android.lib.sqlite.BaseTableModel;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DownloadInfoTableModel
extends BaseTableModel {
    static final String TABLE_NAME = "download_info";
    public static final String col_id = "id";
    public static final String col_download_id = "download_id";
    public static final String col_download_package = "download_package";
    public static final String col_download_content = "download_content";
    static final String TABLE_CREATE_SQL = "CREATE TABLE IF NOT EXISTS [download_info] ([id] INTEGER PRIMARY KEY AUTOINCREMENT,[download_id] NVARCHAR(128)  NULL,[download_package] NVARCHAR(128)  NULL,[download_content] VARCHAR(102400)  NULL)";
    static final String TABLE_DROP_SQL = "DROP TABLE IF EXISTS download_info";

    static int deleteAll(BaseDBHelper helper) {
        return DownloadInfoTableModel.deleteAll((BaseDBHelper)helper, (String)TABLE_NAME);
    }

    private static ContentValues data2CV(DownloadItem item) {
        ContentValues cv = new ContentValues();
        try {
            DownloadInfoTableModel.putValues((ContentValues)cv, (String)col_download_id, (long)item.getDownloadID());
            DownloadInfoTableModel.putValues((ContentValues)cv, (String)col_download_package, (String)item.getPackageName());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(item);
            String res = new String(Base64.encode((byte[])baos.toByteArray(), (int)0));
            oos.close();
            DownloadInfoTableModel.putValues((ContentValues)cv, (String)col_download_content, (String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cv;
    }

    private static DownloadItem cv2data(Cursor cursor) {
        try {
            byte[] data = Base64.decode((String)DownloadInfoTableModel.getStringByName((Cursor)cursor, (String)col_download_content), (int)0);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            DownloadItem item = (DownloadItem)ois.readObject();
            ois.close();
            int status = item.getStatus();
            if (status == 3 || status == 2 || status == 1) {
                item.setStatus(6);
            } else if (status == 4 || status == 5) {
                PackageInfo info = APKUtils.getInstalledPackage((Context)DownloadManager.INSTANCE.getContext(), (String)item.getPackageName());
                if (info != null && (long)info.versionCode == item.getVersionCode()) {
                    item.setStatus(status);
                } else {
                    item.setStatus(0);
                }
            } else {
                item.setStatus(status);
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DownloadItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initData(BaseDBHelper helper) {
        try {
            Cursor cursor = helper.queryInfo(TABLE_NAME, null, null, null, null, null, null, null);
            try {
                DownloadTaskList.INSTANCE.clear();
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    DownloadItem item = DownloadInfoTableModel.cv2data(cursor);
                    item.setFinishedLengthBefore(DownloadInfoDBManager.INSTANCE.getFinishedBefore(item.getDownloadID()));
                    item.setFinished(item.getFinishedLengthBefore());
                    DownloadTaskList.INSTANCE.addToDownloadTaskList(item);
                    if (FileUtils.INSTANCE.checkFileExist(item.getFinalFilePath())) {
                        item.setFinished(item.getFileLength());
                        item.setStatus(5);
                    }
                    long id = DownloadInfoTableModel.getLongByName((Cursor)cursor, (String)col_id);
                    ZLog.d((String)("\u6570\u636e\u5e93\u4fe1\u606f\uff1aid:" + id + "info :" + item.toString()));
                    cursor.moveToNext();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean insertData(BaseDBHelper helper, DownloadItem item) {
        ContentValues values = DownloadInfoTableModel.data2CV(item);
        long id = helper.insert(TABLE_NAME, null, values);
        return id != -1L;
    }

    private static boolean updateData(BaseDBHelper helper, DownloadItem item) {
        ContentValues values = DownloadInfoTableModel.data2CV(item);
        String whereClause = " `download_id` = ? ";
        String[] whereArgs = new String[]{String.valueOf(item.getDownloadID())};
        int rows = helper.update(TABLE_NAME, values, whereClause, whereArgs);
        return rows != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasData(BaseDBHelper helper, String url) {
        String[] columns = null;
        String selection = " download_id = ? ";
        String[] selectionArgs = new String[]{String.valueOf(DownloadItem.getDownloadIDByURL(url))};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        String limit = null;
        boolean find = false;
        Cursor cursor = helper.queryInfo(TABLE_NAME, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        try {
            find = cursor != null && cursor.getCount() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return find;
    }

    static DownloadItem getDownloadInfoFromPackageName(BaseDBHelper helper, String packageName) {
        String selection = " download_package = ? ";
        String[] selectionArgs = new String[]{packageName};
        return DownloadInfoTableModel.getDownloadInfoFromDBBySection(helper, selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DownloadItem getDownloadInfoFromDBBySection(BaseDBHelper helper, String selection, String[] selectionArgs) {
        String[] columns = null;
        String groupBy = null;
        String having = null;
        String orderBy = null;
        String limit = null;
        Cursor cursor = helper.queryInfo(TABLE_NAME, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        DownloadItem dataItem = null;
        try {
            if (cursor.getCount() < 1) {
                dataItem = null;
            } else {
                cursor.moveToFirst();
                dataItem = DownloadInfoTableModel.cv2data(cursor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataItem;
    }

    static DownloadItem getDownloadInfo(BaseDBHelper helper, String url) {
        String selection = " download_id = ? ";
        String[] selectionArgs = new String[]{String.valueOf(DownloadItem.getDownloadIDByURL(url))};
        return DownloadInfoTableModel.getDownloadInfoFromDBBySection(helper, selection, selectionArgs);
    }

    static boolean saveData(BaseDBHelper helper, DownloadItem item) {
        if (TextUtils.isEmpty((CharSequence)item.getDownloadURL())) {
            return false;
        }
        boolean success = DownloadInfoTableModel.hasData(helper, item.getDownloadURL()) ? DownloadInfoTableModel.updateData(helper, item) : DownloadInfoTableModel.insertData(helper, item);
        return success;
    }

    static boolean clearData(BaseDBHelper helper, long download_id) {
        int rows = 0;
        String whereClause = " download_id = ? ";
        String[] whereArgs = new String[]{String.valueOf(download_id)};
        try {
            SQLiteDatabase db = helper.getWritableDatabase();
            rows = db.delete(TABLE_NAME, whereClause, whereArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            rows = 0;
        }
        return rows != 0;
    }
}

