/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.core.DownloadByHttp;
import com.bihe0832.android.lib.download.core.DownloadManager;
import com.bihe0832.android.lib.download.core.list.DownloadTaskList;
import com.bihe0832.android.lib.download.core.list.DownloadingList;
import com.bihe0832.android.lib.download.dabase.DownloadInfoDBManager;
import com.bihe0832.android.lib.download.notify.DownloadNotify;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.mimetype.FileMimeTypes;
import com.bihe0832.android.lib.file.provider.ZixieFileProvider;
import com.bihe0832.android.lib.install.InstallUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.NetworkUtil;
import com.bihe0832.android.lib.request.URLUtils;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.toast.ToastUtil;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b$*\u0001\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0012J\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0014J\b\u0010$\u001a\u00020\u001dH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0014J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.J\b\u0010/\u001a\u0004\u0018\u00010\tJ\u001e\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020&J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001f0.J(\u00105\u001a\u00020&2\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020&2\u0006\u00106\u001a\u00020&H\u0002J\u001e\u00107\u001a\u00020&2\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020&J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001f0.J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001f0.J\u000e\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\tJ*\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010=\u001a\u00020\u0014J\u0012\u0010>\u001a\u00020\u001d2\b\u0010;\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u0010=\u001a\u00020\u0014J\b\u0010?\u001a\u00020\u0014H\u0002J\u0006\u0010@\u001a\u00020\u001dJ\u000e\u0010A\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0014J\u000e\u0010B\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0014J\u001e\u0010C\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0014J\u000e\u0010E\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0014J \u0010F\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002J\u000e\u0010H\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0012J\u000e\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020\u0014J\u000e\u0010K\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020\u0014J\u000e\u0010L\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020\u0014J0\u0010M\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00192\b\u0010N\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014J(\u0010P\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010Q\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00120\u001aj\b\u0012\u0004\u0012\u00020\u0012`\u001b0\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/bihe0832/android/lib/download/core/DownloadManager;", "", "()V", "DEFAULT_MAX_NUM", "", "innerDownloadListener", "com/bihe0832/android/lib/download/core/DownloadManager$innerDownloadListener$1", "Lcom/bihe0832/android/lib/download/core/DownloadManager$innerDownloadListener$1;", "mContext", "Landroid/content/Context;", "mDownloadEngine", "Lcom/bihe0832/android/lib/download/core/DownloadByHttp;", "getMDownloadEngine", "()Lcom/bihe0832/android/lib/download/core/DownloadByHttp;", "mDownloadEngine$delegate", "Lkotlin/Lazy;", "mGlobalDownloadListenerList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/bihe0832/android/lib/download/DownloadListener;", "mHasInit", "", "mIsDebug", "mMaxNum", "mTempDownloadListenerList", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addDownloadItemToList", "", "info", "Lcom/bihe0832/android/lib/download/DownloadItem;", "addGlobalDownloadListener", "listener", "addTask", "forceDownload", "addWaitToDownload", "checkBeforeDownloadFile", "", "checkIsDownloadingAndVersionIsNew", "checkIsInstalledAndLocalVersionIsNew", "deleteTask", "downloadId", "startByUser", "deleteFile", "getAllTask", "", "getContext", "getDownladTempFilePath", "downloadURL", "backFileName", "fileName", "getDownloadingTask", "getFilePath", "prefix", "getFinalFileName", "getFinishedTask", "getWaitingTask", "init", "context", "maxNum", "isDebug", "initContext", "isWifi", "onDestroy", "pauseAllTask", "pauseDownloadingTask", "pauseTask", "clearHistory", "pauseWaitingTask", "realStartTask", "downloadAfterAdd", "removeGlobalDownloadListener", "resumeAllTask", "pauseOnMobile", "resumeFailedTask", "resumePauseTask", "resumeTask", "downloadListener", "downloadWhenUseMobile", "startTask", "updateInfo", "LibDownload_release"})
public final class DownloadManager {
    private static final Lazy mDownloadEngine$delegate;
    private static Context mContext;
    private static CopyOnWriteArrayList<DownloadListener> mGlobalDownloadListenerList;
    private static ConcurrentHashMap<Long, ArrayList<DownloadListener>> mTempDownloadListenerList;
    private static final int DEFAULT_MAX_NUM = 5;
    private static int mMaxNum;
    private static boolean mHasInit;
    private static boolean mIsDebug;
    private static final innerDownloadListener.1 innerDownloadListener;
    public static final DownloadManager INSTANCE;

    private final DownloadByHttp getMDownloadEngine() {
        Lazy lazy = mDownloadEngine$delegate;
        DownloadManager downloadManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DownloadByHttp)lazy.getValue();
    }

    @Nullable
    public final Context getContext() {
        return mContext;
    }

    public final boolean isDebug() {
        return mIsDebug;
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.init(context, mMaxNum, null, mIsDebug);
    }

    public final void init(@NotNull Context context, int maxNum, @Nullable DownloadListener listener, boolean isDebug) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.initContext(context);
            mMaxNum = maxNum;
            mIsDebug = isDebug;
            if (!mHasInit) {
                mHasInit = true;
                DownloadNotify.INSTANCE.init(context);
                DownloadInfoDBManager.INSTANCE.init(context);
            }
            DownloadListener downloadListener = listener;
            if (downloadListener == null) break block2;
            DownloadListener downloadListener2 = downloadListener;
            boolean bl = false;
            boolean bl2 = false;
            DownloadListener it = downloadListener2;
            boolean bl3 = false;
            if (!mGlobalDownloadListenerList.contains(it)) {
                mGlobalDownloadListenerList.add(it);
            }
        }
    }

    public static /* synthetic */ void init$default(DownloadManager downloadManager, Context context, int n, DownloadListener downloadListener, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        downloadManager.init(context, n, downloadListener, bl);
    }

    private final void initContext(Context context) {
        block0: {
            Context context2 = context;
            if (context2 == null) break block0;
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context3;
            boolean bl3 = false;
            mContext = it;
        }
    }

    public final void onDestroy() {
        this.pauseAllTask(false);
        DownloadNotify.INSTANCE.destroy();
        mGlobalDownloadListenerList.clear();
    }

    private final void addWaitToDownload() {
        List<DownloadItem> list = this.getWaitingTask();
        boolean bl = false;
        boolean bl2 = false;
        List<DownloadItem> list2 = list;
        boolean bl3 = false;
        Object object = list2;
        boolean bl4 = false;
        if (!object.isEmpty()) {
            object = CollectionsKt.first(list2);
            bl4 = false;
            boolean bl5 = false;
            DownloadItem it = (DownloadItem)object;
            boolean bl6 = false;
            ThreadManager.getInstance().start(new Runnable(it){
                final /* synthetic */ DownloadItem $it;

                public final void run() {
                    DownloadManager.access$startTask(DownloadManager.INSTANCE, this.$it, this.$it.isDownloadWhenAdd(), this.$it.isDownloadWhenUseMobile(), false);
                }
                {
                    this.$it = downloadItem;
                }
            });
        }
    }

    private final boolean checkIsInstalledAndLocalVersionIsNew(DownloadItem info) {
        boolean bl;
        ZLog.d((String)("checkIsNeedDownload DownloadItem:" + info));
        if (TextUtils.isEmpty((CharSequence)info.getPackageName())) {
            ZLog.d((String)"packageName is bad ");
            return false;
        }
        if (info.getVersionCode() < 1L) {
            ZLog.d((String)"versionCode is bad ");
            return false;
        }
        ZLog.d((String)("checkIsNeedDownload versionCode:" + info.getVersionCode()));
        try {
            boolean bl2;
            PackageInfo packageInfo = APKUtils.getInstalledPackage((Context)mContext, (String)info.getPackageName());
            if (packageInfo != null) {
                ZLog.d((String)("checkIsNeedDownload installVersionCode:" + packageInfo.versionCode));
                bl2 = (long)packageInfo.versionCode > info.getVersionCode();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private final boolean checkIsDownloadingAndVersionIsNew(DownloadItem info) {
        boolean bl;
        ZLog.d((String)("checkIsDownloading DownloadItem:" + info));
        if (TextUtils.isEmpty((CharSequence)info.getPackageName())) {
            ZLog.d((String)"packageName is bad ");
            return false;
        }
        if (info.getVersionCode() < 1L) {
            ZLog.d((String)"versionCode is bad ");
            return false;
        }
        ZLog.d((String)("checkIsNeedDownload versionCode:" + info.getVersionCode()));
        String string = info.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.packageName");
        DownloadItem alreadyDownloadItem = DownloadInfoDBManager.INSTANCE.getDownloadInfoFromPackageName(string);
        if (alreadyDownloadItem == null) {
            ZLog.d((String)"checkIsNeedDownload alreadyDownloadItem null");
            bl = false;
        } else if (alreadyDownloadItem.getVersionCode() > 0L) {
            if (info.getVersionCode() != alreadyDownloadItem.getVersionCode()) {
                this.deleteTask(alreadyDownloadItem.getDownloadID(), false, true);
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void updateInfo(DownloadItem info) {
        String string = info.getDownloadURL();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.downloadURL");
        DownloadItem savedInfo = DownloadInfoDBManager.INSTANCE.getDownloadInfo(string);
        if (savedInfo != null) {
            info.setFinalFilePath(savedInfo.getFinalFilePath());
            info.setTempFilePath(savedInfo.getTempFilePath());
            if (!TextUtils.isEmpty((CharSequence)savedInfo.getRealURL())) {
                info.setRealURL(savedInfo.getRealURL());
            }
            if (savedInfo.getFileLength() > 0L) {
                info.setFileLength(savedInfo.getFileLength());
                info.setFinishedLengthBefore(DownloadInfoDBManager.INSTANCE.getFinishedBefore(info.getDownloadID()));
                info.setFinished(info.getFinishedLengthBefore());
            }
        } else {
            String backFileName = !TextUtils.isEmpty((CharSequence)info.getFileMD5()) ? info.getFileMD5() : (!TextUtils.isEmpty((CharSequence)info.getFileSHA256()) ? info.getFileSHA256() : String.valueOf(System.currentTimeMillis()));
            String string2 = info.getDownloadURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.downloadURL");
            String string3 = backFileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"backFileName");
            String string4 = info.getFileNameWithPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.fileNameWithPath");
            info.setFinalFilePath(this.getFinalFileName(string2, string3, string4));
            String string5 = info.getDownloadURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"info.downloadURL");
            String string6 = info.getFileNameWithPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"info.fileNameWithPath");
            info.setTempFilePath(this.getDownladTempFilePath(string5, backFileName, string6));
        }
    }

    private final String checkBeforeDownloadFile(DownloadItem info) {
        String string = info.getFinalFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.finalFilePath");
        long l = info.getFileLength();
        String string2 = info.getFileMD5();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.fileMD5");
        String string3 = info.getFileSHA256();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.fileSHA256");
        if (FileUtils.INSTANCE.checkFileExist(string, l, string2, string3, false)) {
            String string4 = info.getFinalFilePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.finalFilePath");
            return string4;
        }
        String string5 = info.getTempFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"info.tempFilePath");
        long l2 = info.getFileLength();
        String string6 = info.getFileMD5();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"info.fileMD5");
        String string7 = info.getFileSHA256();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"info.fileSHA256");
        if (FileUtils.INSTANCE.checkFileExist(string5, l2, string6, string7, false)) {
            info.setFinalFilePath(info.getTempFilePath());
            String string8 = info.getTempFilePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"info.tempFilePath");
            return string8;
        }
        return "";
    }

    private final synchronized void startTask(DownloadItem info, boolean downloadAfterAdd, boolean downloadWhenUseMobile, boolean forceDownload) {
        innerDownloadListener.onWait(info);
        if (downloadAfterAdd) {
            if (!this.isWifi()) {
                if (downloadWhenUseMobile) {
                    this.realStartTask(info, true, forceDownload);
                } else {
                    this.realStartTask(info, false, forceDownload);
                }
            } else {
                this.realStartTask(info, true, forceDownload);
            }
        } else {
            ZLog.d((String)("startTask do nothing: $ " + info + ' '));
            this.realStartTask(info, false, forceDownload);
        }
    }

    private final boolean isWifi() {
        return NetworkUtil.isWifiNet((Context)mContext);
    }

    private final void realStartTask(DownloadItem info, boolean downloadAfterAdd, boolean forceDownload) {
        ZLog.d((String)("startTask:" + info));
        try {
            if (!URLUtils.isHTTPUrl((String)info.getDownloadURL())) {
                ZLog.e((String)("bad para:" + info));
                innerDownloadListener.onFail(-1, "bad para", info);
                return;
            }
            if (this.checkIsInstalledAndLocalVersionIsNew(info)) {
                ZLog.e((String)("no need download:" + info));
                innerDownloadListener.onFail(-2, "install is new", info);
                return;
            }
            if (this.checkIsDownloadingAndVersionIsNew(info)) {
                ZLog.e((String)("noneed download:" + info));
                innerDownloadListener.onFail(-3, "install is new", info);
                return;
            }
            this.addDownloadItemToList(info);
            new Thread(new Runnable(info, downloadAfterAdd, forceDownload){
                final /* synthetic */ DownloadItem $info;
                final /* synthetic */ boolean $downloadAfterAdd;
                final /* synthetic */ boolean $forceDownload;

                public final void run() {
                    String filePath = DownloadManager.access$checkBeforeDownloadFile(DownloadManager.INSTANCE, this.$info);
                    if (!TextUtils.isEmpty((CharSequence)filePath)) {
                        ZLog.e((String)("has download:" + this.$info));
                        this.$info.setDownloadStatus(4);
                        innerDownloadListener.1 v0 = DownloadManager.access$getInnerDownloadListener$p(DownloadManager.INSTANCE);
                        String string = this.$info.getFinalFilePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.finalFilePath");
                        v0.onComplete(string, this.$info);
                    } else if (this.$downloadAfterAdd) {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - this.$info.getPauseTime() < 3000L) {
                            ZLog.e((String)("resume to quick:" + this.$info));
                            DownloadManager.access$getInnerDownloadListener$p(DownloadManager.INSTANCE).onWait(this.$info);
                            this.$info.setDownloadWhenAdd(true);
                            long l = this.$info.getPauseTime() + 3000L - currentTime;
                            boolean bl = false;
                            boolean bl2 = false;
                            long it = l;
                            boolean bl3 = false;
                            if (it > 0L) {
                                Thread.sleep(it);
                            }
                        }
                        DownloadByHttp downloadByHttp = DownloadManager.access$getMDownloadEngine$p(DownloadManager.INSTANCE);
                        Context context = DownloadManager.access$getMContext$p(DownloadManager.INSTANCE);
                        if (context == null) {
                            Intrinsics.throwNpe();
                        }
                        downloadByHttp.startDownload(context, this.$info, this.$forceDownload);
                    } else {
                        this.$info.setPause();
                    }
                }
                {
                    this.$info = downloadItem;
                    this.$downloadAfterAdd = bl;
                    this.$forceDownload = bl2;
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.e((String)("download:" + e));
        }
    }

    private final void addDownloadItemToList(DownloadItem info) {
        ThreadManager.getInstance().start(new Runnable(info){
            final /* synthetic */ DownloadItem $info;

            public final void run() {
                DownloadInfoDBManager.INSTANCE.saveDownloadInfo(this.$info);
                DownloadTaskList.INSTANCE.addToDownloadTaskList(this.$info);
            }
            {
                this.$info = downloadItem;
            }
        });
    }

    @NotNull
    public final String getDownladTempFilePath(@NotNull String downloadURL, @NotNull String backFileName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)downloadURL, (String)"downloadURL");
        Intrinsics.checkParameterIsNotNull((Object)backFileName, (String)"backFileName");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return this.getFilePath(downloadURL, backFileName, fileName, "Temp_");
    }

    @NotNull
    public final String getFinalFileName(@NotNull String downloadURL, @NotNull String backFileName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)downloadURL, (String)"downloadURL");
        Intrinsics.checkParameterIsNotNull((Object)backFileName, (String)"backFileName");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return this.getFilePath(downloadURL, backFileName, fileName, "");
    }

    private final String getFilePath(String downloadURL, String backFileName, String fileName, String prefix) {
        String string;
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            StringBuilder stringBuilder = new StringBuilder();
            Context context = mContext;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            String string2 = URLUtils.getFileName((String)downloadURL);
            StringBuilder stringBuilder2 = stringBuilder.append(ZixieFileProvider.getZixieFilePath((Context)context)).append(prefix);
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = TextUtils.isEmpty((CharSequence)it) ? (TextUtils.isEmpty((CharSequence)backFileName) ? Long.valueOf(System.currentTimeMillis()) : backFileName) : it;
            string = stringBuilder2.append((Object)string3).toString();
        } else {
            string = fileName;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void addTask(@NotNull DownloadItem info, boolean forceDownload) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        ZLog.d((String)("addTask:" + info));
        if (DownloadingList.INSTANCE.isDownloading(info)) {
            DownloadItem currentDownload;
            DownloadItem downloadItem = currentDownload = DownloadTaskList.INSTANCE.getTaskByDownloadID(info.getDownloadID());
            if (!TextUtils.isEmpty((CharSequence)(downloadItem != null ? downloadItem.getFileMD5() : null))) {
                DownloadItem downloadItem2 = currentDownload;
                if (!info.getFileMD5().equals(downloadItem2 != null ? downloadItem2.getFileMD5() : null)) {
                    DownloadListener downloadListener = info.getDownloadListener();
                    if (downloadListener == null) return;
                    downloadListener.onFail(-7, "new md5 is diff with current download", info);
                    return;
                }
            }
            DownloadItem downloadItem3 = currentDownload;
            if (!TextUtils.isEmpty((CharSequence)(downloadItem3 != null ? downloadItem3.getFileSHA256() : null))) {
                DownloadItem downloadItem4 = currentDownload;
                if (!info.getFileSHA256().equals(downloadItem4 != null ? downloadItem4.getFileSHA256() : null)) {
                    DownloadListener downloadListener = info.getDownloadListener();
                    if (downloadListener == null) return;
                    downloadListener.onFail(-7, "new sha256 is diff with current download", info);
                    return;
                }
            }
            DownloadListener downloadListener = info.getDownloadListener();
            if (downloadListener == null) return;
            DownloadListener downloadListener2 = downloadListener;
            boolean bl = false;
            boolean bl2 = false;
            DownloadListener it = downloadListener2;
            boolean bl3 = false;
            if (mTempDownloadListenerList.containsKey(info.getDownloadID()) && mTempDownloadListenerList.get(info.getDownloadID()) != null) {
                ArrayList<DownloadListener> arrayList = mTempDownloadListenerList.get(info.getDownloadID());
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                Serializable cfr_ignored_0 = Boolean.valueOf(arrayList.add(it));
                return;
            }
            ArrayList<DownloadListener> arrayList = new ArrayList<DownloadListener>();
            Long l = info.getDownloadID();
            ConcurrentHashMap<Long, ArrayList<DownloadListener>> concurrentHashMap = mTempDownloadListenerList;
            boolean bl4 = false;
            boolean bl5 = false;
            ArrayList<DownloadListener> $this$apply = arrayList;
            boolean bl6 = false;
            $this$apply.add(it);
            ArrayList<DownloadListener> arrayList2 = arrayList;
            Serializable cfr_ignored_1 = concurrentHashMap.put(l, arrayList2);
            return;
        }
        this.updateInfo(info);
        innerDownloadListener.onWait(info);
        if (info.isForceDownloadNew() && TextUtils.isEmpty((CharSequence)this.checkBeforeDownloadFile(info))) {
            this.deleteTask(info.getDownloadID(), false, true);
        }
        if (DownloadTaskList.INSTANCE.hadAddTask(info)) {
            ZLog.d((String)("mDownloadList contains:" + info));
            DownloadTaskList.INSTANCE.updateDownloadTaskListItem(info);
            this.resumeTask(info.getDownloadID(), info.getDownloadListener(), info.isDownloadWhenAdd(), info.isDownloadWhenUseMobile(), forceDownload);
            return;
        }
        this.startTask(info, info.isDownloadWhenAdd(), info.isDownloadWhenUseMobile(), forceDownload);
    }

    public final void resumeTask(long downloadId, @Nullable DownloadListener downloadListener, boolean startByUser, boolean downloadWhenUseMobile, boolean forceDownload) {
        block2: {
            DownloadItem downloadItem = DownloadTaskList.INSTANCE.getTaskByDownloadID(downloadId);
            if (downloadItem == null) break block2;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem info = downloadItem2;
            boolean bl3 = false;
            ZLog.d((String)("resumeTask:" + info));
            if (startByUser) {
                info.setDownloadWhenAdd(true);
            }
            DownloadListener downloadListener2 = downloadListener;
            if (downloadListener2 != null) {
                DownloadListener downloadListener3 = downloadListener2;
                boolean bl4 = false;
                boolean bl5 = false;
                DownloadListener it = downloadListener3;
                boolean bl6 = false;
                info.setDownloadListener(it);
            }
            innerDownloadListener.onWait(info);
            INSTANCE.startTask(info, startByUser, downloadWhenUseMobile, forceDownload);
        }
    }

    public final void pauseTask(long downloadId, boolean startByUser, boolean clearHistory) {
        block1: {
            DownloadItem downloadItem = DownloadTaskList.INSTANCE.getTaskByDownloadID(downloadId);
            if (downloadItem == null) break block1;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem info = downloadItem2;
            boolean bl3 = false;
            ZLog.d((String)("pause:" + info));
            ZLog.d((String)("pause:" + info));
            INSTANCE.getMDownloadEngine().closeDownload(info.getDownloadID(), false, clearHistory);
            info.setStatus(6);
            info.setPause();
            if (startByUser) {
                innerDownloadListener.onPause(info);
            }
        }
    }

    public final void deleteTask(long downloadId, boolean startByUser, boolean deleteFile2) {
        block4: {
            DownloadListener downloadListener;
            DownloadItem downloadItem = DownloadTaskList.INSTANCE.getTaskByDownloadID(downloadId);
            if (downloadItem == null) break block4;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem info = downloadItem2;
            boolean bl3 = false;
            ArrayList<DownloadListener> arrayList = mTempDownloadListenerList.get(downloadId);
            DownloadListener downloadListener2 = downloadListener = arrayList != null ? (DownloadListener)CollectionsKt.first((List)arrayList) : null;
            if (downloadListener != null) {
                info.getDownloadListener().onDelete(info);
                info.setDownloadListener(downloadListener);
            } else {
                if (info.getStatus() == 3) {
                    INSTANCE.addWaitToDownload();
                }
                DownloadTaskList.INSTANCE.removeFromDownloadTaskList(downloadId);
                info.setStatus(8);
                INSTANCE.getMDownloadEngine().closeDownload(downloadId, false, deleteFile2);
                DownloadInfoDBManager.INSTANCE.clearDownloadInfoByID(info.getDownloadID());
                if (deleteFile2) {
                    INSTANCE.getMDownloadEngine().deleteFile(info);
                }
                DownloadNotify.INSTANCE.notifyDelete(info);
                innerDownloadListener.onDelete(info);
            }
        }
    }

    public final void addGlobalDownloadListener(@NotNull DownloadListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (!mGlobalDownloadListenerList.contains(listener)) {
            mGlobalDownloadListenerList.add(listener);
        }
    }

    public final void removeGlobalDownloadListener(@NotNull DownloadListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        mGlobalDownloadListenerList.remove(listener);
    }

    public final void pauseAllTask(boolean startByUser) {
        ZLog.d((String)"pauseAllTask");
        this.pauseWaitingTask(startByUser);
        this.pauseDownloadingTask(startByUser);
    }

    public final void pauseDownloadingTask(boolean startByUser) {
        ZLog.d((String)"pauseDownloadingTask");
        Iterable $this$forEach$iv = this.getDownloadingTask();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.pauseTask(it.getDownloadID(), startByUser, false);
        }
    }

    public final void pauseWaitingTask(boolean startByUser) {
        ZLog.d((String)"pauseWaitingTask");
        Iterable $this$forEach$iv = this.getWaitingTask();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.pauseTask(it.getDownloadID(), startByUser, false);
        }
    }

    public final void resumeAllTask(boolean pauseOnMobile) {
        ZLog.d((String)"resumeAllTask");
        this.resumePauseTask(pauseOnMobile);
        this.resumeFailedTask(pauseOnMobile);
    }

    /*
     * WARNING - void declaration
     */
    public final void resumeFailedTask(boolean pauseOnMobile) {
        void $this$filterTo$iv$iv;
        ZLog.d((String)"resumeFailedTask");
        Iterable $this$filter$iv = this.getAllTask();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == 7)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.resumeTask(it.getDownloadID(), it.getDownloadListener(), true, pauseOnMobile, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void resumePauseTask(boolean pauseOnMobile) {
        void $this$filterTo$iv$iv;
        ZLog.d((String)"resumePauseTask");
        Iterable $this$filter$iv = this.getAllTask();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == 6)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.resumeTask(it.getDownloadID(), it.getDownloadListener(), true, pauseOnMobile, false);
        }
    }

    @NotNull
    public final List<DownloadItem> getAllTask() {
        return DownloadTaskList.INSTANCE.getDownloadTasKList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadItem> getFinishedTask() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DownloadTaskList.INSTANCE.getDownloadTasKList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            DownloadItem downloadItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem, (String)"it");
            if (!(downloadItem.getStatus() == 5 || it.getStatus() == 4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadItem> getDownloadingTask() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DownloadTaskList.INSTANCE.getDownloadTasKList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            DownloadItem downloadItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem, (String)"it");
            if (!DownloadingList.INSTANCE.isDownloading(downloadItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadItem> getWaitingTask() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DownloadTaskList.INSTANCE.getDownloadTasKList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            DownloadItem downloadItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem, (String)"it");
            if (!(downloadItem.getStatus() == 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private DownloadManager() {
    }

    static {
        DownloadManager downloadManager;
        INSTANCE = downloadManager = new DownloadManager();
        mDownloadEngine$delegate = LazyKt.lazy((Function0)mDownloadEngine.2.INSTANCE);
        mGlobalDownloadListenerList = new CopyOnWriteArrayList();
        mTempDownloadListenerList = new ConcurrentHashMap();
        mMaxNum = 5;
        innerDownloadListener = new DownloadListener(){

            public void onWait(@NotNull DownloadItem item) {
                T element$iv;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(1);
                DownloadNotify.INSTANCE.notifyProcess(item);
                Object $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onWait(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    $this$forEach$iv = downloadListener;
                    $i$f$forEach = false;
                    boolean bl = false;
                    Object it = $this$forEach$iv;
                    boolean bl2 = false;
                    it.onWait(item);
                }
                ArrayList arrayList = (ArrayList)DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).get(item.getDownloadID());
                if (arrayList != null) {
                    $this$forEach$iv = arrayList;
                    $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        DownloadListener it = (DownloadListener)element$iv;
                        boolean bl = false;
                        it.onWait(item);
                    }
                }
                DownloadInfoDBManager.INSTANCE.saveDownloadInfo(item);
            }

            public void onStart(@NotNull DownloadItem item) {
                T element$iv;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(2);
                item.setLastSpeed(0L);
                DownloadNotify.INSTANCE.notifyProcess(item);
                item.setStartTime(System.currentTimeMillis());
                Object $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onStart(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    $this$forEach$iv = downloadListener;
                    $i$f$forEach = false;
                    boolean bl = false;
                    Object it = $this$forEach$iv;
                    boolean bl2 = false;
                    it.onStart(item);
                }
                ArrayList arrayList = (ArrayList)DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).get(item.getDownloadID());
                if (arrayList != null) {
                    $this$forEach$iv = arrayList;
                    $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        DownloadListener it = (DownloadListener)element$iv;
                        boolean bl = false;
                        it.onStart(item);
                    }
                }
                DownloadInfoDBManager.INSTANCE.saveDownloadInfo(item);
            }

            public void onProgress(@NotNull DownloadItem item) {
                T element$iv;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(3);
                Object $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onProgress(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    $this$forEach$iv = downloadListener;
                    $i$f$forEach = false;
                    boolean bl = false;
                    Object it = $this$forEach$iv;
                    boolean bl2 = false;
                    it.onProgress(item);
                }
                ArrayList arrayList = (ArrayList)DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).get(item.getDownloadID());
                if (arrayList != null) {
                    $this$forEach$iv = arrayList;
                    $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        DownloadListener it = (DownloadListener)element$iv;
                        boolean bl = false;
                        it.onProgress(item);
                    }
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyProcess(item);
                }
            }

            public void onPause(@NotNull DownloadItem item) {
                T element$iv;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(6);
                Object $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onPause(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    $this$forEach$iv = downloadListener;
                    $i$f$forEach = false;
                    boolean bl = false;
                    Object it = $this$forEach$iv;
                    boolean bl2 = false;
                    it.onPause(item);
                }
                ArrayList arrayList = (ArrayList)DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).get(item.getDownloadID());
                if (arrayList != null) {
                    $this$forEach$iv = arrayList;
                    $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        DownloadListener it = (DownloadListener)element$iv;
                        boolean bl = false;
                        it.onPause(item);
                    }
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyPause(item);
                }
                DownloadManager.access$addWaitToDownload(DownloadManager.INSTANCE);
            }

            public void onFail(int errorCode, @NotNull String msg, @NotNull DownloadItem item) {
                T element$iv;
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(7);
                DownloadManager.access$addWaitToDownload(DownloadManager.INSTANCE);
                if (-2 == errorCode) {
                    ToastUtil.showLong((Context)DownloadManager.access$getMContext$p(DownloadManager.INSTANCE), (String)("\u672c\u673a\u5df2\u6709\u66f4\u9ad8\u7248\u672c\u7684" + item.getDownloadTitle() + "\uff0c\u4e0b\u8f7d\u5df2\u53d6\u6d88"));
                }
                Object $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onFail(errorCode, msg, item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    $this$forEach$iv = downloadListener;
                    $i$f$forEach = false;
                    boolean bl = false;
                    Object it = $this$forEach$iv;
                    boolean bl2 = false;
                    it.onFail(errorCode, msg, item);
                }
                ArrayList arrayList = (ArrayList)DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).get(item.getDownloadID());
                if (arrayList != null) {
                    $this$forEach$iv = arrayList;
                    $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        DownloadListener it = (DownloadListener)element$iv;
                        boolean bl = false;
                        it.onFail(errorCode, msg, item);
                    }
                }
                DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).remove(item.getDownloadID());
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyFailed(item);
                }
            }

            public void onComplete(@NotNull String filePath, @NotNull DownloadItem item) {
                T element$iv;
                Object it;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(5);
                if (item.getFileLength() < 1L) {
                    item.setFileLength(new File(filePath).length());
                }
                item.setFinished(item.getFileLength());
                if (FileMimeTypes.INSTANCE.isApkFile(filePath) && (object = DownloadManager.access$getMContext$p(DownloadManager.INSTANCE)) != null && (object = object.getPackageManager()) != null && (object = object.getPackageArchiveInfo(filePath, 1)) != null && (object = object.packageName) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    it = object2;
                    boolean bl3 = false;
                    item.setPackageName((String)it);
                }
                DownloadInfoDBManager.INSTANCE.saveDownloadInfo(item);
                DownloadManager.access$addDownloadItemToList(DownloadManager.INSTANCE, item);
                item.setFinalFilePath(filePath);
                DownloadManager.access$addWaitToDownload(DownloadManager.INSTANCE);
                Object $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    DownloadListener it2 = (DownloadListener)element$iv;
                    boolean bl = false;
                    it2.onComplete(filePath, item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    $this$forEach$iv = downloadListener;
                    $i$f$forEach = false;
                    boolean bl = false;
                    it = $this$forEach$iv;
                    boolean bl4 = false;
                    it.onComplete(filePath, item);
                }
                ArrayList arrayList = (ArrayList)DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).get(item.getDownloadID());
                if (arrayList != null) {
                    $this$forEach$iv = arrayList;
                    $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        DownloadListener it3 = (DownloadListener)element$iv;
                        boolean bl = false;
                        it3.onComplete(filePath, item);
                    }
                }
                DownloadManager.access$getMTempDownloadListenerList$p(DownloadManager.INSTANCE).remove(item.getDownloadID());
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyFinished(item);
                }
                if (item.isAutoInstall()) {
                    InstallUtils.installAPP((Context)DownloadManager.access$getMContext$p(DownloadManager.INSTANCE), (String)filePath);
                }
            }

            public void onDelete(@NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Iterable $this$forEach$iv = DownloadManager.access$getMGlobalDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onDelete(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onDelete(item);
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyDelete(item);
                }
            }
        };
    }

    public static final /* synthetic */ void access$startTask(DownloadManager $this, DownloadItem info, boolean downloadAfterAdd, boolean downloadWhenUseMobile, boolean forceDownload) {
        $this.startTask(info, downloadAfterAdd, downloadWhenUseMobile, forceDownload);
    }

    public static final /* synthetic */ String access$checkBeforeDownloadFile(DownloadManager $this, DownloadItem info) {
        return $this.checkBeforeDownloadFile(info);
    }

    public static final /* synthetic */ innerDownloadListener.1 access$getInnerDownloadListener$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return innerDownloadListener;
    }

    public static final /* synthetic */ DownloadByHttp access$getMDownloadEngine$p(DownloadManager $this) {
        return $this.getMDownloadEngine();
    }

    public static final /* synthetic */ Context access$getMContext$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(DownloadManager $this, Context context) {
        DownloadManager downloadManager = $this;
        mContext = context;
    }

    public static final /* synthetic */ int access$getMMaxNum$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mMaxNum;
    }

    public static final /* synthetic */ void access$setMMaxNum$p(DownloadManager $this, int n) {
        DownloadManager downloadManager = $this;
        mMaxNum = n;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getMGlobalDownloadListenerList$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mGlobalDownloadListenerList;
    }

    public static final /* synthetic */ void access$setMGlobalDownloadListenerList$p(DownloadManager $this, CopyOnWriteArrayList copyOnWriteArrayList) {
        DownloadManager downloadManager = $this;
        mGlobalDownloadListenerList = copyOnWriteArrayList;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMTempDownloadListenerList$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mTempDownloadListenerList;
    }

    public static final /* synthetic */ void access$setMTempDownloadListenerList$p(DownloadManager $this, ConcurrentHashMap concurrentHashMap) {
        DownloadManager downloadManager = $this;
        mTempDownloadListenerList = concurrentHashMap;
    }

    public static final /* synthetic */ void access$addWaitToDownload(DownloadManager $this) {
        $this.addWaitToDownload();
    }

    public static final /* synthetic */ void access$addDownloadItemToList(DownloadManager $this, DownloadItem info) {
        $this.addDownloadItemToList(info);
    }
}

