/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.dabase;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.sqlite.BaseDBHelper;
import com.bihe0832.android.lib.sqlite.BaseTableModel;

public class DownloadPartInfoTableModel
extends BaseTableModel {
    public static final String col_id = "id";
    public static final String col_download_part_id = "download_part_id";
    public static final String col_part_id = "part_id";
    public static final String col_download_id = "download_id";
    public static final String col_start = "start";
    public static final String col_end = "end";
    public static final String col_finished = "finished";
    static final String TABLE_NAME = "download_part_info";
    static final String TABLE_CREATE_SQL = "CREATE TABLE IF NOT EXISTS [download_part_info] ([id] INTEGER PRIMARY KEY AUTOINCREMENT,[download_part_id] NVARCHAR(128) NOT NULL,[part_id] INT  NULL,[download_id] NVARCHAR(128)  NULL,[start] VARCHAR(256)  NULL,[end] VARCHAR(256)  NULL,[finished] VARCHAR(256) NULL)";
    static final String TABLE_DROP_SQL = "DROP TABLE IF EXISTS download_part_info";

    static int deleteAll(BaseDBHelper helper) {
        return DownloadPartInfoTableModel.deleteAll((BaseDBHelper)helper, (String)TABLE_NAME);
    }

    private static ContentValues data2CV(String download_part_id, int partID, long download_id, long start, long end, long finished) {
        ContentValues cv = new ContentValues();
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_download_part_id, (String)download_part_id);
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_part_id, (int)partID);
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_download_id, (long)download_id);
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_start, (long)start);
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_end, (long)end);
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_finished, (long)finished);
        return cv;
    }

    static boolean insertData(BaseDBHelper helper, String download_part_id, int partID, long download_id, long start, long end, long finished) {
        ContentValues values = DownloadPartInfoTableModel.data2CV(download_part_id, partID, download_id, start, end, finished);
        long id = helper.insert(TABLE_NAME, null, values);
        return id != -1L;
    }

    static boolean updateData(BaseDBHelper helper, String download_part_id, int partID, long download_id, long start, long end, long finished) {
        ContentValues values = DownloadPartInfoTableModel.data2CV(download_part_id, partID, download_id, start, end, finished);
        String whereClause = " `download_part_id` = ? ";
        String[] whereArgs = new String[]{download_part_id};
        int rows = helper.update(TABLE_NAME, values, whereClause, whereArgs);
        return rows != 0;
    }

    static boolean hasData(BaseDBHelper helper, long download_id, boolean showDetail) {
        boolean hasData = DownloadPartInfoTableModel.hasData(helper, download_id);
        ZLog.d((String)("\u6570\u636e\u5e93\u4fe1\u606f\uff1ahasData of :" + download_id + "is :" + hasData));
        if (showDetail) {
            Cursor cursor = helper.queryInfo(TABLE_NAME, null, null, null, null, null, null, null);
            try {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    long id = DownloadPartInfoTableModel.getLongByName((Cursor)cursor, (String)col_id);
                    long finished = DownloadPartInfoTableModel.getLongByName((Cursor)cursor, (String)col_finished);
                    long downloadINfo = DownloadPartInfoTableModel.getLongByName((Cursor)cursor, (String)col_download_id);
                    String partID = DownloadPartInfoTableModel.getStringByName((Cursor)cursor, (String)col_download_part_id);
                    ZLog.d((String)("\u6570\u636e\u5e93\u4fe1\u606f\uff1aid:" + id + "partID :" + partID + "download_id :" + downloadINfo + "finished :" + finished));
                    cursor.moveToNext();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hasData;
    }

    static boolean hasData(BaseDBHelper helper, String download_part_id) {
        String[] columns = null;
        String selection = " download_part_id = ? ";
        String[] selectionArgs = new String[]{download_part_id};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        String limit = null;
        boolean find = false;
        Cursor cursor = helper.queryInfo(TABLE_NAME, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        try {
            find = cursor != null && cursor.getCount() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cursor != null) {
            cursor.close();
        }
        return find;
    }

    static boolean hasData(BaseDBHelper helper, long download_id) {
        boolean find = false;
        Cursor cursor = DownloadPartInfoTableModel.getDownloadPartInfo(helper, download_id);
        try {
            find = cursor != null && cursor.getCount() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cursor != null) {
            cursor.close();
        }
        return find;
    }

    static boolean saveData(BaseDBHelper helper, String download_part_id, int partID, long download_id, long start, long end, long finished) {
        if (TextUtils.isEmpty((CharSequence)download_part_id)) {
            return false;
        }
        boolean success = DownloadPartInfoTableModel.hasData(helper, download_part_id) ? DownloadPartInfoTableModel.updateData(helper, download_part_id, partID, download_id, start, end, finished) : DownloadPartInfoTableModel.insertData(helper, download_part_id, partID, download_id, start, end, finished);
        return success;
    }

    static boolean updateDownloadFinished(BaseDBHelper helper, String downloadPartID, long finished) {
        ContentValues cv = new ContentValues();
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_download_part_id, (String)downloadPartID);
        DownloadPartInfoTableModel.putValues((ContentValues)cv, (String)col_finished, (long)finished);
        ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + downloadPartID + " DB \u6570\u636e\u66f4\u65b0\uff0c\u7d2f\u79ef\u4e0b\u8f7d:" + finished + ", " + FileUtils.INSTANCE.getFileLength(finished)));
        String whereClause = " `download_part_id` = ? ";
        String[] whereArgs = new String[]{downloadPartID};
        int rows = helper.update(TABLE_NAME, cv, whereClause, whereArgs);
        return rows != 0;
    }

    static Cursor getDownloadPartInfo(BaseDBHelper helper, long download_id) {
        String[] columns = null;
        String selection = " download_id = ? ";
        String[] selectionArgs = new String[]{String.valueOf(download_id)};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        String limit = null;
        Cursor cursor = helper.queryInfo(TABLE_NAME, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        return cursor;
    }

    static long getFinished(BaseDBHelper helper, long download_id) {
        String[] columns = null;
        String selection = " download_id = ? ";
        String[] selectionArgs = new String[]{String.valueOf(download_id)};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        String limit = null;
        boolean find = false;
        Cursor cursor = helper.queryInfo(TABLE_NAME, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        long finished = 0L;
        try {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                long partINfo = DownloadPartInfoTableModel.getLongByName((Cursor)cursor, (String)col_finished);
                String partID = DownloadPartInfoTableModel.getStringByName((Cursor)cursor, (String)col_download_part_id);
                ZLog.d((String)("getFinished:" + partINfo + "of id :" + partID));
                finished += partINfo;
                ZLog.e((String)"DownloadInfoDBManager", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + partID + " DB\u6570\u636e\u8bfb\u53d6\uff0c\u7d2f\u79ef\u4e0b\u8f7d:" + partINfo));
                cursor.moveToNext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cursor != null) {
            cursor.close();
        }
        return finished;
    }

    static boolean clearData(BaseDBHelper helper, long download_id) {
        int rows = 0;
        String whereClause = " download_id = ? ";
        String[] whereArgs = new String[]{String.valueOf(download_id)};
        try {
            SQLiteDatabase db = helper.getWritableDatabase();
            rows = db.delete(TABLE_NAME, whereClause, whereArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            rows = 0;
        }
        return rows != 0;
    }
}

