/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.dabase;

import android.content.Context;
import android.database.Cursor;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadPartInfo;
import com.bihe0832.android.lib.download.dabase.DownloadInfoDBHelper;
import com.bihe0832.android.lib.download.dabase.DownloadInfoTableModel;
import com.bihe0832.android.lib.download.dabase.DownloadPartInfoTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/bihe0832/android/lib/download/dabase/DownloadInfoDBManager;", "", "()V", "TAG", "", "commonDBHelperInstance", "Lcom/bihe0832/android/lib/download/dabase/DownloadInfoDBHelper;", "mApplicationContext", "Landroid/content/Context;", "clearDownloadInfoByID", "", "downloadID", "", "clearDownloadPartByID", "getDownloadInfo", "Lcom/bihe0832/android/lib/download/DownloadItem;", "url", "getDownloadInfoDBHelper", "getDownloadInfoFromPackageName", "packageName", "getDownloadPartInfo", "Landroid/database/Cursor;", "getFinishedBefore", "hasDownloadPartInfo", "showLines", "init", "", "context", "saveDownloadInfo", "item", "saveDownloadPartInfo", "downloadPartInfo", "Lcom/bihe0832/android/lib/download/DownloadPartInfo;", "updateDownloadFinished", "downloadPartID", "hasdownloadLength", "LibDownload_release"})
public final class DownloadInfoDBManager {
    @NotNull
    public static final String TAG = "DownloadInfoDBManager";
    private static Context mApplicationContext;
    private static DownloadInfoDBHelper commonDBHelperInstance;
    public static final DownloadInfoDBManager INSTANCE;

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        mApplicationContext = context;
        commonDBHelperInstance = new DownloadInfoDBHelper(mApplicationContext);
        DownloadInfoTableModel.initData(this.getDownloadInfoDBHelper());
    }

    private final synchronized DownloadInfoDBHelper getDownloadInfoDBHelper() {
        return commonDBHelperInstance;
    }

    public final boolean hasDownloadPartInfo(long downloadID, boolean showLines) {
        return DownloadPartInfoTableModel.hasData(this.getDownloadInfoDBHelper(), downloadID, showLines);
    }

    @Nullable
    public final DownloadItem getDownloadInfo(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return DownloadInfoTableModel.getDownloadInfo(this.getDownloadInfoDBHelper(), url);
    }

    @Nullable
    public final DownloadItem getDownloadInfoFromPackageName(@NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return DownloadInfoTableModel.getDownloadInfoFromPackageName(this.getDownloadInfoDBHelper(), packageName);
    }

    public final boolean saveDownloadInfo(@NotNull DownloadItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return item.canDownloadByPart() ? DownloadInfoTableModel.saveData(this.getDownloadInfoDBHelper(), item) : false;
    }

    public final long getFinishedBefore(long downloadID) {
        return DownloadPartInfoTableModel.getFinished(this.getDownloadInfoDBHelper(), downloadID);
    }

    public final boolean saveDownloadPartInfo(@NotNull DownloadPartInfo downloadPartInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadPartInfo, (String)"downloadPartInfo");
        return DownloadPartInfoTableModel.saveData(this.getDownloadInfoDBHelper(), downloadPartInfo.getDownloadPartID(), downloadPartInfo.getPartID(), downloadPartInfo.getDownloadID(), downloadPartInfo.getPartStart(), downloadPartInfo.getPartEnd(), downloadPartInfo.getPartFinished());
    }

    public final boolean updateDownloadFinished(@NotNull String downloadPartID, long hasdownloadLength) {
        Intrinsics.checkParameterIsNotNull((Object)downloadPartID, (String)"downloadPartID");
        return DownloadPartInfoTableModel.updateDownloadFinished(this.getDownloadInfoDBHelper(), downloadPartID, hasdownloadLength);
    }

    @NotNull
    public final Cursor getDownloadPartInfo(long downloadID) {
        Cursor cursor = DownloadPartInfoTableModel.getDownloadPartInfo(this.getDownloadInfoDBHelper(), downloadID);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"DownloadPartInfoTableMod\u2026foDBHelper(), downloadID)");
        return cursor;
    }

    public final boolean clearDownloadPartByID(long downloadID) {
        return DownloadPartInfoTableModel.clearData(this.getDownloadInfoDBHelper(), downloadID);
    }

    public final boolean clearDownloadInfoByID(long downloadID) {
        return DownloadInfoTableModel.clearData(this.getDownloadInfoDBHelper(), downloadID);
    }

    private DownloadInfoDBManager() {
    }

    static {
        DownloadInfoDBManager downloadInfoDBManager;
        INSTANCE = downloadInfoDBManager = new DownloadInfoDBManager();
    }
}

