/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.core.list;

import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.wrapper.DownloadUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u000eJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/bihe0832/android/lib/download/core/list/DownloadTaskList;", "", "()V", "lastCachedList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/bihe0832/android/lib/download/DownloadItem;", "kotlin.jvm.PlatformType", "listHasChanged", "", "mDownLoadIdList", "", "mDownloadList", "Ljava/util/concurrent/ConcurrentHashMap;", "addToDownloadTaskList", "", "item", "clear", "getDownloadTasKList", "getTaskByDownloadID", "downloadID", "getTaskByDownloadURL", "downloadURL", "", "hadAddTask", "removeFromDownloadTaskList", "downloadId", "updateDownloadTaskListItem", "LibDownload_release"})
public final class DownloadTaskList {
    private static final ConcurrentHashMap<Long, DownloadItem> mDownloadList;
    private static CopyOnWriteArrayList<Long> mDownLoadIdList;
    private static boolean listHasChanged;
    private static CopyOnWriteArrayList<DownloadItem> lastCachedList;
    public static final DownloadTaskList INSTANCE;

    @NotNull
    public final synchronized CopyOnWriteArrayList<DownloadItem> getDownloadTasKList() {
        if (listHasChanged) {
            Collection<DownloadItem> collection = mDownloadList.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"mDownloadList.values");
            lastCachedList = new CopyOnWriteArrayList(CollectionsKt.toList((Iterable)collection));
        }
        return lastCachedList;
    }

    public final synchronized boolean hadAddTask(@NotNull DownloadItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return CollectionsKt.toList((Iterable)mDownLoadIdList).contains(item.getDownloadID());
    }

    public final synchronized void clear() {
        listHasChanged = true;
        mDownloadList.clear();
    }

    public final synchronized void addToDownloadTaskList(@NotNull DownloadItem item) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                if (this.hadAddTask(item)) break block0;
                listHasChanged = true;
                ((Map)mDownloadList).put(item.getDownloadID(), item);
                mDownLoadIdList.add(item.getDownloadID());
                break block1;
            }
            this.updateDownloadTaskListItem(item);
            DownloadItem downloadItem = mDownloadList.get(item.getDownloadID());
            if (downloadItem == null) break block1;
            downloadItem.setDownloadListener(item.getDownloadListener());
        }
    }

    public final synchronized void updateDownloadTaskListItem(@NotNull DownloadItem item) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            if (!this.hadAddTask(item)) break block1;
            listHasChanged = true;
            DownloadItem downloadItem = mDownloadList.get(item.getDownloadID());
            if (downloadItem != null) {
                downloadItem.update(item);
            }
        }
    }

    public final synchronized void removeFromDownloadTaskList(long downloadId) {
        listHasChanged = true;
        mDownloadList.remove(downloadId);
        mDownLoadIdList.remove(downloadId);
    }

    @Nullable
    public final synchronized DownloadItem getTaskByDownloadID(long downloadID) {
        return mDownloadList.get(downloadID);
    }

    @Nullable
    public final synchronized DownloadItem getTaskByDownloadURL(@NotNull String downloadURL) {
        Intrinsics.checkParameterIsNotNull((Object)downloadURL, (String)"downloadURL");
        return mDownloadList.get(DownloadUtils.getDownloadIDByURL(downloadURL));
    }

    private DownloadTaskList() {
    }

    static {
        DownloadTaskList downloadTaskList;
        INSTANCE = downloadTaskList = new DownloadTaskList();
        mDownloadList = new ConcurrentHashMap();
        mDownLoadIdList = new CopyOnWriteArrayList();
        Collection<DownloadItem> collection = mDownloadList.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"mDownloadList.values");
        lastCachedList = new CopyOnWriteArrayList(CollectionsKt.toList((Iterable)collection));
    }
}

