/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.core.DownloadByHttp;
import com.bihe0832.android.lib.download.core.DownloadManager;
import com.bihe0832.android.lib.download.core.list.DownloadTaskList;
import com.bihe0832.android.lib.download.core.list.DownloadingList;
import com.bihe0832.android.lib.download.dabase.DownloadInfoDBManager;
import com.bihe0832.android.lib.download.notify.DownloadNotify;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.ZixieFileProvider;
import com.bihe0832.android.lib.install.InstallUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.NetworkUtil;
import com.bihe0832.android.lib.request.URLUtils;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.toast.ToastUtil;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\"*\u0001\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0012J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0014J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0)J\b\u0010*\u001a\u0004\u0018\u00010\tJ\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001a0)J(\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00102\u001a\u00020,H\u0002J\u001e\u00103\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a0)J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001a0)J\u000e\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\tJ*\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u00109\u001a\u00020\u0014J\u0012\u0010:\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u00109\u001a\u00020\u0014J\b\u0010;\u001a\u00020\u0014H\u0002J\u0006\u0010<\u001a\u00020\u0018J\u000e\u0010=\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010>\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0014J\u001e\u0010?\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u0014J\u000e\u0010A\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0014J \u0010B\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u000e\u0010D\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u0014J\u000e\u0010G\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u0014J\u000e\u0010H\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u0014J0\u0010I\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\b\u0010J\u001a\u0004\u0018\u00010\u00122\u0006\u0010&\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014J(\u0010L\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010M\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/bihe0832/android/lib/download/core/DownloadManager;", "", "()V", "DEFAULT_MAX_NUM", "", "innerDownloadListener", "com/bihe0832/android/lib/download/core/DownloadManager$innerDownloadListener$1", "Lcom/bihe0832/android/lib/download/core/DownloadManager$innerDownloadListener$1;", "mContext", "Landroid/content/Context;", "mDownloadEngine", "Lcom/bihe0832/android/lib/download/core/DownloadByHttp;", "getMDownloadEngine", "()Lcom/bihe0832/android/lib/download/core/DownloadByHttp;", "mDownloadEngine$delegate", "Lkotlin/Lazy;", "mDownloadListenerList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/bihe0832/android/lib/download/DownloadListener;", "mHasInit", "", "mIsDebug", "mMaxNum", "addDownloadItemToList", "", "info", "Lcom/bihe0832/android/lib/download/DownloadItem;", "addDownloadListener", "listener", "addTask", "forceDownload", "addWaitToDownload", "checkDownloadBeforeAndNotify", "checkIsDownloadingAndVersionIsNew", "checkIsInstalledAndLocalVersionIsNew", "deleteTask", "downloadId", "", "startByUser", "deleteFile", "getAllTask", "", "getContext", "getDownladTempFilePath", "", "downloadURL", "fileMD5", "fileName", "getDownloadingTask", "getFilePath", "prefix", "getFinalFileName", "getFinishedTask", "getWaitingTask", "init", "context", "maxNum", "isDebug", "initContext", "isWifi", "onDestroy", "pauseAllTask", "pauseDownloadingTask", "pauseTask", "clearHistory", "pauseWaitingTask", "realStartTask", "downloadAfterAdd", "removeDownloadListener", "resumeAllTask", "pauseOnMobile", "resumeFailedTask", "resumePauseTask", "resumeTask", "downloadListener", "downloadWhenUseMobile", "startTask", "updateInfo", "LibDownload_release"})
public final class DownloadManager {
    private static final Lazy mDownloadEngine$delegate;
    private static Context mContext;
    private static CopyOnWriteArrayList<DownloadListener> mDownloadListenerList;
    private static final int DEFAULT_MAX_NUM = 5;
    private static int mMaxNum;
    private static boolean mHasInit;
    private static boolean mIsDebug;
    private static final innerDownloadListener.1 innerDownloadListener;
    public static final DownloadManager INSTANCE;

    private final DownloadByHttp getMDownloadEngine() {
        Lazy lazy = mDownloadEngine$delegate;
        DownloadManager downloadManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DownloadByHttp)lazy.getValue();
    }

    @Nullable
    public final Context getContext() {
        return mContext;
    }

    public final boolean isDebug() {
        return mIsDebug;
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.init(context, mMaxNum, null, mIsDebug);
    }

    public final void init(@NotNull Context context, int maxNum, @Nullable DownloadListener listener, boolean isDebug) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.initContext(context);
            mMaxNum = maxNum;
            mIsDebug = isDebug;
            if (!mHasInit) {
                mHasInit = true;
                ZLog.setDebug((boolean)isDebug);
                DownloadNotify.INSTANCE.init(context);
                DownloadInfoDBManager.INSTANCE.init(context);
            }
            DownloadListener downloadListener = listener;
            if (downloadListener == null) break block2;
            DownloadListener downloadListener2 = downloadListener;
            boolean bl = false;
            boolean bl2 = false;
            DownloadListener it = downloadListener2;
            boolean bl3 = false;
            if (!mDownloadListenerList.contains(it)) {
                mDownloadListenerList.add(it);
            }
        }
    }

    public static /* synthetic */ void init$default(DownloadManager downloadManager, Context context, int n, DownloadListener downloadListener, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        downloadManager.init(context, n, downloadListener, bl);
    }

    private final void initContext(Context context) {
        block0: {
            Context context2 = context;
            if (context2 == null) break block0;
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context3;
            boolean bl3 = false;
            mContext = it;
        }
    }

    public final void onDestroy() {
        this.pauseAllTask(false);
        DownloadNotify.INSTANCE.destroy();
        mDownloadListenerList.clear();
    }

    private final void addWaitToDownload() {
        List<DownloadItem> list = this.getWaitingTask();
        boolean bl = false;
        boolean bl2 = false;
        List<DownloadItem> list2 = list;
        boolean bl3 = false;
        Object object = list2;
        boolean bl4 = false;
        if (!object.isEmpty()) {
            object = CollectionsKt.first(list2);
            bl4 = false;
            boolean bl5 = false;
            DownloadItem it = (DownloadItem)object;
            boolean bl6 = false;
            ThreadManager.getInstance().start(new Runnable(it){
                final /* synthetic */ DownloadItem $it;

                public final void run() {
                    DownloadManager.access$startTask(DownloadManager.INSTANCE, this.$it, this.$it.isDownloadWhenAdd(), this.$it.isDownloadWhenUseMobile(), false);
                }
                {
                    this.$it = downloadItem;
                }
            });
        }
    }

    private final boolean checkIsInstalledAndLocalVersionIsNew(DownloadItem info) {
        boolean bl;
        ZLog.d((String)("checkIsNeedDownload DownloadItem:" + info));
        if (TextUtils.isEmpty((CharSequence)info.getPackageName())) {
            ZLog.d((String)"packageName is bad ");
            return false;
        }
        if (info.getVersionCode() < 1L) {
            ZLog.d((String)"versionCode is bad ");
            return false;
        }
        ZLog.d((String)("checkIsNeedDownload versionCode:" + info.getVersionCode()));
        try {
            boolean bl2;
            PackageInfo packageInfo = APKUtils.getInstalledPackage((Context)mContext, (String)info.getPackageName());
            if (packageInfo != null) {
                ZLog.d((String)("checkIsNeedDownload installVersionCode:" + packageInfo.versionCode));
                bl2 = (long)packageInfo.versionCode > info.getVersionCode();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private final boolean checkIsDownloadingAndVersionIsNew(DownloadItem info) {
        boolean bl;
        ZLog.d((String)("checkIsDownloading DownloadItem:" + info));
        if (TextUtils.isEmpty((CharSequence)info.getPackageName())) {
            ZLog.d((String)"packageName is bad ");
            return false;
        }
        if (info.getVersionCode() < 1L) {
            ZLog.d((String)"versionCode is bad ");
            return false;
        }
        ZLog.d((String)("checkIsNeedDownload versionCode:" + info.getVersionCode()));
        String string = info.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.packageName");
        DownloadItem alreadyDownloadItem = DownloadInfoDBManager.INSTANCE.getDownloadInfoFromPackageName(string);
        if (alreadyDownloadItem == null) {
            ZLog.d((String)"checkIsNeedDownload alreadyDownloadItem null");
            bl = false;
        } else if (alreadyDownloadItem.getVersionCode() > 0L) {
            if (info.getVersionCode() != alreadyDownloadItem.getVersionCode()) {
                this.deleteTask(alreadyDownloadItem.getDownloadID(), false, true);
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void updateInfo(DownloadItem info) {
        DownloadItem savedInfo;
        DownloadItem downloadItem;
        if (info.canDownloadByPart()) {
            String string = info.getDownloadURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.downloadURL");
            downloadItem = DownloadInfoDBManager.INSTANCE.getDownloadInfo(string);
        } else {
            downloadItem = savedInfo = null;
        }
        if (savedInfo != null) {
            info.setFinalFilePath(savedInfo.getFinalFilePath());
            info.setTempFilePath(savedInfo.getTempFilePath());
            if (savedInfo.getFileLength() > 0L) {
                info.setFileLength(savedInfo.getFileLength());
                info.setFinishedLengthBefore(DownloadInfoDBManager.INSTANCE.getFinishedBefore(info.getDownloadID()));
                info.setFinished(info.getFinishedLengthBefore());
            }
        } else {
            String string = info.getDownloadURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.downloadURL");
            String string2 = info.getFileMD5();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.fileMD5");
            String string3 = info.getFileNameWithPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.fileNameWithPath");
            info.setFinalFilePath(this.getFinalFileName(string, string2, string3));
            String string4 = info.getDownloadURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.downloadURL");
            String string5 = info.getFileMD5();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"info.fileMD5");
            String string6 = info.getFileNameWithPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"info.fileNameWithPath");
            info.setTempFilePath(this.getDownladTempFilePath(string4, string5, string6));
        }
    }

    private final boolean checkDownloadBeforeAndNotify(DownloadItem info) {
        if (!info.isForceDownloadNew()) {
            String string = info.getFinalFilePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.finalFilePath");
            long l = info.getFileLength();
            String string2 = info.getFileMD5();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.fileMD5");
            if (FileUtils.INSTANCE.checkFileExist(string, l, string2)) {
                info.setDownloadStatus(4);
                String string3 = info.getFinalFilePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.finalFilePath");
                innerDownloadListener.onComplete(string3, info);
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)info.getFileMD5())) {
                String string4 = info.getTempFilePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.tempFilePath");
                long l2 = info.getFileLength();
                String string5 = info.getFileMD5();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"info.fileMD5");
                if (FileUtils.INSTANCE.checkFileExist(string4, l2, string5)) {
                    info.setFinalFilePath(info.getTempFilePath());
                    String string6 = info.getFinalFilePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"info.finalFilePath");
                    innerDownloadListener.onComplete(string6, info);
                    return true;
                }
            }
        }
        return false;
    }

    private final synchronized void startTask(DownloadItem info, boolean downloadAfterAdd, boolean downloadWhenUseMobile, boolean forceDownload) {
        innerDownloadListener.onWait(info);
        if (downloadAfterAdd) {
            if (!this.isWifi()) {
                if (downloadWhenUseMobile) {
                    this.realStartTask(info, true, forceDownload);
                } else {
                    this.realStartTask(info, false, forceDownload);
                }
            } else {
                this.realStartTask(info, true, forceDownload);
            }
        } else {
            ZLog.d((String)("startTask do nothing: $ " + info + ' '));
            this.realStartTask(info, false, forceDownload);
        }
    }

    private final boolean isWifi() {
        return NetworkUtil.isWifiNet((Context)mContext);
    }

    private final void realStartTask(DownloadItem info, boolean downloadAfterAdd, boolean forceDownload) {
        ZLog.d((String)("startTask:" + info));
        try {
            if (!URLUtils.isHTTPUrl((String)info.getDownloadURL())) {
                ZLog.e((String)("bad para:" + info));
                innerDownloadListener.onFail(-1, "bad para", info);
                return;
            }
            if (this.checkIsInstalledAndLocalVersionIsNew(info)) {
                ZLog.e((String)("no need download:" + info));
                innerDownloadListener.onFail(-2, "install is new", info);
                return;
            }
            if (this.checkIsDownloadingAndVersionIsNew(info)) {
                ZLog.e((String)("noneed download:" + info));
                innerDownloadListener.onFail(-3, "install is new", info);
                return;
            }
            this.addDownloadItemToList(info);
            new Thread(new Runnable(info, downloadAfterAdd, forceDownload){
                final /* synthetic */ DownloadItem $info;
                final /* synthetic */ boolean $downloadAfterAdd;
                final /* synthetic */ boolean $forceDownload;

                public final void run() {
                    if (DownloadManager.access$checkDownloadBeforeAndNotify(DownloadManager.INSTANCE, this.$info)) {
                        ZLog.e((String)("has download:" + this.$info));
                    } else if (this.$downloadAfterAdd) {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - this.$info.getPauseTime() < 3000L) {
                            ZLog.e((String)("resume to quick:" + this.$info));
                            DownloadManager.access$getInnerDownloadListener$p(DownloadManager.INSTANCE).onWait(this.$info);
                            this.$info.setDownloadWhenAdd(true);
                            long l = this.$info.getPauseTime() + 3000L - currentTime;
                            boolean bl = false;
                            boolean bl2 = false;
                            long it = l;
                            boolean bl3 = false;
                            if (it > 0L) {
                                Thread.sleep(it);
                            }
                        }
                        DownloadByHttp downloadByHttp = DownloadManager.access$getMDownloadEngine$p(DownloadManager.INSTANCE);
                        Context context = DownloadManager.access$getMContext$p(DownloadManager.INSTANCE);
                        if (context == null) {
                            Intrinsics.throwNpe();
                        }
                        downloadByHttp.startDownload(context, this.$info, this.$forceDownload);
                    } else {
                        this.$info.setPause();
                    }
                }
                {
                    this.$info = downloadItem;
                    this.$downloadAfterAdd = bl;
                    this.$forceDownload = bl2;
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.e((String)("download:" + e));
        }
    }

    private final void addDownloadItemToList(DownloadItem info) {
        ThreadManager.getInstance().start(new Runnable(info){
            final /* synthetic */ DownloadItem $info;

            public final void run() {
                if (this.$info.canDownloadByPart()) {
                    DownloadInfoDBManager.INSTANCE.saveDownloadInfo(this.$info);
                }
                DownloadTaskList.INSTANCE.addToDownloadTaskList(this.$info);
            }
            {
                this.$info = downloadItem;
            }
        });
    }

    @NotNull
    public final String getDownladTempFilePath(@NotNull String downloadURL, @NotNull String fileMD5, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)downloadURL, (String)"downloadURL");
        Intrinsics.checkParameterIsNotNull((Object)fileMD5, (String)"fileMD5");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return this.getFilePath(downloadURL, fileMD5, fileName, "Temp_");
    }

    @NotNull
    public final String getFinalFileName(@NotNull String downloadURL, @NotNull String fileMD5, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)downloadURL, (String)"downloadURL");
        Intrinsics.checkParameterIsNotNull((Object)fileMD5, (String)"fileMD5");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return this.getFilePath(downloadURL, fileMD5, fileName, "");
    }

    private final String getFilePath(String downloadURL, String fileMD5, String fileName, String prefix) {
        String string;
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            StringBuilder stringBuilder = new StringBuilder();
            Context context = mContext;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            String string2 = URLUtils.getFileName((String)downloadURL);
            StringBuilder stringBuilder2 = stringBuilder.append(ZixieFileProvider.getZixieFilePath((Context)context)).append(prefix);
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = TextUtils.isEmpty((CharSequence)it) ? (TextUtils.isEmpty((CharSequence)fileMD5) ? Long.valueOf(System.currentTimeMillis()) : fileMD5) : it;
            string = stringBuilder2.append((Object)string3).toString();
        } else {
            string = fileName;
        }
        return string;
    }

    public final void addTask(@NotNull DownloadItem info, boolean forceDownload) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        ZLog.d((String)("addTask:" + info));
        this.updateInfo(info);
        if (info.isForceDownloadNew()) {
            this.deleteTask(info.getDownloadID(), false, TextUtils.isEmpty((CharSequence)info.getFileMD5()));
        }
        innerDownloadListener.onWait(info);
        if (DownloadTaskList.INSTANCE.hadAddTask(info)) {
            ZLog.d((String)("mDownloadList contains:" + info));
            DownloadTaskList.INSTANCE.updateDownloadTaskListItem(info);
            this.resumeTask(info.getDownloadID(), info.getDownloadListener(), info.isDownloadWhenAdd(), info.isDownloadWhenUseMobile(), forceDownload);
        } else {
            this.startTask(info, info.isDownloadWhenAdd(), info.isDownloadWhenUseMobile(), forceDownload);
        }
    }

    public final void resumeTask(long downloadId, @Nullable DownloadListener downloadListener, boolean startByUser, boolean downloadWhenUseMobile, boolean forceDownload) {
        block2: {
            DownloadItem downloadItem = DownloadTaskList.INSTANCE.getTaskByDownloadID(downloadId);
            if (downloadItem == null) break block2;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem info = downloadItem2;
            boolean bl3 = false;
            ZLog.d((String)("resumeTask:" + info));
            if (startByUser) {
                info.setDownloadWhenAdd(true);
            }
            DownloadListener downloadListener2 = downloadListener;
            if (downloadListener2 != null) {
                DownloadListener downloadListener3 = downloadListener2;
                boolean bl4 = false;
                boolean bl5 = false;
                DownloadListener it = downloadListener3;
                boolean bl6 = false;
                info.setDownloadListener(it);
            }
            innerDownloadListener.onWait(info);
            INSTANCE.startTask(info, startByUser, downloadWhenUseMobile, forceDownload);
        }
    }

    public final void pauseTask(long downloadId, boolean startByUser, boolean clearHistory) {
        block1: {
            DownloadItem downloadItem = DownloadTaskList.INSTANCE.getTaskByDownloadID(downloadId);
            if (downloadItem == null) break block1;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem info = downloadItem2;
            boolean bl3 = false;
            ZLog.d((String)("pause:" + info));
            ZLog.d((String)("pause:" + info));
            INSTANCE.getMDownloadEngine().closeDownload(info.getDownloadID(), false, clearHistory);
            info.setStatus(6);
            info.setPause();
            if (startByUser) {
                innerDownloadListener.onPause(info);
            }
        }
    }

    public final void deleteTask(long downloadId, boolean startByUser, boolean deleteFile2) {
        block2: {
            DownloadItem downloadItem = DownloadTaskList.INSTANCE.getTaskByDownloadID(downloadId);
            if (downloadItem == null) break block2;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem info = downloadItem2;
            boolean bl3 = false;
            if (info.getStatus() == 3) {
                INSTANCE.addWaitToDownload();
            }
            DownloadTaskList.INSTANCE.removeFromDownloadTaskList(downloadId);
            info.setStatus(8);
            INSTANCE.getMDownloadEngine().closeDownload(downloadId, false, deleteFile2);
            DownloadInfoDBManager.INSTANCE.clearDownloadInfoByID(info.getDownloadID());
            if (deleteFile2) {
                INSTANCE.getMDownloadEngine().deleteFile(info);
            }
            DownloadNotify.INSTANCE.notifyDelete(info);
            innerDownloadListener.onDelete(info);
        }
    }

    public final void addDownloadListener(@NotNull DownloadListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (!mDownloadListenerList.contains(listener)) {
            mDownloadListenerList.add(listener);
        }
    }

    public final void removeDownloadListener(@NotNull DownloadListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        mDownloadListenerList.remove(listener);
    }

    public final void pauseAllTask(boolean startByUser) {
        ZLog.d((String)"pauseAllTask");
        this.pauseWaitingTask(startByUser);
        this.pauseDownloadingTask(startByUser);
    }

    public final void pauseDownloadingTask(boolean startByUser) {
        ZLog.d((String)"pauseDownloadingTask");
        Iterable $this$forEach$iv = this.getDownloadingTask();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.pauseTask(it.getDownloadID(), startByUser, false);
        }
    }

    public final void pauseWaitingTask(boolean startByUser) {
        ZLog.d((String)"pauseWaitingTask");
        Iterable $this$forEach$iv = this.getWaitingTask();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.pauseTask(it.getDownloadID(), startByUser, false);
        }
    }

    public final void resumeAllTask(boolean pauseOnMobile) {
        ZLog.d((String)"resumeAllTask");
        this.resumePauseTask(pauseOnMobile);
        this.resumeFailedTask(pauseOnMobile);
    }

    /*
     * WARNING - void declaration
     */
    public final void resumeFailedTask(boolean pauseOnMobile) {
        void $this$filterTo$iv$iv;
        ZLog.d((String)"resumeFailedTask");
        Iterable $this$filter$iv = this.getAllTask();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == 7)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.resumeTask(it.getDownloadID(), it.getDownloadListener(), true, pauseOnMobile, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void resumePauseTask(boolean pauseOnMobile) {
        void $this$filterTo$iv$iv;
        ZLog.d((String)"resumePauseTask");
        Iterable $this$filter$iv = this.getAllTask();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == 6)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItem it = (DownloadItem)element$iv;
            boolean bl = false;
            INSTANCE.resumeTask(it.getDownloadID(), it.getDownloadListener(), true, pauseOnMobile, false);
        }
    }

    @NotNull
    public final List<DownloadItem> getAllTask() {
        return DownloadTaskList.INSTANCE.getDownloadTasKList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadItem> getFinishedTask() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DownloadTaskList.INSTANCE.getDownloadTasKList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            DownloadItem downloadItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem, (String)"it");
            if (!(downloadItem.getStatus() == 5 || it.getStatus() == 4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadItem> getDownloadingTask() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DownloadTaskList.INSTANCE.getDownloadTasKList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            DownloadItem downloadItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem, (String)"it");
            if (!DownloadingList.INSTANCE.isDownloading(downloadItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadItem> getWaitingTask() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DownloadTaskList.INSTANCE.getDownloadTasKList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadItem it = (DownloadItem)element$iv$iv;
            boolean bl = false;
            DownloadItem downloadItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem, (String)"it");
            if (!(downloadItem.getStatus() == 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private DownloadManager() {
    }

    static {
        DownloadManager downloadManager;
        INSTANCE = downloadManager = new DownloadManager();
        mDownloadEngine$delegate = LazyKt.lazy((Function0)mDownloadEngine.2.INSTANCE);
        mDownloadListenerList = new CopyOnWriteArrayList();
        mMaxNum = 5;
        innerDownloadListener = new DownloadListener(){

            public void onWait(@NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(1);
                DownloadNotify.INSTANCE.notifyProcess(item);
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onWait(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onWait(item);
                }
                if (item.canDownloadByPart()) {
                    DownloadInfoDBManager.INSTANCE.saveDownloadInfo(item);
                }
            }

            public void onStart(@NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(2);
                item.setLastSpeed(0L);
                DownloadNotify.INSTANCE.notifyProcess(item);
                item.setStartTime(System.currentTimeMillis());
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onStart(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onStart(item);
                }
                if (item.canDownloadByPart()) {
                    DownloadInfoDBManager.INSTANCE.saveDownloadInfo(item);
                }
            }

            public void onProgress(@NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(3);
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onProgress(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onProgress(item);
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyProcess(item);
                }
            }

            public void onPause(@NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(6);
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onPause(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onPause(item);
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyPause(item);
                }
                DownloadManager.access$addWaitToDownload(DownloadManager.INSTANCE);
            }

            public void onFail(int errorCode, @NotNull String msg, @NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(7);
                DownloadManager.access$addWaitToDownload(DownloadManager.INSTANCE);
                if (-2 == errorCode) {
                    ToastUtil.showLong((Context)DownloadManager.access$getMContext$p(DownloadManager.INSTANCE), (String)("\u672c\u673a\u5df2\u6709\u66f4\u9ad8\u7248\u672c\u7684" + item.getDownloadTitle() + "\uff0c\u4e0b\u8f7d\u5df2\u53d6\u6d88"));
                }
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onFail(errorCode, msg, item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onFail(errorCode, msg, item);
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyFailed(item);
                }
            }

            public void onComplete(@NotNull String filePath, @NotNull DownloadItem item) {
                Object it;
                boolean bl;
                Object object;
                Object object2;
                Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setStatus(5);
                if (item.getFileLength() < 1L) {
                    item.setFileLength(new File(filePath).length());
                }
                item.setFinished(item.getFileLength());
                if (InstallUtils.isApkFile((String)filePath) && (object2 = DownloadManager.access$getMContext$p(DownloadManager.INSTANCE)) != null && (object2 = object2.getPackageManager()) != null && (object2 = object2.getPackageArchiveInfo(filePath, 1)) != null && (object2 = ((PackageInfo)object2).packageName) != null) {
                    object = object2;
                    bl = false;
                    boolean bl2 = false;
                    it = object;
                    boolean bl3 = false;
                    item.setPackageName((String)it);
                }
                if (item.canDownloadByPart()) {
                    DownloadInfoDBManager.INSTANCE.saveDownloadInfo(item);
                }
                DownloadManager.access$addDownloadItemToList(DownloadManager.INSTANCE, item);
                item.setFinalFilePath(filePath);
                DownloadManager.access$addWaitToDownload(DownloadManager.INSTANCE);
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it2 = (DownloadListener)element$iv;
                    boolean bl4 = false;
                    it2.onComplete(filePath, item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    object = downloadListener;
                    bl = false;
                    boolean bl5 = false;
                    it = object;
                    boolean bl6 = false;
                    it.onComplete(filePath, item);
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyFinished(item);
                }
                if (item.isAutoInstall()) {
                    InstallUtils.installAPP((Context)DownloadManager.access$getMContext$p(DownloadManager.INSTANCE), (String)filePath);
                }
            }

            public void onDelete(@NotNull DownloadItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Iterable $this$forEach$iv = DownloadManager.access$getMDownloadListenerList$p(DownloadManager.INSTANCE);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl = false;
                    it.onDelete(item);
                }
                DownloadListener downloadListener = item.getDownloadListener();
                if (downloadListener != null) {
                    DownloadListener downloadListener2 = downloadListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DownloadListener it = downloadListener2;
                    boolean bl3 = false;
                    it.onDelete(item);
                }
                if (item.notificationVisibility()) {
                    DownloadNotify.INSTANCE.notifyDelete(item);
                }
            }
        };
    }

    public static final /* synthetic */ void access$startTask(DownloadManager $this, DownloadItem info, boolean downloadAfterAdd, boolean downloadWhenUseMobile, boolean forceDownload) {
        $this.startTask(info, downloadAfterAdd, downloadWhenUseMobile, forceDownload);
    }

    public static final /* synthetic */ boolean access$checkDownloadBeforeAndNotify(DownloadManager $this, DownloadItem info) {
        return $this.checkDownloadBeforeAndNotify(info);
    }

    public static final /* synthetic */ innerDownloadListener.1 access$getInnerDownloadListener$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return innerDownloadListener;
    }

    public static final /* synthetic */ DownloadByHttp access$getMDownloadEngine$p(DownloadManager $this) {
        return $this.getMDownloadEngine();
    }

    public static final /* synthetic */ Context access$getMContext$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(DownloadManager $this, Context context) {
        DownloadManager downloadManager = $this;
        mContext = context;
    }

    public static final /* synthetic */ int access$getMMaxNum$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mMaxNum;
    }

    public static final /* synthetic */ void access$setMMaxNum$p(DownloadManager $this, int n) {
        DownloadManager downloadManager = $this;
        mMaxNum = n;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getMDownloadListenerList$p(DownloadManager $this) {
        DownloadManager downloadManager = $this;
        return mDownloadListenerList;
    }

    public static final /* synthetic */ void access$setMDownloadListenerList$p(DownloadManager $this, CopyOnWriteArrayList copyOnWriteArrayList) {
        DownloadManager downloadManager = $this;
        mDownloadListenerList = copyOnWriteArrayList;
    }

    public static final /* synthetic */ void access$addWaitToDownload(DownloadManager $this) {
        $this.addWaitToDownload();
    }

    public static final /* synthetic */ void access$addDownloadItemToList(DownloadManager $this, DownloadItem info) {
        $this.addDownloadItemToList(info);
    }
}

