/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.core;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.DownloadPartInfo;
import com.bihe0832.android.lib.download.core.ConnectionUpdateKt;
import com.bihe0832.android.lib.download.core.DownloadManager;
import com.bihe0832.android.lib.download.core.list.DownloadingList;
import com.bihe0832.android.lib.download.core.list.DownloadingPartList;
import com.bihe0832.android.lib.download.dabase.DownloadInfoDBManager;
import com.bihe0832.android.lib.download.part.DownloadThread;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.request.HTTPRequestUtils;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.utils.encrypt.MD5;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u001e\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\nJ8\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/bihe0832/android/lib/download/core/DownloadByHttp;", "", "applicationContext", "Landroid/content/Context;", "maxNum", "", "innerDownloadListener", "Lcom/bihe0832/android/lib/download/DownloadListener;", "(Landroid/content/Context;ILcom/bihe0832/android/lib/download/DownloadListener;)V", "hasStart", "", "addToDownloadList", "", "info", "Lcom/bihe0832/android/lib/download/DownloadItem;", "checkDownloadProcess", "closeDownload", "downloadID", "", "isFinished", "clearHistory", "deleteFile", "downloadInfo", "goDownload", "notifyDownloadAfterFinish", "notifyDownloadFailed", "errorCode", "msg", "", "item", "notifyDownloadSucc", "startDownload", "context", "forceDownload", "startDownloadPart", "partNo", "oldstart", "end", "finished", "canDownloadByPart", "startNew", "updateDownItemByServerInfo", "LibDownload_release"})
public final class DownloadByHttp {
    private boolean hasStart;
    private Context applicationContext;
    private int maxNum;
    private final DownloadListener innerDownloadListener;

    public final void startDownload(@NotNull Context context, @NotNull DownloadItem info, boolean forceDownload) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        ZLog.e((String)"Download", (String)("start info:" + info));
        if (this.applicationContext == null) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            this.applicationContext = context2;
        }
        if (DownloadingList.INSTANCE.isDownloading(info)) {
            ZLog.d((String)"Download", (String)"download has start");
            DownloadingList.INSTANCE.addToDownloadingList(info);
            return;
        }
        if (this.updateDownItemByServerInfo(info)) {
            if (DownloadingList.INSTANCE.getDownloadingNum() < this.maxNum || forceDownload) {
                ZLog.d((String)"Download", (String)"getDownloadList() is good");
                this.addToDownloadList(info);
                this.innerDownloadListener.onStart(info);
                this.goDownload(info);
                this.checkDownloadProcess();
            } else {
                this.innerDownloadListener.onWait(info);
            }
        }
    }

    private final void checkDownloadProcess() {
        if (this.hasStart) {
            ZLog.d((String)"Download", (String)"checkDownloadProcess has start");
            return;
        }
        this.hasStart = true;
        new Thread(new Runnable(this){
            final /* synthetic */ DownloadByHttp this$0;

            public final void run() {
                while (DownloadingList.INSTANCE.getDownloadingNum() > 0) {
                    ZLog.d((String)"checkDownloadProcess work");
                    Iterable $this$forEach$iv = DownloadingList.INSTANCE.getDownloadingItemList();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DownloadItem downloadItem = (DownloadItem)element$iv;
                        boolean bl = false;
                        boolean notFinished = false;
                        boolean hasFail = false;
                        DownloadItem downloadItem2 = downloadItem;
                        Intrinsics.checkExpressionValueIsNotNull((Object)downloadItem2, (String)"downloadItem");
                        if (downloadItem2.getStatus() == 3) {
                            long newFinished = 0L;
                            long finishedBefore = 0L;
                            Iterable $this$forEach$iv2 = DownloadingPartList.INSTANCE.getPartListById(downloadItem.getDownloadID());
                            boolean $i$f$forEach2 = false;
                            for (T element$iv2 : $this$forEach$iv2) {
                                DownloadThread downloadPartItem = (DownloadThread)element$iv2;
                                boolean bl2 = false;
                                newFinished += downloadPartItem.getDownloadPartInfo().getPartFinished();
                                finishedBefore += downloadPartItem.getDownloadPartInfo().getPartFinishedBefore();
                                ZLog.d((String)"Download", (String)("" + '\u7b2c' + downloadPartItem.getDownloadPartInfo().getPartID() + "\u5206\u7247\u4fe1\u606f:" + downloadPartItem.getDownloadPartInfo()));
                                if (downloadPartItem.getDownloadPartInfo().getPartStatus() != 5) {
                                    notFinished = true;
                                }
                                if (downloadPartItem.getDownloadPartInfo().getPartStatus() != 7) continue;
                                hasFail = true;
                            }
                            if (newFinished - finishedBefore < 1L) {
                                downloadItem.setLastSpeed(0L);
                            } else {
                                downloadItem.setLastSpeed(newFinished - downloadItem.getFinished());
                            }
                            downloadItem.setFinished(newFinished);
                            downloadItem.setFinishedLengthBefore(finishedBefore);
                            if (DownloadManager.INSTANCE.isDebug()) {
                                ZLog.w((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6c47\u603b - " + downloadItem.getDownloadID() + ": \u5b8c\u6210\u957f\u5ea6:" + FileUtils.INSTANCE.getFileLength(newFinished) + " \u4e4b\u524d\u4e0b\u8f7d\u957f\u5ea6:" + FileUtils.INSTANCE.getFileLength(finishedBefore)));
                            }
                            if (DownloadManager.INSTANCE.isDebug()) {
                                ZLog.w((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6c47\u603b - " + downloadItem.getDownloadID() + ": " + "\u6587\u4ef6\u957f\u5ea6 :" + FileUtils.INSTANCE.getFileLength(downloadItem.getFileLength()) + ";\u5b8c\u6210\u957f\u5ea6 :" + FileUtils.INSTANCE.getFileLength(downloadItem.getFinished()) + ";\u4e4b\u524d\u4e0b\u8f7d\u957f\u5ea6 :" + FileUtils.INSTANCE.getFileLength(downloadItem.getFinishedLengthBefore()) + ";\u672c\u6b21\u4e0b\u8f7d\u7d2f\u8ba1\u957f\u5ea6 :" + FileUtils.INSTANCE.getFileLength(newFinished - downloadItem.getFinishedLengthBefore()) + " \uff0c\u65b0\u589e\u957f\u5ea6: " + FileUtils.INSTANCE.getFileLength(downloadItem.getLastSpeed())));
                            }
                            if (downloadItem.getFinished() >= downloadItem.getFileLength()) {
                                downloadItem.setFinished(downloadItem.getFileLength());
                            }
                            DownloadByHttp.access$getInnerDownloadListener$p(this.this$0).onProgress(downloadItem);
                        }
                        if (!notFinished) {
                            DownloadByHttp.access$notifyDownloadAfterFinish(this.this$0, downloadItem);
                            continue;
                        }
                        if (downloadItem.getFileLength() > 0L && downloadItem.getFinished() == downloadItem.getFileLength()) {
                            DownloadByHttp.access$notifyDownloadAfterFinish(this.this$0, downloadItem);
                            continue;
                        }
                        if (!hasFail) continue;
                        DownloadByHttp.access$notifyDownloadFailed(this.this$0, -6, "download part exception", downloadItem);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                DownloadByHttp.access$setHasStart$p(this.this$0, false);
            }
            {
                this.this$0 = downloadByHttp;
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean updateDownItemByServerInfo(DownloadItem info) {
        ZLog.d((String)"Download", (String)("updateDownItemByServerInfo:" + info));
        URL url = new URL(info.getDownloadURL());
        int times = 0;
        while (true) {
            try {
                do {
                    URLConnection uRLConnection = url.openConnection();
                    if (uRLConnection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    boolean bl = false;
                    boolean bl2 = false;
                    HttpURLConnection $this$apply = httpURLConnection;
                    boolean bl3 = false;
                    ConnectionUpdateKt.upateRequestInfo($this$apply);
                    HttpURLConnection connection = httpURLConnection;
                    long time = System.currentTimeMillis();
                    connection.connect();
                    ZLog.e((String)"Download", (String)("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6\uff0c\u8bf7\u6c42\u7528\u65f6: " + (System.currentTimeMillis() - time) + " ~~~~~~~~~~~~~"));
                    if (DownloadManager.INSTANCE.isDebug()) {
                        ConnectionUpdateKt.logHeaderFields(connection, "\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6");
                    }
                    long contentLength = HTTPRequestUtils.getContentLength((URLConnection)connection);
                    ZLog.d((String)"Download", (String)("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6 getContentType:" + connection.getContentType()));
                    ZLog.d((String)"Download", (String)("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6 getContentLength:" + contentLength));
                    ZLog.d((String)"Download", (String)("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6 responseCode:" + connection.getResponseCode()));
                    if (connection.getResponseCode() != 200 && connection.getResponseCode() != 206) continue;
                    if (contentLength > 0L) {
                        info.setFileLength(contentLength);
                        ZLog.d((String)("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6 \u4fdd\u5b58\u4fe1\u606f:" + info));
                        if (!info.canDownloadByPart()) return true;
                        DownloadInfoDBManager.INSTANCE.saveDownloadInfo(info);
                        return true;
                    }
                    info.setCanDownloadByPart(false);
                    return true;
                } while (++times <= 3);
                this.notifyDownloadFailed(-5, "download with error file length after three times", info);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                ZLog.d((String)"Download", (String)("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6 \u5f02\u5e38 " + times + " :" + e));
                if (++times <= 3) continue;
                ZLog.e((String)"Download", (String)"\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6 \u5f02\u5e38: download with exception after three times");
                this.notifyDownloadFailed(-5, "download with exception after three times", info);
                return false;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void goDownload(DownloadItem info) {
        block18: {
            ZLog.d((String)"Download", (String)("goDownload:" + info));
            if (info.getFileLength() < 1L) {
                info.setCanDownloadByPart(false);
            }
            try {
                boolean hasDownload;
                File file = new File(info.getTempFilePath());
                boolean bl = hasDownload = info.canDownloadByPart() ? DownloadInfoDBManager.INSTANCE.hasDownloadPartInfo(info.getDownloadID(), DownloadManager.INSTANCE.isDebug()) : false;
                if (file.exists() && hasDownload && file.length() <= info.getFileLength()) {
                    ZLog.e((String)"Download", (String)("\u65ad\u70b9\u7eed\u4f20\u903b\u8f91:" + info));
                    ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + info.getDownloadID() + " \u5386\u53f2\u4e0b\u8f7d\u8ba1\u7b97\u524d: \u4e4b\u524d\u5df2\u5b8c\u6210" + FileUtils.INSTANCE.getFileLength(info.getFinishedLengthBefore()) + "\uff0c\u7d2f\u79ef\u5df2\u5b8c\u6210: " + FileUtils.INSTANCE.getFileLength(info.getFinished())));
                    info.setFinishedLengthBefore(DownloadInfoDBManager.INSTANCE.getFinishedBefore(info.getDownloadID()));
                    if (info.getFinishedLengthBefore() > info.getFinished()) {
                        info.setFinished(info.getFinishedLengthBefore());
                    }
                    ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + info.getDownloadID() + " \u5386\u53f2\u4e0b\u8f7d\u8ba1\u7b97\u540e: \u4e4b\u524d\u5df2\u5b8c\u6210" + FileUtils.INSTANCE.getFileLength(info.getFinishedLengthBefore()) + "\uff0c\u7d2f\u79ef\u5df2\u5b8c\u6210: " + FileUtils.INSTANCE.getFileLength(info.getFinished())));
                    ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + info.getDownloadID() + " : file length:" + FileUtils.INSTANCE.getFileLength(info.getFileLength()) + ", finished before: " + FileUtils.INSTANCE.getFileLength(info.getFinishedLengthBefore()) + ", need download " + FileUtils.INSTANCE.getFileLength(info.getFileLength() - info.getFinishedLengthBefore())));
                    Cursor cursor = DownloadInfoDBManager.INSTANCE.getDownloadPartInfo(info.getDownloadID());
                    ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + info.getDownloadID() + " - \u5df2\u6709\u5206\u7247:" + cursor.getCount()));
                    try {
                        cursor.moveToFirst();
                        while (!cursor.isAfterLast()) {
                            int id = cursor.getInt(cursor.getColumnIndex("part_id"));
                            long start = cursor.getLong(cursor.getColumnIndex("start"));
                            long end = cursor.getLong(cursor.getColumnIndex("end"));
                            long finished = cursor.getLong(cursor.getColumnIndex("finished"));
                            this.startDownloadPart(id, info, start, end, finished, true);
                            cursor.moveToNext();
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block18;
                    }
                    finally {
                        try {
                            cursor.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (hasDownload) {
                    DownloadInfoDBManager.INSTANCE.clearDownloadPartByID(info.getDownloadID());
                }
                this.startNew(info);
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (info.getStatus() == 6) break block18;
                this.notifyDownloadFailed(-6, "download with exception" + e, info);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startNew(DownloadItem info) {
        int n;
        ZLog.d((String)"Download", (String)("startNew:" + info));
        int threadNum = 1;
        if (info.canDownloadByPart() && info.getFileLength() > (long)0xA00000) {
            int n2;
            int n3 = (int)(info.getFileLength() / (long)0xA00000);
            boolean bl = false;
            n = 0;
            int it = n3;
            boolean bl2 = false;
            ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d: \u6587\u4ef6\u957f\u5ea6: " + info.getFileLength() + "\uff0c\u9ed8\u8ba4\u5206\u7247\u5927\u5c0f\uff1a10485760\uff0c\u6309\u9ed8\u8ba4\u5206\u7247\u53ef\u5206\u7247\uff1a" + it));
            int n4 = it > 10 ? 5 : (2 <= (n2 = it) && 10 >= n2 ? 10 / this.maxNum : (it < 1 ? 1 : it / this.maxNum));
            threadNum = n4;
            ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d: \u6587\u4ef6\u957f\u5ea6: " + info.getFileLength() + "\uff0c\u4e8c\u6b21\u5206\u7247\u6570\u91cf\uff1a" + threadNum + "\uff0c\u5e76\u884c\u4e0b\u8f7d\u91cf\u6570\u91cf\uff1a" + this.maxNum));
            if (threadNum < 1) {
                threadNum = 1;
            } else if (threadNum > 5) {
                threadNum = 5;
            }
            ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d: \u6587\u4ef6\u957f\u5ea6: " + info.getFileLength() + "\uff0c\u4e09\u6b21\u5206\u7247\u6570\u91cf\uff1a" + threadNum + "\uff0c\u5e76\u884c\u4e0b\u8f7d\u91cf\u6570\u91cf\uff1a" + this.maxNum));
            if (info.getFileLength() / (long)threadNum < (long)51200) {
                threadNum = (int)(info.getFileLength() / (long)51200);
            }
            if (threadNum < 1) {
                threadNum = 1;
            }
        } else {
            threadNum = 1;
        }
        long newpart = info.getFileLength() / (long)threadNum;
        if (info.getFileLength() - newpart * (long)(threadNum - 1) < newpart / (long)5 && threadNum > 1) {
            --threadNum;
        }
        ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d: \u6587\u4ef6\u957f\u5ea6: " + info.getFileLength() + "\uff0c\u6700\u7ec8\u5206\u7247\u6570\u91cf\uff1a" + threadNum));
        ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d: \u6700\u540e\u4e00\u7247\u957f\u5ea6: " + (info.getFileLength() - newpart * (long)(threadNum - 1))));
        if (threadNum > 1) {
            n = 0;
            int n5 = threadNum;
            while (n < n5) {
                void i;
                long start = (long)i * newpart;
                ZLog.d((String)("\u5206\u7247\u4e0b\u8f7d\uff1a\u5f00\u59cb\u7b2c" + (int)i + " \u6bb5"));
                void var9_11 = i;
                if (var9_11 == false) {
                    this.startDownloadPart((int)i, info, 0L, newpart, 0L, true);
                } else if (var9_11 == threadNum - 1) {
                    this.startDownloadPart((int)i, info, start, info.getFileLength(), 0L, true);
                } else {
                    this.startDownloadPart((int)i, info, start, start + newpart, 0L, true);
                }
                ++i;
            }
        } else {
            this.startDownloadPart(0, info, 0L, newpart, 0L, info.canDownloadByPart());
        }
    }

    private final void startDownloadPart(int partNo, DownloadItem info, long oldstart, long end, long finished, boolean canDownloadByPart) {
        DownloadPartInfo downloadPartInfo;
        ZLog.e((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e \u7b2c" + partNo + "\u5206\u7247 start: " + oldstart + ", end:" + end + ",length :" + (end - oldstart) + ", \u6587\u4ef6\u957f\u5ea6:" + info.getFileLength() + ' '));
        DownloadPartInfo downloadPartInfo2 = new DownloadPartInfo();
        boolean bl = false;
        boolean bl2 = false;
        DownloadPartInfo $this$apply = downloadPartInfo2;
        boolean bl3 = false;
        $this$apply.setPartID(partNo);
        $this$apply.setDownloadID(info.getDownloadID());
        $this$apply.setDownloadURL(info.getDownloadURL());
        $this$apply.setFinalFileName(info.getTempFilePath());
        $this$apply.setPartStart(oldstart);
        $this$apply.setPartEnd(end);
        $this$apply.setPartFinished(finished);
        $this$apply.setPartFinishedBefore(finished);
        $this$apply.setCanDownloadByPart(canDownloadByPart);
        downloadPartInfo2 = downloadPartInfo = downloadPartInfo2;
        bl = false;
        bl2 = false;
        DownloadPartInfo it = downloadPartInfo2;
        boolean bl4 = false;
        ZLog.d((String)"Download", (String)("\u5206\u7247\u4e0b\u8f7d\u6570\u636e - " + info.getDownloadID() + ": \u5f00\u59cb\u7b2c" + partNo + " \u6bb5\u5f00\u59cb:" + it));
        DownloadPartInfo downloadPartInfo3 = downloadPartInfo = downloadPartInfo2;
        DownloadThread downloadThreadForPart = new DownloadThread(downloadPartInfo3);
        DownloadingPartList.INSTANCE.addDownloadingPart(downloadThreadForPart);
        if (info.canDownloadByPart()) {
            DownloadInfoDBManager.INSTANCE.saveDownloadPartInfo(downloadThreadForPart.getDownloadPartInfo());
        }
        this.innerDownloadListener.onProgress(info);
        try {
            downloadThreadForPart.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.notifyDownloadFailed(-6, "download with exception:" + e, info);
        }
    }

    private final void addToDownloadList(DownloadItem info) {
        DownloadingList.INSTANCE.addToDownloadingList(info);
    }

    public final void closeDownload(long downloadID, boolean isFinished, boolean clearHistory) {
        ZLog.d((String)"Download", (String)("cancelDownload connectList:" + DownloadingPartList.INSTANCE.getDownloadingPartNum()));
        ZLog.d((String)"Download", (String)("cancelDownload downloadList:" + DownloadingList.INSTANCE.getDownloadingNum()));
        DownloadingPartList.INSTANCE.removeItem(downloadID, isFinished);
        if (clearHistory) {
            DownloadInfoDBManager.INSTANCE.clearDownloadPartByID(downloadID);
        }
        DownloadingList.INSTANCE.removeFromDownloadingList(downloadID);
        ZLog.d((String)"Download", (String)("cancelDownload connectList:" + DownloadingPartList.INSTANCE.getDownloadingPartNum()));
        ZLog.d((String)"Download", (String)("cancelDownload downloadList:" + DownloadingList.INSTANCE.getDownloadingNum()));
    }

    public final void deleteFile(@NotNull DownloadItem downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        ThreadManager.getInstance().start(new Runnable(downloadInfo){
            final /* synthetic */ DownloadItem $downloadInfo;

            public final void run() {
                String string = this.$downloadInfo.getFinalFilePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadInfo.finalFilePath");
                FileUtils.INSTANCE.deleteFile(string);
                String string2 = this.$downloadInfo.getTempFilePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"downloadInfo.tempFilePath");
                FileUtils.INSTANCE.deleteFile(string2);
            }
            {
                this.$downloadInfo = downloadItem;
            }
        });
    }

    private final void notifyDownloadFailed(int errorCode, String msg, DownloadItem item) {
        ZLog.d((String)"Download", (String)("notifyDownloadFailed errorCode " + errorCode + ", msg: " + msg + ", item: " + item));
        this.closeDownload(item.getDownloadID(), false, false);
        if (item.getStatus() != 6) {
            this.innerDownloadListener.onFail(errorCode, msg, item);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyDownloadAfterFinish(DownloadItem downloadInfo) {
        void downloadFile;
        this.closeDownload(downloadInfo.getDownloadID(), true, false);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = downloadInfo.getTempFilePath();
        ThreadManager.getInstance().start(new Runnable(this, (Ref.ObjectRef)downloadFile, downloadInfo){
            final /* synthetic */ DownloadByHttp this$0;
            final /* synthetic */ Ref.ObjectRef $downloadFile;
            final /* synthetic */ DownloadItem $downloadInfo;

            public final void run() {
                try {
                    File oldfile = new File((String)this.$downloadFile.element);
                    ZLog.d((String)"Download", (String)(" oldfile:" + oldfile));
                    ZLog.d((String)"Download", (String)(" oldfile length:" + oldfile.length()));
                    if (TextUtils.isEmpty((CharSequence)this.$downloadInfo.getFileMD5())) {
                        DownloadByHttp.access$notifyDownloadSucc(this.this$0, this.$downloadInfo);
                    } else {
                        String md5 = MD5.getFileMD5((String)((String)this.$downloadFile.element));
                        ZLog.d((String)"Download", (String)(" oldfile md5:" + md5));
                        ZLog.d((String)"Download", (String)(" downloadInfo md5:" + this.$downloadInfo.getFileMD5()));
                        if (StringsKt.equals((String)md5, (String)this.$downloadInfo.getFileMD5(), (boolean)true)) {
                            DownloadByHttp.access$notifyDownloadSucc(this.this$0, this.$downloadInfo);
                        } else {
                            DownloadByHttp.access$notifyDownloadFailed(this.this$0, -7, "Sorry! the file md5 is bad", this.$downloadInfo);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadByHttp.access$notifyDownloadFailed(this.this$0, -8, "Sorry! the file can't be renamed", this.$downloadInfo);
                }
            }
            {
                this.this$0 = downloadByHttp;
                this.$downloadFile = objectRef;
                this.$downloadInfo = downloadItem;
            }
        });
    }

    private final void notifyDownloadSucc(DownloadItem downloadInfo) {
        String downloadFile = downloadInfo.getTempFilePath();
        String finalFileName = downloadInfo.getFinalFilePath();
        File oldfile = new File(downloadFile);
        File newfile = new File(finalFileName);
        if (downloadFile.equals(finalFileName)) {
            String string = finalFileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"finalFileName");
            this.innerDownloadListener.onComplete(string, downloadInfo);
        } else if (oldfile.renameTo(newfile)) {
            ZLog.d((String)"Download", (String)" File renamed");
            ZLog.d((String)"Download", (String)(" finalFile:" + finalFileName));
            ZLog.d((String)"Download", (String)(" finalFile length:" + newfile.length()));
            String string = finalFileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"finalFileName");
            this.innerDownloadListener.onComplete(string, downloadInfo);
        } else {
            ZLog.d((String)"Sorry! the file can't be renamed");
            String string = downloadFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadFile");
            this.innerDownloadListener.onComplete(string, downloadInfo);
        }
    }

    public DownloadByHttp(@NotNull Context applicationContext, int maxNum, @NotNull DownloadListener innerDownloadListener2) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkParameterIsNotNull((Object)innerDownloadListener2, (String)"innerDownloadListener");
        this.applicationContext = applicationContext;
        this.maxNum = maxNum;
        this.innerDownloadListener = innerDownloadListener2;
    }

    public static final /* synthetic */ DownloadListener access$getInnerDownloadListener$p(DownloadByHttp $this) {
        return $this.innerDownloadListener;
    }

    public static final /* synthetic */ void access$notifyDownloadAfterFinish(DownloadByHttp $this, DownloadItem downloadInfo) {
        $this.notifyDownloadAfterFinish(downloadInfo);
    }

    public static final /* synthetic */ void access$notifyDownloadFailed(DownloadByHttp $this, int errorCode, String msg, DownloadItem item) {
        $this.notifyDownloadFailed(errorCode, msg, item);
    }

    public static final /* synthetic */ boolean access$getHasStart$p(DownloadByHttp $this) {
        return $this.hasStart;
    }

    public static final /* synthetic */ void access$setHasStart$p(DownloadByHttp $this, boolean bl) {
        $this.hasStart = bl;
    }

    public static final /* synthetic */ void access$notifyDownloadSucc(DownloadByHttp $this, DownloadItem downloadInfo) {
        $this.notifyDownloadSucc(downloadInfo);
    }
}

