/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download;

import android.text.TextUtils;
import android.util.Log;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.wrapper.DownloadUtils;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.bihe0832.android.lib.utils.MathUtils;
import java.io.Serializable;

public class DownloadItem
implements Serializable {
    public static final String TAG = "Download";
    private String downloadURL = "";
    private String fileMD5 = "";
    private boolean forceDownloadNew = false;
    private boolean autoInstall = false;
    private boolean notificationVisibility = false;
    private int status = 6;
    private boolean downloadWhenUseMobile = false;
    private boolean downloadWhenAdd = true;
    private boolean canDownloadByPart = false;
    private transient DownloadListener mDownloadListener = null;
    private String downloadDesc = "";
    private String downloadTitle = "";
    private String fileNameWithPath = "";
    private String finalFilePath = "";
    private String actionKey = "";
    private String extraInfo = "";
    private String packageName = "";
    private long versionCode = 0L;
    private String downloadIcon = "";
    private String tempFilePath = "";
    private long finishedLength = 0L;
    private long finishedLengthBefore = 0L;
    private long fileLength = 0L;
    private transient long lastSpeed = 0L;
    private transient long startTime = 0L;
    private transient long pauseTime = 0L;

    public boolean canDownloadByPart() {
        return this.canDownloadByPart;
    }

    public void setCanDownloadByPart(boolean canDownloadByPart) {
        this.canDownloadByPart = canDownloadByPart;
    }

    public void setNotificationVisibility(boolean visibility) {
        this.notificationVisibility = visibility;
    }

    public boolean notificationVisibility() {
        return this.notificationVisibility;
    }

    public DownloadListener getDownloadListener() {
        return this.mDownloadListener;
    }

    public void setDownloadListener(DownloadListener listener) {
        this.mDownloadListener = listener;
    }

    public int getAverageSpeed() {
        long finished = this.finishedLength - this.finishedLengthBefore;
        if (finished < 0L) {
            return 0;
        }
        return (int)((float)finished * 1.0f * 1000.0f / (float)(System.currentTimeMillis() - this.startTime));
    }

    public long getDownloadID() {
        return DownloadUtils.getDownloadIDByURL(this.downloadURL);
    }

    public String getDownloadDesc() {
        return this.downloadDesc;
    }

    public void setDownloadDesc(String desc) {
        this.downloadDesc = desc;
    }

    public String getProcessDesc() {
        return MathUtils.getFormatPercentDesc((float)this.getProcess());
    }

    public float getProcess() {
        return MathUtils.getFormatPercent((long)this.finishedLength, (long)this.fileLength, (int)4);
    }

    public boolean isDownloadWhenUseMobile() {
        return this.downloadWhenUseMobile;
    }

    public void setDownloadWhenUseMobile(boolean downloadWhenUseMobile) {
        this.downloadWhenUseMobile = downloadWhenUseMobile;
    }

    public boolean isDownloadWhenAdd() {
        return this.downloadWhenAdd;
    }

    public void setDownloadWhenAdd(boolean downloadWhenAdd) {
        this.downloadWhenAdd = downloadWhenAdd;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public String getDownloadIcon() {
        return this.downloadIcon;
    }

    public void setDownloadIcon(String downloadIcon) {
        this.downloadIcon = downloadIcon;
    }

    public String getFileMD5() {
        return this.fileMD5;
    }

    public void setFileMD5(String fileMD5) {
        this.fileMD5 = fileMD5;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getTempFilePath() {
        return this.tempFilePath;
    }

    public void setTempFilePath(String tempFilePath) {
        this.tempFilePath = tempFilePath;
    }

    public String getFileNameWithPath() {
        return this.fileNameWithPath;
    }

    public void setFileNameWithPath(String fileNameWithPath) {
        this.fileNameWithPath = fileNameWithPath;
    }

    public boolean isForceDownloadNew() {
        if (this.forceDownloadNew) {
            return true;
        }
        return !this.canDownloadByPart();
    }

    public static long getDownloadIDByURL(String url) {
        return ConvertUtils.getUnsignedInt((int)url.hashCode());
    }

    public void setForceDownloadNew(boolean forceDownloadNew) {
        this.forceDownloadNew = forceDownloadNew;
    }

    public void setDownloadStatus(int downloadStatus) {
        this.status = downloadStatus;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public String getFinalFilePath() {
        return this.finalFilePath;
    }

    public void setFinalFilePath(String finalFilePath) {
        this.finalFilePath = finalFilePath;
    }

    public long getFinishedLengthBefore() {
        return this.finishedLengthBefore;
    }

    public void setFinishedLengthBefore(long finishedLengthBefore) {
        this.finishedLengthBefore = finishedLengthBefore;
    }

    public boolean isAutoInstall() {
        return this.autoInstall;
    }

    public void setAutoInstall(boolean autoInstall) {
        this.autoInstall = autoInstall;
    }

    public long getFinished() {
        return this.finishedLength;
    }

    public void setFinished(long finished) {
        this.finishedLength = finished;
    }

    public long addFinished(long data) {
        return this.finishedLength += data;
    }

    public long getLastSpeed() {
        return this.lastSpeed;
    }

    public void setLastSpeed(long lastSpeed) {
        if (lastSpeed >= 0L) {
            this.lastSpeed = lastSpeed;
        }
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public void setPause() {
        this.status = 6;
        this.pauseTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int newStatus) {
        Log.d((String)TAG, (String)("status change , before: " + this.status + " after : " + newStatus));
        this.status = newStatus;
    }

    public String getDownloadTitle() {
        return this.downloadTitle;
    }

    public void setDownloadTitle(String downloadTitle) {
        this.downloadTitle = downloadTitle;
    }

    public long getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(long versionCode) {
        this.versionCode = versionCode;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        if (!TextUtils.isEmpty((CharSequence)extraInfo)) {
            this.extraInfo = extraInfo;
        }
    }

    public String getActionKey() {
        return this.actionKey;
    }

    public void setActionKey(String actionKey) {
        if (!TextUtils.isEmpty((CharSequence)actionKey)) {
            this.actionKey = actionKey;
        }
    }

    public void update(DownloadItem item) {
        if (item.getDownloadID() == this.getDownloadID()) {
            this.downloadURL = item.downloadURL;
            this.fileMD5 = item.fileMD5;
            this.forceDownloadNew = item.forceDownloadNew;
            this.autoInstall = item.autoInstall;
            this.notificationVisibility = item.notificationVisibility;
            this.downloadWhenUseMobile = item.downloadWhenUseMobile;
            this.downloadWhenAdd = item.downloadWhenAdd;
            this.canDownloadByPart = item.canDownloadByPart;
            this.mDownloadListener = item.mDownloadListener;
            this.downloadDesc = item.downloadDesc;
            this.downloadTitle = item.downloadTitle;
            this.fileNameWithPath = item.fileNameWithPath;
            this.finalFilePath = item.finalFilePath;
            this.actionKey = item.actionKey;
            this.extraInfo = item.extraInfo;
            this.packageName = item.packageName;
            this.versionCode = item.versionCode;
            this.downloadIcon = item.downloadIcon;
            this.tempFilePath = item.tempFilePath;
        } else {
            Log.e((String)TAG, (String)"update error , download id is bad ");
        }
    }

    public String toString() {
        return "\u4e0b\u8f7d\u8d44\u6e90\uff1a{downloadDesc='" + this.downloadDesc + '\'' + ", downloadTitle='" + this.downloadTitle + '\'' + ", actionKey='" + this.actionKey + '\'' + ", extraInfo='" + this.extraInfo + '\'' + ", packageName='" + this.packageName + '\'' + ", versionCode=" + this.versionCode + ", downloadIcon='" + this.downloadIcon + '\'' + ", downloadURL='" + this.downloadURL + '\'' + ", fileNameWithPath='" + this.fileNameWithPath + '\'' + ", finalFilePath='" + this.finalFilePath + '\'' + ", tempFilePath='" + this.tempFilePath + '\'' + ", fileMD5='" + this.fileMD5 + '\'' + ", forceDownloadNew=" + this.forceDownloadNew + ", finishedLength=" + this.finishedLength + ", finishedLengthBefore=" + this.finishedLengthBefore + ", fileLength=" + this.fileLength + ", lastSpeed=" + this.lastSpeed + ", startTime=" + this.startTime + ", pauseTime=" + this.pauseTime + ", autoInstall=" + this.autoInstall + ", status=" + this.status + ", downloadWhenUseMobile=" + this.downloadWhenUseMobile + ", downloadWhenAdd=" + this.downloadWhenAdd + '}';
    }
}

