/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.ZixieFileProvider;
import com.bihe0832.android.lib.install.APKInstall;
import com.bihe0832.android.lib.install.InstallListener;
import com.bihe0832.android.lib.install.InstallUtils;
import com.bihe0832.android.lib.install.obb.OBBFormats;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.zip.ZipUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class ObbFileInstall {
    private static final String TAG = "ObbFileInstall";

    ObbFileInstall() {
    }

    static void installObbAPKByFile(@NotNull Context context, @NonNull String fileDir, String packageName, InstallListener listener) {
        try {
            if (!FileUtils.INSTANCE.checkStoragePermissions(context)) {
                ZLog.d((String)"ObbFileInstallprepare4InstallObb checkPermissions failed");
                listener.onInstallFailed(-4);
                return;
            }
            File obbFolder = OBBFormats.getObbDir(packageName);
            if (!obbFolder.exists() && !obbFolder.mkdirs()) {
                listener.onInstallFailed(-5);
                return;
            }
            listener.onInstallPrepare();
            String result = ObbFileInstall.prepareInstallOBB(new File(fileDir), obbFolder, listener);
            if (!TextUtils.isEmpty((CharSequence)result)) {
                if (result.startsWith(ZixieFileProvider.getZixieFilePath((Context)context))) {
                    APKInstall.installAPK(context, result, listener);
                } else {
                    String realInstallPath = ZixieFileProvider.getZixieFilePath((Context)context) + "/" + FileUtils.INSTANCE.getFileName(result);
                    ZLog.d((String)"ObbFileInstallinstallObbAPKByFile start copy apk File");
                    FileUtils.INSTANCE.copyFile(new File(result), new File(realInstallPath));
                    ZLog.d((String)"ObbFileInstallinstallObbAPKByFile finished copy apk File");
                    listener.onInstallStart();
                    APKInstall.installAPK(context, realInstallPath, listener);
                }
            }
        }
        catch (Exception e) {
            ZLog.d((String)("ObbFileInstallprepare4InstallObb failed, for " + e));
            listener.onInstallFailed(-3);
        }
    }

    static String prepareInstallOBB(File fileDir, File obbFolder, InstallListener listener) {
        if (fileDir == null || !fileDir.exists()) {
            listener.onInstallFailed(-1);
            return "";
        }
        String dstApkFilePath = "";
        for (File file2 : fileDir.listFiles()) {
            if (file2.isDirectory()) {
                String result = ObbFileInstall.prepareInstallOBB(file2, obbFolder, listener);
                if (TextUtils.isEmpty((CharSequence)result)) continue;
                dstApkFilePath = result;
                continue;
            }
            if (OBBFormats.isObbFile(file2.getAbsolutePath())) {
                File targetObbFile = new File(obbFolder.getAbsolutePath() + "/" + FileUtils.INSTANCE.getFileName(file2.getAbsolutePath()));
                ZLog.d((String)"ObbFileInstallinstallObbAPKByFile start copy obb File");
                if (targetObbFile.exists()) {
                    targetObbFile.deleteOnExit();
                }
                FileUtils.INSTANCE.copyFile(file2, targetObbFile);
                ZLog.d((String)"ObbFileInstallinstallObbAPKByFile finished copy obb File");
                if (FileUtils.INSTANCE.checkFileExist(targetObbFile.getAbsolutePath())) continue;
                listener.onInstallFailed(-5);
                return "";
            }
            if (!InstallUtils.isApkFile(file2.getAbsolutePath())) continue;
            dstApkFilePath = file2.getAbsolutePath();
        }
        return dstApkFilePath;
    }

    static void installObbAPKByZip(@NotNull Context context, @NonNull String zipFile, String packageName, InstallListener listener) {
        try {
            if (!FileUtils.INSTANCE.checkStoragePermissions(context)) {
                ZLog.d((String)"ObbFileInstallprepare4InstallObb checkPermissions failed");
                listener.onInstallFailed(-4);
                return;
            }
            File obbFolder = OBBFormats.getObbDir(packageName);
            File targetAPKFolder = new File(ZixieFileProvider.getZixieFilePath((Context)context) + "/" + packageName);
            if (!targetAPKFolder.exists() && !targetAPKFolder.mkdirs()) {
                listener.onInstallFailed(-5);
                return;
            }
            String dstApkFilePath = "";
            for (String fileName : ZipUtils.getFileList((String)zipFile)) {
                if (OBBFormats.isObbFile(fileName)) {
                    if (!obbFolder.exists() && !obbFolder.mkdirs()) {
                        listener.onInstallFailed(-5);
                        return;
                    }
                    File newTargetObbFile = new File(obbFolder.getAbsolutePath() + "/" + FileUtils.INSTANCE.getFileName(fileName));
                    newTargetObbFile.deleteOnExit();
                    ZLog.d((String)("ObbFileInstall installObbAPKByZip unCompress to " + newTargetObbFile.getAbsolutePath() + " obb start"));
                    listener.onUnCompress();
                    ZipUtils.unCompressWithOutPath((String)zipFile, (String)fileName, (String)obbFolder.getAbsolutePath());
                    ZLog.d((String)"ObbFileInstall installObbAPKByZip unCompress obb finish");
                    if (FileUtils.INSTANCE.checkFileExist(newTargetObbFile.getAbsolutePath())) continue;
                    listener.onInstallFailed(-5);
                    return;
                }
                if (!InstallUtils.isApkFile(fileName)) continue;
                ZLog.d((String)"ObbFileInstall installObbAPKByZip unCompress apk start");
                listener.onUnCompress();
                ZipUtils.unCompressWithOutPath((String)zipFile, (String)fileName, (String)targetAPKFolder.getAbsolutePath());
                ZLog.d((String)"ObbFileInstall installObbAPKByZip unCompress apk finish");
                dstApkFilePath = targetAPKFolder.getAbsolutePath() + "/" + FileUtils.INSTANCE.getFileName(fileName);
            }
            listener.onInstallStart();
            APKInstall.installAPK(context, dstApkFilePath, listener);
        }
        catch (Exception e) {
            ZLog.d((String)("ObbFileInstallprepare4InstallObb failed, for " + e));
            listener.onInstallFailed(-3);
        }
    }
}

