/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.Context;
import android.support.annotation.NonNull;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.install.APKInstall;
import com.bihe0832.android.lib.install.InstallListener;
import com.bihe0832.android.lib.install.InstallUtils;
import com.bihe0832.android.lib.install.obb.OBBFormats;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.zip.ZipUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class ObbFileInstall {
    private static final String TAG = "ObbFileInstall";

    ObbFileInstall() {
    }

    static void installObbAPKByFile(@NotNull Context context, @NonNull String fileDir, String packageName, InstallListener listener) {
        try {
            if (!FileUtils.INSTANCE.checkStoragePermissions(context)) {
                ZLog.d((String)"ObbFileInstallprepare4InstallObb checkPermissions failed");
                listener.onInstallFailed(-4);
                return;
            }
            File obbFolder = OBBFormats.getObbDir(packageName);
            File[] a = new File(fileDir).listFiles();
            String dstApkFilePath = "";
            for (File tempFile : a) {
                if (OBBFormats.isObbFile(tempFile.getName())) {
                    if (!obbFolder.exists() && !obbFolder.mkdirs()) {
                        listener.onInstallFailed(-5);
                        return;
                    }
                    File targetObbFile = new File(obbFolder.getAbsolutePath() + "/" + FileUtils.INSTANCE.getFileName(tempFile.getAbsolutePath()));
                    ZLog.d((String)"ObbFileInstallinstallObbAPKByZip start copyFile");
                    if (targetObbFile.exists()) {
                        targetObbFile.deleteOnExit();
                    }
                    listener.onInstallPrepare();
                    FileUtils.INSTANCE.copyFile(tempFile, targetObbFile);
                    ZLog.d((String)"ObbFileInstallinstallObbAPKByZip finished copyFile");
                    if (FileUtils.INSTANCE.checkFileExist(targetObbFile.getAbsolutePath())) continue;
                    listener.onInstallFailed(-5);
                    return;
                }
                if (!InstallUtils.isApkFile(tempFile.getName())) continue;
                dstApkFilePath = tempFile.getAbsolutePath();
            }
            APKInstall.installAPK(context, dstApkFilePath, listener);
        }
        catch (Exception e) {
            ZLog.d((String)("ObbFileInstallprepare4InstallObb failed, for " + e));
            listener.onInstallFailed(-3);
        }
    }

    static void installObbAPKByZip(@NotNull Context context, @NonNull String zipFile, String packageName, InstallListener listener) {
        try {
            if (!FileUtils.INSTANCE.checkStoragePermissions(context)) {
                ZLog.d((String)"ObbFileInstallprepare4InstallObb checkPermissions failed");
                listener.onInstallFailed(-4);
                return;
            }
            File obbFolder = OBBFormats.getObbDir(packageName);
            File targetFolder = new File(FileUtils.INSTANCE.getZixieFilePath(context) + "/" + packageName);
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                listener.onInstallFailed(-5);
                return;
            }
            String dstApkFilePath = "";
            for (String fileName : ZipUtils.getFileList((String)zipFile)) {
                if (OBBFormats.isObbFile(fileName)) {
                    if (!obbFolder.exists() && !obbFolder.mkdirs()) {
                        listener.onInstallFailed(-5);
                        return;
                    }
                    File targetObbFile = new File(obbFolder.getAbsolutePath() + "/" + fileName);
                    targetObbFile.deleteOnExit();
                    ZLog.d((String)"ObbFileInstallinstallObbAPKByZip unCompress start");
                    listener.onUnCompress();
                    ZipUtils.unCompress((String)zipFile, (String)fileName, (String)obbFolder.getAbsolutePath());
                    ZLog.d((String)"ObbFileInstallinstallObbAPKByZip unCompress finish");
                    if (!FileUtils.INSTANCE.checkFileExist(targetObbFile.getAbsolutePath())) {
                        listener.onInstallFailed(-5);
                        return;
                    }
                } else if (InstallUtils.isApkFile(fileName)) {
                    dstApkFilePath = targetFolder.getAbsolutePath() + "/" + fileName;
                }
                listener.onUnCompress();
                ZipUtils.unCompress((String)zipFile, (String)fileName, (String)targetFolder.getAbsolutePath());
            }
            APKInstall.installAPK(context, dstApkFilePath, listener);
        }
        catch (Exception e) {
            ZLog.d((String)("ObbFileInstallprepare4InstallObb failed, for " + e));
            listener.onInstallFailed(-3);
        }
    }
}

