/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install.splitapk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.bihe0832.android.lib.log.ZLog;
import java.util.ArrayList;
import java.util.List;

public class SplitApksInstallBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "SplitApksInstallBroadcastReceiver:::";
    private Context mContext;
    private List<EventObserver> mObservers = new ArrayList<EventObserver>();

    public SplitApksInstallBroadcastReceiver(Context context) {
        this.mContext = context;
    }

    public String getIntentFilterFlag() {
        return this.mContext.getPackageName() + ".action.RootlessSaiPiBroadcastReceiver.ACTION_DELIVER_PI_EVENT";
    }

    public void onReceive(Context context, Intent intent) {
        int status = intent.getIntExtra("android.content.pm.extra.STATUS", -999);
        switch (status) {
            case -1: {
                ZLog.d((String)"SplitApksInstallBroadcastReceiver:::Requesting user confirmation for installation");
                Intent confirmationIntent = (Intent)intent.getParcelableExtra("android.intent.extra.INTENT");
                confirmationIntent.addFlags(0x10000000);
                try {
                    context.startActivity(confirmationIntent);
                }
                catch (Exception e) {
                    ZLog.e((String)("SplitApksInstallBroadcastReceiver:::startActivity failed:" + e.getMessage()));
                }
                this.dispatchOnConfirmationPending();
                break;
            }
            case 0: {
                ZLog.d((String)"SplitApksInstallBroadcastReceiver:::Installation succeed");
                this.dispatchOnInstallationSucceeded();
                break;
            }
            default: {
                ZLog.d((String)"SplitApksInstallBroadcastReceiver:::Installation failed");
                this.dispatchOnInstallationFailed();
            }
        }
    }

    private void dispatchOnConfirmationPending() {
        for (EventObserver observer : this.mObservers) {
            observer.onConfirmationPending();
        }
    }

    private void dispatchOnInstallationSucceeded() {
        for (EventObserver observer : this.mObservers) {
            observer.onInstallationSucceeded();
        }
    }

    private void dispatchOnInstallationFailed() {
        for (EventObserver observer : this.mObservers) {
            observer.onInstallationFailed();
        }
    }

    public void addEventObserver(EventObserver observer) {
        this.mObservers.add(observer);
    }

    public static interface EventObserver {
        public void onConfirmationPending();

        public void onInstallationSucceeded();

        public void onInstallationFailed();
    }
}

