/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.install.APKInstall;
import com.bihe0832.android.lib.install.ObbFileInstall;
import com.bihe0832.android.lib.install.obb.OBBFormats;
import com.bihe0832.android.lib.install.splitapk.SplitApksInstallHelper;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.zip.ZipUtils;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class InstallUtils {
    private static final String APK_FILE_SUFFIX = ".apk";
    private static final String TAG = "InstallUtils";

    public static boolean isApkFile(String filename) {
        return filename.endsWith(APK_FILE_SUFFIX);
    }

    public static boolean installAPP(Context context, Uri fileProvider, File file) {
        return APKInstall.realInstallAPK(context, fileProvider, file);
    }

    public static boolean installAPP(Context context, String filePath, String packageName) {
        return InstallUtils.installAllAPK(context, filePath, packageName);
    }

    public static boolean installAPP(Context context, String filePath) {
        return InstallUtils.installAPP(context, filePath, "");
    }

    static boolean installAllAPK(final Context context, final String filePath, final String packageName) {
        try {
            final File downloadedFile = new File(filePath);
            ZLog.d((String)("InstallUtilsinstallAllApk downloadedFile:" + downloadedFile.getAbsolutePath()));
            if (downloadedFile == null) {
                return false;
            }
            if (ZipUtils.isZipFile((String)downloadedFile.getAbsolutePath())) {
                ThreadManager.getInstance().start(new Runnable(){

                    @Override
                    public void run() {
                        boolean result = InstallUtils.installSpecialAPKByZip(context, filePath, packageName);
                        ZLog.d((String)("InstallUtilsinstallSpecialAPK result:" + result));
                    }
                });
                return true;
            }
            if (!downloadedFile.isDirectory()) {
                return APKInstall.installAPK(context, downloadedFile.getAbsolutePath());
            }
            ThreadManager.getInstance().start(new Runnable(){

                @Override
                public void run() {
                    boolean result = InstallUtils.installSpecialAPKByFolder(context, downloadedFile.getAbsolutePath(), packageName);
                    ZLog.d((String)("InstallUtilsinstallSpecialAPK result:" + result));
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)("InstallUtilsinstallAllApk failed:" + e.getMessage()));
            return false;
        }
    }

    static boolean installSpecialAPKByZip(@NotNull Context context, @NonNull String zipFilePath, String packageName) {
        ZLog.d((String)("InstallUtilsinstallSpecialAPKByZip:" + zipFilePath));
        String finalPackageName = "";
        finalPackageName = TextUtils.isEmpty((CharSequence)packageName) ? FileUtils.INSTANCE.getFileNameWithoutEx(zipFilePath) : packageName;
        ApkInstallType apkInstallType = InstallUtils.getApkInstallTypeByZip(zipFilePath);
        if (apkInstallType == ApkInstallType.OBB) {
            return ObbFileInstall.installObbAPKByZip(context, zipFilePath, finalPackageName);
        }
        if (apkInstallType == ApkInstallType.SPLIT_APKS) {
            String fileDir = FileUtils.INSTANCE.getZixieFilePath(context) + "/" + packageName;
            ZLog.d((String)"InstallUtilsinstallSpecialAPKByZip start unCompress:");
            ZipUtils.unCompress((String)zipFilePath, (String)fileDir);
            ZLog.d((String)"InstallUtilsinstallSpecialAPKByZip finished unCompress ");
            return SplitApksInstallHelper.INSTANCE.installApk(context, new File(fileDir), finalPackageName);
        }
        return false;
    }

    static boolean installSpecialAPKByFolder(@NotNull Context context, @NonNull String folderPath, String packageName) {
        ZLog.d((String)("InstallUtilsinstallSpecialAPKByFolder:" + folderPath));
        String finalPackageName = "";
        finalPackageName = TextUtils.isEmpty((CharSequence)packageName) ? FileUtils.INSTANCE.getFileName(folderPath) : packageName;
        ApkInstallType apkInstallType = InstallUtils.getApkInstallTypeByFolder(new File(folderPath));
        ZLog.d((String)("InstallUtilsinstallSpecialAPKByFolder start install:" + folderPath));
        if (apkInstallType == ApkInstallType.OBB) {
            return ObbFileInstall.installObbAPKByFile(context, folderPath, finalPackageName);
        }
        if (apkInstallType == ApkInstallType.SPLIT_APKS) {
            return SplitApksInstallHelper.INSTANCE.installApk(context, new File(folderPath), finalPackageName);
        }
        return false;
    }

    static ApkInstallType getApkInstallTypeByZip(String zipFile) {
        if (zipFile == null) {
            return ApkInstallType.APK;
        }
        int apkFileCount = 0;
        for (String fileName : ZipUtils.getFileList((String)zipFile)) {
            if (OBBFormats.isObbFile(fileName)) {
                return ApkInstallType.OBB;
            }
            if (!InstallUtils.isApkFile(fileName)) continue;
            if (apkFileCount > 0) {
                return ApkInstallType.SPLIT_APKS;
            }
            ++apkFileCount;
        }
        return apkFileCount > 1 ? ApkInstallType.SPLIT_APKS : ApkInstallType.APK;
    }

    static ApkInstallType getApkInstallTypeByFolder(File apkInstallFile) {
        if (apkInstallFile == null || !apkInstallFile.exists()) {
            return ApkInstallType.APK;
        }
        int apkFileCount = 0;
        LinkedList<File> folderList = new LinkedList<File>();
        for (File file2 : apkInstallFile.listFiles()) {
            if (file2.isDirectory()) {
                folderList.add(file2);
                continue;
            }
            if (OBBFormats.isObbFile(file2.getAbsolutePath())) {
                return ApkInstallType.OBB;
            }
            if (!InstallUtils.isApkFile(file2.getAbsolutePath())) continue;
            if (apkFileCount > 0) {
                return ApkInstallType.SPLIT_APKS;
            }
            ++apkFileCount;
        }
        while (!folderList.isEmpty()) {
            File temp_file = (File)folderList.removeFirst();
            for (File file2 : temp_file.listFiles()) {
                if (file2.isDirectory()) {
                    folderList.add(file2);
                    continue;
                }
                if (OBBFormats.isObbFile(file2.getAbsolutePath())) {
                    return ApkInstallType.OBB;
                }
                if (!InstallUtils.isApkFile(file2.getAbsolutePath())) continue;
                if (apkFileCount > 0) {
                    return ApkInstallType.SPLIT_APKS;
                }
                ++apkFileCount;
            }
        }
        return apkFileCount > 1 ? ApkInstallType.SPLIT_APKS : ApkInstallType.APK;
    }

    static enum ApkInstallType {
        APK,
        OBB,
        SPLIT_APKS;

    }
}

