/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.bihe0832.android.lib.file.FileUtils;
import java.io.File;

class APKInstall {
    private static String INSTALL_TYPE = "application/vnd.android.package-archive";

    APKInstall() {
    }

    static boolean installAPK(Context context, String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            try {
                File file = new File(filePath);
                Uri fileProvider = FileUtils.INSTANCE.getZixieFileProvider(context, file);
                return APKInstall.realInstallAPK(context, fileProvider, file);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    static boolean realInstallAPK(Context context, Uri fileProvider, File file) {
        if (file != null && file.exists()) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            try {
                if (Build.VERSION.SDK_INT < 24) {
                    intent.setDataAndType(Uri.fromFile((File)file), INSTALL_TYPE);
                } else {
                    intent.setDataAndType(fileProvider, INSTALL_TYPE);
                    intent.addFlags(1);
                    intent.addFlags(2);
                }
                if (Build.VERSION.SDK_INT > 26 && !context.getPackageManager().canRequestPackageInstalls()) {
                    Log.e((String)"InstallUtils", (String)"app don't hava install permission");
                    Log.e((String)"InstallUtils", (String)"app don't hava install permission");
                    Log.e((String)"InstallUtils", (String)"app don't hava install permission");
                }
                context.startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

