/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.Context;
import android.support.annotation.NonNull;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.ZipCompressor;
import com.bihe0832.android.lib.install.APKInstall;
import com.bihe0832.android.lib.install.splitapk.SplitApksInstallHelper;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

class SplitApkInstall {
    private static final String TAG = "ObbFileInstall";

    SplitApkInstall() {
    }

    static boolean installSplitAPKByZip(@NotNull Context context, @NonNull String filePath, String packageName) {
        try {
            ZipFile zipFile;
            File downloadedFile = new File(filePath);
            try {
                zipFile = new ZipFile(downloadedFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String fileDir = FileUtils.INSTANCE.getZixieFilePath(context) + "/" + packageName;
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String zipEntryName = zipEntry.getName();
                String filename = new File(zipEntryName).getName();
                File dstApkFile = new File(fileDir, filename);
                File dstApkParentDir = dstApkFile.getParentFile();
                if (!dstApkParentDir.exists() && !dstApkParentDir.mkdirs()) {
                    return false;
                }
                if (!APKInstall.isApkFile(filename)) continue;
                ZipCompressor.unzip2Dst((ZipFile)zipFile, (ZipEntry)zipEntry, (File)dstApkFile);
            }
            return SplitApksInstallHelper.INSTANCE.installApk(context, new File(fileDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

