/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.install.APKInstall;
import com.bihe0832.android.lib.install.ObbFileInstall;
import com.bihe0832.android.lib.install.SplitApkInstall;
import com.bihe0832.android.lib.install.obb.OBBFormats;
import com.bihe0832.android.lib.install.splitapk.SplitApksInstallHelper;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class InstallUtils {
    private static final String TAG = "InstallUtils";
    private static final String ZIP_DOWNLOADED_FILE_SUFFIX = ".zip";

    public static boolean installAPP(Context context, Uri fileProvider, File file) {
        return APKInstall.realInstallAPK(context, fileProvider, file);
    }

    public static boolean installAPP(Context context, String filePath, String packageName) {
        return InstallUtils.installAllAPK(context, filePath, packageName);
    }

    public static boolean installAPP(Context context, String filePath) {
        return InstallUtils.installAPP(context, filePath, "");
    }

    static boolean installAllAPK(final Context context, final String filePath, final String packageName) {
        try {
            File downloadedFile = new File(filePath);
            ZLog.d((String)("InstallUtilsinstallAllApk downloadedFile:" + downloadedFile.getAbsolutePath()));
            if (downloadedFile == null) {
                return false;
            }
            if (FileUtils.INSTANCE.isZipFile(downloadedFile)) {
                ThreadManager.getInstance().start(new Runnable(){

                    @Override
                    public void run() {
                        boolean result = InstallUtils.installSpecialAPK(context, filePath, packageName);
                        ZLog.d((String)("InstallUtilsinstallSpecialAPK result:" + result));
                    }
                });
                return true;
            }
            if (!downloadedFile.isDirectory()) {
                return APKInstall.installAPK(context, downloadedFile.getAbsolutePath());
            }
            return SplitApksInstallHelper.INSTANCE.installApk(context, downloadedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)("InstallUtilsinstallAllApk failed:" + e.getMessage()));
            return false;
        }
    }

    static boolean installSpecialAPK(@NotNull Context context, @NonNull String zipFilePath, String packageName) {
        String finalPackageName = "";
        finalPackageName = TextUtils.isEmpty((CharSequence)packageName) ? FileUtils.INSTANCE.getFileNameWithoutEx(zipFilePath) : packageName;
        ApkInstallType apkInstallType = InstallUtils.getApkInstallType(new File(zipFilePath));
        if (apkInstallType == ApkInstallType.OBB) {
            return ObbFileInstall.installObbAPKByZip(context, zipFilePath, finalPackageName);
        }
        if (apkInstallType == ApkInstallType.SPLIT_APKS) {
            return SplitApkInstall.installSplitAPKByZip(context, zipFilePath, finalPackageName);
        }
        return false;
    }

    static ApkInstallType getApkInstallType(File apkInstallFile) {
        if (apkInstallFile == null || !apkInstallFile.exists()) {
            return ApkInstallType.APK;
        }
        String apkInstallFileName = apkInstallFile.getName();
        ZLog.d((String)("InstallUtilsgetApkInstallType apkInstallFile:" + apkInstallFile + ",apkInstallFileName:" + apkInstallFileName));
        if (APKInstall.isApkFile(apkInstallFileName)) {
            return ApkInstallType.APK;
        }
        if (apkInstallFileName.endsWith(ZIP_DOWNLOADED_FILE_SUFFIX)) {
            try {
                ZipFile zipFile = new ZipFile(apkInstallFile);
                int apkFileCount = 0;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    String zipEntryName = zipEntry.getName();
                    ZLog.d((String)("InstallUtilsgetApkInstallType zipEntryName:" + zipEntryName));
                    String filename = new File(zipEntryName).getName();
                    ZLog.d((String)("InstallUtilsgetApkInstallType filename:" + filename));
                    if (OBBFormats.isObbFile(filename)) {
                        return ApkInstallType.OBB;
                    }
                    if (!APKInstall.isApkFile(filename)) continue;
                    ++apkFileCount;
                }
                ZLog.d((String)("InstallUtilsgetApkInstallType apkFileCount:" + apkFileCount));
                return apkFileCount > 1 ? ApkInstallType.SPLIT_APKS : ApkInstallType.APK;
            }
            catch (Exception e) {
                ZLog.e((String)("InstallUtilsgetApkInstallType failed:" + e.getMessage()));
            }
        }
        return ApkInstallType.APK;
    }

    static enum ApkInstallType {
        APK,
        OBB,
        SPLIT_APKS;

    }
}

