/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import com.bihe0832.android.lib.download.R;
import com.bihe0832.android.lib.file.FileUtils;
import java.io.File;

public class InstallUtils {
    private static String INSTALL_TYPE = "application/vnd.android.package-archive";

    public static boolean installAPP(Context context, String filePath) {
        return InstallUtils.realInstallAPP(context, filePath);
    }

    public static boolean realInstallAPP(Context context, String filePath) {
        if (FileUtils.INSTANCE.checkFileExist(filePath)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            File file = new File(filePath);
            try {
                if (Build.VERSION.SDK_INT < 24) {
                    intent.setDataAndType(Uri.fromFile((File)file), INSTALL_TYPE);
                } else {
                    Uri photoURI = FileProvider.getUriForFile((Context)context, (String)context.getResources().getString(R.string.lib_bihe0832_install_file_provider), (File)file);
                    intent.setDataAndType(photoURI, INSTALL_TYPE);
                    intent.addFlags(1);
                    intent.addFlags(2);
                }
                context.startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

