/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.download.manager;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.R;
import com.bihe0832.android.lib.download.manager.DownloadByDownloadManager;
import com.bihe0832.android.lib.download.manager.DownloadWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0004\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0012H\u0014R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/bihe0832/android/lib/download/manager/DownloadByDownloadManager;", "Lcom/bihe0832/android/lib/download/manager/DownloadWrapper;", "()V", "contentObserver", "com/bihe0832/android/lib/download/manager/DownloadByDownloadManager$contentObserver$2$1", "getContentObserver", "()Lcom/bihe0832/android/lib/download/manager/DownloadByDownloadManager$contentObserver$2$1;", "contentObserver$delegate", "Lkotlin/Lazy;", "downloadBroadcastReceiver", "com/bihe0832/android/lib/download/manager/DownloadByDownloadManager$downloadBroadcastReceiver$2$1", "getDownloadBroadcastReceiver", "()Lcom/bihe0832/android/lib/download/manager/DownloadByDownloadManager$downloadBroadcastReceiver$2$1;", "downloadBroadcastReceiver$delegate", "hasRegisterContentObserver", "", "hasRegisterDownloadBroadcastReceiver", "cancleDownload", "", "url", "", "goDownload", "context", "Landroid/content/Context;", "info", "Lcom/bihe0832/android/lib/download/DownloadItem;", "downloadListener", "Lcom/bihe0832/android/lib/download/DownloadListener;", "onDestory", "LibDownloadAndInstall_release"})
public final class DownloadByDownloadManager
extends DownloadWrapper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private boolean hasRegisterContentObserver;
    private boolean hasRegisterDownloadBroadcastReceiver;
    private final Lazy contentObserver$delegate = LazyKt.lazy((Function0)((Function0)new Function0<contentObserver.1>(this){
        final /* synthetic */ DownloadByDownloadManager this$0;

        @NotNull
        public final contentObserver.1 invoke() {
            return new ContentObserver(this, null){
                final /* synthetic */ contentObserver.2 this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onChange(boolean selfChange) {
                    Context context = this.this$0.this$0.getApplicationContext();
                    Object object = context != null ? context.getSystemService("download") : null;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.DownloadManager");
                    }
                    DownloadManager dm = (DownloadManager)object;
                    Map $this$forEach$iv = this.this$0.this$0.getMCurrentDownloadList();
                    boolean $i$f$forEach = false;
                    Map map = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Integer n;
                        DownloadItem downloadItem;
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> listItem = element$iv = iterator.next();
                        boolean bl2 = false;
                        if ((DownloadItem)listItem.getValue() == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        DownloadItem downloadInfo = downloadItem;
                        boolean bl5 = false;
                        Cursor c = null;
                        try {
                            Integer n2;
                            DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{downloadInfo.getDownloadID()});
                            c = dm.query(query);
                            if (c != null && c.moveToFirst()) {
                                int curSize = c.getInt(c.getColumnIndexOrThrow("bytes_so_far"));
                                int totalSize = c.getInt(c.getColumnIndexOrThrow("total_size"));
                                if (totalSize > 0) {
                                    ArrayList<DownloadListener> arrayList = downloadInfo.getDownloadNotifyListenerList();
                                    if (arrayList != null) {
                                        Iterable $this$forEach$iv2 = arrayList;
                                        boolean $i$f$forEach2 = false;
                                        for (T element$iv2 : $this$forEach$iv2) {
                                            DownloadListener it = (DownloadListener)element$iv2;
                                            boolean bl6 = false;
                                            it.onProgress(totalSize, curSize);
                                        }
                                    }
                                }
                                if (curSize == totalSize) {
                                    int fileUriIdx = c.getColumnIndex("local_uri");
                                    String fileUri = c.getString(fileUriIdx);
                                    DownloadByDownloadManager downloadByDownloadManager = this.this$0.this$0;
                                    String string2 = fileUri;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileUri");
                                    downloadByDownloadManager.notifyDownload(downloadInfo, string2);
                                    n2 = Unit.INSTANCE;
                                } else {
                                    int columnIndex = c.getColumnIndex("status");
                                    n2 = Log.e((String)this.this$0.this$0.getTAG(), (String)("startDownloadApk downloading 11" + c.getInt(columnIndex)));
                                }
                            } else {
                                n2 = Log.e((String)this.this$0.this$0.getTAG(), (String)"startDownloadApk c may null");
                            }
                            n = n2;
                        }
                        catch (Exception e) {
                            n = Log.e((String)this.this$0.this$0.getTAG(), (String)("startDownloadApk: " + e.getMessage()));
                        }
                        finally {
                            Cursor cursor = c;
                            if (cursor == null) continue;
                            cursor.close();
                        }
                    }
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
        }
        {
            this.this$0 = downloadByDownloadManager;
            super(0);
        }
    }));
    private final Lazy downloadBroadcastReceiver$delegate = LazyKt.lazy((Function0)((Function0)new Function0<downloadBroadcastReceiver.1>(this){
        final /* synthetic */ DownloadByDownloadManager this$0;

        @NotNull
        public final downloadBroadcastReceiver.1 invoke() {
            return new BroadcastReceiver(this){
                final /* synthetic */ downloadBroadcastReceiver.2 this$0;

                /*
                 * WARNING - void declaration
                 */
                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                    Object object = context.getSystemService("download");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.DownloadManager");
                    }
                    DownloadManager dm = (DownloadManager)object;
                    Bundle bundle = intent.getExtras();
                    long id = bundle != null ? bundle.getLong("extra_download_id", -1L) : 0L;
                    Map $this$filter$iv = this.this$0.this$0.getMCurrentDownloadList();
                    boolean $i$f$filter = false;
                    Map map = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    void var11_12 = $this$filterTo$iv$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = var11_12.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(((DownloadItem)it.getValue()).getDownloadID() == id)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    Map $this$forEach$iv = destination$iv$iv;
                    boolean $i$f$forEach = false;
                    map = $this$forEach$iv;
                    boolean bl3 = false;
                    Iterator<Map.Entry<K, V>> iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> listItem = element$iv = iterator2.next();
                        boolean bl4 = false;
                        Cursor c = dm.query(new DownloadManager.Query().setFilterById(new long[]{id}));
                        if (c == null || !c.moveToFirst()) continue;
                        int columnIndex = c.getColumnIndex("status");
                        if (16 == c.getInt(columnIndex)) {
                            Iterable $this$forEach$iv2 = ((DownloadItem)listItem.getValue()).getDownloadNotifyListenerList();
                            boolean $i$f$forEach2 = false;
                            for (T element$iv2 : $this$forEach$iv2) {
                                DownloadListener it = (DownloadListener)element$iv2;
                                boolean bl5 = false;
                                it.onError(-5, "download failed");
                            }
                        }
                        this.this$0.this$0.getMCurrentDownloadList().remove(listItem.getKey());
                        c.close();
                    }
                }
                {
                    this.this$0 = $outer;
                }
            };
        }
        {
            this.this$0 = downloadByDownloadManager;
            super(0);
        }
    }));

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DownloadByDownloadManager.class), "contentObserver", "getContentObserver()Lcom/bihe0832/android/lib/download/manager/DownloadByDownloadManager$contentObserver$2$1;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DownloadByDownloadManager.class), "downloadBroadcastReceiver", "getDownloadBroadcastReceiver()Lcom/bihe0832/android/lib/download/manager/DownloadByDownloadManager$downloadBroadcastReceiver$2$1;"))};
    }

    private final contentObserver.1 getContentObserver() {
        Lazy lazy = this.contentObserver$delegate;
        DownloadByDownloadManager downloadByDownloadManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Object)lazy.getValue();
    }

    private final downloadBroadcastReceiver.1 getDownloadBroadcastReceiver() {
        Lazy lazy = this.downloadBroadcastReceiver$delegate;
        DownloadByDownloadManager downloadByDownloadManager = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (Object)lazy.getValue();
    }

    @Override
    protected void goDownload(@NotNull Context context, @NotNull DownloadItem info, @Nullable DownloadListener downloadListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        if (!this.hasRegisterContentObserver) {
            context.getContentResolver().registerContentObserver(this.getCONTENT_URI(), true, (ContentObserver)this.getContentObserver());
        }
        if (!this.hasRegisterDownloadBroadcastReceiver) {
            context.registerReceiver((BroadcastReceiver)this.getDownloadBroadcastReceiver(), new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)info.getDownloadURL()));
        boolean bl = false;
        boolean bl2 = false;
        DownloadManager.Request $this$apply = request;
        boolean bl3 = false;
        $this$apply.setAllowedNetworkTypes(3);
        if (!TextUtils.isEmpty((CharSequence)info.getDowmloadTitle())) {
            $this$apply.setTitle((CharSequence)info.getDowmloadTitle());
        } else {
            $this$apply.setTitle((CharSequence)info.getFileName());
        }
        if (!TextUtils.isEmpty((CharSequence)info.getDownloadDesc())) {
            $this$apply.setDescription((CharSequence)info.getDownloadDesc());
        }
        if (Build.VERSION.SDK_INT >= 11) {
            $this$apply.allowScanningByMediaScanner();
            $this$apply.setNotificationVisibility(info.getNotificationVisibility());
        }
        if (info.getNotificationVisibility() == 1 || info.getNotificationVisibility() == 3) {
            Context context2 = this.getApplicationContext();
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.setDestinationInExternalFilesDir(context, context2.getString(R.string.lib_bihe0832_install_folder), info.getFileName());
        } else {
            Context context3 = this.getApplicationContext();
            if (context3 == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.setDestinationInExternalFilesDir(context, context3.getString(R.string.lib_bihe0832_install_folder), "temp_" + System.currentTimeMillis() + "_" + info.getFileName());
        }
        DownloadManager.Request request2 = request;
        Object object = context.getSystemService("download");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.DownloadManager");
        }
        DownloadManager dm = (DownloadManager)object;
        info.setDownloadID(dm.enqueue(request2));
        if (info.getDownloadID() > 0L) {
            ((Map)this.getMCurrentDownloadList()).put(info.getDownloadURL(), info);
        } else {
            ArrayList<DownloadListener> arrayList = info.getDownloadNotifyListenerList();
            if (arrayList != null) {
                Iterable $this$forEach$iv = arrayList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DownloadListener it = (DownloadListener)element$iv;
                    boolean bl4 = false;
                    it.onError(-6, "id is bad");
                }
            }
        }
    }

    @Override
    public void cancleDownload(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        DownloadItem downloadItem = this.getMCurrentDownloadList().get(url);
        if (downloadItem != null) {
            DownloadManager dm;
            DownloadItem downloadItem2 = downloadItem;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItem it = downloadItem2;
            boolean bl3 = false;
            Context context = this.getApplicationContext();
            Object object = context != null ? context.getSystemService("download") : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.DownloadManager");
            }
            DownloadManager downloadManager = dm = (DownloadManager)object;
            if (downloadManager != null) {
                downloadManager.remove(new long[]{it.getDownloadID()});
            }
            Iterable $this$forEach$iv = it.getDownloadNotifyListenerList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadListener it2 = (DownloadListener)element$iv;
                boolean bl4 = false;
                it2.onError(-8, "cancle");
            }
        }
        this.stopDownload(url);
    }

    @Override
    protected void onDestory() {
        if (this.hasRegisterContentObserver) {
            Context context = this.getApplicationContext();
            if (context != null && (context = context.getContentResolver()) != null) {
                context.unregisterContentObserver((ContentObserver)this.getContentObserver());
            }
            this.hasRegisterContentObserver = false;
        }
        if (this.hasRegisterDownloadBroadcastReceiver) {
            Context context = this.getApplicationContext();
            if (context != null) {
                context.unregisterReceiver((BroadcastReceiver)this.getDownloadBroadcastReceiver());
            }
            this.hasRegisterDownloadBroadcastReceiver = false;
        }
    }
}

