/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.dialog.view;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.bihe0832.android.lib.utils.os.DisplayUtil;
import java.util.ArrayList;
import java.util.List;

public class ProgressIndicatorView
extends View {
    public static final int DEFAULT_ITEM_SIZE = 16;
    public static final int DEFAULT_NUM = 3;
    public static final float SCALE = 1.0f;
    private boolean mAutoAnimation = true;
    private int mAnimationNum = 3;
    private List<Animator> mAnimators = null;
    private float[] scaleFloats = new float[0];
    Paint mPaint;

    public ProgressIndicatorView(Context context) {
        super(context);
        this.initView();
    }

    public ProgressIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ProgressIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(DisplayUtil.dip2px((Context)this.getContext(), (float)(16 * this.mAnimationNum)), widthMeasureSpec);
        int height = this.measureDimension(DisplayUtil.dip2px((Context)this.getContext(), (float)48.0f), heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureDimension(int defaultSize, int measureSpec) {
        int result = defaultSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(defaultSize, specSize) : defaultSize);
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float xradius = this.getWidth() / (this.mAnimators.size() * 2 + 1);
        float yradius = this.getHeight() / this.mAnimators.size();
        float radius = Math.min(xradius, yradius) / 2.0f;
        float circleSpacing = ((float)this.getWidth() - radius * 2.0f * (float)this.mAnimators.size()) / (float)(this.mAnimators.size() + 1);
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        float y = this.getHeight() / 2;
        for (int i = 0; i < this.mAnimators.size(); ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + circleSpacing * (float)i;
            canvas.translate(translateX, y);
            if (this.scaleFloats.length > i) {
                canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            }
            canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
            canvas.restore();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (null == this.mAnimators || this.mAnimators.isEmpty()) {
            this.applyAnimation();
        }
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (this.mAutoAnimation) {
                if (v == 8 || v == 4) {
                    this.setAnimationStatus(AnimStatus.END);
                } else {
                    this.setAnimationStatus(AnimStatus.START);
                }
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setAnimationStatus(AnimStatus.CANCEL);
    }

    protected void applyAnimation() {
        this.mAnimators = this.createAnimation();
    }

    protected List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.scaleFloats = new float[this.mAnimationNum];
        for (int i = 0; i < this.mAnimationNum; ++i) {
            final int index = i;
            this.scaleFloats[index] = 1.0f;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            scaleAnim.setDuration((long)(375 * this.mAnimationNum));
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)(180 * i + 1));
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((ProgressIndicatorView)ProgressIndicatorView.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    ProgressIndicatorView.this.postInvalidate();
                }
            });
            scaleAnim.start();
            animators.add((Animator)scaleAnim);
        }
        return animators;
    }

    public void setAnimationStatus(AnimStatus animStatus) {
        if (this.mAnimators == null) {
            return;
        }
        int count = this.mAnimators.size();
        block5: for (int i = 0; i < count; ++i) {
            Animator animator = this.mAnimators.get(i);
            boolean isRunning = animator.isRunning();
            switch (animStatus) {
                case START: {
                    if (isRunning) continue block5;
                    animator.start();
                    continue block5;
                }
                case END: {
                    if (!isRunning) continue block5;
                    animator.end();
                    continue block5;
                }
                case CANCEL: {
                    if (!isRunning) continue block5;
                    animator.cancel();
                }
            }
        }
    }

    public void setAnimationNum(int num) {
        this.mAnimationNum = num;
    }

    public void seAutoAnimation(boolean mAutoAnimation) {
        this.mAutoAnimation = mAutoAnimation;
    }

    public static enum AnimStatus {
        START,
        END,
        CANCEL;

    }
}

