/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.dialog.input;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.bihe0832.android.lib.ui.dialog.CommonDialog;
import com.bihe0832.android.lib.ui.dialog.OnDialogListener;
import com.bihe0832.android.lib.ui.dialog.R;
import com.bihe0832.android.lib.ui.dialog.input.InputDialogCallback;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

public class InputDialog {
    public static void showInputDialog(Context context, String titleName, String msg, String positive, String negtive, Boolean canCanceledOnTouchOutside, int inputType, String defaultValue, String hint, final InputDialogCallback listener) {
        final CommonDialog dialog = new CommonDialog(context);
        dialog.setTitle(titleName);
        dialog.setHtmlContent(msg);
        dialog.setPositive(positive);
        dialog.setNegative(negtive);
        dialog.setShouldCanceled(canCanceledOnTouchOutside);
        final EditText editText = new EditText(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setSingleLine();
        editText.setInputType(inputType);
        editText.setPadding(DisplayUtil.dip2px((Context)context, (float)4.0f), DisplayUtil.dip2px((Context)context, (float)8.0f), DisplayUtil.dip2px((Context)context, (float)4.0f), DisplayUtil.dip2px((Context)context, (float)8.0f));
        editText.setBackgroundColor(context.getResources().getColor(R.color.com_bihe0832_dialog_hint));
        editText.setTextSize(10.0f);
        editText.setTextColor(context.getResources().getColor(R.color.com_bihe0832_dialog_bg));
        editText.setHintTextColor(context.getResources().getColor(R.color.com_bihe0832_dialog_split));
        editText.setHint((CharSequence)hint);
        if (!TextUtils.isEmpty((CharSequence)defaultValue)) {
            editText.requestFocus();
            editText.setText((CharSequence)defaultValue);
            editText.selectAll();
        }
        dialog.addViewToContent((View)editText);
        dialog.setOnClickBottomListener(new OnDialogListener(){

            @Override
            public void onPositiveClick() {
                try {
                    listener.onPositiveClick(editText.getText().toString());
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onNegativeClick() {
                try {
                    listener.onNegativeClick(editText.getText().toString());
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onCancel() {
                try {
                    listener.onCancel(editText.getText().toString());
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dialog.show();
    }
}

