/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.dialog;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.bihe0832.android.lib.ui.dialog.CommonDialog;
import com.bihe0832.android.lib.ui.dialog.R;
import com.bihe0832.android.lib.utils.os.DisplayUtil;
import java.util.ArrayList;
import java.util.List;

public class RadioDialog
extends CommonDialog {
    private RadioGroup mRadioGroup = null;
    private List<String> mDataList = new ArrayList<String>();
    private OnSelectedListener mOnSelectedListener = null;
    private int mCheckedIndex = -1;

    public RadioDialog(Context context) {
        super(context);
    }

    public RadioDialog(Context context, int themeResId) {
        super(context, themeResId);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mRadioGroup = new RadioGroup(this.getContext());
        RadioGroup.LayoutParams radioGroupLayoutParams = new RadioGroup.LayoutParams(-1, -2);
        int margin = DisplayUtil.dip2px((Context)this.getContext(), (float)16.0f);
        radioGroupLayoutParams.setMargins(0, margin / 2, 0, margin / 2);
        this.mRadioGroup.setLayoutParams((ViewGroup.LayoutParams)radioGroupLayoutParams);
        this.addViewToContent((View)this.mRadioGroup);
        this.initView();
    }

    @Override
    protected void refreshView() {
        super.refreshView();
        if (this.mCheckedIndex < this.mDataList.size() && null != this.mRadioGroup) {
            this.mRadioGroup.check(this.mCheckedIndex);
        }
    }

    public void initView() {
        if (null == this.mDataList || this.mDataList.isEmpty() || null == this.mRadioGroup) {
            return;
        }
        this.mRadioGroup.removeAllViews();
        int i = 0;
        while (i < this.mDataList.size()) {
            RadioButton radioButton = new RadioButton(this.getContext());
            radioButton.setId(i);
            radioButton.setButtonDrawable(this.getContext().getResources().getDrawable(R.drawable.com_bihe0832_common_radio_selctor));
            radioButton.setPadding(DisplayUtil.dip2px((Context)this.getContext(), (float)8.0f), DisplayUtil.dip2px((Context)this.getContext(), (float)8.0f), 0, DisplayUtil.dip2px((Context)this.getContext(), (float)8.0f));
            radioButton.setText((CharSequence)this.mDataList.get(i));
            radioButton.setTextSize(0, this.getContext().getResources().getDimension(R.dimen.com_bihe0832_dialog_content_text_size));
            radioButton.setTextColor(this.getContext().getResources().getColorStateList(R.drawable.com_bihe0832_common_select_color));
            final int index = i++;
            radioButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RadioDialog.this.mCheckedIndex = index;
                    if (null != RadioDialog.this.mOnSelectedListener) {
                        RadioDialog.this.mOnSelectedListener.onSelect(RadioDialog.this.mCheckedIndex);
                    }
                }
            });
            this.mRadioGroup.addView((View)radioButton);
        }
    }

    public int getCheckedIndex() {
        return this.mCheckedIndex;
    }

    public void setRadioData(List<String> data, int index, OnSelectedListener listener) {
        this.mDataList.clear();
        this.mCheckedIndex = index;
        this.mDataList.addAll(data);
        this.mOnSelectedListener = listener;
    }

    public static interface OnSelectedListener {
        public void onSelect(int var1);
    }
}

