/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.TextView;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.dialog.R;
import com.bihe0832.android.lib.ui.dialog.view.ProgressIndicatorView;

public class LoadingDialog
extends Dialog {
    public static final int LOADING_TYPE_CIRCLE = 1;
    public static final int LOADING_TYPE_DOTS = 2;
    private TextView titleTv;
    private String title;
    private boolean shouldCanceledOutside = true;
    private boolean isFullScreen = false;
    private int loadingType = 2;

    public LoadingDialog(Context context) {
        super(context, R.style.LoadingProgressDialog);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_bihe0832_dialog_loading);
        this.initView();
        this.refreshView();
    }

    private void refreshView() {
        if (this.loadingType == 1) {
            this.findViewById(R.id.circle_loading_bar).setVisibility(0);
            this.findViewById(R.id.dots_loading_bar).setVisibility(8);
        } else {
            this.findViewById(R.id.circle_loading_bar).setVisibility(8);
            this.findViewById(R.id.dots_loading_bar).setVisibility(0);
        }
        this.setCanceledOnTouchOutside(this.shouldCanceledOutside);
        if (this.titleTv != null) {
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.title = "\u52a0\u8f7d\u4e2d\u2026\u2026";
            }
            Spanned charSequence = TextFactoryUtils.getSpannedTextByHtml((String)this.title);
            this.titleTv.setText((CharSequence)charSequence);
        }
        if (this.isFullScreen) {
            ViewGroup.LayoutParams lp = this.findViewById(R.id.loading_main_layout).getLayoutParams();
            lp.width = -1;
            lp.height = -1;
            this.findViewById(R.id.loading_main_layout).setLayoutParams(lp);
        } else {
            this.findViewById(R.id.loading_main_layout).setBackgroundResource(R.drawable.com_bihe0832_loading_progress_bg);
        }
    }

    private void showAction() {
        if (!this.isShowing()) {
            super.show();
        }
        this.refreshView();
    }

    public void showOnUIThread() {
        ThreadManager.getInstance().runOnUIThread(new Runnable(){

            @Override
            public void run() {
                LoadingDialog.this.show();
            }
        });
    }

    public void show() {
        this.showAction();
    }

    public void show(String msg) {
        this.title = msg;
        this.show();
    }

    public void showOnUIThread(String msg) {
        this.title = msg;
        this.showOnUIThread();
    }

    private void initView() {
        this.titleTv = (TextView)this.findViewById(R.id.loading_label);
        ((ProgressIndicatorView)this.findViewById(R.id.dots_loading_bar)).setAnimationNum(3);
    }

    public LoadingDialog setHtmlTitle(String content) {
        this.title = content;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public LoadingDialog setCanCanceled(boolean flag) {
        this.shouldCanceledOutside = flag;
        return this;
    }

    public LoadingDialog setIsFullScreen(boolean flag) {
        this.isFullScreen = flag;
        return this;
    }

    public void setLoadingType(int loadingType) {
        this.loadingType = loadingType;
    }
}

