/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.ui.dialog.OnDialogListener;
import com.bihe0832.android.lib.ui.dialog.R;
import com.bihe0832.android.lib.utils.os.DisplayUtil;
import java.text.NumberFormat;

public class DownloadProgressDialog
extends Dialog {
    private TextView mTitleView;
    private TextView mContentView;
    private ProgressBar mProgress;
    private TextView mProgressPercent;
    private TextView mProgressNumber;
    private TextView mNegativeButton;
    private View mButtonLine;
    private TextView mPositiveButton;
    private String mTitleString;
    private String mContentString;
    private long mAPKSize;
    private long mCurrentSize = 0L;
    private boolean shouldCanceledOutside = false;
    private boolean shouldCanceled = true;
    private NumberFormat mProgressPercentFormat = NumberFormat.getPercentInstance();
    private int maxLine = -1;
    private static final int MAX_LINES_LANDSCAPE = 3;
    private static final int MAX_LINES_PORTRAIT = 8;
    private CharSequence mNegativeButtonString;
    private CharSequence mPositiveButtonString;
    public OnDialogListener mClickBottomListener;

    public DownloadProgressDialog(Context context) {
        super(context, R.style.CommonProgressDialogStyle);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_bihe0832_common_progress_dialog);
        this.initView();
        this.refreshView();
        this.initEvent();
    }

    private void initEvent() {
        this.mPositiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DownloadProgressDialog.this.mClickBottomListener != null) {
                    DownloadProgressDialog.this.mClickBottomListener.onPositiveClick();
                }
            }
        });
        this.mNegativeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DownloadProgressDialog.this.mClickBottomListener != null) {
                    DownloadProgressDialog.this.mClickBottomListener.onNegativeClick();
                }
            }
        });
    }

    private void refreshView() {
        this.setCanceledOnTouchOutside(this.shouldCanceledOutside);
        this.setCancelable(this.shouldCanceled);
        int screenWidth = DisplayUtil.getScreenWidth((Context)this.getContext());
        int screenheight = DisplayUtil.getScreenHeight((Context)this.getContext());
        if (this.mTitleView != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mTitleString)) {
                this.mTitleView.setText((CharSequence)this.mTitleString);
                this.mTitleView.setVisibility(0);
            } else {
                this.mTitleView.setVisibility(8);
            }
        }
        if (null != this.mContentView) {
            if (!TextUtils.isEmpty((CharSequence)this.mContentString)) {
                if (!TextUtils.isEmpty((CharSequence)this.mContentString)) {
                    Spanned charSequence = TextFactoryUtils.getSpannedTextByHtml((String)this.mContentString);
                    this.mContentView.setText((CharSequence)charSequence);
                }
                this.mContentView.setVisibility(0);
                this.mContentView.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
                if (screenWidth > screenheight) {
                    if (this.maxLine > 0) {
                        if (this.maxLine > 3) {
                            this.mContentView.setMaxLines(3);
                        } else {
                            this.mContentView.setMaxLines(this.maxLine);
                        }
                    } else {
                        this.mContentView.setMaxLines(3);
                    }
                } else if (this.maxLine > 0) {
                    if (this.maxLine > 8) {
                        this.mContentView.setMaxLines(8);
                    } else {
                        this.mContentView.setMaxLines(this.maxLine);
                    }
                } else {
                    this.mContentView.setMaxLines(8);
                }
            } else {
                this.mContentView.setVisibility(8);
            }
        }
        if (null != this.mProgressNumber) {
            String process = FileUtils.INSTANCE.getFileLength(this.mCurrentSize) + "/";
            process = this.mAPKSize < 1L ? process + "0" : process + FileUtils.INSTANCE.getFileLength(this.mAPKSize);
            this.mProgressNumber.setText((CharSequence)process);
        }
        if (null != this.mProgressPercent) {
            this.mProgressPercent.setVisibility(0);
            if (this.mProgressPercentFormat != null) {
                if (this.mAPKSize >= 1L) {
                    double percent = (double)this.mCurrentSize * 1.0 / (double)this.mAPKSize;
                    SpannableString tmp = new SpannableString((CharSequence)this.mProgressPercentFormat.format(percent));
                    tmp.setSpan((Object)new StyleSpan(1), 0, tmp.length(), 33);
                    this.mProgressPercent.setText((CharSequence)tmp);
                }
            } else {
                this.mProgressPercent.setText((CharSequence)"");
            }
        }
        if (null != this.mProgress) {
            this.mProgress.setProgress(0);
            if (this.mAPKSize < 1L) {
                this.mProgress.setProgress(100);
            } else {
                this.mProgress.setProgress((int)(this.mCurrentSize * 100L / this.mAPKSize));
            }
        }
        if (this.mPositiveButton != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mPositiveButtonString)) {
                this.mPositiveButton.setText(this.mPositiveButtonString);
            } else {
                this.mPositiveButton.setText((CharSequence)"\u786e\u5b9a");
            }
        }
        if (this.mNegativeButton != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mNegativeButtonString)) {
                this.mNegativeButton.setText(this.mNegativeButtonString);
                this.mNegativeButton.setVisibility(0);
                this.mButtonLine.setVisibility(0);
            } else {
                this.mNegativeButton.setVisibility(8);
                this.mButtonLine.setVisibility(8);
            }
        }
    }

    public void show() {
        super.show();
        this.refreshView();
    }

    private void initView() {
        this.mTitleView = (TextView)this.findViewById(R.id.update_title);
        this.mContentView = (TextView)this.findViewById(R.id.update_message);
        this.mProgress = (ProgressBar)this.findViewById(R.id.update_progress_bar);
        this.mProgress.setMax(100);
        this.mProgressNumber = (TextView)this.findViewById(R.id.update_progress_number);
        this.mProgressPercent = (TextView)this.findViewById(R.id.update_progress_percent);
        this.mNegativeButton = (TextView)this.findViewById(R.id.update_progress_cancle);
        this.mPositiveButton = (TextView)this.findViewById(R.id.update_progress_positive);
        this.mButtonLine = this.findViewById(R.id.update_progress_column_line);
    }

    public DownloadProgressDialog setOnClickListener(OnDialogListener bottomListener) {
        this.mClickBottomListener = bottomListener;
        return this;
    }

    public DownloadProgressDialog setMessage(String message) {
        this.mContentString = message;
        return this;
    }

    public DownloadProgressDialog setTitle(String title) {
        this.mTitleString = title;
        return this;
    }

    public DownloadProgressDialog setPositive(String positive) {
        this.mPositiveButtonString = positive;
        return this;
    }

    public DownloadProgressDialog setNegative(String negative) {
        this.mNegativeButtonString = negative;
        return this;
    }

    public DownloadProgressDialog setContentMaxLine(int maxLine) {
        this.maxLine = maxLine;
        return this;
    }

    public DownloadProgressDialog setShouldCanceled(boolean flag) {
        this.shouldCanceled = flag;
        return this;
    }

    public void setCurrentSize(long value) {
        this.mCurrentSize = value;
        this.refreshView();
    }

    public void setAPKSize(long max) {
        this.mAPKSize = max;
        this.refreshView();
    }
}

