/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.menu;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.util.List;

public class PopupList {
    public static final int DEFAULT_NORMAL_TEXT_COLOR = -1;
    public static final int DEFAULT_PRESSED_TEXT_COLOR = -1;
    public static final float DEFAULT_TEXT_SIZE_DP = 14.0f;
    public static final float DEFAULT_TEXT_PADDING_LEFT_DP = 10.0f;
    public static final float DEFAULT_TEXT_PADDING_TOP_DP = 5.0f;
    public static final float DEFAULT_TEXT_PADDING_RIGHT_DP = 10.0f;
    public static final float DEFAULT_TEXT_PADDING_BOTTOM_DP = 5.0f;
    public static final int DEFAULT_NORMAL_BACKGROUND_COLOR = -872415232;
    public static final int DEFAULT_PRESSED_BACKGROUND_COLOR = -411601033;
    public static final int DEFAULT_BACKGROUND_RADIUS_DP = 8;
    public static final int DEFAULT_DIVIDER_COLOR = -1694498817;
    public static final float DEFAULT_DIVIDER_WIDTH_DP = 0.5f;
    public static final float DEFAULT_DIVIDER_HEIGHT_DP = 40.0f;
    private Context mContext;
    private PopupWindow mPopupWindow;
    private View mAnchorView;
    private View mAdapterView;
    private View mContextView;
    private View mIndicatorView;
    private List<String> mPopupItemList;
    private PopupListListener mPopupListListener;
    private int mContextPosition = 0;
    private float mOffsetX = 0.0f;
    private float mOffsetY = 0.0f;
    private StateListDrawable mLeftItemBackground;
    private StateListDrawable mRightItemBackground;
    private StateListDrawable mCornerItemBackground;
    private ColorStateList mTextColorStateList;
    private GradientDrawable mCornerBackground;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private int mPopupWindowWidth;
    private int mPopupWindowHeight;
    private int mNormalTextColor;
    private int mPressedTextColor;
    private float mTextSize;
    private int mTextPaddingLeft;
    private int mTextPaddingTop;
    private int mTextPaddingRight;
    private int mTextPaddingBottom;
    private int mNormalBackgroundColor;
    private int mPressedBackgroundColor;
    private int mBackgroundCornerRadius;
    private int mDividerColor;
    private int mDividerWidth;
    private int mDividerHeight;

    public PopupList(Context context) {
        this.mContext = context;
        this.mNormalTextColor = -1;
        this.mPressedTextColor = -1;
        this.mTextSize = this.dp2px(14.0f);
        this.mTextPaddingLeft = this.dp2px(10.0f);
        this.mTextPaddingTop = this.dp2px(5.0f);
        this.mTextPaddingRight = this.dp2px(10.0f);
        this.mTextPaddingBottom = this.dp2px(5.0f);
        this.mNormalBackgroundColor = -872415232;
        this.mPressedBackgroundColor = -411601033;
        this.mBackgroundCornerRadius = this.dp2px(8.0f);
        this.mDividerColor = -1694498817;
        this.mDividerWidth = this.dp2px(0.5f);
        this.mDividerHeight = this.dp2px(40.0f);
        this.mIndicatorView = this.getDefaultIndicatorView(this.mContext);
        this.refreshBackgroundOrRadiusStateList();
        this.refreshTextColorStateList(this.mPressedTextColor, this.mNormalTextColor);
    }

    public void show(View anchorView, List<String> popupItemList, PopupListListener popupListListener) {
        this.mAnchorView = anchorView;
        this.mPopupItemList = popupItemList;
        this.mPopupListListener = popupListListener;
        this.mPopupWindow = null;
        this.mOffsetX = anchorView.getX() + (float)(anchorView.getWidth() / 2);
        this.mOffsetY = 0.0f;
        if (this.mPopupListListener != null && !this.mPopupListListener.onPopupListShow(anchorView, anchorView, 0)) {
            return;
        }
        this.mContextView = anchorView;
        this.mContextPosition = 0;
        this.showPopupListWindow(this.mOffsetX, this.mOffsetY);
    }

    public void showPopupListWindow(View anchorView, int contextPosition, float rawX, float rawY, List<String> popupItemList, PopupListListener popupListListener) {
        this.mAnchorView = anchorView;
        this.mContextPosition = contextPosition;
        this.mPopupItemList = popupItemList;
        this.mPopupListListener = popupListListener;
        this.mPopupWindow = null;
        this.mContextView = anchorView;
        if (this.mPopupListListener != null && !this.mPopupListListener.onPopupListShow(this.mContextView, this.mContextView, contextPosition)) {
            return;
        }
        this.showPopupListWindow(rawX, rawY);
    }

    private void showPopupListWindow(float offsetX, float offsetY) {
        if (this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing()) {
            return;
        }
        if (this.mPopupWindow == null || this.mPopupListListener instanceof AdapterPopupListListener) {
            LinearLayout contentView = new LinearLayout(this.mContext);
            contentView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            contentView.setOrientation(1);
            LinearLayout popupListContainer = new LinearLayout(this.mContext);
            popupListContainer.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            popupListContainer.setOrientation(0);
            popupListContainer.setBackgroundDrawable((Drawable)this.mCornerBackground);
            contentView.addView((View)popupListContainer);
            if (this.mIndicatorView != null) {
                LinearLayout.LayoutParams layoutParams = this.mIndicatorView.getLayoutParams() == null ? new LinearLayout.LayoutParams(-2, -2) : (LinearLayout.LayoutParams)this.mIndicatorView.getLayoutParams();
                layoutParams.gravity = 17;
                this.mIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                ViewParent viewParent = this.mIndicatorView.getParent();
                if (viewParent instanceof ViewGroup) {
                    ((ViewGroup)viewParent).removeView(this.mIndicatorView);
                }
                contentView.addView(this.mIndicatorView);
            }
            for (int i = 0; i < this.mPopupItemList.size(); ++i) {
                TextView textView = new TextView(this.mContext);
                LinearLayout.LayoutParams textlayoutParams = new LinearLayout.LayoutParams(-2, this.mDividerHeight);
                textlayoutParams.gravity = 17;
                textView.setLayoutParams((ViewGroup.LayoutParams)textlayoutParams);
                textView.setTextColor(this.mTextColorStateList);
                textView.setGravity(16);
                textView.setTextSize(0, this.mTextSize);
                textView.setPadding(this.mTextPaddingLeft, this.mTextPaddingTop, this.mTextPaddingRight, this.mTextPaddingBottom);
                textView.setClickable(true);
                final int finalI = i;
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (PopupList.this.mPopupListListener != null) {
                            PopupList.this.mPopupListListener.onPopupListClick(PopupList.this.mContextView, PopupList.this.mContextPosition, finalI);
                            PopupList.this.hidePopupListWindow();
                        }
                    }
                });
                if (this.mPopupListListener instanceof AdapterPopupListListener) {
                    AdapterPopupListListener adapterPopupListListener = (AdapterPopupListListener)this.mPopupListListener;
                    textView.setText((CharSequence)adapterPopupListListener.formatText(this.mAdapterView, this.mContextView, this.mContextPosition, i, this.mPopupItemList.get(i)));
                } else {
                    textView.setText((CharSequence)this.mPopupItemList.get(i));
                }
                if (this.mPopupItemList.size() > 1 && i == 0) {
                    textView.setBackgroundDrawable((Drawable)this.mLeftItemBackground);
                } else if (this.mPopupItemList.size() > 1 && i == this.mPopupItemList.size() - 1) {
                    textView.setBackgroundDrawable((Drawable)this.mRightItemBackground);
                } else if (this.mPopupItemList.size() == 1) {
                    textView.setBackgroundDrawable((Drawable)this.mCornerItemBackground);
                } else {
                    textView.setBackgroundDrawable((Drawable)this.getCenterItemBackground());
                }
                popupListContainer.addView((View)textView);
                if (this.mPopupItemList.size() <= 1 || i == this.mPopupItemList.size() - 1) continue;
                View divider = new View(this.mContext);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.mDividerWidth, this.mDividerHeight);
                layoutParams.gravity = 17;
                divider.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                divider.setBackgroundColor(this.mDividerColor);
                popupListContainer.addView(divider);
            }
            if (this.mPopupWindowWidth == 0) {
                this.mPopupWindowWidth = this.getViewWidth((View)popupListContainer);
            }
            if (this.mIndicatorView != null && this.mIndicatorWidth == 0) {
                this.mIndicatorWidth = this.mIndicatorView.getLayoutParams().width > 0 ? this.mIndicatorView.getLayoutParams().width : this.getViewWidth(this.mIndicatorView);
            }
            if (this.mIndicatorView != null && this.mIndicatorHeight == 0) {
                this.mIndicatorHeight = this.mIndicatorView.getLayoutParams().height > 0 ? this.mIndicatorView.getLayoutParams().height : this.getViewHeight(this.mIndicatorView);
            }
            if (this.mPopupWindowHeight == 0) {
                this.mPopupWindowHeight = this.getViewHeight((View)popupListContainer) + this.mIndicatorHeight;
            }
            this.mPopupWindow = new PopupWindow((View)contentView, this.mPopupWindowWidth, this.mPopupWindowHeight, true);
            this.mPopupWindow.setTouchable(true);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        }
        int[] location = new int[2];
        this.mAnchorView.getLocationInWindow(location);
        if (this.mIndicatorView != null) {
            float leftTranslationLimit = (float)this.mIndicatorWidth / 2.0f + (float)this.mBackgroundCornerRadius - (float)this.mPopupWindowWidth / 2.0f;
            float rightTranslationLimit = (float)this.mPopupWindowWidth / 2.0f - (float)this.mIndicatorWidth / 2.0f - (float)this.mBackgroundCornerRadius;
            float maxWidth = this.mContext.getResources().getDisplayMetrics().widthPixels;
            if ((float)location[0] + offsetX < (float)this.mPopupWindowWidth / 2.0f) {
                this.mIndicatorView.setTranslationX(Math.max((float)location[0] + offsetX - (float)this.mPopupWindowWidth / 2.0f, leftTranslationLimit));
            } else if ((float)location[0] + offsetX + (float)this.mPopupWindowWidth / 2.0f > maxWidth) {
                this.mIndicatorView.setTranslationX(Math.min((float)location[0] + offsetX + (float)this.mPopupWindowWidth / 2.0f - maxWidth, rightTranslationLimit));
            } else {
                this.mIndicatorView.setTranslationX(0.0f);
            }
        }
        if (!this.mPopupWindow.isShowing()) {
            int x = (int)((float)location[0] + offsetX - (float)this.mPopupWindowWidth / 2.0f + 0.5f);
            int y = (int)((float)location[1] + offsetY - (float)this.mPopupWindowHeight + 0.5f);
            this.mPopupWindow.showAtLocation(this.mAnchorView, 0, x, y);
        }
    }

    private void refreshBackgroundOrRadiusStateList() {
        GradientDrawable leftItemPressedDrawable = new GradientDrawable();
        leftItemPressedDrawable.setColor(this.mPressedBackgroundColor);
        leftItemPressedDrawable.setCornerRadii(new float[]{this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, 0.0f, 0.0f, 0.0f, 0.0f, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius});
        GradientDrawable leftItemNormalDrawable = new GradientDrawable();
        leftItemNormalDrawable.setColor(0);
        leftItemNormalDrawable.setCornerRadii(new float[]{this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, 0.0f, 0.0f, 0.0f, 0.0f, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius});
        this.mLeftItemBackground = new StateListDrawable();
        this.mLeftItemBackground.addState(new int[]{16842919}, (Drawable)leftItemPressedDrawable);
        this.mLeftItemBackground.addState(new int[0], (Drawable)leftItemNormalDrawable);
        GradientDrawable rightItemPressedDrawable = new GradientDrawable();
        rightItemPressedDrawable.setColor(this.mPressedBackgroundColor);
        rightItemPressedDrawable.setCornerRadii(new float[]{0.0f, 0.0f, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, 0.0f, 0.0f});
        GradientDrawable rightItemNormalDrawable = new GradientDrawable();
        rightItemNormalDrawable.setColor(0);
        rightItemNormalDrawable.setCornerRadii(new float[]{0.0f, 0.0f, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, 0.0f, 0.0f});
        this.mRightItemBackground = new StateListDrawable();
        this.mRightItemBackground.addState(new int[]{16842919}, (Drawable)rightItemPressedDrawable);
        this.mRightItemBackground.addState(new int[0], (Drawable)rightItemNormalDrawable);
        GradientDrawable cornerItemPressedDrawable = new GradientDrawable();
        cornerItemPressedDrawable.setColor(this.mPressedBackgroundColor);
        cornerItemPressedDrawable.setCornerRadius((float)this.mBackgroundCornerRadius);
        GradientDrawable cornerItemNormalDrawable = new GradientDrawable();
        cornerItemNormalDrawable.setColor(0);
        cornerItemNormalDrawable.setCornerRadius((float)this.mBackgroundCornerRadius);
        this.mCornerItemBackground = new StateListDrawable();
        this.mCornerItemBackground.addState(new int[]{16842919}, (Drawable)cornerItemPressedDrawable);
        this.mCornerItemBackground.addState(new int[0], (Drawable)cornerItemNormalDrawable);
        this.mCornerBackground = new GradientDrawable();
        this.mCornerBackground.setColor(this.mNormalBackgroundColor);
        this.mCornerBackground.setCornerRadius((float)this.mBackgroundCornerRadius);
    }

    private StateListDrawable getCenterItemBackground() {
        StateListDrawable centerItemBackground = new StateListDrawable();
        GradientDrawable centerItemPressedDrawable = new GradientDrawable();
        centerItemPressedDrawable.setColor(this.mPressedBackgroundColor);
        GradientDrawable centerItemNormalDrawable = new GradientDrawable();
        centerItemNormalDrawable.setColor(0);
        centerItemBackground.addState(new int[]{16842919}, (Drawable)centerItemPressedDrawable);
        centerItemBackground.addState(new int[0], (Drawable)centerItemNormalDrawable);
        return centerItemBackground;
    }

    private void refreshTextColorStateList(int pressedTextColor, int normalTextColor) {
        int[][] states = new int[][]{{16842919}, new int[0]};
        int[] colors = new int[]{pressedTextColor, normalTextColor};
        this.mTextColorStateList = new ColorStateList((int[][])states, colors);
    }

    public void hidePopupListWindow() {
        if (this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing()) {
            return;
        }
        if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
    }

    public View getIndicatorView() {
        return this.mIndicatorView;
    }

    public void setIndicatorView(View indicatorView) {
        this.mIndicatorView = indicatorView;
    }

    public View getDefaultIndicatorView(Context context) {
        return this.getTriangleIndicatorView(context, this.dp2px(16.0f), this.dp2px(8.0f), -872415232);
    }

    public View getTriangleIndicatorView(Context context, final float widthPixel, final float heightPixel, final int color) {
        ImageView indicator = new ImageView(context);
        Drawable drawable2 = new Drawable(){

            public void draw(Canvas canvas) {
                Path path = new Path();
                Paint paint = new Paint();
                paint.setColor(color);
                paint.setStyle(Paint.Style.FILL);
                path.moveTo(0.0f, 0.0f);
                path.lineTo(widthPixel, 0.0f);
                path.lineTo(widthPixel / 2.0f, heightPixel);
                path.close();
                canvas.drawPath(path, paint);
            }

            public void setAlpha(int alpha) {
            }

            public void setColorFilter(ColorFilter colorFilter) {
            }

            public int getOpacity() {
                return -3;
            }

            public int getIntrinsicWidth() {
                return (int)widthPixel;
            }

            public int getIntrinsicHeight() {
                return (int)heightPixel;
            }
        };
        indicator.setImageDrawable(drawable2);
        return indicator;
    }

    public void setIndicatorSize(int widthPixel, int heightPixel) {
        this.mIndicatorWidth = widthPixel;
        this.mIndicatorHeight = heightPixel;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.mIndicatorWidth, this.mIndicatorHeight);
        layoutParams.gravity = 17;
        if (this.mIndicatorView != null) {
            this.mIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public int getNormalTextColor() {
        return this.mNormalTextColor;
    }

    public void setNormalTextColor(int normalTextColor) {
        this.mNormalTextColor = normalTextColor;
        this.refreshTextColorStateList(this.mPressedTextColor, this.mNormalTextColor);
    }

    public int getPressedTextColor() {
        return this.mPressedTextColor;
    }

    public void setPressedTextColor(int pressedTextColor) {
        this.mPressedTextColor = pressedTextColor;
        this.refreshTextColorStateList(this.mPressedTextColor, this.mNormalTextColor);
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float textSizePixel) {
        this.mTextSize = textSizePixel;
    }

    public int getTextPaddingLeft() {
        return this.mTextPaddingLeft;
    }

    public void setTextPaddingLeft(int textPaddingLeft) {
        this.mTextPaddingLeft = textPaddingLeft;
    }

    public int getTextPaddingTop() {
        return this.mTextPaddingTop;
    }

    public void setTextPaddingTop(int textPaddingTop) {
        this.mTextPaddingTop = textPaddingTop;
    }

    public int getTextPaddingRight() {
        return this.mTextPaddingRight;
    }

    public void setTextPaddingRight(int textPaddingRight) {
        this.mTextPaddingRight = textPaddingRight;
    }

    public int getTextPaddingBottom() {
        return this.mTextPaddingBottom;
    }

    public void setTextPaddingBottom(int textPaddingBottom) {
        this.mTextPaddingBottom = textPaddingBottom;
    }

    public void setTextPadding(int left, int top, int right, int bottom) {
        this.mTextPaddingLeft = left;
        this.mTextPaddingTop = top;
        this.mTextPaddingRight = right;
        this.mTextPaddingBottom = bottom;
    }

    public int getNormalBackgroundColor() {
        return this.mNormalBackgroundColor;
    }

    public void setNormalBackgroundColor(int normalBackgroundColor) {
        this.mNormalBackgroundColor = normalBackgroundColor;
        this.refreshBackgroundOrRadiusStateList();
    }

    public int getPressedBackgroundColor() {
        return this.mPressedBackgroundColor;
    }

    public void setPressedBackgroundColor(int pressedBackgroundColor) {
        this.mPressedBackgroundColor = pressedBackgroundColor;
        this.refreshBackgroundOrRadiusStateList();
    }

    public int getBackgroundCornerRadius() {
        return this.mBackgroundCornerRadius;
    }

    public void setBackgroundCornerRadius(int backgroundCornerRadiusPixel) {
        this.mBackgroundCornerRadius = backgroundCornerRadiusPixel;
        this.refreshBackgroundOrRadiusStateList();
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public void setDividerWidth(int dividerWidthPixel) {
        this.mDividerWidth = dividerWidthPixel;
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    public void setDividerHeight(int dividerHeightPixel) {
        this.mDividerHeight = dividerHeightPixel;
    }

    public Resources getResources() {
        if (this.mContext == null) {
            return Resources.getSystem();
        }
        return this.mContext.getResources();
    }

    private int getViewWidth(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return view.getMeasuredWidth();
    }

    private int getViewHeight(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return view.getMeasuredHeight();
    }

    public int dp2px(float value) {
        return (int)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public int sp2px(float value) {
        return (int)TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public static interface AdapterPopupListListener
    extends PopupListListener {
        public String formatText(View var1, View var2, int var3, int var4, String var5);
    }

    public static interface PopupListListener {
        public boolean onPopupListShow(View var1, View var2, int var3);

        public void onPopupListClick(View var1, int var2, int var3);
    }
}

