/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.ui.dialog.OnDialogListener;
import com.bihe0832.android.lib.ui.dialog.R;
import com.bihe0832.android.lib.ui.image.GlideExtKt;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

public class CommonDialog
extends Dialog {
    private TextView titleTv;
    private LinearLayout content_layout;
    private TextView contentTv;
    private Button negativeBn;
    private Button positiveBn;
    private ImageView imageView;
    private View columnLineView;
    private TextView feedback;
    private CheckBox nomoreCb;
    private boolean isShowCheckBox = false;
    private OnCheckedListener onCheckedListener;
    private int contentColor = -1;
    private boolean loadImgWithFade = true;
    private String message;
    private String title;
    private String content;
    private CharSequence charSequenceContent = null;
    private MovementMethod movement = null;
    private String feedbackContent;
    private String positiveString;
    private String negativeString;
    private String imageUrl = null;
    private boolean shouldCanceledOutside = false;
    private int imageContentResId = -1;
    private int imageResId = -1;
    private int maxLine = -1;
    private static final int MAX_LINES_LANDSCAPE = 3;
    private static final int MAX_LINES_PORTRAIT = 8;
    private View extraView;
    private boolean isSingle = false;
    protected OnDialogListener onClickBottomListener;

    public CommonDialog(Context context) {
        super(context, R.style.CommonDialog);
    }

    public CommonDialog(Context context, int themeResId) {
        super(context, themeResId);
    }

    protected int getLayoutID() {
        return R.layout.com_bihe0832_commonm_dialog_layout;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayoutID());
        this.initView();
        this.refreshView();
        this.initEvent();
    }

    private void initEvent() {
        if (this.positiveBn != null) {
            this.positiveBn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonDialog.this.onClickBottomListener != null) {
                        CommonDialog.this.onClickBottomListener.onPositiveClick();
                    }
                }
            });
        }
        if (this.negativeBn != null) {
            this.negativeBn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonDialog.this.onClickBottomListener != null) {
                        CommonDialog.this.onClickBottomListener.onNegativeClick();
                    }
                }
            });
        }
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (CommonDialog.this.onClickBottomListener != null) {
                    CommonDialog.this.onClickBottomListener.onCancel();
                }
            }
        });
    }

    protected void refreshView() {
        this.setCanceledOnTouchOutside(this.shouldCanceledOutside);
        this.setCancelable(this.shouldCanceledOutside);
        int screenWidth = DisplayUtil.getScreenWidth((Context)this.getContext());
        int screenheight = DisplayUtil.getScreenHeight((Context)this.getContext());
        if (this.titleTv != null) {
            if (!TextUtils.isEmpty((CharSequence)this.title)) {
                this.titleTv.setText((CharSequence)this.title);
                this.titleTv.setVisibility(0);
            } else {
                this.titleTv.setVisibility(8);
            }
        }
        if (null != this.contentTv) {
            if (!TextUtils.isEmpty((CharSequence)this.content) || null != this.charSequenceContent) {
                if (!TextUtils.isEmpty((CharSequence)this.content)) {
                    this.contentTv.setText((CharSequence)this.content);
                } else if (null != this.charSequenceContent) {
                    this.contentTv.setText(this.charSequenceContent);
                }
                if (null != this.movement) {
                    this.contentTv.setMovementMethod(this.movement);
                } else {
                    this.contentTv.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
                }
                this.contentTv.setVisibility(0);
                if (this.contentColor != -1) {
                    this.contentTv.setTextColor(this.contentColor);
                }
                if (screenWidth > screenheight) {
                    if (this.maxLine > 0) {
                        if (this.maxLine > 3) {
                            this.contentTv.setMaxLines(3);
                        } else {
                            this.contentTv.setMaxLines(this.maxLine);
                        }
                    } else {
                        this.contentTv.setMaxLines(3);
                    }
                } else if (this.maxLine > 0) {
                    if (this.maxLine > 8) {
                        this.contentTv.setMaxLines(8);
                    } else {
                        this.contentTv.setMaxLines(this.maxLine);
                    }
                } else {
                    this.contentTv.setMaxLines(8);
                }
            } else {
                this.contentTv.setVisibility(8);
            }
        }
        if (this.extraView != null && this.content_layout != null && this.extraView.getParent() == null) {
            this.content_layout.addView(this.extraView);
        }
        if (this.positiveBn != null) {
            if (!TextUtils.isEmpty((CharSequence)this.positiveString)) {
                this.positiveBn.setText((CharSequence)this.positiveString);
            } else {
                this.positiveBn.setText((CharSequence)"\u786e\u5b9a");
            }
        }
        if (this.negativeBn != null && !TextUtils.isEmpty((CharSequence)this.negativeString)) {
            this.negativeBn.setText((CharSequence)this.negativeString);
        }
        if (this.imageView != null) {
            if (this.imageContentResId != -1) {
                this.imageView.setImageResource(this.imageContentResId);
                this.imageView.setVisibility(0);
            } else if (this.imageUrl != null) {
                GlideExtKt.loadCenterCropImage((ImageView)this.imageView, (String)this.imageUrl, (boolean)this.loadImgWithFade, (int)-16777216, (int)-1);
                this.imageView.setVisibility(0);
            } else {
                this.imageView.setVisibility(8);
            }
            if (this.imageView != null && this.imageView.getVisibility() == 0) {
                ViewGroup.LayoutParams para = this.imageView.getLayoutParams();
                para.height = para.width > 0 ? para.width * 1920 / 1080 : (screenWidth - DisplayUtil.dip2px((Context)this.getContext(), (float)88.0f)) * 1080 / 1920;
                this.imageView.setLayoutParams(para);
                if (screenWidth > screenheight) {
                    para.height = (int)((double)screenheight * 0.3);
                }
            }
        }
        if (this.feedback != null) {
            if (!TextUtils.isEmpty((CharSequence)this.feedbackContent)) {
                this.feedback.setText((CharSequence)this.feedbackContent);
                this.feedback.setVisibility(0);
            } else {
                this.feedback.setVisibility(8);
            }
        }
        if (this.columnLineView != null && this.negativeBn != null) {
            if (this.isSingle || TextUtils.isEmpty((CharSequence)this.negativeString)) {
                this.columnLineView.setVisibility(8);
                this.negativeBn.setVisibility(8);
            } else {
                this.negativeBn.setVisibility(0);
                this.columnLineView.setVisibility(0);
            }
        }
        if (this.isShowCheckBox) {
            this.nomoreCb.setVisibility(0);
            this.nomoreCb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (CommonDialog.this.onCheckedListener != null) {
                        CommonDialog.this.onCheckedListener.onChecked(isChecked);
                    }
                }
            });
        }
    }

    public void show() {
        if (!this.isShowing()) {
            super.show();
        }
        this.refreshView();
    }

    private void initView() {
        this.negativeBn = (Button)this.findViewById(R.id.negtive);
        this.positiveBn = (Button)this.findViewById(R.id.positive);
        this.titleTv = (TextView)this.findViewById(R.id.title);
        this.content_layout = (LinearLayout)this.findViewById(R.id.content_layout);
        this.contentTv = (TextView)this.findViewById(R.id.content);
        this.columnLineView = this.findViewById(R.id.column_line);
        this.imageView = (ImageView)this.findViewById(R.id.content_img);
        this.feedback = (TextView)this.findViewById(R.id.feedback);
        this.nomoreCb = (CheckBox)this.findViewById(R.id.nomore_cb);
    }

    public CommonDialog setOnClickBottomListener(OnDialogListener clickBottomListener) {
        this.onClickBottomListener = clickBottomListener;
        return this;
    }

    public CommonDialog setOnCheckedListener(OnCheckedListener onCheckedListener) {
        this.onCheckedListener = onCheckedListener;
        return this;
    }

    public CommonDialog setIsShowCheckBox(boolean isShowCheckBox) {
        this.isShowCheckBox = isShowCheckBox;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommonDialog setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public CommonDialog setContent(String content) {
        this.content = content;
        return this;
    }

    public CommonDialog setContentTextColor(int colorRes) {
        this.contentColor = colorRes;
        return this;
    }

    public CommonDialog setHtmlContent(String content) {
        this.charSequenceContent = TextFactoryUtils.getSpannedTextByHtml((String)content);
        return this;
    }

    public CommonDialog setHtmlContent(CharSequence content, MovementMethod method) {
        this.charSequenceContent = content;
        this.movement = method;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public CommonDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getPositive() {
        return this.positiveString;
    }

    public void addViewToContent(View view) {
        this.extraView = view;
    }

    public CommonDialog setPositive(String positive) {
        this.positiveString = positive;
        return this;
    }

    public String getNegative() {
        return this.negativeString;
    }

    @Deprecated
    public void setCancelable(boolean flag) {
        super.setCancelable(flag);
        this.shouldCanceledOutside = flag;
    }

    @Deprecated
    public void setCanceledOnTouchOutside(boolean flag) {
        super.setCanceledOnTouchOutside(flag);
        this.shouldCanceledOutside = flag;
    }

    public CommonDialog setShouldCanceled(boolean flag) {
        this.shouldCanceledOutside = flag;
        return this;
    }

    public CommonDialog setNegative(String negtive) {
        this.negativeString = negtive;
        return this;
    }

    public int getImageResId() {
        return this.imageResId;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public CommonDialog setSingle(boolean single) {
        this.isSingle = single;
        return this;
    }

    public CommonDialog setImageResId(int imageResId) {
        this.imageResId = imageResId;
        return this;
    }

    public int getImageContentResId() {
        return this.imageContentResId;
    }

    public CommonDialog setImageContentResId(int imageContentResId) {
        this.imageContentResId = imageContentResId;
        return this;
    }

    public CommonDialog setFeedBackContent(String feedbackContent) {
        this.feedbackContent = feedbackContent;
        return this;
    }

    public CommonDialog setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public CommonDialog setLoadImgWithFade(boolean needFade) {
        this.loadImgWithFade = needFade;
        return this;
    }

    public CommonDialog setContentMaxLine(int maxLine) {
        this.maxLine = maxLine;
        return this;
    }

    public static interface OnCheckedListener {
        public void onChecked(boolean var1);
    }
}

