/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.NonNull;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.IpUtils;
import com.bihe0832.android.lib.network.NetworkUtil;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class WifiUtil {
    public static final int SECURITY_NONE = 0;
    public static final int SECURITY_WEP = 1;
    public static final int SECURITY_PSK = 2;
    public static final int SECURITY_EAP = 3;
    public static final String VOID_SIGNAL_INFO = "-1_-1_-1_-1";
    private static final int SOCKET_TIMEOUT = 5;
    public static final int IO_BUFFER_SIZE = 8192;
    public static final String INVALID_BSSID = "02:00:00:00:00:00";
    private static final String INVALID_MAC = "00:00:00:00:00:00";
    private static final String MAC_RE = "^%s\\s+0x1\\s+0x[2|6]\\s+([:0-9a-fA-F]+)\\s+\\*\\s+\\w+$";
    private static final int BUF = 8192;
    private static int sLastTerminalCount = -1;
    private static Set<String> ipList = new HashSet<String>();

    public static int getSecurity(WifiConfiguration config) {
        if (config.allowedKeyManagement.get(1)) {
            return 2;
        }
        if (config.allowedKeyManagement.get(2) || config.allowedKeyManagement.get(3)) {
            return 3;
        }
        return config.wepKeys[0] != null ? 1 : 0;
    }

    public static String getWifiSSIDBasedNetworkId(Context context) {
        if (context == null) {
            return "";
        }
        try {
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null) {
                WifiInfo info = wm.getConnectionInfo();
                if (null == info) {
                    return "";
                }
                ZLog.d((String)("getWifiSSIDBasedNetworkId WifiInfo:" + info.toString()));
                int netWorkId = info.getNetworkId();
                if (-1 == netWorkId) {
                    return "";
                }
                List wifiConfigurationList = wm.getConfiguredNetworks();
                if (null == wifiConfigurationList || wifiConfigurationList.size() <= 0) {
                    return "";
                }
                for (WifiConfiguration wifiConfiguration : wifiConfigurationList) {
                    if (wifiConfiguration.networkId != netWorkId) continue;
                    ZLog.d((String)("getWifiSSIDBasedNetworkId wifiConfiguration:" + wifiConfiguration.toString()));
                    return wifiConfiguration.SSID;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static int getWifiSignalLevel(Context context) {
        int strength = -1;
        if (context == null) {
            return strength;
        }
        try {
            WifiInfo info;
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null && (info = wm.getConnectionInfo()).getBSSID() != null) {
                strength = WifiManager.calculateSignalLevel((int)info.getRssi(), (int)5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strength;
    }

    public static RouterInfo getRouterInfo(Context context) {
        if (context == null) {
            ZLog.d((String)"getRouterInfo, context is null");
            return new RouterInfo(-2);
        }
        if (NetworkUtil.getNetworkState(context) != 4) {
            ZLog.d((String)"getRouterInfo, current net is non-wifi");
            return new RouterInfo(-3);
        }
        WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wm == null) {
            ZLog.d((String)"getRouterInfo, wifiManager is null");
            return new RouterInfo(-4);
        }
        DhcpInfo dhcpInfo = wm.getDhcpInfo();
        int ipNetSeq = dhcpInfo.ipAddress;
        int netmaskNetSeq = dhcpInfo.netmask;
        try {
            InetAddress inetAddress = InetAddress.getByName(IpUtils.ipn2s(dhcpInfo.ipAddress));
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (networkInterface == null) {
                return new RouterInfo(-6);
            }
            for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                short netPrefix = address.getNetworkPrefixLength();
                ZLog.d((String)("netPrefix: " + netPrefix));
                if (netPrefix >= 32) continue;
                netmaskNetSeq = (1 << netPrefix) - 1;
            }
        }
        catch (IOException inetAddress) {
            // empty catch block
        }
        HashMap<String, String> beaconData = new HashMap<String, String>();
        beaconData.put("current IP", IpUtils.ipn2s(ipNetSeq));
        beaconData.put("Netmask", IpUtils.ipn2s(netmaskNetSeq));
        beaconData.put("Gateway", IpUtils.ipn2s(dhcpInfo.gateway));
        if (netmaskNetSeq == 0) {
            netmaskNetSeq = 0xFFFFFF;
            ZLog.d((String)"getRouterInfo, netmaskNetSeq is null");
        }
        String ipStr = IpUtils.ipn2s(ipNetSeq);
        try {
            if (!IpUtils.isIpv4Address(ipStr)) {
                ZLog.d((String)"getRouterInfo, current host ip is not valid ipv4 address");
                return new RouterInfo(-5);
            }
        }
        catch (Exception e) {
            return new RouterInfo(-5);
        }
        int ipHostSeq = IpUtils.ips2h(ipStr);
        int netmaskHostSeq = IpUtils.ipn2h(netmaskNetSeq);
        int startIp = (ipHostSeq & netmaskHostSeq) + 1;
        int endIp = ipHostSeq & netmaskHostSeq | ~netmaskHostSeq;
        ZLog.d((String)("getRouterInfo, ip:" + ipStr + ", netmask:" + IpUtils.ipn2s(netmaskNetSeq)));
        ZLog.d((String)("getRouterInfo, startIp:" + IpUtils.iph2s(startIp) + ", endIp:" + IpUtils.iph2s(endIp)));
        int availableIps = 0;
        ipList = new HashSet<String>();
        ZLog.d((String)"Begin sending arp req");
        ExecutorService executor = Executors.newFixedThreadPool(50);
        for (int ip = startIp; ip < endIp && ++availableIps < 255; ++ip) {
            final String curIpStr = IpUtils.iph2s(ip);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    WifiUtil.addIpList(curIpStr);
                    ZLog.d((String)("getRouterInfo1: " + curIpStr));
                    WifiUtil.sendArpReqPacket(curIpStr, 1);
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ZLog.d((String)"End Sending arp req");
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        ZLog.d((String)"getLanMacAddr begin");
        Map<String, String> ipMacMap = WifiUtil.getLanMacAddr(ipList);
        ZLog.d((String)"getLanMacAddr end");
        int terminals = ipMacMap.size();
        if (terminals == 0) {
            terminals = 1;
        }
        ZLog.d((String)("getRouterInfo, availableIps:" + availableIps + ", terminals:" + terminals));
        return new RouterInfo(terminals, availableIps, ipMacMap);
    }

    private static synchronized void addIpList(String IP) {
        ipList.add(IP);
    }

    public static int getCachedTerminalCount() {
        return sLastTerminalCount;
    }

    private static void sendArpReqPacket(String ipStr) {
        try {
            InetAddress inetAddress = IpUtils.getDomainFirstAddr(ipStr);
            if (inetAddress != null) {
                inetAddress.isReachable(5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendArpReqPacket(String ipStr, int count) {
        try {
            InetAddress inetAddress = IpUtils.getDomainFirstAddr(ipStr);
            if (inetAddress != null) {
                for (int i = 0; i < count; ++i) {
                    inetAddress.isReachable(5);
                }
            }
        }
        catch (Exception e) {
            ZLog.d((String)("sendArpReqPacketerr" + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getLanMacAddr(Set<String> ipList) {
        HashMap<String, String> ipMacMap = new HashMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            if (null != ipList && ipList.size() != 0) {
                String line;
                if (BuildUtils.INSTANCE.getSDK_INT() > 28) {
                    Process proc = Runtime.getRuntime().exec("ip neigh show");
                    proc.waitFor();
                    bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                } else {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/net/arp"), Charset.forName("UTF-8")), 8192);
                }
                while ((line = bufferedReader.readLine()) != null) {
                    int dup;
                    String macIP;
                    String macAddr;
                    String ip;
                    ZLog.d((String)("getLanMacAddr1 lien:" + line));
                    String[] lineSegments = line.split(" +");
                    if (BuildUtils.INSTANCE.getSDK_INT() > 28) {
                        if (lineSegments.length <= 4) continue;
                        ip = lineSegments[0];
                        macAddr = lineSegments[4];
                        if (macAddr.equals(INVALID_MAC)) continue;
                        ZLog.d((String)("putLanMacAddr:" + ip + " " + macAddr));
                        macIP = (String)ipMacMap.get(macAddr);
                        if (macIP == null) {
                            ipMacMap.put(macAddr, ip + " 1");
                            continue;
                        }
                        dup = Integer.parseInt(macIP.split(" ")[1]);
                        ipMacMap.put(macAddr, macIP.split(" ")[0] + " " + String.valueOf(dup + 1));
                        continue;
                    }
                    if (lineSegments.length <= 4) continue;
                    ip = lineSegments[0];
                    macAddr = lineSegments[3];
                    if (macAddr.equals(INVALID_MAC)) continue;
                    ZLog.d((String)("putLanMacAddr:" + ip + " " + macAddr));
                    macIP = (String)ipMacMap.get(macAddr);
                    if (macIP == null) {
                        ipMacMap.put(macAddr, ip + " 1");
                        continue;
                    }
                    dup = Integer.parseInt(macIP.split(" ")[1]);
                    ipMacMap.put(macAddr, macIP.split(" ")[0] + " " + String.valueOf(dup + 1));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return ipMacMap;
    }

    public static String getWifiMacAddr(WifiManager wm) {
        if (null == wm) {
            return "";
        }
        DhcpInfo dhcpInfo = wm.getDhcpInfo();
        if (null == dhcpInfo) {
            return "";
        }
        String gateWayIp = IpUtils.ipn2s(dhcpInfo.gateway);
        ZLog.d((String)("getWifiMacAddr gateWayIp:" + gateWayIp));
        return WifiUtil.getLanMacAddr(gateWayIp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLanMacAddr(String wifiGateIp) {
        String ipMac;
        block13: {
            ipMac = "";
            BufferedReader bufferedReader = null;
            try {
                String line;
                if (wifiGateIp == null || wifiGateIp.length() == 0) break block13;
                bufferedReader = new BufferedReader(new FileReader("/proc/net/arp"), 8192);
                while ((line = bufferedReader.readLine()) != null) {
                    String linePattern;
                    Pattern pattern;
                    Matcher matcher;
                    if (line.contains(INVALID_MAC) || !line.contains(wifiGateIp) || !(matcher = (pattern = Pattern.compile(linePattern = String.format(MAC_RE, wifiGateIp.replace(".", "\\.")))).matcher(line)).matches()) continue;
                    String macAddr = matcher.group(1);
                    if (!macAddr.equals(INVALID_MAC)) {
                        ipMac = macAddr;
                    }
                    break;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return ipMac;
    }

    public static String getGatewayIp(Context context) {
        String ret = "0.0.0.0";
        if (context == null) {
            return ret;
        }
        try {
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null) {
                DhcpInfo dhcpInfo = wm.getDhcpInfo();
                ret = IpUtils.ipn2s(dhcpInfo.gateway);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getRouterMac(Context ctx) {
        String ret = "0";
        try {
            WifiInfo info;
            WifiManager wm;
            int netType = NetworkUtil.getNetworkState(ctx);
            if (netType == 4 && (wm = (WifiManager)ctx.getApplicationContext().getSystemService("wifi")) != null && (info = wm.getConnectionInfo()) != null) {
                ret = info.getBSSID();
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getRouterMac, exception:" + e.getMessage()));
        }
        return ret;
    }

    public static int getWifiLinkSpeed(Context ctx) {
        int linkSpeed = -1;
        try {
            WifiInfo info;
            WifiManager wm = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
            if (wm != null && (info = wm.getConnectionInfo()).getBSSID() != null) {
                linkSpeed = info.getLinkSpeed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkSpeed;
    }

    public static int getWifiSignalValue(Context ctx) {
        int signalValue = 1;
        try {
            WifiInfo info;
            WifiManager wm = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
            if (wm != null && (info = wm.getConnectionInfo()).getBSSID() != null) {
                signalValue = info.getRssi();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return signalValue;
    }

    public static int getWifiChannel(Context ctx) {
        if (NetworkUtil.getNetworkState(ctx) != 4) {
            return -1;
        }
        int curChannel = 0;
        try {
            WifiManager wm = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
            if (wm != null) {
                WifiInfo info = wm.getConnectionInfo();
                List scanResults = wm.getScanResults();
                if (scanResults == null || scanResults.size() <= 0) {
                    ZLog.d((String)"channel scanResult is 0, for location switch or permission denied");
                    return curChannel;
                }
                for (ScanResult result : scanResults) {
                    int channel = WifiUtil.getWifiChannelByFrequency(result.frequency);
                    if (!result.BSSID.equalsIgnoreCase(info.getBSSID())) continue;
                    curChannel = channel;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return curChannel;
    }

    public static RouterChannelInfo getRouterChannelInfo(WifiManager wifiManager) {
        RouterChannelInfo ret = new RouterChannelInfo();
        try {
            WifiInfo info = wifiManager.getConnectionInfo();
            List scanResults = wifiManager.getScanResults();
            HashMap<Integer, Integer> channelCount = new HashMap<Integer, Integer>();
            int curChannel = 0;
            for (ScanResult result : scanResults) {
                int channel = WifiUtil.getWifiChannelByFrequency(result.frequency);
                if (result.BSSID.equalsIgnoreCase(info.getBSSID())) {
                    curChannel = channel;
                }
                if (channelCount.containsKey(channel)) {
                    channelCount.put(channel, (Integer)channelCount.get(channel) + 1);
                    continue;
                }
                channelCount.put(channel, 1);
            }
            int curChannelApCount = 0;
            int neigbourChannelApCount = 0;
            int totalApCount = 0;
            for (Map.Entry entry : channelCount.entrySet()) {
                int chn = (Integer)entry.getKey();
                int num = (Integer)entry.getValue();
                totalApCount += num;
                if (curChannel == chn) {
                    curChannelApCount = num;
                    continue;
                }
                if (chn < curChannel - 2 || chn > curChannel + 2) continue;
                neigbourChannelApCount += num;
            }
            ret.curChannel = curChannel;
            ret.curChannelApCount = curChannelApCount;
            ret.neigbourChannelApCount = neigbourChannelApCount;
            ret.totalApCount = totalApCount;
        }
        catch (Exception e) {
            ZLog.e((String)e.toString());
        }
        return ret;
    }

    public static String getWifiSignal(Context ctx) {
        if (NetworkUtil.getNetworkState(ctx) != 4) {
            return VOID_SIGNAL_INFO;
        }
        try {
            WifiManager wm = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
            if (wm == null) {
                return VOID_SIGNAL_INFO;
            }
            WifiInfo info = wm.getConnectionInfo();
            int curChannel = 0;
            HashMap<Integer, Integer> channelCount = new HashMap<Integer, Integer>();
            List scanResults = wm.getScanResults();
            if (scanResults.size() <= 0) {
                ZLog.d((String)"scanResult is 0");
            }
            for (ScanResult result : scanResults) {
                int channel = WifiUtil.getWifiChannelByFrequency(result.frequency);
                if (result.BSSID.equalsIgnoreCase(info.getBSSID())) {
                    curChannel = channel;
                }
                if (channelCount.containsKey(channel)) {
                    channelCount.put(channel, (Integer)channelCount.get(channel) + 1);
                    continue;
                }
                channelCount.put(channel, 1);
            }
            int curCount = 0;
            int neibCount = 0;
            int sum = 0;
            for (Map.Entry entry : channelCount.entrySet()) {
                int chn = (Integer)entry.getKey();
                int num = (Integer)entry.getValue();
                sum += num;
                if (curChannel == chn) {
                    curCount = num;
                    continue;
                }
                if (chn < curChannel - 2 || chn > curChannel + 2) continue;
                neibCount += num;
            }
            return "" + curChannel + "_" + curCount + "_" + neibCount + "_" + sum;
        }
        catch (Exception e) {
            return VOID_SIGNAL_INFO;
        }
    }

    public static String getWifiSSID(Context context) {
        String ret = "";
        try {
            WifiInfo info;
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null && (info = wm.getConnectionInfo()) != null) {
                ret = info.getSSID();
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getRouterSSID, exception:" + e.getMessage()));
        }
        return ret;
    }

    public static String removeQuotes(String originStr) {
        return originStr.replace("\"", "");
    }

    public static String getWifiSSIDWithoutQuotes(Context context) {
        return WifiUtil.removeQuotes(WifiUtil.getWifiSSID(context));
    }

    public static int getWifiCode(Context context) {
        try {
            WifiManager wm;
            Context applicationContext = context.getApplicationContext();
            if (NetworkUtil.getNetworkState(context) == 4 && (wm = (WifiManager)applicationContext.getSystemService("wifi")) != null) {
                List wifiConfigList = wm.getConfiguredNetworks();
                for (WifiConfiguration wifiConfiguration : wifiConfigList) {
                    if (wifiConfiguration.status != 0) continue;
                    return WifiUtil.getSecurity(wifiConfiguration);
                }
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getWifiCode exception:" + e.getMessage()));
        }
        return -1;
    }

    public static String getBssid(@NonNull Context context) {
        String bssid = "";
        try {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            bssid = wifiInfo.getBSSID();
        }
        catch (Exception e) {
            ZLog.d((String)("getBssid failed, for " + e.toString()));
        }
        return bssid;
    }

    public static List<WifiChannelInfo> getWifiChannelInfos(@NonNull Context context) {
        List<WifiChannelInfo> wifiChannelInfos = Collections.emptyList();
        try {
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null) {
                List scanResults = wm.getScanResults();
                wifiChannelInfos = new ArrayList<WifiChannelInfo>(scanResults.size());
                for (ScanResult scanResult : scanResults) {
                    wifiChannelInfos.add(new WifiChannelInfo(scanResult.BSSID, scanResult.SSID, scanResult.level, scanResult.frequency));
                }
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getWifiChannelInfos failed, for " + e.toString()));
        }
        return wifiChannelInfos;
    }

    public static FrequencyInfo getWifiFrequencyInfo(Context ctx) {
        if (NetworkUtil.getNetworkState(ctx) != 4) {
            return FrequencyInfo.EMPTY;
        }
        try {
            WifiManager wm = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
            if (null == wm) {
                return FrequencyInfo.EMPTY;
            }
            WifiInfo info = wm.getConnectionInfo();
            List scanResults = wm.getScanResults();
            if (scanResults == null || scanResults.size() <= 0) {
                ZLog.d((String)"channel scanResult is 0, for location switch or permission denied");
                return FrequencyInfo.EMPTY;
            }
            for (ScanResult result : scanResults) {
                if (!result.BSSID.equalsIgnoreCase(info.getBSSID())) continue;
                boolean is24G = WifiUtil.is24GHz(result.frequency);
                boolean is5G = WifiUtil.is5GHz(result.frequency);
                return new FrequencyInfo(is24G, is5G);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FrequencyInfo.EMPTY;
    }

    public static boolean is24GHz(int freq) {
        return freq > 2400 && freq < 2500;
    }

    public static boolean is5GHz(int freq) {
        return freq > 4900 && freq < 5900;
    }

    public static int getCurrentRouterDevices(Context mContext) {
        if (mContext == null) {
            return -1;
        }
        WifiManager wm = (WifiManager)mContext.getApplicationContext().getSystemService("wifi");
        DhcpInfo dhcpInfo = wm.getDhcpInfo();
        int netipaddr = dhcpInfo.ipAddress;
        int netmask = dhcpInfo.netmask;
        if (netmask == 0) {
            netmask = 0xFFFFFF;
            ZLog.e((String)"netmask is null");
        }
        String str_ipaddr = IpUtils.ipn2s(netipaddr);
        try {
            if (!(InetAddress.getByName(str_ipaddr) instanceof Inet4Address)) {
                ZLog.e((String)"current host ip is not valid ipv4 address");
                return -1;
            }
        }
        catch (UnknownHostException e) {
            ZLog.w((String)("reverseIpMultiThread UnknownHostException error:" + e.getMessage()));
        }
        int hostIpAddr = IpUtils.ips2h(str_ipaddr);
        String str_netmask = IpUtils.ipn2s(netmask);
        int hostmask = IpUtils.ips2h(str_netmask);
        int startIp = (hostIpAddr & hostmask) + 1;
        int endIp = hostIpAddr & hostmask | ~hostmask;
        ZLog.d((String)("neighborPhones ipaddr:" + IpUtils.iph2s(hostIpAddr) + ",mask:" + IpUtils.iph2s(hostmask)));
        ZLog.d((String)("neighborPhones startIp:" + IpUtils.iph2s(startIp) + ",endIp:" + IpUtils.iph2s(endIp)));
        int count = 0;
        Vector<String> ipList = new Vector<String>();
        for (int i = startIp; i < endIp && ++count <= 255; ++i) {
            String tmpIp = IpUtils.iph2s(i);
            ipList.add(tmpIp);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        HashMap<String, String> ipmacMap = WifiUtil.getHardwareAddress(ipList);
        int total = ipmacMap != null ? ipmacMap.size() : 0;
        ZLog.d((String)("neighborPhones wifis:" + (endIp - startIp) + ",valid host:" + total + ",iplists:" + ipList.size() + ",count:" + count));
        return total;
    }

    public static int getWifiSharedTerminalNum(WifiManager wifiManager) {
        int total = -1;
        try {
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            int netipaddr = dhcpInfo.ipAddress;
            int netmask = dhcpInfo.netmask;
            if (netmask == 0) {
                netmask = 0xFFFFFF;
                ZLog.e((String)"netmask is null");
            }
            String str_ipaddr = IpUtils.ipn2s(netipaddr);
            try {
                if (!(InetAddress.getByName(str_ipaddr) instanceof Inet4Address)) {
                    ZLog.e((String)"current host ip is not valid ipv4 address");
                    return -5;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return -5;
            }
            int hostIpAddr = IpUtils.ips2h(str_ipaddr);
            String str_netmask = IpUtils.ipn2s(netmask);
            int hostmask = IpUtils.ips2h(str_netmask);
            int startIp = (hostIpAddr & hostmask) + 1;
            int endIp = hostIpAddr & hostmask | ~hostmask;
            ZLog.d((String)("neighborPhones ipaddr:" + IpUtils.iph2s(hostIpAddr) + ",mask:" + IpUtils.iph2s(hostmask)));
            ZLog.d((String)("neighborPhones startIp:" + IpUtils.iph2s(startIp) + ",endIp:" + IpUtils.iph2s(endIp)));
            int count = 0;
            Vector<String> ipList = new Vector<String>();
            for (int i = startIp; i < endIp && ++count <= 255; ++i) {
                String tmpIp = IpUtils.iph2s(i);
                ipList.add(tmpIp);
                WifiUtil.getLanMacAddr(tmpIp);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            HashMap<String, String> ipmacMap = WifiUtil.getHardwareAddress(ipList);
            int n = total = ipmacMap != null ? ipmacMap.size() : 0;
            if (total == 0) {
                total = 1;
            }
            ZLog.d((String)("neighborPhones wifis:" + (endIp - startIp) + ",valid host:" + total + ",iplists:" + ipList.size() + ",count:" + count));
        }
        catch (Exception e) {
            ZLog.e((String)e.getMessage());
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getHardwareAddress(Vector<String> ipList) {
        String hw = INVALID_MAC;
        HashMap<String, String> mapList = new HashMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            if (ipList != null && ipList.size() != 0) {
                String line;
                bufferedReader = new BufferedReader(new FileReader("/proc/net/arp"), 8192);
                block11: while ((line = bufferedReader.readLine()) != null) {
                    if (line.contains(INVALID_MAC)) continue;
                    boolean flag = false;
                    for (String ip : ipList) {
                        String ptrn;
                        Pattern pattern;
                        Matcher matcher;
                        if (!line.contains(ip) || !(matcher = (pattern = Pattern.compile(ptrn = String.format(MAC_RE, ip.replace(".", "\\.")))).matcher(line)).matches()) continue;
                        hw = matcher.group(1);
                        if (hw.equals(INVALID_MAC)) continue block11;
                        mapList.put(ip, hw);
                        flag = true;
                        continue block11;
                    }
                }
            }
        }
        catch (Exception e) {
            HashMap<String, String> hashMap = mapList;
            return hashMap;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {
                    ZLog.e((String)("getHardwareAddress, error:" + e.getMessage()));
                }
            }
        }
        return mapList;
    }

    public static int getWifiChannelByFrequency(int frequency) {
        int channel = -1;
        switch (frequency) {
            case 2412: {
                channel = 1;
                break;
            }
            case 2417: {
                channel = 2;
                break;
            }
            case 2422: {
                channel = 3;
                break;
            }
            case 2427: {
                channel = 4;
                break;
            }
            case 2432: {
                channel = 5;
                break;
            }
            case 2437: {
                channel = 6;
                break;
            }
            case 2442: {
                channel = 7;
                break;
            }
            case 2447: {
                channel = 8;
                break;
            }
            case 2452: {
                channel = 9;
                break;
            }
            case 2457: {
                channel = 10;
                break;
            }
            case 2462: {
                channel = 11;
                break;
            }
            case 2467: {
                channel = 12;
                break;
            }
            case 2472: {
                channel = 13;
                break;
            }
            case 2484: {
                channel = 14;
                break;
            }
            case 5180: {
                channel = 36;
                break;
            }
            case 5190: {
                channel = 38;
                break;
            }
            case 5200: {
                channel = 40;
                break;
            }
            case 5210: {
                channel = 42;
                break;
            }
            case 5220: {
                channel = 44;
                break;
            }
            case 5230: {
                channel = 46;
                break;
            }
            case 5240: {
                channel = 48;
                break;
            }
            case 5260: {
                channel = 52;
                break;
            }
            case 5280: {
                channel = 56;
                break;
            }
            case 5300: {
                channel = 60;
                break;
            }
            case 5320: {
                channel = 64;
                break;
            }
            case 5500: {
                channel = 100;
                break;
            }
            case 5520: {
                channel = 104;
                break;
            }
            case 5745: {
                channel = 149;
                break;
            }
            case 5765: {
                channel = 153;
                break;
            }
            case 5785: {
                channel = 157;
                break;
            }
            case 5805: {
                channel = 161;
                break;
            }
            case 5825: {
                channel = 165;
                break;
            }
        }
        return channel;
    }

    public static class WifiChannelInfo {
        public final String bssid;
        public final String ssid;
        public final int signalLevelDbm;
        public final int frequency;
        public final int channel;

        public WifiChannelInfo(String bssid, String ssid, int signalLevelDbm, int frequency) {
            this.bssid = bssid;
            this.ssid = ssid;
            this.signalLevelDbm = signalLevelDbm;
            this.frequency = frequency;
            this.channel = WifiUtil.getWifiChannelByFrequency(frequency);
        }

        public String toString() {
            return "WifiChannelInfo{bssid='" + this.bssid + '\'' + ", bssid='" + this.ssid + '\'' + ", signalLevelDbm=" + this.signalLevelDbm + ", frequency=" + this.frequency + ", channel=" + this.channel + '}';
        }
    }

    public static class RouterChannelInfo {
        public int curChannel = -1;
        public int curChannelApCount = -1;
        public int neigbourChannelApCount = -1;
        public int totalApCount = -1;
    }

    public static class FrequencyInfo {
        public static final FrequencyInfo EMPTY = new FrequencyInfo(false, false);
        public final boolean is24G;
        public final boolean is5G;

        public FrequencyInfo(boolean is24G, boolean is5G) {
            this.is24G = is24G;
            this.is5G = is5G;
        }
    }

    public static class RouterInfo {
        public final int terminals;
        public final int availableIps;
        public final Map<String, String> ipMacMap;

        public RouterInfo(int terminals, int availableIps, Map<String, String> ipMacMap) {
            this.terminals = terminals;
            this.availableIps = availableIps;
            this.ipMacMap = ipMacMap;
        }

        public RouterInfo(int terminals) {
            this(terminals, 0, null);
        }
    }
}

