/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.IpUtils;
import com.bihe0832.android.lib.network.NetworkUtil;
import com.bihe0832.android.lib.network.WifiManagerWrapper;
import com.bihe0832.android.lib.network.WifiUtil;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.thread.ThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0016*\u0001 \b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0006\u0010/\u001a\u00020-J\u000e\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020&J*\u00100\u001a\u00020-2\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020&2\b\b\u0002\u00105\u001a\u00020\nH\u0007J \u00106\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020&H\u0002J\u0006\u00109\u001a\u00020\u0004J\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017J\u0012\u0010;\u001a\u0004\u0018\u00010\u00182\u0006\u00101\u001a\u00020&H\u0002J\u0010\u0010<\u001a\u0004\u0018\u00010\u00182\u0006\u00102\u001a\u00020\u0004J\b\u0010=\u001a\u00020&H\u0003J\u0006\u0010>\u001a\u00020\u0004J\u0006\u0010?\u001a\u00020&J\u0006\u0010@\u001a\u00020&J\u0006\u0010A\u001a\u00020\u0004J\u000e\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020\u0010J\u000e\u0010D\u001a\u00020&2\u0006\u0010C\u001a\u00020\u0010J\u000e\u0010E\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0010J\b\u0010F\u001a\u00020&H\u0002J\u0006\u0010G\u001a\u00020&J\u0006\u0010H\u001a\u00020\u0004J\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017J\u0006\u0010J\u001a\u00020&J\u0006\u0010K\u001a\u00020LJ\b\u0010M\u001a\u0004\u0018\u00010\u0004J\b\u0010N\u001a\u0004\u0018\u00010\u0018J\u0012\u0010O\u001a\u00020\u00042\b\u0010P\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u0010Q\u001a\u00020\u0004J\u0016\u0010R\u001a\u00020-2\u0006\u0010C\u001a\u00020\u00102\u0006\u0010S\u001a\u00020\nJ&\u0010R\u001a\u00020-2\u0006\u0010C\u001a\u00020\u00102\u0006\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020\nJ\u0006\u0010V\u001a\u00020\nJ\u000e\u0010W\u001a\u00020\n2\u0006\u00102\u001a\u00020\u0004J\u0006\u0010X\u001a\u00020\nJ\u0006\u0010Y\u001a\u00020-J\u000e\u0010Z\u001a\u00020-2\u0006\u0010C\u001a\u00020\u0010J\u0010\u0010[\u001a\u00020-2\b\u0010\\\u001a\u0004\u0018\u00010\u0015J\u0006\u0010]\u001a\u00020-J\b\u0010^\u001a\u00020-H\u0002J\b\u0010_\u001a\u00020-H\u0002J\b\u0010`\u001a\u00020-H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R$\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006b"}, d2={"Lcom/bihe0832/android/lib/network/WifiManagerWrapper;", "", "()V", "DEFAULT_SSID", "", "getDEFAULT_SSID", "()Ljava/lang/String;", "TAG", "getTAG", "hasInit", "", "isDebug", "mCanScanWifi", "mConnectivityManager", "Landroid/net/ConnectivityManager;", "mContext", "Landroid/content/Context;", "mNotifyRSSI", "mWiFiNetworkInfo", "Landroid/net/NetworkInfo;", "mWifiChangeListener", "Lcom/bihe0832/android/lib/network/WifiManagerWrapper$OnWifiChangerListener;", "mWifiConfigurationList", "", "Landroid/net/wifi/WifiConfiguration;", "mWifiInfo", "Landroid/net/wifi/WifiInfo;", "mWifiList", "Landroid/net/wifi/ScanResult;", "mWifiManager", "Landroid/net/wifi/WifiManager;", "mWifiReceiver", "com/bihe0832/android/lib/network/WifiManagerWrapper$mWifiReceiver$2$1", "getMWifiReceiver", "()Lcom/bihe0832/android/lib/network/WifiManagerWrapper$mWifiReceiver$2$1;", "mWifiReceiver$delegate", "Lkotlin/Lazy;", "<set-?>", "", "wifiState", "getWifiState", "()I", "setWifiState$LibDeviceNetwork_release", "(I)V", "checkBaseInfoNotify", "", "checkConfiguredInfoNotify", "closeWifi", "connectWifi", "networkId", "ssid", "password", "type", "forceDeleteIfExist", "createWifiInfo", "Password", "Type", "getBSSID", "getConfigurationList", "getConfiguredByNetworkID", "getConfiguredBySSID", "getFrequency", "getInfoString", "getIpAddress", "getLinkSpeed", "getLinkSpeedUnits", "getMobileNetType", "context", "getNetType", "getNetTypeName", "getNetworkId", "getRssi", "getSSID", "getScanResultList", "getSignalLevel", "getSupplicantState", "Landroid/net/wifi/SupplicantState;", "getWiFiBssID", "getWifiConfiguration", "getWifiConfigurationString", "info", "getWifiMacAddr", "init", "debug", "notifyRSSI", "canScanWifi", "is5GHzWiFi", "isCurrent", "isWifiAvailable", "openWifi", "register", "setWifiChangedListener", "listener", "startScan", "updateBaseInfo", "updateConfiguredListInfo", "updateScanListInfo", "OnWifiChangerListener", "LibDeviceNetwork_release"})
public final class WifiManagerWrapper {
    @NotNull
    private static final String TAG = "WifiManager-> ";
    @NotNull
    private static final String DEFAULT_SSID = "<unknown ssid>";
    private static Context mContext;
    private static WifiManager mWifiManager;
    private static ConnectivityManager mConnectivityManager;
    private static final Lazy mWifiReceiver$delegate;
    private static OnWifiChangerListener mWifiChangeListener;
    private static boolean isDebug;
    private static boolean hasInit;
    private static boolean mNotifyRSSI;
    private static boolean mCanScanWifi;
    private static List<ScanResult> mWifiList;
    private static List<? extends WifiConfiguration> mWifiConfigurationList;
    private static int wifiState;
    private static WifiInfo mWifiInfo;
    private static NetworkInfo mWiFiNetworkInfo;
    public static final WifiManagerWrapper INSTANCE;

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    @NotNull
    public final String getDEFAULT_SSID() {
        return DEFAULT_SSID;
    }

    private final mWifiReceiver.1 getMWifiReceiver() {
        Lazy lazy = mWifiReceiver$delegate;
        WifiManagerWrapper wifiManagerWrapper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Object)lazy.getValue();
    }

    public final int getWifiState() {
        return wifiState;
    }

    public final void setWifiState$LibDeviceNetwork_release(int n) {
        wifiState = n;
    }

    public final void setWifiChangedListener(@Nullable OnWifiChangerListener listener) {
        if (listener == null) {
            mWifiChangeListener = null;
        } else {
            mWifiChangeListener = listener;
            if (hasInit) {
                this.updateBaseInfo();
                this.updateScanListInfo();
                this.updateConfiguredListInfo();
                listener.onWifiInfoChanged();
                listener.onScanUpdate(this.getScanResultList());
                listener.onConnectUpdate(this.getConfigurationList());
            }
        }
    }

    @NotNull
    public final List<WifiConfiguration> getConfigurationList() {
        List list;
        List<? extends WifiConfiguration> list2 = mWifiConfigurationList;
        if (list2 == null) {
            list = new ArrayList();
        } else {
            list = mWifiConfigurationList;
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<android.net.wifi.WifiConfiguration?>");
            }
        }
        return list;
    }

    @NotNull
    public final List<ScanResult> getScanResultList() {
        List list;
        List<ScanResult> list2 = mWifiList;
        if (list2 == null) {
            list = new ArrayList();
        } else {
            list = mWifiList;
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<android.net.wifi.ScanResult>");
            }
        }
        return list;
    }

    @NotNull
    public final String getSSID() {
        block3: {
            WifiInfo wifiInfo = mWifiInfo;
            if (wifiInfo == null) break block3;
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            if (StringsKt.equals((String)TextFactoryUtils.trimMarks((String)it.getSSID()), (String)DEFAULT_SSID, (boolean)true)) {
                WifiConfiguration wifiConfiguration = INSTANCE.getConfiguredByNetworkID(INSTANCE.getNetworkId());
                if (wifiConfiguration != null) {
                    WifiConfiguration wifiConfiguration2 = wifiConfiguration;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    WifiConfiguration wifiConfiguration3 = wifiConfiguration2;
                    boolean bl6 = false;
                    String string = TextFactoryUtils.trimMarks((String)wifiConfiguration3.SSID);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TextFactoryUtils.trimMarks(wifiConfiguration.SSID)");
                    return string;
                }
            } else {
                String string = TextFactoryUtils.trimMarks((String)it.getSSID());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TextFactoryUtils.trimMarks(it.ssid)");
                return string;
            }
        }
        return DEFAULT_SSID;
    }

    @NotNull
    public final String getBSSID() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            String string = it.getBSSID();
            if (string != null) {
                CharSequence charSequence = string;
                boolean bl4 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    String string2 = it.getBSSID();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.bssid");
                    return string2;
                }
            }
        }
        return "02:00:00:00:00:00";
    }

    public final int getRssi() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            return it.getRssi();
        }
        return -126;
    }

    @NotNull
    public final SupplicantState getSupplicantState() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            SupplicantState supplicantState = it.getSupplicantState();
            Intrinsics.checkExpressionValueIsNotNull((Object)supplicantState, (String)"it.supplicantState");
            return supplicantState;
        }
        return SupplicantState.DISCONNECTED;
    }

    public final int getSignalLevel() {
        return WifiManager.calculateSignalLevel((int)this.getRssi(), (int)5);
    }

    public final int getLinkSpeed() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            return it.getLinkSpeed();
        }
        return -1;
    }

    @NotNull
    public final String getLinkSpeedUnits() {
        return "Mbps";
    }

    public final int getIpAddress() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            return it.getIpAddress();
        }
        return 0;
    }

    private final int getNetworkId() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            return it.getNetworkId();
        }
        return -1;
    }

    @RequiresApi(value=21)
    private final int getFrequency() {
        WifiInfo wifiInfo = mWifiInfo;
        if (wifiInfo != null) {
            WifiInfo wifiInfo2 = wifiInfo;
            boolean bl = false;
            boolean bl2 = false;
            WifiInfo it = wifiInfo2;
            boolean bl3 = false;
            return it.getFrequency();
        }
        return 0;
    }

    public final boolean is5GHzWiFi() {
        int frequency = this.getFrequency();
        int n = frequency;
        return 4901 <= n && 5899 >= n;
    }

    @Nullable
    public final WifiConfiguration getWifiConfiguration() {
        return this.getConfiguredByNetworkID(this.getNetworkId());
    }

    public final boolean isWifiAvailable() {
        NetworkInfo networkInfo = mWiFiNetworkInfo;
        if (networkInfo != null) {
            NetworkInfo networkInfo2 = networkInfo;
            boolean bl = false;
            boolean bl2 = false;
            NetworkInfo it = networkInfo2;
            boolean bl3 = false;
            return it.getType() == 1;
        }
        return false;
    }

    @NotNull
    public final String getInfoString() {
        WifiInfo it;
        boolean bl;
        boolean bl2;
        WifiInfo wifiInfo;
        StringBuffer buffer = new StringBuffer();
        WifiInfo wifiInfo2 = mWifiInfo;
        if (wifiInfo2 != null) {
            wifiInfo = wifiInfo2;
            bl2 = false;
            bl = false;
            it = wifiInfo;
            boolean bl3 = false;
            buffer.append("\n\tWifiInfo-> ").append(it.toString());
        }
        NetworkInfo networkInfo = mWiFiNetworkInfo;
        if (networkInfo != null) {
            wifiInfo = networkInfo;
            bl2 = false;
            bl = false;
            it = wifiInfo;
            boolean bl4 = false;
            buffer.append("\n\tnetwork-> ").append(it.toString());
        }
        WifiConfiguration wifiConfiguration = this.getWifiConfiguration();
        if (wifiConfiguration != null) {
            wifiInfo = wifiConfiguration;
            bl2 = false;
            bl = false;
            it = wifiInfo;
            boolean bl5 = false;
            buffer.append("\n\tWifiConfiguration-> ").append(INSTANCE.getWifiConfigurationString((WifiConfiguration)it));
        }
        buffer.append("\n\twifi state-> " + wifiState).append(";network state-> " + this.isWifiAvailable());
        buffer.append("\n\tmWifiList-> " + this.getScanResultList().size()).append(";mWifiConfigurationList-> " + this.getConfigurationList().size());
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    public final void init(@NotNull Context context, boolean debug) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.init(context, debug, false, false);
    }

    public final void init(@NotNull Context context, boolean debug, boolean notifyRSSI, boolean canScanWifi) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        mContext = context;
        isDebug = debug;
        mNotifyRSSI = notifyRSSI;
        mCanScanWifi = canScanWifi;
        if (hasInit) {
            context.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.getMWifiReceiver());
            this.register(context);
            return;
        }
        hasInit = true;
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        mWifiManager = (WifiManager)object;
        Object object2 = context.getApplicationContext().getSystemService("connectivity");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        mConnectivityManager = (ConnectivityManager)object2;
        this.updateBaseInfo();
        this.updateConfiguredListInfo();
        this.updateScanListInfo();
        this.register(context);
    }

    public final void register(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IntentFilter foundFilter = new IntentFilter();
        foundFilter.addAction("android.net.wifi.STATE_CHANGE");
        foundFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        foundFilter.addAction("android.net.wifi.supplicant.CONNECTION_CHANGE");
        if (mNotifyRSSI) {
            foundFilter.addAction("android.net.wifi.RSSI_CHANGED");
        }
        if (mCanScanWifi) {
            foundFilter.addAction("android.net.wifi.SCAN_RESULTS");
        }
        context.getApplicationContext().registerReceiver((BroadcastReceiver)this.getMWifiReceiver(), foundFilter);
    }

    public final void openWifi() {
        block2: {
            ConnectivityManager connectivityManager = mConnectivityManager;
            if (connectivityManager == null || (connectivityManager = connectivityManager.getActiveNetworkInfo()) == null) break block2;
            ConnectivityManager connectivityManager2 = connectivityManager;
            boolean bl = false;
            boolean bl2 = false;
            ConnectivityManager it = connectivityManager2;
            boolean bl3 = false;
            ConnectivityManager connectivityManager3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)connectivityManager3, (String)"it");
            if (connectivityManager3.getType() == 1) {
                return;
            }
            WifiManager wifiManager = mWifiManager;
            if (wifiManager != null) {
                wifiManager.setWifiEnabled(true);
            }
            INSTANCE.startScan();
        }
    }

    public final void closeWifi() {
        block2: {
            WifiManager wifiManager = mWifiManager;
            if (wifiManager == null) break block2;
            if (wifiManager.isWifiEnabled()) {
                WifiManager wifiManager2 = mWifiManager;
                if (wifiManager2 != null) {
                    wifiManager2.setWifiEnabled(false);
                }
            }
        }
    }

    public final void startScan() {
        ThreadManager.getInstance().start((Runnable)startScan.1.INSTANCE);
    }

    private final void updateBaseInfo() {
        WifiManager wifiManager = mWifiManager;
        mWifiInfo = wifiManager != null ? wifiManager.getConnectionInfo() : null;
        ConnectivityManager connectivityManager = mConnectivityManager;
        mWiFiNetworkInfo = connectivityManager != null ? connectivityManager.getNetworkInfo(1) : null;
    }

    private final void updateScanListInfo() {
        if (mCanScanWifi) {
            try {
                WifiManager wifiManager = mWifiManager;
                mWifiList = wifiManager != null ? wifiManager.getScanResults() : null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final void updateConfiguredListInfo() {
        try {
            WifiManager wifiManager = mWifiManager;
            mWifiConfigurationList = wifiManager != null ? wifiManager.getConfiguredNetworks() : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void checkBaseInfoNotify() {
        block2: {
            OnWifiChangerListener listener;
            block3: {
                WifiInfo temp;
                block4: {
                    temp = mWifiInfo;
                    this.updateBaseInfo();
                    if (isDebug) {
                        WifiInfo wifiInfo = temp;
                        ZLog.d((String)(TAG + " networkId " + (wifiInfo != null ? Integer.valueOf(wifiInfo.getNetworkId()) : null) + " ;networkId " + this.getNetworkId()));
                    }
                    if (isDebug) {
                        WifiInfo wifiInfo = temp;
                        WifiInfo wifiInfo2 = mWifiInfo;
                        ZLog.d((String)(TAG + " SupplicantState " + (wifiInfo != null ? wifiInfo.getSupplicantState() : null) + " ;SupplicantState " + (wifiInfo2 != null ? wifiInfo2.getSupplicantState() : null)));
                    }
                    OnWifiChangerListener onWifiChangerListener = mWifiChangeListener;
                    if (onWifiChangerListener == null) break block2;
                    OnWifiChangerListener onWifiChangerListener2 = onWifiChangerListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    listener = onWifiChangerListener2;
                    boolean bl3 = false;
                    if (temp == null) break block3;
                    if (temp.getNetworkId() == INSTANCE.getNetworkId()) break block4;
                    listener.onWifiInfoChanged();
                    break block2;
                }
                WifiInfo wifiInfo = mWifiInfo;
                if (temp.getSupplicantState() == (wifiInfo != null ? wifiInfo.getSupplicantState() : null)) break block2;
                listener.onWifiInfoChanged();
                break block2;
            }
            WifiInfo wifiInfo = mWifiInfo;
            if (wifiInfo == null) break block2;
            WifiInfo wifiInfo3 = wifiInfo;
            boolean bl = false;
            boolean bl4 = false;
            WifiInfo it = wifiInfo3;
            boolean bl5 = false;
            listener.onWifiInfoChanged();
        }
    }

    private final void checkConfiguredInfoNotify() {
        block2: {
            int size = this.getConfigurationList().size();
            this.updateConfiguredListInfo();
            if (isDebug) {
                ZLog.d((String)(TAG + " size " + size + " ;size  + " + this.getConfigurationList().size()));
            }
            OnWifiChangerListener onWifiChangerListener = mWifiChangeListener;
            if (onWifiChangerListener == null) break block2;
            OnWifiChangerListener onWifiChangerListener2 = onWifiChangerListener;
            boolean bl = false;
            boolean bl2 = false;
            OnWifiChangerListener it = onWifiChangerListener2;
            boolean bl3 = false;
            Collection collection = INSTANCE.getConfigurationList();
            boolean bl4 = false;
            if (!collection.isEmpty() && INSTANCE.getConfigurationList().size() != size) {
                it.onConnectUpdate(INSTANCE.getConfigurationList());
            }
        }
    }

    @JvmOverloads
    public final void connectWifi(@NotNull String ssid, @NotNull String password, int type, boolean forceDeleteIfExist) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)ssid, (String)"ssid");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        int networkId = -1;
        WifiConfiguration tempConfig = this.getConfiguredBySSID(ssid);
        if (tempConfig != null && forceDeleteIfExist) {
            WifiManager wifiManager = mWifiManager;
            if (wifiManager != null) {
                wifiManager.removeNetwork(tempConfig.networkId);
            }
            tempConfig = null;
        }
        if (tempConfig != null && tempConfig.networkId > -1) {
            n = tempConfig.networkId;
        } else {
            WifiConfiguration wcg = this.createWifiInfo(ssid, password, type);
            WifiManager wifiManager = mWifiManager;
            n = wifiManager != null ? wifiManager.addNetwork(wcg) : -1;
        }
        networkId = n;
        this.connectWifi(networkId);
    }

    public static /* synthetic */ void connectWifi$default(WifiManagerWrapper wifiManagerWrapper, String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        wifiManagerWrapper.connectWifi(string, string2, n, bl);
    }

    @JvmOverloads
    public final void connectWifi(@NotNull String ssid, @NotNull String password, int type) {
        WifiManagerWrapper.connectWifi$default(this, ssid, password, type, false, 8, null);
    }

    public final void connectWifi(int networkId) {
        block3: {
            block2: {
                WifiManager wifiManager;
                if (networkId <= -1 || (wifiManager = mWifiManager) != null && (wifiManager = wifiManager.getConnectionInfo()) != null && wifiManager.getNetworkId() == networkId) break block2;
                WifiManager wifiManager2 = mWifiManager;
                if (wifiManager2 != null) {
                    wifiManager2.disconnect();
                }
                WifiManager wifiManager3 = mWifiManager;
                if (wifiManager3 != null) {
                    wifiManager3.enableNetwork(networkId, true);
                }
                WifiManager wifiManager4 = mWifiManager;
                if (wifiManager4 == null) break block3;
                wifiManager4.reconnect();
                break block3;
            }
            OnWifiChangerListener onWifiChangerListener = mWifiChangeListener;
            if (onWifiChangerListener == null) break block3;
            OnWifiChangerListener onWifiChangerListener2 = onWifiChangerListener;
            boolean bl = false;
            boolean bl2 = false;
            OnWifiChangerListener it = onWifiChangerListener2;
            boolean bl3 = false;
            it.onWifiInfoChanged();
        }
    }

    public final boolean isCurrent(@NotNull String ssid) {
        Intrinsics.checkParameterIsNotNull((Object)ssid, (String)"ssid");
        WifiConfiguration wifiConfiguration = this.getConfiguredBySSID(ssid);
        if (wifiConfiguration != null) {
            WifiConfiguration wifiConfiguration2 = wifiConfiguration;
            boolean bl = false;
            boolean bl2 = false;
            WifiConfiguration it = wifiConfiguration2;
            boolean bl3 = false;
            return it.networkId > 0 && it.networkId == INSTANCE.getNetworkId();
        }
        return false;
    }

    public final int getNetType(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return NetworkUtil.getNetworkState(context);
    }

    @NotNull
    public final String getNetTypeName(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = NetworkUtil.getNetworkName(NetworkUtil.getNetworkState(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NetworkUtil.getNetworkNa\u2026getNetworkState(context))");
        return string;
    }

    public final int getMobileNetType(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return NetworkUtil.getMobileNetworkClass(context, null);
    }

    @Nullable
    public final String getWiFiBssID() {
        String string;
        String bssId = "";
        try {
            WifiInfo wi;
            WifiManager wifiManager = mWifiManager;
            WifiInfo wifiInfo = wi = wifiManager != null ? wifiManager.getConnectionInfo() : null;
            bssId = wifiInfo != null ? wifiInfo.getBSSID() : null;
        }
        catch (Exception e) {
            ZLog.e((String)("getWiFiBssID error:" + e.getMessage()));
        }
        if (bssId != null && bssId.length() > 0) {
            String string2 = bssId;
            boolean bl = false;
            String string3 = string2.toUpperCase();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        } else {
            string = bssId;
        }
        return string;
    }

    @NotNull
    public final String getWifiMacAddr() {
        WifiManager wifiManager = mWifiManager;
        if (wifiManager == null || (wifiManager = wifiManager.getDhcpInfo()) == null) {
            return "";
        }
        WifiManager dhcpInfo = wifiManager;
        String gateWayIp = IpUtils.ipn2s(dhcpInfo.gateway);
        ZLog.d((String)("getWifiMacAddr gateWayIp:" + gateWayIp));
        String string = WifiUtil.getLanMacAddr(gateWayIp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"WifiUtil.getLanMacAddr(gateWayIp)");
        return string;
    }

    private final String getWifiConfigurationString(WifiConfiguration info) {
        StringBuilder sbuf = new StringBuilder();
        WifiConfiguration wifiConfiguration = info;
        if (wifiConfiguration != null) {
            WifiConfiguration wifiConfiguration2 = wifiConfiguration;
            boolean bl = false;
            boolean bl2 = false;
            WifiConfiguration it = wifiConfiguration2;
            boolean bl3 = false;
            sbuf.append("SSID:").append(info.SSID);
            sbuf.append(";networkId:").append(info.networkId);
            sbuf.append(";status:").append(info.status);
            sbuf.append(";BSSID:").append(info.BSSID);
        }
        String string = sbuf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sbuf.toString()");
        return string;
    }

    @Nullable
    public final WifiConfiguration getConfiguredBySSID(@NotNull String ssid) {
        Intrinsics.checkParameterIsNotNull((Object)ssid, (String)"ssid");
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return null;
        }
        List<WifiConfiguration> list = this.getConfigurationList();
        if (list != null) {
            List<WifiConfiguration> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<WifiConfiguration> it = list2;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                Iterator<WifiConfiguration> iterator = it.iterator();
                while (iterator.hasNext()) {
                    WifiConfiguration existingConfig;
                    WifiConfiguration wifiConfiguration = existingConfig = iterator.next();
                    if (!Intrinsics.areEqual((Object)TextFactoryUtils.trimMarks((String)(wifiConfiguration != null ? wifiConfiguration.SSID : null)), (Object)ssid)) continue;
                    return existingConfig;
                }
            }
        }
        return null;
    }

    private final WifiConfiguration getConfiguredByNetworkID(int networkId) {
        if (networkId < 0) {
            return null;
        }
        List<WifiConfiguration> list = this.getConfigurationList();
        boolean bl = false;
        boolean bl2 = false;
        List<WifiConfiguration> it = list;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            Iterator<WifiConfiguration> iterator = it.iterator();
            while (iterator.hasNext()) {
                WifiConfiguration existingConfig;
                WifiConfiguration wifiConfiguration = existingConfig = iterator.next();
                if (wifiConfiguration == null) continue;
                if (wifiConfiguration.networkId != networkId) continue;
                return existingConfig;
            }
        }
        return null;
    }

    private final WifiConfiguration createWifiInfo(String ssid, String Password, int Type2) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + ssid + "\"";
        switch (Type2) {
            case 1: {
                config.wepKeys[0] = "";
                config.allowedKeyManagement.set(0);
                config.wepTxKeyIndex = 0;
                break;
            }
            case 2: {
                config.hiddenSSID = true;
                config.wepKeys[0] = "\"" + Password + "\"";
                config.allowedAuthAlgorithms.set(1);
                config.allowedGroupCiphers.set(3);
                config.allowedGroupCiphers.set(2);
                config.allowedGroupCiphers.set(0);
                config.allowedGroupCiphers.set(1);
                config.allowedKeyManagement.set(0);
                config.wepTxKeyIndex = 0;
                break;
            }
            case 3: {
                config.preSharedKey = "\"" + Password + "\"";
                config.hiddenSSID = true;
                config.allowedAuthAlgorithms.set(0);
                config.allowedGroupCiphers.set(2);
                config.allowedKeyManagement.set(1);
                config.allowedPairwiseCiphers.set(1);
                config.allowedGroupCiphers.set(3);
                config.allowedPairwiseCiphers.set(2);
                config.status = 2;
                break;
            }
        }
        return config;
    }

    private WifiManagerWrapper() {
    }

    static {
        WifiManagerWrapper wifiManagerWrapper;
        INSTANCE = wifiManagerWrapper = new WifiManagerWrapper();
        TAG = TAG;
        DEFAULT_SSID = DEFAULT_SSID;
        mWifiReceiver$delegate = LazyKt.lazy((Function0)mWifiReceiver.2.INSTANCE);
        wifiState = 1;
    }

    public static final /* synthetic */ WifiManager access$getMWifiManager$p(WifiManagerWrapper $this) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        return mWifiManager;
    }

    public static final /* synthetic */ void access$setMWifiManager$p(WifiManagerWrapper $this, WifiManager wifiManager) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        mWifiManager = wifiManager;
    }

    public static final /* synthetic */ boolean access$isDebug$p(WifiManagerWrapper $this) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        return isDebug;
    }

    public static final /* synthetic */ void access$setDebug$p(WifiManagerWrapper $this, boolean bl) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        isDebug = bl;
    }

    public static final /* synthetic */ OnWifiChangerListener access$getMWifiChangeListener$p(WifiManagerWrapper $this) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        return mWifiChangeListener;
    }

    public static final /* synthetic */ void access$setMWifiChangeListener$p(WifiManagerWrapper $this, OnWifiChangerListener onWifiChangerListener) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        mWifiChangeListener = onWifiChangerListener;
    }

    public static final /* synthetic */ void access$checkBaseInfoNotify(WifiManagerWrapper $this) {
        $this.checkBaseInfoNotify();
    }

    public static final /* synthetic */ void access$checkConfiguredInfoNotify(WifiManagerWrapper $this) {
        $this.checkConfiguredInfoNotify();
    }

    public static final /* synthetic */ boolean access$getMNotifyRSSI$p(WifiManagerWrapper $this) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        return mNotifyRSSI;
    }

    public static final /* synthetic */ void access$setMNotifyRSSI$p(WifiManagerWrapper $this, boolean bl) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        mNotifyRSSI = bl;
    }

    public static final /* synthetic */ void access$updateBaseInfo(WifiManagerWrapper $this) {
        $this.updateBaseInfo();
    }

    public static final /* synthetic */ boolean access$getMCanScanWifi$p(WifiManagerWrapper $this) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        return mCanScanWifi;
    }

    public static final /* synthetic */ void access$setMCanScanWifi$p(WifiManagerWrapper $this, boolean bl) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        mCanScanWifi = bl;
    }

    public static final /* synthetic */ void access$updateScanListInfo(WifiManagerWrapper $this) {
        $this.updateScanListInfo();
    }

    public static final /* synthetic */ List access$getMWifiList$p(WifiManagerWrapper $this) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        return mWifiList;
    }

    public static final /* synthetic */ void access$setMWifiList$p(WifiManagerWrapper $this, List list) {
        WifiManagerWrapper wifiManagerWrapper = $this;
        mWifiList = list;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H&J\u001a\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u0005H&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u0003H&\u00a8\u0006\u000e"}, d2={"Lcom/bihe0832/android/lib/network/WifiManagerWrapper$OnWifiChangerListener;", "", "onConnectUpdate", "", "wifiConfigurationList", "", "Landroid/net/wifi/WifiConfiguration;", "onScanUpdate", "wifiList", "Landroid/net/wifi/ScanResult;", "onStateChanged", "state", "", "onWifiInfoChanged", "LibDeviceNetwork_release"})
    public static interface OnWifiChangerListener {
        public void onStateChanged(int var1);

        public void onWifiInfoChanged();

        public void onScanUpdate(@Nullable List<ScanResult> var1);

        public void onConnectUpdate(@Nullable List<? extends WifiConfiguration> var1);
    }
}

