/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.IpUtils;
import com.bihe0832.android.lib.network.MobileUtil;
import com.bihe0832.android.lib.network.WifiUtil;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtil {
    public static final int DT_TYPE_BLUETOOTH_AUXILIARY = 64;
    public static final int DT_TYPE_WIFI_AUXILIARY = 32;
    public static final int DT_TYPE_BLUETOOTH = 16;
    public static final int DT_TYPE_ETH = 8;
    public static final int DT_TYPE_WIFI = 4;
    public static final int DT_TYPE_MOBILE = 2;
    public static final int DT_TYPE_VPN = 1;
    public static final int NETWORK_CLASS_NONET = 0;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    public static final int NETWORK_CLASS_WIFI = 4;
    public static final int NETWORK_CLASS_WIFI_4G = 5;
    public static final int NETWORK_CLASS_WIFI_WIFI = 6;
    public static final int NETWORK_CLASS_5_G = 7;
    public static final int NETWORK_CLASS_BLUETOOTH = 8;
    public static final int NETWORK_CLASS_ETHERNET = 9;
    public static final int DEFAULT_SIGNAL_LEVEL = -1;
    public static final int DEFAULT_SIGNAL_VALUE = 1;

    public static String getNetworkName(Context context) {
        return NetworkUtil.getNetworkName(NetworkUtil.getNetworkState(context));
    }

    public static String getNetworkName(int netState) {
        String name = "unknown";
        switch (netState) {
            case 0: {
                name = "unknown\u6216\u65e0\u7f51\u7edc";
                break;
            }
            case 1: {
                name = "2G";
                break;
            }
            case 2: {
                name = "3G";
                break;
            }
            case 3: {
                name = "4G";
                break;
            }
            case 4: {
                name = "Wi-Fi";
                break;
            }
            case 9: {
                name = "ethernet";
                break;
            }
            case 8: {
                name = "bluetooth";
                break;
            }
            case 7: {
                name = "5G";
                break;
            }
        }
        return name;
    }

    public static int getNetworkState(Context context) {
        int netValue = 0;
        if (null == context) {
            return netValue;
        }
        try {
            ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = connectMgr.getActiveNetworkInfo();
            netValue = info == null ? 0 : (info.getType() == 1 ? 4 : (info.getType() == 0 ? NetworkUtil.getMobileNetworkClass(context, info) : (info.getType() == 9 ? 9 : (info.getType() == 7 ? 8 : 0))));
        }
        catch (Exception e) {
            ZLog.d((String)("getNetworkState exception:" + e.getMessage()));
        }
        return netValue;
    }

    public static int getMobileNetworkClass(Context context, NetworkInfo info) {
        TelephonyManager telephonyManager;
        int netTypeFormInfo = 0;
        if (info != null && info.getType() == 0) {
            netTypeFormInfo = NetworkUtil.getMobileNetworkClass(info.getSubtype());
            if (netTypeFormInfo == 0 && info.getState() == NetworkInfo.State.CONNECTED) {
                netTypeFormInfo = 3;
            }
            if (netTypeFormInfo != 3 && netTypeFormInfo != 0) {
                return netTypeFormInfo;
            }
        }
        if ((telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null) {
            int netTypeFromManager = NetworkUtil.getMobileNetworkClass(telephonyManager.getNetworkType());
            if (netTypeFromManager != 0) {
                return netTypeFromManager;
            }
            if (netTypeFormInfo == 0 && telephonyManager.getDataState() == 2) {
                netTypeFormInfo = 3;
            }
        }
        return netTypeFormInfo;
    }

    private static int getMobileNetworkClass(int networkType) {
        switch (networkType) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 2;
            }
            case 13: 
            case 18: 
            case 19: {
                return 3;
            }
            case 20: {
                return 7;
            }
        }
        return 3;
    }

    public static boolean isMobileNet(int networkType) {
        return networkType == 1 || networkType == 2 || networkType == 3 || networkType == 7;
    }

    public static boolean isMobileNet(Context context) {
        return NetworkUtil.isMobileNet(NetworkUtil.getNetworkState(context));
    }

    public static boolean isWifiNet(int networkType) {
        return networkType == 4;
    }

    public static boolean isWifiNet(Context context) {
        return NetworkUtil.isWifiNet(NetworkUtil.getNetworkState(context));
    }

    public static boolean isEtherNet(int networkType) {
        return networkType == 9;
    }

    public static boolean isEtherNet(Context context) {
        return NetworkUtil.isEtherNet(NetworkUtil.getNetworkState(context));
    }

    public static boolean isBluetoothNet(int networkType) {
        return networkType == 8;
    }

    public static boolean isBluetoothNet(Context context) {
        return NetworkUtil.isBluetoothNet(NetworkUtil.getNetworkState(context));
    }

    public static int getSignalLevel(Context context, int networkType) {
        switch (networkType) {
            case 4: {
                return WifiUtil.getWifiSignalLevel(context);
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return MobileUtil.getSignalLevel();
            }
        }
        return -1;
    }

    public static int getSignalValue(Context context, int networkType) {
        switch (networkType) {
            case 4: {
                return WifiUtil.getWifiSignalValue(context);
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return MobileUtil.getSignalValue();
            }
        }
        return 1;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isNetworkConnected(int netType) {
        return netType != 0;
    }

    public static boolean checkDtTypeAvailable(int dtType, int targetType) {
        return (dtType & targetType) == targetType;
    }

    public static boolean checkDtTypeWiFi4GVpn(int dtType) {
        int targetType = 7;
        return NetworkUtil.checkDtTypeAvailable(dtType, 7);
    }

    public static String[] getAllNetInterface() {
        ArrayList<String> availableInterface = new ArrayList<String>();
        String[] interfaces = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            InetAddress ia = null;
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    ia = ias.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    String ip = ia.getHostAddress();
                    ZLog.d((String)("getAllNetInterface, available interface:" + ni.getName() + ", address:" + ip));
                    if (ni.isLoopback()) continue;
                    availableInterface.add(ni.getName() + ":" + ip);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        ZLog.d((String)("getAllNetInterface, all interface:" + availableInterface.toString()));
        int size = availableInterface.size();
        if (size > 0) {
            interfaces = new String[size];
            for (int i = 0; i < size; ++i) {
                interfaces[i] = (String)availableInterface.get(i);
            }
        }
        return interfaces;
    }

    public static DtTypeInfo getDtTypeInfo(Context context) {
        DtTypeInfo dtTypeinfo = new DtTypeInfo();
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (cm == null) {
                return dtTypeinfo;
            }
            if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
                Network[] nets;
                block9: for (Network net : nets = cm.getAllNetworks()) {
                    List las;
                    LinkProperties linkProperties;
                    NetworkInfo netInfo = cm.getNetworkInfo(net);
                    if (netInfo == null || !netInfo.isAvailable() || (linkProperties = cm.getLinkProperties(net)) == null || (las = linkProperties.getLinkAddresses()) == null) continue;
                    String ip = "";
                    for (LinkAddress linkAddress : las) {
                        InetAddress ia = linkAddress.getAddress();
                        if (ia instanceof Inet6Address || ia.isLoopbackAddress()) continue;
                        ip = ia.getHostAddress();
                    }
                    if (ip == null || ip.length() <= 0) continue;
                    switch (netInfo.getType()) {
                        case 17: {
                            dtTypeinfo.dtType |= 1;
                            dtTypeinfo.vpnIp = ip;
                            continue block9;
                        }
                        case 9: {
                            dtTypeinfo.dtType |= 8;
                            dtTypeinfo.ethIp = ip;
                            continue block9;
                        }
                        case 7: {
                            dtTypeinfo.dtType |= 0x10;
                            dtTypeinfo.bluetoothIp = ip;
                            continue block9;
                        }
                        case 0: {
                            dtTypeinfo.dtType |= 2;
                            dtTypeinfo.mobileIp = ip;
                            continue block9;
                        }
                        case 1: {
                            String ifName = linkProperties.getInterfaceName();
                            if (ifName == null) continue block9;
                            if (ifName.contains("wlan0")) {
                                dtTypeinfo.dtType |= 4;
                                dtTypeinfo.wifiIp = ip;
                                continue block9;
                            }
                            if (!ifName.contains("wlan1")) continue block9;
                            dtTypeinfo.dtType |= 0x20;
                            dtTypeinfo.wifiAuxiliaryIp = ip;
                            continue block9;
                        }
                        default: {
                            String typeName = netInfo.getTypeName();
                            if (typeName == null || !typeName.contains("WIFI") && !typeName.contains("wifi")) continue block9;
                            dtTypeinfo.dtType |= 0x20;
                            dtTypeinfo.wifiAuxiliaryIp = ip;
                            continue block9;
                        }
                    }
                }
                ZLog.d((String)("getDtTypeInfo new:" + dtTypeinfo.toString()));
            } else {
                dtTypeinfo = NetworkUtil.getDtTypeInfoByInterface(context);
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getDtTypeInfo Exception:" + e.toString()));
        }
        return dtTypeinfo;
    }

    public static DtTypeInfo getDtTypeInfoByInterface(Context context) {
        String[] interfaces = NetworkUtil.getAllNetInterface();
        DtTypeInfo info = new DtTypeInfo();
        if (interfaces == null) {
            return info;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            String iface = interfaces[i];
            ZLog.d((String)("getDtTypeInfo iface:" + iface));
            String[] tmps = iface.split(":");
            if (iface.contains("tun")) {
                if (tmps.length <= 1) continue;
                info.dtType |= 1;
                info.vpnIp = tmps[1];
                continue;
            }
            if (iface.contains("eth")) {
                if (context != null && !NetworkUtil.isEtherNet(context) || tmps.length <= 1) continue;
                info.dtType |= 8;
                info.ethIp = tmps[1];
                continue;
            }
            if (iface.contains("wlan0")) {
                if (tmps.length <= 1) continue;
                info.dtType |= 4;
                info.wifiIp = tmps[1];
                continue;
            }
            if (iface.contains("wlan1")) {
                if (tmps.length <= 1) continue;
                info.dtType |= 0x20;
                info.wifiAuxiliaryIp = tmps[1];
                continue;
            }
            if (iface.contains("rmnet")) {
                if (tmps.length <= 1) continue;
                info.dtType |= 2;
                info.mobileIp = tmps[1];
                continue;
            }
            if (!iface.contains("bt") || tmps.length <= 1) continue;
            info.dtType |= 0x10;
            info.bluetoothIp = tmps[1];
        }
        ZLog.d((String)("getDtTypeInfo:" + info.toString()));
        return info;
    }

    public static boolean isNetworkOnline() {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process ipProcess = runtime.exec("ping -c 3 weixin.qq.com");
            int exitValue = ipProcess.waitFor();
            ZLog.i((String)("zixie isNetworkOnline exitValue:" + exitValue));
            if (exitValue == 0) {
                return true;
            }
            int len = ipProcess.getErrorStream().available();
            if (len > 0) {
                byte[] buf = new byte[len];
                ipProcess.getErrorStream().read(buf);
                ZLog.i((String)("zixie " + new String(buf)));
            }
            return false;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean is4GReachable(String domain, int netid, int SOCKET_TIMEOUT) {
        boolean flag = true;
        try {
            ZLog.i((String)("is4GReachable netid = " + netid));
            InetAddress inetAddress = IpUtils.getNetDomainFirstAddr(domain, netid);
            if (inetAddress != null) {
                flag = inetAddress.isReachable(SOCKET_TIMEOUT);
                ZLog.i((String)("is4GReachable flag = " + flag + ";getHostAddress = " + inetAddress.getHostAddress() + ";getHostName = " + inetAddress.getHostName()));
            }
        }
        catch (Exception exception) {}
        finally {
            return flag;
        }
    }

    public static String getMobileLocalIp(Context context) {
        String mobileLocalIp = "";
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (cm == null) {
                return "";
            }
            if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
                Network[] nets;
                for (Network net : nets = cm.getAllNetworks()) {
                    List las;
                    LinkProperties linkProperties;
                    NetworkInfo netInfo = cm.getNetworkInfo(net);
                    if (netInfo == null || !netInfo.isAvailable() || (linkProperties = cm.getLinkProperties(net)) == null || (las = linkProperties.getLinkAddresses()) == null) continue;
                    String ip = "";
                    for (LinkAddress linkAddress : las) {
                        InetAddress ia = linkAddress.getAddress();
                        if (ia instanceof Inet6Address || ia.isLoopbackAddress()) continue;
                        ip = ia.getHostAddress();
                    }
                    if (ip == null || ip.length() <= 0 || 0 != netInfo.getType()) continue;
                    mobileLocalIp = ip;
                }
                ZLog.d((String)("getMobileLocalIp mobileLocalIp:" + mobileLocalIp));
            } else {
                String[] interfaces = NetworkUtil.getAllNetInterface();
                if (interfaces == null) {
                    return "";
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    String iface = interfaces[i];
                    ZLog.d((String)("getMobileLocalIp iface:" + iface));
                    String[] tmps = iface.split(":");
                    if (!iface.contains("rmnet") || tmps.length <= 1) continue;
                    mobileLocalIp = tmps[1];
                }
                ZLog.d((String)("getMobileLocalIp mobileLocalIp lessthan L:" + mobileLocalIp));
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getMobileLocalIp Exception:" + e.toString()));
        }
        return mobileLocalIp;
    }

    public static Network getMobileNetwork(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (cm != null && BuildUtils.INSTANCE.getSDK_INT() >= 21) {
            Network[] nets;
            for (Network net : nets = cm.getAllNetworks()) {
                NetworkInfo info = cm.getNetworkInfo(net);
                if (info == null || info.getType() != 0) continue;
                if (info.isAvailable()) {
                    ZLog.d((String)("getMobileNetwork type:" + info.getType() + ", netInfo:" + info.toString()));
                    LinkProperties linkProperties = cm.getLinkProperties(net);
                    if (linkProperties == null) continue;
                    ZLog.d((String)("getMobileNetwork linkProperties:" + linkProperties.toString()));
                    List las = linkProperties.getLinkAddresses();
                    if (las == null) continue;
                    String ip = "";
                    for (LinkAddress linkAddress : las) {
                        InetAddress ia = linkAddress.getAddress();
                        if (ia instanceof Inet6Address || ia.isLoopbackAddress()) continue;
                        ip = ia.getHostAddress();
                    }
                    if (ip == null || ip.length() <= 0) continue;
                    ZLog.d((String)("getMobileNetwork mobileip:" + ip));
                    return net;
                }
                return null;
            }
        }
        return null;
    }

    public static String getInternalIp() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                if (!intf.getDisplayName().contains("wlan")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !IpUtils.isIpv4Address(inetAddress.getHostAddress())) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException var4) {
            ZLog.d((String)("getInternalIp failed, " + var4.toString()));
        }
        return null;
    }

    public static String getIPAddress(Context context) {
        NetworkInfo info = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getType() == 0) {
                try {
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        NetworkInterface intf = en.nextElement();
                        Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                        while (enumIpAddr.hasMoreElements()) {
                            InetAddress inetAddress = enumIpAddr.nextElement();
                            if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                            return inetAddress.getHostAddress();
                        }
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            } else if (info.getType() == 1) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                String ipAddress = IpUtils.ipn2s(wifiInfo.getIpAddress());
                return ipAddress;
            }
        }
        return null;
    }

    public static String getWifiIp(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (null == wifiManager) {
            return "";
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (null == wifiInfo) {
            return "";
        }
        String ipAddress = IpUtils.ipn2s(wifiInfo.getIpAddress());
        ZLog.i((String)("wifi_ip -> " + ipAddress));
        return ipAddress;
    }

    public static class DtTypeInfo {
        public int dtType = 0;
        public String vpnIp = "";
        public String ethIp = "";
        public String wifiIp = "";
        public String mobileIp = "";
        public String bluetoothIp = "";
        public String wifiAuxiliaryIp = "";
        public String bluetoothAuxiliaryIp = "";

        public String toString() {
            return "DtTypeInfo{dtType=" + this.dtType + ", vpnIp='" + this.vpnIp + '\'' + ", ethIp='" + this.ethIp + '\'' + ", wifiIp='" + this.wifiIp + '\'' + ", mobileIp='" + this.mobileIp + '\'' + ", bluetoothIp='" + this.bluetoothIp + '\'' + ", wifiAuxiliaryIp='" + this.wifiAuxiliaryIp + '\'' + ", bluetoothAuxiliaryIp='" + this.bluetoothAuxiliaryIp + '\'' + '}';
        }
    }
}

