/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Looper;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellLocation;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.lang.reflect.Method;
import java.util.Iterator;

public class MobileUtil {
    @SuppressLint(value={"StaticFieldLeak"})
    private static MobileSignalListener sMobileSignalListener = null;
    private static int sSignalLevel = -1;
    private static int sSignalValue = 1;

    public static void registerMobileSignalListener(Context context) {
        if (context == null) {
            return;
        }
        if (Looper.myLooper() == null) {
            ZLog.d((String)"registerMobileSignalListener failed, looper is null");
            return;
        }
        try {
            if (sMobileSignalListener == null) {
                sMobileSignalListener = new MobileSignalListener(context);
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    telephonyManager.listen((PhoneStateListener)sMobileSignalListener, 256);
                }
            }
        }
        catch (Exception e) {
            ZLog.d((String)("registerMobileSignalListener exception:" + e.getMessage()));
        }
    }

    public static void unregisterMobileSignalListener(Context context) {
        if (context == null || sMobileSignalListener == null) {
            return;
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                telephonyManager.listen((PhoneStateListener)sMobileSignalListener, 0);
                sMobileSignalListener = null;
            }
        }
        catch (Exception e) {
            ZLog.d((String)("unregisterMobileSignalListener:" + e.getMessage()));
        }
    }

    public static int getSignalLevel() {
        return sSignalLevel;
    }

    public static int getSignalValue() {
        return sSignalValue;
    }

    @SuppressLint(value={"NewApi"})
    public static int getMobileSignalValue(Context ctx) {
        TelephonyManager telephonyManager = (TelephonyManager)ctx.getSystemService("phone");
        try {
            Iterator iterator = telephonyManager.getAllCellInfo().iterator();
            if (iterator.hasNext()) {
                CellInfo info = (CellInfo)iterator.next();
                if (info instanceof CellInfoGsm) {
                    CellSignalStrengthGsm gsm = ((CellInfoGsm)info).getCellSignalStrength();
                    return gsm.getDbm();
                }
                if (info instanceof CellInfoCdma) {
                    CellSignalStrengthCdma cdma = ((CellInfoCdma)info).getCellSignalStrength();
                    return cdma.getDbm();
                }
                if (info instanceof CellInfoLte) {
                    CellSignalStrengthLte lte = ((CellInfoLte)info).getCellSignalStrength();
                    return lte.getDbm();
                }
                throw new Exception("Unknown type of cell signal!");
            }
        }
        catch (Exception e) {
            ZLog.e((String)"Unable to obtain cell signal information");
        }
        return 0;
    }

    public static String getPhoneCellInfo(Context context) {
        String cellInfo = "0_0_0_0";
        try {
            String operator;
            int lac = -1;
            int cid = -1;
            TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            String string = operator = mTelephonyManager != null ? mTelephonyManager.getNetworkOperator() : null;
            if (operator == null) {
                return cellInfo;
            }
            String mcc = operator.substring(0, 3);
            String mnc = operator.substring(3);
            if (mcc == null || mnc == null) {
                ZLog.d((String)("cellinfo:" + cellInfo));
                return cellInfo;
            }
            CellLocation cellLocation = mTelephonyManager.getCellLocation();
            if (cellLocation instanceof GsmCellLocation) {
                GsmCellLocation gsmlocation = (GsmCellLocation)cellLocation;
                lac = gsmlocation.getLac();
                cid = gsmlocation.getCid();
            } else if (cellLocation instanceof CdmaCellLocation) {
                CdmaCellLocation cdmalocation = (CdmaCellLocation)cellLocation;
                lac = cdmalocation.getNetworkId();
                cid = cdmalocation.getBaseStationId();
            }
            cellInfo = mcc + "_" + mnc + "_" + lac + "_" + cid;
        }
        catch (Exception e) {
            ZLog.d((String)("getPhoneCellInfo exception:" + e.getMessage()));
        }
        return cellInfo;
    }

    static class MobileSignalListener
    extends PhoneStateListener {
        private Context mContext;

        public MobileSignalListener(Context context) {
            this.mContext = context.getApplicationContext();
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            try {
                int level;
                Method method;
                if (BuildUtils.INSTANCE.getSDK_INT() >= 23) {
                    method = SignalStrength.class.getMethod("getLevel", new Class[0]);
                    method.setAccessible(true);
                    level = (Integer)method.invoke((Object)signalStrength, new Object[0]);
                } else {
                    method = SignalStrength.class.getMethod("getEvdoLevel", new Class[0]);
                    method.setAccessible(true);
                    level = (Integer)method.invoke((Object)signalStrength, new Object[0]);
                }
                if (level > 4) {
                    level = 4;
                }
                sSignalLevel = level;
                Method getDbmMethod = SignalStrength.class.getMethod("getDbm", new Class[0]);
                getDbmMethod.setAccessible(true);
                sSignalValue = (Integer)getDbmMethod.invoke((Object)signalStrength, new Object[0]);
            }
            catch (Exception e) {
                ZLog.d((String)("MobileSignalListener exception:" + e.getMessage()));
            }
        }
    }
}

