/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network;

import com.bihe0832.android.lib.log.ZLog;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IpUtils {
    public static final String INVALID_IP = "0.0.0.0";
    public static final String BROADCAST_IP = "255.255.255.255";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public static boolean isValidIpv4Address(String input) {
        if (input == null || input.length() <= 0) {
            return false;
        }
        if (INVALID_IP.equals(input) || BROADCAST_IP.equals(input)) {
            return false;
        }
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIpv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIpv6Address(String input) {
        return IpUtils.isIpv6StdAddress(input) || IpUtils.isIpv6HexCompressedAddress(input);
    }

    public static boolean isIpAddress(String input) {
        return IpUtils.isIpv4Address(input) || IpUtils.isIpv6Address(input);
    }

    private static boolean isIpv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    private static boolean isIpv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    public static List<String> getDomainIpList(String domain) {
        ArrayList<String> ret = new ArrayList<String>();
        InetAddress[] addrs = IpUtils.getDomainAddrList(domain);
        if (addrs != null && addrs.length > 0) {
            for (InetAddress addr : addrs) {
                ret.add(addr.getHostAddress());
            }
        }
        return ret;
    }

    public static List<String> getDomainIpListOnlyIPv4(String domain) {
        ArrayList<String> ret = new ArrayList<String>();
        InetAddress[] addrs = IpUtils.getDomainAddrList(domain);
        if (addrs != null && addrs.length > 0) {
            for (InetAddress addr : addrs) {
                if (!(addr instanceof Inet4Address)) continue;
                ret.add(addr.getHostAddress());
            }
        }
        return ret;
    }

    public static String getDomainFirstIp(String domain) {
        InetAddress firstAddr = IpUtils.getDomainFirstAddr(domain);
        if (firstAddr != null) {
            return firstAddr.getHostAddress();
        }
        return "";
    }

    public static InetAddress[] getDomainAddrList(String domain) {
        InetAddress[] ips = null;
        int retry = 2;
        if (IpUtils.isIpAddress(domain)) {
            try {
                return InetAddress.getAllByName(domain);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (retry-- > 0) {
            try {
                DnsLookupThread dnsQuery = new DnsLookupThread(domain);
                dnsQuery.start();
                dnsQuery.join(3000L);
                ips = dnsQuery.getAddrs();
                if (ips == null || ips.length <= 0) continue;
                return ips;
            }
            catch (Exception exception) {
            }
        }
        ZLog.w((String)("dns\u89e3\u6790addrs\u5931\u8d25:" + domain));
        return null;
    }

    public static InetAddress getDomainFirstAddr(String domain) {
        InetAddress[] addrs = IpUtils.getDomainAddrList(domain);
        if (addrs != null && addrs.length > 0) {
            return addrs[0];
        }
        return null;
    }

    public static String getNetDomainFirstIp(String domain, int netid) {
        InetAddress firstAddr = IpUtils.getNetDomainFirstAddr(domain, netid);
        if (firstAddr != null) {
            return firstAddr.getHostAddress();
        }
        return "";
    }

    public static InetAddress getNetDomainFirstAddr(String domain, int netid) {
        InetAddress[] addrs = IpUtils.dnsOnNet(domain, netid);
        if (addrs != null && addrs.length > 0) {
            return addrs[0];
        }
        return null;
    }

    public static InetAddress[] dnsOnNet(String domain, int netid) {
        InetAddress[] ips = null;
        int retry = 2;
        while (retry-- > 0) {
            try {
                DnsLookupThread dnsQuery = new DnsLookupThread(domain, netid);
                dnsQuery.start();
                dnsQuery.join(3000L);
                ips = dnsQuery.getAddrs();
                if (ips == null || ips.length <= 0) continue;
                return ips;
            }
            catch (Exception exception) {
            }
        }
        ZLog.w((String)("dnsOnNet\u89e3\u6790addrs\u5931\u8d25:" + domain + ", netid:" + netid));
        return null;
    }

    public static String ipn2s(int ipNetSeq) {
        return (ipNetSeq & 0xFF) + "." + (0xFF & ipNetSeq >> 8) + "." + (0xFF & ipNetSeq >> 16) + "." + (0xFF & ipNetSeq >> 24);
    }

    public static String iph2s(int ipHostSeq) {
        return (ipHostSeq >> 24 & 0xFF) + "." + (ipHostSeq >> 16 & 0xFF) + "." + (ipHostSeq >> 8 & 0xFF) + "." + (ipHostSeq & 0xFF);
    }

    public static int ips2h(String ipStr) {
        int ipHostSeq = 0;
        if (ipStr == null) {
            return ipHostSeq;
        }
        String[] ipAddrArr = ipStr.split("\\.");
        if (ipAddrArr.length != 4) {
            return ipHostSeq;
        }
        try {
            for (int i = 3; i >= 0; --i) {
                int ip = Integer.parseInt(ipAddrArr[3 - i]);
                ipHostSeq |= ip << i * 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipHostSeq;
    }

    public static int ipn2h(int ipNetSeq) {
        String ipStr = IpUtils.ipn2s(ipNetSeq);
        return IpUtils.ips2h(ipStr);
    }

    public static boolean isInnerIP(String ip) {
        long ipNum = IpUtils.getIpNum(ip);
        return ipNum >= 0xA000000L && ipNum <= 0xAFFFFFFL || ipNum >= 2886729728L && ipNum <= 2887778303L || ipNum >= 3232235520L && ipNum <= 3232301055L || ip.equals("127.0.0.1");
    }

    private static long getIpNum(String ipAddress) {
        String[] ip = ipAddress.split("\\.");
        long a = Integer.parseInt(ip[0]);
        long b = Integer.parseInt(ip[1]);
        long c = Integer.parseInt(ip[2]);
        long d = Integer.parseInt(ip[3]);
        return a * 256L * 256L * 256L + b * 256L * 256L + c * 256L + d;
    }

    public static boolean verifyIpSegmentValidity(String ipSegment, String prefixLength_) {
        try {
            if (!IpUtils.isValidIpv4Address(ipSegment)) {
                return false;
            }
            int prefixLength = Integer.parseInt(prefixLength_);
            if (prefixLength < 0 || prefixLength > 32) {
                return false;
            }
            InetAddress[] addrs = InetAddress.getAllByName(ipSegment);
            InetAddress inetAddress = null;
            if (addrs != null && addrs.length > 0) {
                inetAddress = addrs[0];
            }
            if (inetAddress == null) {
                return false;
            }
            int offset = prefixLength / 8;
            byte[] bytes = inetAddress.getAddress();
            if (offset < bytes.length) {
                int n = offset;
                bytes[n] = (byte)(bytes[n] << prefixLength % 8);
                while (offset < bytes.length) {
                    if (bytes[offset] != 0) {
                        return false;
                    }
                    ++offset;
                }
            }
            return true;
        }
        catch (Exception e) {
            ZLog.e((String)("verifyIpSegmentValidity failed:" + e.getMessage()));
            return false;
        }
    }

    private static class DnsLookupThread
    extends Thread {
        private InetAddress[] mAddrs = null;
        private String mHostname = null;
        private int mNetid = -1;

        private DnsLookupThread(String hostname) {
            this(hostname, -1);
        }

        private DnsLookupThread(String hostname, int netid) {
            this.mHostname = hostname;
            this.mNetid = netid;
        }

        @Override
        public void run() {
            try {
                InetAddress[] localAddrs = null;
                if (this.mNetid > 0) {
                    Method dnsMethod = InetAddress.class.getMethod("getAllByNameOnNet", String.class, Integer.TYPE);
                    localAddrs = (InetAddress[])dnsMethod.invoke(null, this.mHostname, this.mNetid);
                } else {
                    localAddrs = InetAddress.getAllByName(this.mHostname);
                }
                this.setAddrs(localAddrs);
            }
            catch (Throwable t) {
                ZLog.d((String)("dns exception:" + t.getMessage()));
            }
        }

        private synchronized void setAddrs(InetAddress[] localAddrs) {
            this.mAddrs = localAddrs;
        }

        private synchronized InetAddress[] getAddrs() {
            return this.mAddrs;
        }
    }
}

