/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DeviceInfoManager {
    private static volatile DeviceInfoManager INSTANCE = null;
    private ConnectivityManager connectivityManager;
    private TelephonyManager telephonyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceInfoManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DeviceInfoManager> clazz = DeviceInfoManager.class;
        synchronized (DeviceInfoManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DeviceInfoManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void init(Context context) {
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
    }

    public boolean ishasSimCard() {
        if (null == this.telephonyManager) {
            return true;
        }
        int simState = this.telephonyManager.getSimState();
        boolean result = true;
        switch (simState) {
            case 1: {
                result = false;
                break;
            }
            case 0: {
                result = false;
            }
        }
        ZLog.d((String)(result ? "has SimCard" : "has not SimCard"));
        return result;
    }

    public boolean isMobileSwitchOpened() {
        if (this.connectivityManager == null) {
            return false;
        }
        Class<?> conMgrClass = null;
        Method getMobileDataEnabledMethod = null;
        boolean isMobileOpened = true;
        try {
            conMgrClass = Class.forName(this.connectivityManager.getClass().getName());
            if (BuildUtils.INSTANCE.getSDK_INT() < 21) {
                Field iConnectivityManagerField = conMgrClass.getDeclaredField("mService");
                iConnectivityManagerField.setAccessible(true);
                Object iConnectivityManager = iConnectivityManagerField.get(this.connectivityManager);
                Class<?> iConnectivityManagerClass = Class.forName(iConnectivityManager.getClass().getName());
                getMobileDataEnabledMethod = iConnectivityManagerClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
                getMobileDataEnabledMethod.setAccessible(true);
                isMobileOpened = (Boolean)getMobileDataEnabledMethod.invoke(iConnectivityManager, new Object[0]);
            } else {
                getMobileDataEnabledMethod = conMgrClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
                getMobileDataEnabledMethod.setAccessible(true);
                isMobileOpened = (Boolean)getMobileDataEnabledMethod.invoke((Object)this.connectivityManager, new Object[0]);
            }
        }
        catch (Exception e) {
            ZLog.e((String)("isMobileOpened " + e.getMessage()));
            e.printStackTrace();
        }
        ZLog.d((String)("isMobileOpened:" + isMobileOpened));
        return isMobileOpened;
    }

    public boolean isMobileOpened() {
        return this.ishasSimCard() && this.isMobileSwitchOpened();
    }

    public int getMobileMutisetId() {
        if (this.telephonyManager == null) {
            return -1;
        }
        String simOperator = this.telephonyManager.getSimOperator();
        ZLog.d((String)("getSimOperator simOperator:" + simOperator));
        return this.parseOperatorCode(simOperator);
    }

    public String getOperatorType(int setId) {
        String result = "unknow";
        switch (setId) {
            case 0: {
                result = "\u4e2d\u56fd\u7535\u4fe1";
                break;
            }
            case 1: {
                result = "\u4e2d\u56fd\u79fb\u52a8";
                break;
            }
            case 2: {
                result = "\u4e2d\u56fd\u8054\u901a";
                break;
            }
            case 3: {
                result = "\u5176\u4ed6";
                break;
            }
        }
        return result;
    }

    public String getMobileOperatorType() {
        String result = "unknow";
        int setId = this.getMobileMutisetId();
        switch (setId) {
            case 0: {
                result = "\u4e2d\u56fd\u7535\u4fe1";
                break;
            }
            case 1: {
                result = "\u4e2d\u56fd\u79fb\u52a8";
                break;
            }
            case 2: {
                result = "\u4e2d\u56fd\u8054\u901a";
                break;
            }
            case 3: {
                result = "cap";
                break;
            }
        }
        return result;
    }

    public int parseOperatorCode(String operatorCode) {
        if (operatorCode == null || "".equals(operatorCode)) {
            return -1;
        }
        switch (operatorCode) {
            case "46000": 
            case "46002": 
            case "46004": 
            case "46007": 
            case "46008": {
                return 1;
            }
            case "46001": 
            case "46006": 
            case "46009": {
                return 2;
            }
            case "46003": 
            case "46005": 
            case "46011": {
                return 0;
            }
        }
        return -1;
    }

    public String getOperatorName(Context context) {
        if (this.telephonyManager == null) {
            return "";
        }
        String OperatorName = this.telephonyManager.getSimOperatorName();
        ZLog.d((String)("getOperatorName OperatorName:" + OperatorName));
        return OperatorName;
    }

    public String getProvidersName(Context context) {
        if (this.telephonyManager == null) {
            return "";
        }
        String ProvidersName = null;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return "unknow";
        }
        String IMSI = this.telephonyManager.getSubscriberId();
        if (IMSI == null) {
            return "unknow";
        }
        ZLog.d((String)("getProvidersName IMSI\uff1a" + IMSI));
        ProvidersName = IMSI.startsWith("46000") || IMSI.startsWith("46002") || IMSI.startsWith("46004") || IMSI.startsWith("46007") ? "\u4e2d\u56fd\u79fb\u52a8" : (IMSI.startsWith("46001") || IMSI.startsWith("46006") || IMSI.startsWith("46009") ? "\u4e2d\u56fd\u8054\u901a" : (IMSI.startsWith("46003") || IMSI.startsWith("46005") || IMSI.startsWith("46011") ? "\u4e2d\u56fd\u7535\u4fe1" : (IMSI.startsWith("46020") ? "\u4e2d\u56fd\u94c1\u901a" : "unknow")));
        ZLog.d((String)("getProvidersName \u5f53\u524d\u5361\u4e3a\uff1a" + ProvidersName));
        return ProvidersName;
    }
}

