/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.device;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.bihe0832.android.lib.log.ZLog;

public class BatteryUtils {
    public static int getBatteryLevel(Context context) {
        if (context == null) {
            ZLog.d((String)"battery context null");
            return -1;
        }
        int level = -1;
        try {
            Intent batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (batteryIntent != null) {
                level = batteryIntent.getIntExtra("level", -1);
            }
        }
        catch (Exception e) {
            ZLog.d((String)("battery exception:" + e.getMessage()));
        }
        return level;
    }

    public static int[] getBatteryLevelAndCharging(Context context) {
        int[] value = new int[]{-1, 0};
        if (context == null) {
            ZLog.e((String)"battery context null");
            return value;
        }
        try {
            Intent batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (batteryIntent != null) {
                value[0] = batteryIntent.getIntExtra("level", -1);
                int status = batteryIntent.getIntExtra("status", 1);
                if (status == 2 || status == 5) {
                    value[1] = 1;
                }
            }
        }
        catch (Exception e) {
            ZLog.d((String)("battery " + e.getMessage()));
        }
        return value;
    }
}

