/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.debug;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.bihe0832.android.lib.debug.InputDialogCallback;
import com.bihe0832.android.lib.debug.InputDialogCompletedCallback;
import com.bihe0832.android.lib.debug.R;
import com.bihe0832.android.lib.text.ClipboardUtil;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.ui.dialog.CommonDialog;
import com.bihe0832.android.lib.ui.dialog.OnDialogListener;
import com.bihe0832.android.lib.ui.toast.ToastUtil;

public class DebugTools {
    public static void sendInfo(final Context context, final String title, final String content, boolean showDialog) {
        if (!showDialog) {
            DebugTools.sendInfo(context, title, content);
            return;
        }
        final CommonDialog dialog = new CommonDialog(context);
        dialog.setTitle(title);
        dialog.setPositive("\u5206\u4eab\u7ed9\u6211\u4eec");
        dialog.setContent("\u8c03\u8bd5\u4fe1\u606f\u5df2\u7ecf\u51c6\u5907\u597d\uff0c\u4f60\u53ef\u4ee5\u76f4\u63a5\u300c\u5206\u4eab\u7ed9\u6211\u4eec\u300d\u6216\u5c06\u4fe1\u606f\u300c\u590d\u5236\u5230\u526a\u8d34\u677f\u300d\u540e\u8f6c\u53d1\u7ed9\u6211\u4eec");
        dialog.setImageContentResId(R.mipmap.debug);
        dialog.setFeedBackContent("\u6211\u4eec\u627f\u8bfa\u4f60\u63d0\u4f9b\u7684\u4fe1\u606f\u4ec5\u7528\u4e8e\u95ee\u9898\u5b9a\u4f4d");
        dialog.setNegative("\u590d\u5236\u5230\u526a\u5207\u677f");
        dialog.setOnClickBottomListener(new OnDialogListener(){

            public void onPositiveClick() {
                try {
                    DebugTools.sendInfo(context, title, content);
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onNegativeClick() {
                try {
                    DebugTools.copyToClipboard(context, content);
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onCancel() {
            }
        });
        dialog.show();
    }

    public static void showInfoWithHTML(Context context, String title, String content, String positiveText) {
        DebugTools.showInfoWithCharSequence(context, title, (CharSequence)TextFactoryUtils.getSpannedTextByHtml((String)content), null, positiveText);
    }

    public static void showInfo(Context context, String title, String content, String positiveText) {
        DebugTools.showInfo(context, title, content, null, null, positiveText);
    }

    public static void showInfoWithCharSequence(Context context, String title, CharSequence content, MovementMethod method, String positiveText) {
        DebugTools.showInfo(context, title, "", content, method, positiveText);
    }

    public static void showInfo(final Context context, final String title, String content, CharSequence charSequence, MovementMethod method, String positiveText) {
        final CommonDialog dialog = new CommonDialog(context);
        String tempContent = "";
        if (!TextUtils.isEmpty((CharSequence)content)) {
            dialog.setContent(content);
            tempContent = content;
        } else {
            dialog.setHtmlContent(charSequence, method);
            tempContent = charSequence.toString();
        }
        final String finalContent = tempContent;
        dialog.setTitle(title).setShouldCanceled(true).setPositive(positiveText).setNegative("\u590d\u5236\u5230\u526a\u5207\u677f").setOnClickBottomListener(new OnDialogListener(){

            public void onPositiveClick() {
                try {
                    DebugTools.sendInfo(context, title, finalContent);
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onNegativeClick() {
                try {
                    DebugTools.copyToClipboard(context, finalContent);
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onCancel() {
            }
        });
        dialog.show();
    }

    public static void copyToClipboard(Context context, String content) {
        ClipboardUtil.copyToClipboard((Context)context, (String)content);
        ToastUtil.showShort((Context)context, (String)"\u4fe1\u606f\u5df2\u4fdd\u5b58\u5230\u526a\u8d34\u677f");
    }

    public static void sendInfo(Context context, String title, String content) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", content);
        sendIntent.setFlags(0x10000000);
        sendIntent.addFlags(0x20000000);
        sendIntent.setType("text/plain");
        try {
            context.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)title));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                context.startActivity(sendIntent);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public static void showInputDialog(Context context, String titleName, String msg, String positive, String negtive, Boolean canCanceledOnTouchOutside, String defaultValue, String hint, final InputDialogCallback listener) {
        final CommonDialog dialog = new CommonDialog(context);
        dialog.setTitle(titleName);
        dialog.setHtmlContent(msg);
        dialog.setPositive(positive);
        dialog.setNegative(negtive);
        dialog.setCanceledOnTouchOutside(canCanceledOnTouchOutside.booleanValue());
        final EditText editText = new EditText(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.setMargins(50, 10, 50, 10);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setSingleLine();
        editText.setBackgroundColor(context.getResources().getColor(R.color.com_bihe0832_dialog_text));
        editText.setTextColor(context.getResources().getColor(R.color.com_bihe0832_dialog_bg));
        editText.setHint((CharSequence)hint);
        if (!TextUtils.isEmpty((CharSequence)defaultValue)) {
            editText.requestFocus();
            editText.setText((CharSequence)defaultValue);
            editText.selectAll();
        }
        dialog.addViewToContent((View)editText);
        dialog.setOnClickBottomListener(new OnDialogListener(){

            public void onPositiveClick() {
                try {
                    listener.onPositiveClick(editText.getText().toString());
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onNegativeClick() {
                try {
                    listener.onNegtiveClick(editText.getText().toString());
                    dialog.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onCancel() {
            }
        });
        dialog.show();
    }

    public static void showInputDialog(Context context, String titleName, String msg, String defaultValue, final InputDialogCompletedCallback listener) {
        DebugTools.showInputDialog(context, titleName, msg, "\u786e\u5b9a", "", true, defaultValue, "\u8f93\u5165\u5b8c\u6210\u540e\u70b9\u51fb\u786e\u5b9a~", new InputDialogCallback(){

            @Override
            public void onPositiveClick(String result) {
                listener.onInputCompleted(result);
            }

            @Override
            public void onNegtiveClick(String result) {
            }

            @Override
            public void onCloseClick(String result) {
            }
        });
    }
}

