/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.view;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import com.bihe0832.android.lib.ui.view.BottomBarTab;
import java.util.ArrayList;
import java.util.List;

public class BottomBar
extends LinearLayout {
    private static final int TRANSLATE_DURATION_MILLIS = 200;
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mVisible = true;
    private List<BottomBarTab> mTabs = new ArrayList<BottomBarTab>();
    private LinearLayout mTabLayout;
    private LinearLayout.LayoutParams mTabParams;
    private int mCurrentPosition = 0;
    private OnTabSelectedListener mListener;

    public BottomBar(Context context) {
        this(context, null);
    }

    public BottomBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setOrientation(1);
        this.mTabLayout = new LinearLayout(context);
        this.mTabLayout.setOrientation(0);
        this.addView((View)this.mTabLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mTabParams = new LinearLayout.LayoutParams(0, -1);
        this.mTabParams.weight = 1.0f;
    }

    public BottomBar addItem(final BottomBarTab tab) {
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BottomBar.this.mListener == null) {
                    return;
                }
                int pos = tab.getTabPosition();
                if (BottomBar.this.mCurrentPosition == pos) {
                    BottomBar.this.mListener.onTabReselected(pos);
                } else {
                    BottomBar.this.mListener.onTabSelected(pos, BottomBar.this.mCurrentPosition);
                    tab.setSelected(true);
                    BottomBar.this.mListener.onTabUnselected(BottomBar.this.mCurrentPosition);
                    ((BottomBarTab)((Object)BottomBar.this.mTabs.get(BottomBar.this.mCurrentPosition))).setSelected(false);
                    BottomBar.this.mCurrentPosition = pos;
                }
            }
        });
        tab.setTabPosition(this.mTabLayout.getChildCount());
        tab.setLayoutParams((ViewGroup.LayoutParams)this.mTabParams);
        this.mTabLayout.addView((View)tab);
        this.mTabs.add(tab);
        return this;
    }

    public void setOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.mListener = onTabSelectedListener;
    }

    public void setCurrentItem(final int position) {
        this.mTabLayout.post(new Runnable(){

            @Override
            public void run() {
                BottomBar.this.mTabLayout.getChildAt(position).performClick();
            }
        });
    }

    public int getCurrentItemPosition() {
        return this.mCurrentPosition;
    }

    public BottomBarTab getItem(int index) {
        if (this.mTabs.size() < index) {
            return null;
        }
        return this.mTabs.get(index);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mCurrentPosition);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mCurrentPosition != ss.position) {
            this.mTabLayout.getChildAt(this.mCurrentPosition).setSelected(false);
            this.mTabLayout.getChildAt(ss.position).setSelected(true);
        }
        this.mCurrentPosition = ss.position;
    }

    public void hide() {
        this.hide(true);
    }

    public void show() {
        this.show(true);
    }

    public void hide(boolean anim) {
        this.toggle(false, anim, false);
    }

    public void show(boolean anim) {
        this.toggle(true, anim, false);
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    private void toggle(final boolean visible, final boolean animate, boolean force) {
        if (this.mVisible != visible || force) {
            int translationY;
            ViewTreeObserver vto;
            this.mVisible = visible;
            int height = this.getHeight();
            if (height == 0 && !force && (vto = this.getViewTreeObserver()).isAlive()) {
                vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewTreeObserver currentVto = BottomBar.this.getViewTreeObserver();
                        if (currentVto.isAlive()) {
                            currentVto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        }
                        BottomBar.this.toggle(visible, animate, true);
                        return true;
                    }
                });
                return;
            }
            int n = translationY = visible ? 0 : height;
            if (animate) {
                this.animate().setInterpolator((TimeInterpolator)this.mInterpolator).setDuration(200L).translationY((float)translationY);
            } else {
                ViewCompat.setTranslationY((View)this, (float)translationY);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        private int position;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.position = source.readInt();
        }

        public SavedState(Parcelable superState, int position) {
            super(superState);
            this.position = position;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1, int var2);

        public void onTabUnselected(int var1);

        public void onTabReselected(int var1);
    }
}

