/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.config;

import android.content.Context;
import android.text.TextUtils;
import com.bihe0832.android.lib.config.OnConfigChangedListener;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.tencent.mmkv.MMKV;
import com.tencent.mmkv.MMKVLogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ConfigManager {
    private static final String TAG = "ConfigManager";
    private static volatile ConfigManager instance = null;
    private boolean hasInit = false;
    private Properties mLocalConfig = null;
    private ConcurrentHashMap<String, String> mConfigInfoInCache = new ConcurrentHashMap();
    private CopyOnWriteArrayList<OnConfigChangedListener> mConfigChangedListenerList = new CopyOnWriteArrayList();
    private MMKV mMMKVInstance = null;

    ConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ConfigManager getInstance() {
        if (instance != null) return instance;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (instance != null) return instance;
            instance = new ConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void init(Context ctx, String file, boolean isDebug) {
        if (ctx == null) {
            ZLog.w((String)TAG, (String)"context is null");
            return;
        }
        this.hasInit = true;
        try {
            this.loadFile(ctx, file, isDebug);
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)TAG, (String)"ERROR: config file");
        }
        try {
            String rootDir = MMKV.initialize((Context)ctx.getApplicationContext());
            this.mMMKVInstance = MMKV.mmkvWithID((String)ctx.getPackageName(), (int)2);
            if (isDebug) {
                MMKV.setLogLevel((MMKVLogLevel)MMKVLogLevel.LevelInfo);
            } else {
                MMKV.setLogLevel((MMKVLogLevel)MMKVLogLevel.LevelNone);
            }
            ZLog.d((String)TAG, (String)("mmkv root: " + rootDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)TAG, (String)"ERROR: config file");
        }
    }

    protected void addOnConfigChangedListener(OnConfigChangedListener listener) {
        if (listener != null) {
            this.mConfigChangedListenerList.add(listener);
        }
    }

    protected void removeOnConfigChangedListener(OnConfigChangedListener listener) {
        if (this.mConfigChangedListenerList.contains(listener)) {
            this.mConfigChangedListenerList.remove(listener);
        }
    }

    protected boolean hasInit() {
        return this.hasInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(Context ctx, String file, boolean isDebug) {
        if (ctx == null) {
            ZLog.w((String)TAG, (String)"context is null");
            return;
        }
        InputStream inputStream = null;
        try {
            Set<Map.Entry<Object, Object>> entrySet;
            Properties localConfig = new Properties();
            if (!TextUtils.isEmpty((CharSequence)file)) {
                inputStream = ctx.getResources().getAssets().open(file);
                localConfig.load(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
            }
            if (null == this.mLocalConfig) {
                this.mLocalConfig = localConfig;
            } else {
                entrySet = localConfig.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    this.mLocalConfig.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (isDebug) {
                ZLog.d((String)TAG, (String)"================== config ================");
                ZLog.d((String)TAG, (String)"local config:");
                entrySet = this.mLocalConfig.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    ZLog.d((String)TAG, (String)(entry.getKey() + "=" + entry.getValue()));
                }
                ZLog.d((String)TAG, (String)"================== config ================");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ZLog.d((String)TAG, (String)"ERROR: config file");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String readLocalConfig(String key) {
        if (null == this.mLocalConfig || !this.mLocalConfig.containsKey(key)) {
            return null;
        }
        String value = null;
        try {
            value = this.mLocalConfig.getProperty(key, null);
            if (value == null || value.length() == 0) {
                ZLog.d((String)TAG, (String)("key value is empty: " + key));
                return value;
            }
            return value.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)TAG, (String)"readLocalConfig failed");
            return value;
        }
    }

    private String readCloudConfig(String key) {
        try {
            if (null != this.mMMKVInstance && this.mMMKVInstance.containsKey(key)) {
                return this.mMMKVInstance.decodeString(key, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)TAG, (String)"readCloudConfig failed");
        }
        return null;
    }

    protected String readConfig(String key, String defValue) {
        String value = null;
        if (this.mConfigInfoInCache.containsKey(key)) {
            value = this.mConfigInfoInCache.get(key);
        }
        if (value != null) {
            ZLog.d((String)TAG, (String)("readConfig: key=" + key + ";use cache value:" + value));
            return value;
        }
        value = this.readCloudConfig(key);
        if (value == null) {
            ZLog.d((String)TAG, (String)"read local value");
            value = this.readLocalConfig(key);
        }
        if (value != null) {
            this.mConfigInfoInCache.put(key, value);
        }
        ZLog.d((String)TAG, (String)"read cloud value");
        if (value == null) {
            value = defValue;
        }
        ZLog.d((String)TAG, (String)("readConfig: key=" + key + ";value=" + value));
        return value;
    }

    protected boolean isSwitchEnabled(String switchKey, boolean defValue) {
        String value = this.readConfig(switchKey, String.valueOf(defValue));
        if (!TextUtils.isEmpty((CharSequence)value)) {
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            return defValue;
        }
        return defValue;
    }

    protected int readConfig(String key, int defaultValue) {
        String configInterval = this.readConfig(key, String.valueOf(defaultValue));
        return ConvertUtils.parseInt((String)configInterval, (int)defaultValue);
    }

    protected long readConfig(String key, long defaultValue) {
        String configInterval = this.readConfig(key, String.valueOf(defaultValue));
        return ConvertUtils.parseLong((String)configInterval, (long)defaultValue);
    }

    protected float readConfig(String key, float defaultValue) {
        String configInterval = this.readConfig(key, String.valueOf(defaultValue));
        return ConvertUtils.parseFloat((String)configInterval, (float)defaultValue);
    }

    protected double readConfig(String key, double defaultValue) {
        String configInterval = this.readConfig(key, String.valueOf(defaultValue));
        return ConvertUtils.parseDouble((String)configInterval, (double)defaultValue);
    }

    protected boolean writeConfig(String key, boolean value, boolean saveToLocal) {
        return this.writeConfig(key, value ? "true" : "false", saveToLocal);
    }

    protected boolean writeConfig(String key, String value, boolean saveToLocal) {
        ZLog.d((String)TAG, (String)("writeConfig, key is :" + key + ";value is:" + value));
        try {
            if (TextUtils.isEmpty((CharSequence)key)) {
                ZLog.d((String)TAG, (String)("writeConfig, key is null:" + key));
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)value)) {
                ZLog.d((String)TAG, (String)("writeConfig, value is null:" + key));
                value = "";
            }
            if (null != this.mConfigInfoInCache) {
                String preData = "";
                if (this.mConfigInfoInCache.containsKey(key)) {
                    preData = this.mConfigInfoInCache.get(key);
                }
                this.mConfigInfoInCache.put(key, value);
                this.notifyValueChange(key, preData, value);
            }
            if (!saveToLocal) {
                return true;
            }
            if (null == this.mMMKVInstance) {
                ZLog.d((String)TAG, (String)"writeConfig, sp is null:");
                return false;
            }
            boolean result = this.mMMKVInstance.encode(key, value);
            ZLog.d((String)TAG, (String)("writeConfig result:" + result));
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean writeConfigs(Map<String, String> configs, boolean saveToLocal) {
        boolean result = true;
        try {
            ZLog.d((String)TAG, (String)("writeConfig, " + configs));
            if (null == this.mConfigInfoInCache) {
                ZLog.d((String)TAG, (String)"writeConfig ConfigInfoInCache is null");
                return false;
            }
            if (null == this.mMMKVInstance && saveToLocal) {
                ZLog.d((String)TAG, (String)"writeConfig, sp is null:");
                return false;
            }
            if (configs != null && configs.size() > 0) {
                for (Map.Entry<String, String> entry : configs.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    ZLog.d((String)TAG, (String)("key :" + key + " ;value: " + value));
                    boolean tempResult = this.writeConfig(key, value, saveToLocal);
                    if (tempResult) {
                        this.mConfigInfoInCache.put(key, value);
                        continue;
                    }
                    result = false;
                }
                return result;
            }
            ZLog.d((String)TAG, (String)"writeConfig, configs is null:");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean writeConfigs(JSONObject configs, boolean saveToLocal) {
        boolean result = true;
        try {
            ZLog.d((String)TAG, (String)("writeConfig, " + configs));
            if (null == this.mConfigInfoInCache) {
                ZLog.d((String)TAG, (String)"writeConfig ConfigInfoInCache is null");
                return false;
            }
            if (null == this.mMMKVInstance && saveToLocal) {
                ZLog.d((String)TAG, (String)"writeConfig, sp is null:");
                return false;
            }
            if (configs != null) {
                Iterator keys = configs.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = configs.getString(key);
                    ZLog.d((String)TAG, (String)("key :" + key + " ;value: " + value));
                    boolean tempResult = this.writeConfig(key, value, saveToLocal);
                    if (tempResult) {
                        this.mConfigInfoInCache.put(key, value);
                        continue;
                    }
                    result = false;
                }
                return result;
            }
            ZLog.d((String)TAG, (String)"writeConfig, configs is null:");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void notifyValueChange(String key, String preData, String newData) {
        if (this.mConfigChangedListenerList.size() > 0) {
            boolean isSame = preData.equals(newData);
            for (OnConfigChangedListener listener : this.mConfigChangedListenerList) {
                if (isSame) {
                    listener.onValueAgain(key, newData);
                    continue;
                }
                listener.onValueChanged(key, newData);
            }
        }
    }
}

