/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.channel;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bihe0832/android/lib/channel/ChannelTools;", "", "()V", "CHANNEL_ID_FILE", "", "CHANNEL_ID_KEY", "mChannel", "mDefaultChannel", "getChannel", "init", "", "context", "Landroid/content/Context;", "channel", "readChannelFromIni", "LibChannel_release"})
public final class ChannelTools {
    private static final String CHANNEL_ID_KEY = "CHANNEL";
    private static final String CHANNEL_ID_FILE = "channel.ini";
    private static String mDefaultChannel;
    private static String mChannel;
    public static final ChannelTools INSTANCE;

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        mChannel = this.readChannelFromIni(context);
    }

    public final void init(@NotNull Context context, @NotNull String channel) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        mDefaultChannel = channel;
        mChannel = this.readChannelFromIni(context);
    }

    @NotNull
    public final String getChannel() {
        if (TextUtils.isEmpty((CharSequence)mChannel)) {
            mChannel = mDefaultChannel;
        }
        return mChannel;
    }

    private final String readChannelFromIni(Context context) {
        String string;
        try {
            Context context2 = context;
            InputStream inputStream = context2 != null && (context2 = context2.getResources()) != null && (context2 = context2.getAssets()) != null ? context2.open(CHANNEL_ID_FILE) : null;
            Properties properties = new Properties();
            properties.load(inputStream);
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                inputStream2.close();
            }
            String string2 = properties.getProperty(CHANNEL_ID_KEY, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"properties.getProperty(CHANNEL_ID_KEY, \"\")");
            string = string2;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)"Channel", (String)"CHANNEL ID ERROR");
            string = "";
        }
        return string;
    }

    private ChannelTools() {
    }

    static {
        ChannelTools channelTools;
        INSTANCE = channelTools = new ChannelTools();
        mDefaultChannel = "000000";
        mChannel = "";
    }
}

