/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.lib.audio.player.block;

import android.content.Context;
import android.media.SoundPool;
import androidx.annotation.NonNull;
import com.bihe0832.android.lib.block.task.BaseAAFBlockTask;
import com.bihe0832.android.lib.block.task.BlockTask;
import com.bihe0832.android.lib.block.task.BlockTaskManager;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.media.audio.AudioTools;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.lib.audio.player.AudioItem;
import com.bihe0832.lib.audio.player.AudioPlayListener;
import com.bihe0832.lib.audio.player.block.AudioPLayerManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00042\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0004J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J(\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0004J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010\u001d\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/bihe0832/lib/audio/player/block/AudioPLayerManager;", "Lcom/bihe0832/android/lib/block/task/BlockTaskManager;", "()V", "PRIORITY_DEFAULT", "", "getPRIORITY_DEFAULT", "()I", "TAG", "", "mAudioInfoMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/bihe0832/lib/audio/player/AudioItem;", "mSoundPool", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "getMSoundPool", "()Landroid/media/SoundPool;", "mSoundPool$delegate", "Lkotlin/Lazy;", "pause", "", "play", "context", "Landroid/content/Context;", "resId", "listener", "Lcom/bihe0832/lib/audio/player/AudioPlayListener;", "priority", "path", "resume", "stopAll", "stopCurrent", "", "BlockAudioTask", "LibAudioPlayer_release"})
public final class AudioPLayerManager
extends BlockTaskManager {
    private final int PRIORITY_DEFAULT;
    @NotNull
    private final String TAG;
    @NotNull
    private final ConcurrentHashMap<Integer, AudioItem> mAudioInfoMap = new ConcurrentHashMap();
    @NotNull
    private final Lazy mSoundPool$delegate = LazyKt.lazy((Function0)mSoundPool.2.INSTANCE);

    public AudioPLayerManager() {
        this.PRIORITY_DEFAULT = 1;
        this.TAG = "AudioManager";
        this.getMSoundPool().setOnLoadCompleteListener((arg_0, arg_1, arg_2) -> AudioPLayerManager._init_$lambda-2(this, arg_0, arg_1, arg_2));
    }

    public final int getPRIORITY_DEFAULT() {
        return this.PRIORITY_DEFAULT;
    }

    private final SoundPool getMSoundPool() {
        Lazy lazy = this.mSoundPool$delegate;
        return (SoundPool)lazy.getValue();
    }

    public final int play(@NonNull @NotNull Context context, @NonNull int resId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.play(context, resId, null);
    }

    public final int play(@NotNull Context context, int resId, @Nullable AudioPlayListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.play(context, resId, 0, listener);
    }

    public final int play(@NotNull Context context, int resId, int priority) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.play(context, resId, priority, null);
    }

    public final int play(@NotNull Context context, int resId, int priority, @Nullable AudioPlayListener listener) {
        AudioItem audioItem;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ZLog.d((String)this.TAG, (String)"load start");
        AudioPlayListener audioPlayListener = listener;
        if (audioPlayListener != null) {
            audioPlayListener.onLoad();
        }
        int soundid = this.getMSoundPool().load(context, resId, this.PRIORITY_DEFAULT);
        long duration = AudioTools.INSTANCE.getAudioDuration(context, resId);
        Map map = this.mAudioInfoMap;
        Integer n = soundid;
        AudioItem $this$play_u24lambda_u2d4 = audioItem = new AudioItem(soundid, duration);
        boolean bl = false;
        AudioPlayListener audioPlayListener2 = listener;
        if (audioPlayListener2 != null) {
            AudioPlayListener it = audioPlayListener2;
            boolean bl2 = false;
            $this$play_u24lambda_u2d4.setPlayListener(it);
        }
        $this$play_u24lambda_u2d4.setPriority(priority);
        map.put(n, audioItem);
        return soundid;
    }

    public final int play(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.play(path, 0);
    }

    public final int play(@NotNull String path, int priority) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.play(path, priority, null);
    }

    public final int play(@NotNull String path, @Nullable AudioPlayListener listener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.play(path, 0, listener);
    }

    public final int play(@NotNull String path, int priority, @Nullable AudioPlayListener listener) {
        AudioItem audioItem;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZLog.d((String)this.TAG, (String)"load start");
        AudioPlayListener audioPlayListener = listener;
        if (audioPlayListener != null) {
            audioPlayListener.onLoad();
        }
        int soundid = this.getMSoundPool().load(path, this.PRIORITY_DEFAULT);
        long duration = AudioTools.INSTANCE.getAudioDuration(path);
        Map map = this.mAudioInfoMap;
        Integer n = soundid;
        AudioItem $this$play_u24lambda_u2d6 = audioItem = new AudioItem(soundid, duration);
        boolean bl = false;
        AudioPlayListener audioPlayListener2 = listener;
        if (audioPlayListener2 != null) {
            AudioPlayListener it = audioPlayListener2;
            boolean bl2 = false;
            $this$play_u24lambda_u2d6.setPlayListener(it);
        }
        $this$play_u24lambda_u2d6.setPriority(priority);
        map.put(n, audioItem);
        return soundid;
    }

    public final void stopAll(boolean stopCurrent) {
        block1: {
            this.mAudioInfoMap.clear();
            super.clearAll();
            if (!stopCurrent) break block1;
            BlockTask blockTask = this.getCurrentTask();
            BlockAudioTask blockAudioTask = blockTask instanceof BlockAudioTask ? (BlockAudioTask)blockTask : null;
            if (blockAudioTask != null) {
                blockAudioTask.forceStop();
            }
        }
    }

    public final void pause() {
        this.getMSoundPool().autoPause();
    }

    public final void resume() {
        this.getMSoundPool().autoResume();
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda-2(AudioPLayerManager this$0, SoundPool soundPool, int sampleId, int status) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            AudioItem audioItem = this$0.mAudioInfoMap.get(sampleId);
            if (audioItem != null) {
                void $this$lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0;
                BlockAudioTask blockAudioTask;
                AudioItem it = audioItem;
                boolean bl = false;
                ZLog.d((String)this$0.TAG, (String)("load Complete, add task \uff1asampleId " + sampleId + ", status: " + status));
                AudioPlayListener audioPlayListener = it.getPlayListener();
                if (audioPlayListener != null) {
                    audioPlayListener.onLoadComplete(sampleId, status);
                }
                SoundPool soundPool2 = this$0.getMSoundPool();
                Intrinsics.checkNotNullExpressionValue((Object)soundPool2, (String)"mSoundPool");
                BlockAudioTask blockAudioTask2 = blockAudioTask = new BlockAudioTask(soundPool2, it, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, sampleId){
                    final /* synthetic */ AudioPLayerManager this$0;
                    final /* synthetic */ int $sampleId;
                    {
                        this.this$0 = $receiver;
                        this.$sampleId = $sampleId;
                        super(0);
                    }

                    public final void invoke() {
                        AudioPLayerManager.access$getMAudioInfoMap$p(this.this$0).remove(this.$sampleId);
                        ZLog.d((String)AudioPLayerManager.access$getTAG$p(this.this$0), (String)("play Complete\uff1a" + AudioPLayerManager.access$getMAudioInfoMap$p(this.this$0).size()));
                    }
                }), "");
                AudioPLayerManager audioPLayerManager = this$0;
                boolean bl2 = false;
                $this$lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setSequence((long)sampleId);
                $this$lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setPriority(it.getPriority());
                audioPLayerManager.add((BlockTask)blockAudioTask);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMAudioInfoMap$p(AudioPLayerManager $this) {
        return $this.mAudioInfoMap;
    }

    public static final /* synthetic */ String access$getTAG$p(AudioPLayerManager $this) {
        return $this.TAG;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/bihe0832/lib/audio/player/block/AudioPLayerManager$BlockAudioTask;", "Lcom/bihe0832/android/lib/block/task/BaseAAFBlockTask;", "mPlay", "Landroid/media/SoundPool;", "mAudioItem", "Lcom/bihe0832/lib/audio/player/AudioItem;", "innerFinishedAction", "Lkotlin/Function0;", "", "name", "", "(Landroid/media/SoundPool;Lcom/bihe0832/lib/audio/player/AudioItem;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "errorCode", "", "msg", "doTask", "finishTask", "forceStop", "LibAudioPlayer_release"})
    public static final class BlockAudioTask
    extends BaseAAFBlockTask {
        @NotNull
        private final SoundPool mPlay;
        @NotNull
        private final AudioItem mAudioItem;
        @NotNull
        private final Function0<Unit> innerFinishedAction;
        private int errorCode;
        @NotNull
        private String msg;

        public BlockAudioTask(@NotNull SoundPool mPlay, @NotNull AudioItem mAudioItem, @NotNull Function0<Unit> innerFinishedAction, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mPlay, (String)"mPlay");
            Intrinsics.checkNotNullParameter((Object)mAudioItem, (String)"mAudioItem");
            Intrinsics.checkNotNullParameter(innerFinishedAction, (String)"innerFinishedAction");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name);
            this.mPlay = mPlay;
            this.mAudioItem = mAudioItem;
            this.innerFinishedAction = innerFinishedAction;
            this.msg = "";
        }

        public void doTask() {
            block6: {
                try {
                    if (this.mAudioItem != null && this.mAudioItem.getDuration() > 0L) {
                        AudioPlayListener audioPlayListener = this.mAudioItem.getPlayListener();
                        if (audioPlayListener != null) {
                            audioPlayListener.onPlayStart();
                        }
                        ZLog.d((String)"AudioManager", (String)("play start\uff1a" + this.mAudioItem));
                        try {
                            this.mPlay.play(this.mAudioItem.getSoundid(), 1.0f, 1.0f, 0, 0, 1.0f);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ThreadManager.getInstance().start(() -> BlockAudioTask.doTask$lambda-0(this), this.mAudioItem.getDuration());
                        break block6;
                    }
                    this.errorCode = -1;
                    this.msg = "bad audio data";
                    this.unLockBlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errorCode = -2;
                    this.msg = "audio play throw exception:" + e;
                    this.unLockBlock();
                }
            }
        }

        public void finishTask() {
            super.finishTask();
            ZLog.d((String)"AudioManager", (String)("play finish\uff1a" + this.mAudioItem));
            this.innerFinishedAction.invoke();
            try {
                AudioPlayListener audioPlayListener = this.mAudioItem.getPlayListener();
                if (audioPlayListener != null) {
                    audioPlayListener.onPlayFinished(this.errorCode, this.msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final void forceStop() {
            this.mPlay.autoPause();
            this.errorCode = -3;
            this.msg = "force stop";
            this.unLockBlock();
        }

        private static final void doTask$lambda-0(BlockAudioTask this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.unLockBlock();
        }
    }
}

