/*
 * Decompiled with CFR 0.152.
 */
package android.content.resource.parser;

import android.content.pm.APKInfo;
import android.content.resource.parser.ResourceDecoder;
import java.io.FileInputStream;
import java.io.InputStream;

public class ResourceTool {
    public static boolean needResourceParser(APKInfo info) {
        if (info == null) {
            return false;
        }
        if (info.application_res_name != null && info.application_res_name.startsWith("@")) {
            return true;
        }
        if (info.versionName != null && info.versionName.startsWith("@")) {
            return true;
        }
        return info.iconResName != null && info.iconResName.startsWith("@");
    }

    public static void resourceParser(APKInfo info, InputStream is) {
        ResourceDecoder decoder = new ResourceDecoder(is);
        int name_index = 0;
        int icon_index = 0;
        int version_index = 0;
        try {
            String subString;
            if (info.application_res_name != null && info.application_res_name.startsWith("@")) {
                subString = info.application_res_name.substring(1);
                name_index = Integer.parseInt(subString, 10);
                decoder.addQury(name_index);
            }
            if (info.versionName != null && info.versionName.startsWith("@")) {
                subString = info.versionName.substring(1);
                version_index = Integer.parseInt(subString, 10);
                decoder.addQury(version_index);
            }
            if (info.iconResName != null && info.iconResName.startsWith("@")) {
                subString = info.iconResName.substring(1);
                icon_index = Integer.parseInt(subString, 10);
                decoder.addQury(icon_index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        decoder.setQuery();
        try {
            decoder.Decoder(info, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < decoder.rt.result.length; ++i) {
            if (decoder.rt.result[i].key == name_index) {
                info.application_name = decoder.rt.result[i].value;
                continue;
            }
            if (decoder.rt.result[i].key == icon_index) {
                info.iconPath = decoder.rt.result[i].value;
                continue;
            }
            if (decoder.rt.result[i].key != version_index) continue;
            info.versionName = decoder.rt.result[i].value;
        }
    }

    public static void main(String[] args) {
        ResourceTool.Decoder("e:/resources.arsc");
    }

    public static void Decoder(String filePath) {
        try {
            FileInputStream is = new FileInputStream(filePath);
            ResourceDecoder decoder = new ResourceDecoder(is);
            decoder.addQury(2131230764);
            decoder.setQuery();
            decoder.Decoder(true);
            for (int i = 0; i < decoder.rt.result.length; ++i) {
                System.out.println(decoder.rt.result[i].key + " = " + decoder.rt.result[i].value);
            }
            ((InputStream)is).close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

