/*
 * Decompiled with CFR 0.152.
 */
package android.content.resource.parser;

import java.io.InputStream;

public class ResourceReader {
    public static short readShort(InputStream is) throws Exception {
        byte[] bytes = new byte[2];
        int read = is.read(bytes);
        if (read < 2) {
            throw new Exception("XXXX2");
        }
        return (short)(bytes[1] << 8 | bytes[0] & 0xFF);
    }

    public static void skipBytes(InputStream is, int count) throws Exception {
        is.skip(count);
    }

    public static int readInt(InputStream is) throws Exception {
        byte[] bytes = new byte[4];
        int read = is.read(bytes);
        if (read < 4) {
            throw new Exception("XXXX4");
        }
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    public static byte readByte(InputStream is) throws Exception {
        byte[] bytes = new byte[1];
        is.read(bytes);
        return bytes[0];
    }

    public static int[] readIntArray(InputStream is, int size) throws Exception {
        int[] intArray = new int[size];
        for (int i = 0; i < size; ++i) {
            intArray[i] = ResourceReader.readInt(is);
        }
        return intArray;
    }

    public static void readFully(InputStream is, byte[] bytes) throws Exception {
        is.read(bytes);
    }

    public static String readNulEndString(InputStream is, int length, boolean bool) throws Exception {
        short i;
        StringBuilder sb = new StringBuilder(16);
        while (length-- != 0 && (i = ResourceReader.readShort(is)) != 0) {
            sb.append((char)i);
        }
        if (bool) {
            ResourceReader.skipBytes(is, length * 2);
        }
        return sb.toString();
    }
}

